/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.test;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import java.util.Vector;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateOperations {
    private static String database = "test";
    private static String mongoDBUrl = "mongodb://127.0.0.1:27017";
    private static String collection = "updateTest";
    private static MongoClientURI uri;
    private static MongoClient mongoClient;
    private static MongoDatabase mongoDatabase;
    private static List<Document> allDocumentsToInsert;

    static {
        allDocumentsToInsert = new Vector<Document>();
    }

    public static void main(String[] args) throws Exception {
        uri = new MongoClientURI(mongoDBUrl);
        mongoClient = new MongoClient(uri);
        mongoDatabase = mongoClient.getDatabase(database);
        UpdateOperations.loadJsonInList();
        UpdateOperations.count();
        UpdateOperations.delete();
        UpdateOperations.insertMany();
        UpdateOperations.updateManyWithUpdateKey();
        UpdateOperations.updateOneWithUpdateKey();
        UpdateOperations.delete();
        UpdateOperations.count();
        UpdateOperations.insertMany();
        UpdateOperations.replace();
        mongoClient.close();
    }

    private static void delete() {
        System.out.println("Start delete");
        Document filter = Document.parse((String)"{}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.deleteMany((Bson)filter);
        for (Document doc : collectionObject.find()) {
            System.out.println("dopo remove: " + doc.toJson());
        }
        System.out.println("Stop delete");
    }

    private static void count() {
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        System.out.println("number of objects: " + collectionObject.countDocuments());
    }

    private static void loadJsonInList() {
        System.out.println("Start loading into list");
        allDocumentsToInsert.clear();
        int i = 1;
        while (i < 100000) {
            allDocumentsToInsert.add(Document.parse((String)("{ \"_id\":" + i + ", \"web-app\": {" + "\"servlet\": [" + "{" + "\"servlet-name\": \"cofaxCDS\"," + "\"servlet-class\": \"org.cofax.cds.CDSServlet\"," + "\"init-param\": {" + "\"configGlossary:installationAt\": \"Philadelphia, PA\"," + "\"configGlossary:adminEmail\": \"ksm@pobox.com\"," + "\"configGlossary:poweredBy\": \"Cofax\"," + "\"configGlossary:poweredByIcon\": \"/images/cofax.gif\"," + "\"configGlossary:staticPath\": \"/content/static\"," + "\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\"," + "\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\"," + "\"templatePath\": \"templates\"," + "\"templateOverridePath\": \"\"," + "\"defaultListTemplate\": \"listTemplate.htm\"," + "\"defaultFileTemplate\": \"articleTemplate.htm\"," + "\"useJSP\": false," + "\"jspListTemplate\": \"listTemplate.jsp\"," + "\"jspFileTemplate\": \"articleTemplate.jsp\"," + "\"cachePackageTagsTrack\": " + i + "," + "\"cachePackageTagsStore\": 200," + "\"cachePackageTagsRefresh\": 60," + "\"cacheTemplatesTrack\": 100," + "\"cacheTemplatesStore\": 50," + "\"cacheTemplatesRefresh\": 15," + "\"cachePagesTrack\": 200," + "\"cachePagesStore\": 100," + "\"cachePagesRefresh\": 10," + "\"cachePagesDirtyRead\": 10," + "\"searchEngineListTemplate\": \"forSearchEnginesList.htm\"," + "\"searchEngineFileTemplate\": \"forSearchEngines.htm\"," + "\"searchEngineRobotsDb\": \"WEB-INF/robots.db\"," + "\"useDataStore\": true," + "\"dataStoreClass\": \"org.cofax.SqlDataStore\"," + "\"redirectionClass\": \"org.cofax.SqlRedirection\"," + "\"dataStoreName\": \"cofax\"," + "\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\"," + "\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\"," + "\"dataStoreUser\": \"sa\"," + "\"dataStorePassword\": \"dataStoreTestQuery\"," + "\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\"," + "\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\"," + "\"dataStoreInitConns\": 10," + "\"dataStoreMaxConns\": 100," + "\"dataStoreConnUsageLimit\": 100," + "\"dataStoreLogLevel\": \"debug\"," + "\"maxUrlLength\": 500}}," + "{" + "\"servlet-name\": \"cofaxEmail\"," + "\"servlet-class\": \"org.cofax.cds.EmailServlet\"," + "\"init-param\": {" + "\"mailHost\": \"mail1\"," + "\"mailHostOverride\": \"mail2\"}}," + "{" + "\"servlet-name\": \"cofaxAdmin\"," + "\"servlet-class\": \"org.cofax.cds.AdminServlet\"}," + "{" + "\"servlet-name\": \"fileServlet\"," + "\"servlet-class\": \"org.cofax.cds.FileServlet\"}," + "{" + "\"servlet-name\": \"cofaxTools\"," + "\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\"," + "\"init-param\": {" + "\"templatePath\": \"toolstemplates/\"," + "\"log\": 1," + "\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\"," + "\"logMaxSize\": \"\"," + "\"dataLog\": 1," + "\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\"," + "\"dataLogMaxSize\": \"\"," + "\"removePageCache\": \"/content/admin/remove?cache=pages&id=\"," + "\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\"," + "\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\"," + "\"lookInContext\": 1," + "\"adminGroupID\": 4," + "\"betaServer\": true}}]," + "\"servlet-mapping\": {" + "\"cofaxCDS\": \"/\"," + "\"cofaxEmail\": \"/cofaxutil/aemail/*\"," + "\"cofaxAdmin\": \"/admin/*\"," + "\"fileServlet\": \"/static/*\"," + "\"cofaxTools\": \"/tools/*\"}," + "\"taglib\": {" + "\"taglib-uri\": \"cofax.tld\"," + "\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}")));
            ++i;
        }
        System.out.println("Finished loading into list");
    }

    private static void insertMany() {
        System.out.println("Start insert many approach");
        long l = System.currentTimeMillis();
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.insertMany(allDocumentsToInsert);
        long duration = (System.currentTimeMillis() - l) / 1000L;
        System.out.println(String.valueOf(duration) + " sec");
    }

    private static void updateManyWithUpdateKey() {
        System.out.println("Start update many with UK");
        Document whereCondition = Document.parse((String)"{\"web-app.servlet.servlet-name\": {$eq:\"cofaxCDS\"}}");
        Document newVal = Document.parse((String)"{$set:{\"web-app.taglib.taglib-uri\": \"newVal\"}}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        UpdateResult res = collectionObject.updateMany((Bson)whereCondition, (Bson)newVal);
        System.out.println("matched: " + res.getMatchedCount() + " modified: " + res.getModifiedCount());
        for (Document docFound : collectionObject.find((Bson)Document.parse((String)"{_id:1,\"web-app.servlet\": \"newVal\"}"))) {
            System.out.println("found: " + docFound.toJson());
        }
    }

    private static void updateOneWithUpdateKey() {
        System.out.println("Start update one");
        Document whereCondition = Document.parse((String)"{ _id:{$eq:3},\"web-app.servlet.init-param.cachePackageTagsTrack\":{$gte:3},\"web-app.servlet.init-param.cachePackageTagsRefresh\":{$lte:60},\"web-app.servlet.init-param.searchEngineListTemplate\":{$eq:\"forSearchEnginesList.htm\"}}");
        Document newVal = Document.parse((String)"{$set:{\"web-app.servlet-mapping.cofaxEmail\": \"nuovo\"}}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        UpdateResult res = collectionObject.updateMany((Bson)whereCondition, (Bson)newVal);
        System.out.println("matched: " + res.getMatchedCount() + " modified: " + res.getModifiedCount());
        for (Document docFound : collectionObject.find((Bson)Document.parse((String)"{ _id:{$eq:3},\"web-app.servlet.init-param.cachePackageTagsTrack\":{$gte:3},\"web-app.servlet.init-param.cachePackageTagsRefresh\":{$lte:60},\"web-app.servlet.init-param.searchEngineListTemplate\":{$eq:\"forSearchEnginesList.htm\"}}"))) {
            System.out.println("found: " + docFound.toJson());
        }
    }

    private static void replace() {
        System.out.println("Start replace one");
        Document filter = Document.parse((String)"{ \"_id\":1, \"web-app\": {\"servlet\": [{\"servlet-name\": \"cofaxCDS\",\"servlet-class\": \"org.cofax.cds.CDSServlet\",\"init-param\": {\"configGlossary:installationAt\": \"Philadelphia, PA\",\"configGlossary:adminEmail\": \"ksm@pobox.com\",\"configGlossary:poweredBy\": \"Cofax\",\"configGlossary:poweredByIcon\": \"/images/cofax.gif\",\"configGlossary:staticPath\": \"/content/static\",\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\",\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\",\"templatePath\": \"templates\",\"templateOverridePath\": \"\",\"defaultListTemplate\": \"listTemplate.htm\",\"defaultFileTemplate\": \"articleTemplate.htm\",\"useJSP\": false,\"jspListTemplate\": \"listTemplate.jsp\",\"jspFileTemplate\": \"articleTemplate.jsp\",\"cachePackageTagsTrack\": 1,\"cachePackageTagsStore\": 200,\"cachePackageTagsRefresh\": 60,\"cacheTemplatesTrack\": 100,\"cacheTemplatesStore\": 50,\"cacheTemplatesRefresh\": 15,\"cachePagesTrack\": 200,\"cachePagesStore\": 100,\"cachePagesRefresh\": 10,\"cachePagesDirtyRead\": 10,\"searchEngineListTemplate\": \"forSearchEnginesList.htm\",\"searchEngineFileTemplate\": \"forSearchEngines.htm\",\"searchEngineRobotsDb\": \"WEB-INF/robots.db\",\"useDataStore\": true,\"dataStoreClass\": \"org.cofax.SqlDataStore\",\"redirectionClass\": \"org.cofax.SqlRedirection\",\"dataStoreName\": \"cofax\",\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\",\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\",\"dataStoreUser\": \"sa\",\"dataStorePassword\": \"dataStoreTestQuery\",\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\",\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\",\"dataStoreInitConns\": 10,\"dataStoreMaxConns\": 100,\"dataStoreConnUsageLimit\": 100,\"dataStoreLogLevel\": \"debug\",\"maxUrlLength\": 500}},{\"servlet-name\": \"cofaxEmail\",\"servlet-class\": \"org.cofax.cds.EmailServlet\",\"init-param\": {\"mailHost\": \"mail1\",\"mailHostOverride\": \"mail2\"}},{\"servlet-name\": \"cofaxAdmin\",\"servlet-class\": \"org.cofax.cds.AdminServlet\"},{\"servlet-name\": \"fileServlet\",\"servlet-class\": \"org.cofax.cds.FileServlet\"},{\"servlet-name\": \"cofaxTools\",\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\",\"init-param\": {\"templatePath\": \"toolstemplates/\",\"log\": 1,\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\",\"logMaxSize\": \"\",\"dataLog\": 1,\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\",\"dataLogMaxSize\": \"\",\"removePageCache\": \"/content/admin/remove?cache=pages&id=\",\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\",\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\",\"lookInContext\": 1,\"adminGroupID\": 4,\"betaServer\": true}}],\"servlet-mapping\": {\"cofaxCDS\": \"/\",\"cofaxEmail\": \"/cofaxutil/aemail/*\",\"cofaxAdmin\": \"/admin/*\",\"fileServlet\": \"/static/*\",\"cofaxTools\": \"/tools/*\"},\"taglib\": {\"taglib-uri\": \"cofax.tld\",\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}");
        Document replace = Document.parse((String)"{\"web-app\": {\"servlet\": [{\"servlet-name\": \"NUOVOZ\",\"servlet-class\": \"org.cofax.cds.CDSServlet\",\"init-param\": {\"configGlossary:installationAt\": \"Philadelphia, PA\",\"configGlossary:adminEmail\": \"ksm@pobox.com\",\"configGlossary:poweredBy\": \"Cofax\",\"configGlossary:poweredByIcon\": \"/images/cofax.gif\",\"configGlossary:staticPath\": \"/content/static\",\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\",\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\",\"templatePath\": \"templates\",\"templateOverridePath\": \"\",\"defaultListTemplate\": \"listTemplate.htm\",\"defaultFileTemplate\": \"articleTemplate.htm\",\"useJSP\": false,\"jspListTemplate\": \"listTemplate.jsp\",\"jspFileTemplate\": \"articleTemplate.jsp\",\"cachePackageTagsTrack\": 1,\"cachePackageTagsStore\": 200,\"cachePackageTagsRefresh\": 60,\"cacheTemplatesTrack\": 100,\"cacheTemplatesStore\": 50,\"cacheTemplatesRefresh\": 15,\"cachePagesTrack\": 200,\"cachePagesStore\": 100,\"cachePagesRefresh\": 10,\"cachePagesDirtyRead\": 10,\"searchEngineListTemplate\": \"forSearchEnginesList.htm\",\"searchEngineFileTemplate\": \"forSearchEngines.htm\",\"searchEngineRobotsDb\": \"WEB-INF/robots.db\",\"useDataStore\": true,\"dataStoreClass\": \"org.cofax.SqlDataStore\",\"redirectionClass\": \"org.cofax.SqlRedirection\",\"dataStoreName\": \"cofax\",\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\",\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\",\"dataStoreUser\": \"sa\",\"dataStorePassword\": \"dataStoreTestQuery\",\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\",\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\",\"dataStoreInitConns\": 10,\"dataStoreMaxConns\": 100,\"dataStoreConnUsageLimit\": 100,\"dataStoreLogLevel\": \"debug\",\"maxUrlLength\": 500}},{\"servlet-name\": \"cofaxEmail\",\"servlet-class\": \"org.cofax.cds.EmailServlet\",\"init-param\": {\"mailHost\": \"mail1\",\"mailHostOverride\": \"mail2\"}},{\"servlet-name\": \"cofaxAdmin\",\"servlet-class\": \"org.cofax.cds.AdminServlet\"},{\"servlet-name\": \"fileServlet\",\"servlet-class\": \"org.cofax.cds.FileServlet\"},{\"servlet-name\": \"cofaxTools\",\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\",\"init-param\": {\"templatePath\": \"toolstemplates/\",\"log\": 1,\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\",\"logMaxSize\": \"\",\"dataLog\": 1,\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\",\"dataLogMaxSize\": \"\",\"removePageCache\": \"/content/admin/remove?cache=pages&id=\",\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\",\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\",\"lookInContext\": 1,\"adminGroupID\": 4,\"betaServer\": true}}],\"servlet-mapping\": {\"cofaxCDS\": \"/\",\"cofaxEmail\": \"/cofaxutil/aemail/*\",\"cofaxAdmin\": \"/admin/*\",\"fileServlet\": \"/static/*\",\"cofaxTools\": \"/tools/*\"},\"taglib\": {\"taglib-uri\": \"NUOVOZ\",\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        UpdateResult res = collectionObject.replaceOne((Bson)filter, (Object)replace);
        System.out.println("matched: " + res.getMatchedCount() + " modified: " + res.getModifiedCount());
        for (Document doc : collectionObject.find((Bson)Document.parse((String)"{_id:1}"))) {
            System.out.println("dopo replace: " + doc.toJson());
        }
    }
}

