/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.v20150209;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class JsonToObject {
    private Path path = new Path();
    private Map<String, Path> idsPath;
    static final QName type = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");

    JsonToObject(String _path, Map<String, String> _idPath) {
        if (_path != null && !_path.isEmpty()) {
            String[] stringArray = _path.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                this.path.add(str);
                ++n2;
            }
        }
        if (_idPath != null && !_idPath.isEmpty()) {
            this.idsPath = new HashMap<String, Path>();
            for (String key : _idPath.keySet()) {
                String path = _idPath.get(key);
                Path idPath = new Path();
                this.idsPath.put(key, idPath);
                String[] stringArray = path.split("/");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String str = stringArray[n3];
                    idPath.add(str);
                    ++n3;
                }
            }
        }
    }

    public void execute(XMLEventReader jxer, IJsonToObjectHandler handler) throws XMLStreamException, IOException {
        Object ret = null;
        String currentName = null;
        int _type = 0;
        Path currentPath = new Path();
        int number = 0;
        Stack stack = null;
        HashMap<String, String> currentId = new HashMap<String, String>();
        while (jxer.hasNext()) {
            Object parent;
            XMLEvent event = jxer.nextEvent();
            if (event.isStartElement()) {
                currentName = event.asStartElement().getName().getLocalPart();
                currentPath.add(currentName);
                if (currentPath.equals(this.path)) {
                    stack = new Stack();
                }
                if (stack == null) continue;
                _type = 0;
                Cloneable newObject = null;
                Attribute attr = event.asStartElement().getAttributeByName(type);
                if (attr != null) {
                    if (attr.getValue().equals("json:array")) {
                        newObject = new ArrayList();
                    } else if (attr.getValue().equals("json:object")) {
                        newObject = new LinkedHashMap();
                    } else if (attr.getValue().equals("string")) {
                        _type = 1;
                    } else if (attr.getValue().equals("boolean")) {
                        _type = 2;
                    } else if (attr.getValue().equals("decimal")) {
                        _type = 3;
                    }
                }
                if (newObject == null) continue;
                if (stack.size() > 0) {
                    parent = stack.lastElement();
                    if (parent instanceof List) {
                        ((List)parent).add(newObject);
                    } else if (parent instanceof Map) {
                        ((Map)parent).put(currentName, newObject);
                    }
                }
                stack.add(newObject);
                continue;
            }
            if (event.isEndElement()) {
                if (stack != null && _type == 0 && stack.size() > 0) {
                    ret = stack.pop();
                    if (currentPath.equals(this.path) && ret != null) {
                        handler.handleMessage(ret, currentId, ++number);
                        stack = null;
                        currentId.clear();
                    }
                }
                currentPath.remove();
                _type = 0;
                continue;
            }
            if (event.isCharacters()) {
                if (stack == null) continue;
                String data = event.asCharacters().getData();
                Object value = null;
                if (_type == 1) {
                    value = data;
                } else if (_type == 2) {
                    value = Boolean.valueOf(data);
                } else if (_type == 3) {
                    value = data.contains(".") ? BigDecimal.valueOf(Double.valueOf(data)) : BigInteger.valueOf(Long.valueOf(data));
                }
                if (this.idsPath != null) {
                    for (String key : this.idsPath.keySet()) {
                        Path idPath = this.idsPath.get(key);
                        if (!idPath.equals(currentPath) || value == null) continue;
                        currentId.put(key, value.toString());
                    }
                }
                if (stack.size() > 0) {
                    parent = stack.lastElement();
                    if (parent instanceof List) {
                        ((List)parent).add(value);
                        continue;
                    }
                    if (!(parent instanceof Map)) continue;
                    ((Map)parent).put(currentName, value);
                    continue;
                }
                ret = value;
                continue;
            }
            if (!event.isEndDocument()) continue;
            handler.handleEnd(number);
        }
    }

    public static interface IJsonToObjectHandler {
        public void handleEnd(int var1);

        public void handleMessage(Object var1, Map<String, String> var2, int var3);
    }

    class Path {
        Stack stack = new Stack();

        Path() {
        }

        void add(String str) {
            this.stack.add(str);
        }

        void remove() {
            if (this.stack.size() > 0) {
                this.stack.pop();
            }
        }

        boolean equals(Path path) {
            if (path.stack.size() == this.stack.size()) {
                int i = 0;
                while (i < this.stack.size()) {
                    if (!this.stack.get(i).equals(path.stack.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            String ret = "";
            int i = 0;
            while (i < this.stack.size()) {
                ret = String.valueOf(ret) + "/" + this.stack.get(i);
                ++i;
            }
            return ret;
        }
    }
}

