/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainerLevel implements Enumerator
{
    FIELD(0, "FIELD", "FIELD"),
    DATASTORE(1, "DATASTORE", "DATASTORE"),
    SCHEMA(2, "SCHEMA", "SCHEMA"),
    SERVER(3, "SERVER", "SERVER"),
    PRODUCT(4, "PRODUCT", "PRODUCT");

    public static final int FIELD_VALUE = 0;
    public static final int DATASTORE_VALUE = 1;
    public static final int SCHEMA_VALUE = 2;
    public static final int SERVER_VALUE = 3;
    public static final int PRODUCT_VALUE = 4;
    private static final ContainerLevel[] VALUES_ARRAY;
    public static final List<ContainerLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainerLevel[]{FIELD, DATASTORE, SCHEMA, SERVER, PRODUCT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainerLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerLevel get(int value) {
        switch (value) {
            case 0: {
                return FIELD;
            }
            case 1: {
                return DATASTORE;
            }
            case 2: {
                return SCHEMA;
            }
            case 3: {
                return SERVER;
            }
            case 4: {
                return PRODUCT;
            }
        }
        return null;
    }

    private ContainerLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

