/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.ws.soap.axiom.Axiom12CachingPayload;
import org.springframework.ws.soap.axiom.Axiom12NonCachingPayload;
import org.springframework.ws.soap.axiom.Axiom14CachingPayload;
import org.springframework.ws.soap.axiom.Axiom14NonCachingPayload;
import org.springframework.ws.soap.axiom.Payload;
import org.springframework.ws.soap.axiom.support.AxiomUtils;

final class AxiomPayloadUtils {
    private AxiomPayloadUtils() {
        throw new RuntimeException("Utility class not meant to be instantiated.");
    }

    static Payload createCachingPayload(SOAPBody axiomBody, SOAPFactory axiomFactory) {
        if (AxiomUtils.AXIOM14_IS_PRESENT()) {
            return new Axiom14CachingPayload(axiomBody, axiomFactory);
        }
        return new Axiom12CachingPayload(axiomBody, axiomFactory);
    }

    static Payload createNonCachingPayload(SOAPBody axiomBody, SOAPFactory axiomFactory) {
        if (AxiomUtils.AXIOM14_IS_PRESENT()) {
            return new Axiom14NonCachingPayload(axiomBody, axiomFactory);
        }
        return new Axiom12NonCachingPayload(axiomBody, axiomFactory);
    }
}

