/*
 * Decompiled with CFR 0.152.
 */
package com.indy.shell.internal;

import com.indy.shell.ShellApplicationException;
import com.indy.shell.internal.MappingWorkspaceVisitor;
import com.semarchy.xdi.designer.core.models.IMetaDataInformationsProviderFactory;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.MappingBuildablePredicate;
import com.semarchy.xdi.designer.core.utils.MemoryPreserverEditingDomainWrapper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;

public class MappingBuilder {
    private static final String MSG_SERVICE_NOT_FOUND = "Could not find the service %s";
    ICacheService cacheService;
    Logger logger = LogManager.getLogger(MappingBuilder.class);
    MemoryPreserverEditingDomainWrapper editingDomainWrapper;
    IMappingBuilderDelegate builderDelegate;

    public MappingBuilder() throws ShellApplicationException {
        this.cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        this.builderDelegate = (IMappingBuilderDelegate)E4InjectorHelper.getService(IMappingBuilderDelegate.class);
        IMetaDataInformationsProviderFactory mdipf = (IMetaDataInformationsProviderFactory)E4InjectorHelper.getService(IMetaDataInformationsProviderFactory.class);
        if (this.cacheService == null) {
            throw new ShellApplicationException(String.format(MSG_SERVICE_NOT_FOUND, ICacheService.class));
        }
        if (this.builderDelegate == null) {
            throw new ShellApplicationException(String.format(MSG_SERVICE_NOT_FOUND, IMappingBuilderDelegate.class));
        }
        if (mdipf == null) {
            throw new ShellApplicationException(String.format(MSG_SERVICE_NOT_FOUND, IMetaDataInformationsProviderFactory.class));
        }
        this.editingDomainWrapper = new MemoryPreserverEditingDomainWrapper(mdipf, 15);
    }

    public void buildMappings() throws BuildException {
        IWorkspace workspace = (IWorkspace)E4InjectorHelper.getService(IWorkspace.class);
        MappingWorkspaceVisitor visitor = new MappingWorkspaceVisitor();
        try {
            workspace.getRoot().accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            throw new BuildException("Failed to look for mappings within the workspace", (Exception)((Object)e));
        }
        try {
            visitor.getMappings().stream().map(f -> URIUtils.convertIPathToEMFURI2((IPath)f.getFullPath())).filter(MappingBuildablePredicate.of((ICacheService)this.cacheService, (Logger)this.logger)).forEach(this::build);
        }
        finally {
            this.editingDomainWrapper.releaseMemory();
        }
    }

    /*
     * Loose catch block
     */
    private void build(URI modelURI) {
        Resource mappingResource = null;
        this.logger.info(() -> String.format("Building %s ...", modelURI));
        try {
            try {
                mappingResource = this.editingDomainWrapper.loadResource(modelURI);
                this.builderDelegate.buildMapping(mappingResource);
                mappingResource.unload();
                this.editingDomainWrapper.getEditingDomain().getResourceSet().getResources().remove((Object)mappingResource);
                this.logger.info(() -> String.format("Built %s", modelURI));
            }
            catch (WrappedException e) {
                this.logger.error(String.format("Failed to load mapping %s", modelURI), (Throwable)e);
                if (!this.editingDomainWrapper.releaseWhenMemoryIsThin()) {
                    this.editingDomainWrapper.releaseMemory();
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to build mapping %s", modelURI), (Throwable)e);
                if (!this.editingDomainWrapper.releaseWhenMemoryIsThin()) {
                    this.editingDomainWrapper.releaseMemory();
                }
            }
            catch (OutOfMemoryError e) {
                this.editingDomainWrapper.releaseMemory();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (!this.editingDomainWrapper.releaseWhenMemoryIsThin()) {
                    this.editingDomainWrapper.releaseMemory();
                }
            }
        }
        finally {
            if (!this.editingDomainWrapper.releaseWhenMemoryIsThin()) {
                this.editingDomainWrapper.releaseMemory();
            }
        }
    }

    public class BuildException
    extends Exception {
        public BuildException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

