/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator;

import com.indy.engine.core.common.objects2.DeliveryRepositoryInfoExchange;
import com.indy.engine.core.common.objects2.IDeliveryRepositoryInfo;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.app.authorization.Action;
import com.stambia.ui.navigator.NavigatorFacade;
import com.stambia.ui.navigator.SyncInfo;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnRuntimeRepositories;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RuntimeSynchronizer {
    Job job = new Job("Synchronizing runtimes"){

        protected IStatus run(IProgressMonitor monitor) {
            RuntimeSynchronizer.this.synchronizing.addAll(RuntimeSynchronizer.this.toSynch);
            RuntimeSynchronizer.this.toSynch.clear();
            while (!RuntimeSynchronizer.this.synchronizing.isEmpty()) {
                final OwnRuntime curRuntime = RuntimeSynchronizer.this.synchronizing.poll();
                IStambiaRuntime runtime = curRuntime.getRuntime();
                SyncInfo info = RuntimeSynchronizer.this.infoMaps.remove(curRuntime);
                ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
                String id = "Runtime Synch " + runtime.getName() + "(" + runtime.getHost() + ":" + runtime.getPort() + ") ";
                try {
                    AnalyticsEngineWrapper _runtime = EngineRegistry.getDefault().getEngine(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword());
                    if (EngineRegistry.isConnected((AnalyticsEngineWrapper)_runtime)) {
                        curRuntime.setStatus(1);
                        Map map = _runtime.getVersion();
                        if (map != null) {
                            curRuntime.setVersion((String)map.get("branding.engine"));
                        }
                    }
                    if (EngineRegistry.getDefault().isRuntimes17_4_2(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword())) {
                        Map repos = _runtime.getRepositories(null);
                        for (Map repoMap : repos.values()) {
                            DeliveryRepositoryInfoExchange esd = new DeliveryRepositoryInfoExchange(repoMap);
                            String resourceId = String.valueOf(curRuntime.getResourceId()) + "/" + esd.getName();
                            resources.add(new IPotentialResource((IDeliveryRepositoryInfo)esd, curRuntime, resourceId){
                                private final /* synthetic */ IDeliveryRepositoryInfo val$esd;
                                private final /* synthetic */ OwnRuntime val$curRuntime;
                                private final /* synthetic */ String val$resourceId;
                                {
                                    this.val$esd = iDeliveryRepositoryInfo;
                                    this.val$curRuntime = ownRuntime;
                                    this.val$resourceId = string;
                                }

                                @Override
                                public String getName() {
                                    return this.val$esd.getName();
                                }

                                @Override
                                public IResource createResource() {
                                    return new OwnRuntimeRepositories(this.val$esd.getName(), this.val$curRuntime, this.val$resourceId, this.val$esd);
                                }

                                @Override
                                public String getId() {
                                    return this.val$resourceId;
                                }
                            });
                        }
                    } else {
                        final String resourceId = String.valueOf(curRuntime.getResourceId()) + "/" + UUID.randomUUID();
                        resources.add(new IPotentialResource(){

                            @Override
                            public String getName() {
                                return "default";
                            }

                            @Override
                            public IResource createResource() {
                                HashMap<String, Object> defaultRepoMap = new HashMap<String, Object>();
                                defaultRepoMap.put("isWebservice", false);
                                defaultRepoMap.put("isDefault", true);
                                defaultRepoMap.put("name", null);
                                defaultRepoMap.put("type", "File");
                                return new OwnRuntimeRepositories("default", curRuntime, resourceId, (IDeliveryRepositoryInfo)new DeliveryRepositoryInfoExchange(defaultRepoMap));
                            }

                            @Override
                            public String getId() {
                                return resourceId;
                            }
                        });
                    }
                    curRuntime.setConnectionException(null);
                    if (RuntimeSynchronizer.this.display != null && !RuntimeSynchronizer.this.display.isDisposed()) {
                        RuntimeSynchronizer.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                NavigatorFacade.navigatorUISynchItem(curRuntime);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    curRuntime.setStatus(-1);
                    if (RuntimeSynchronizer.this.display != null && !RuntimeSynchronizer.this.display.isDisposed()) {
                        RuntimeSynchronizer.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                NavigatorFacade.navigatorUISynchItem(curRuntime);
                            }
                        });
                    }
                    curRuntime.setConnectionException(e);
                    e.printStackTrace();
                }
                RuntimeSynchronizer.this.toRefreshInUI.put(curRuntime, new Object[]{info, resources});
            }
            NavigatorFacade.navigatorUISynch(RuntimeSynchronizer.this.display, RuntimeSynchronizer.this.toRefreshInUI);
            if (!RuntimeSynchronizer.this.toSynch.isEmpty()) {
                RuntimeSynchronizer.this.job.schedule(1000L);
            }
            return Status.OK_STATUS;
        }
    };
    Map<OwnRuntime, SyncInfo> infoMaps = Collections.synchronizedMap(new HashMap());
    Queue<OwnRuntime> toSynch = new ConcurrentLinkedQueue<OwnRuntime>();
    Queue<OwnRuntime> synchronizing = new ConcurrentLinkedQueue<OwnRuntime>();
    Map<OwnRuntime, Object[]> toRefreshInUI = Collections.synchronizedMap(new HashMap());
    Display display;

    public void setDisplay(Display display) {
        this.display = display;
    }

    public synchronized void add(OwnRuntime runtime, boolean deeply, Map<String, Object> requestInfo) {
        if (NavigatorFacade.isAuthorized(Action.RUNTIME_DELIVERY_ACCESS)) {
            this.infoMaps.put(runtime, new SyncInfo(deeply, requestInfo));
            if (!this.toSynch.contains(runtime)) {
                this.toSynch.add(runtime);
            }
            runtime.setStatus(2);
            NotificationManager.getInstance().refreshItem((IResource)runtime);
            this.job.schedule(1000L);
        }
    }
}

