/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.ui.common.resource.IResource;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameWizard
extends Wizard {
    private String name;
    private String path;
    private IResource element;
    private RenameWizardPage initialObjectCreationPage;
    private HashSet<String> fileNames;

    public boolean performFinish() {
        return this.element.rename(this.name);
    }

    public void init(IResource element) {
        this.setWindowTitle("Rename");
        this.fileNames = new HashSet();
        this.element = element;
        for (IResource res : element.getParent().getResources()) {
            this.fileNames.add(res.getName());
        }
    }

    public void addPages() {
        this.initialObjectCreationPage = new RenameWizardPage("rename");
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public URI getModelURI() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public class RenameWizardPage
    extends WizardPage {
        private Text newNameField;
        protected ModifyListener validator;

        public RenameWizardPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameWizardPage.this.setPageComplete(RenameWizardPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText("New name: ");
            this.newNameField = new Text(composite, 2048);
            data = new GridData(4, 4, true, false);
            this.newNameField.setLayoutData((Object)data);
            this.newNameField.setText(RenameWizard.this.element.getName());
            this.newNameField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            URI fileURI = this.getFileURI();
            if (fileURI == null || fileURI.isEmpty()) {
                this.setErrorMessage(null);
                return false;
            }
            String extension = fileURI.fileExtension();
            if (extension != null) {
                this.setErrorMessage("Extension must be empty");
                return false;
            }
            if (fileURI.toString().matches("# \\| | : | * | <  | > | \\ | / | ?")) {
                this.setErrorMessage("File name incorrect");
                return false;
            }
            if (RenameWizard.this.fileNames.contains(RenameWizard.this.name)) {
                this.setErrorMessage("Folder " + RenameWizard.this.name + " already exists");
                return false;
            }
            if (RenameWizard.this.fileNames.contains(String.valueOf(RenameWizard.this.name) + ".criteria")) {
                this.setErrorMessage("File " + RenameWizard.this.name + " already exists");
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.newNameField.setFocus();
            }
        }

        public URI getFileURI() {
            try {
                RenameWizard.this.name = this.newNameField.getText();
                return URI.createFileURI((String)this.newNameField.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void selectFileField() {
            this.newNameField.selectAll();
            this.newNameField.setFocus();
        }
    }
}

