/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.internal.actions.AbstractAction;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnSchedule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class ResumeSchedule
extends AbstractAction {
    public void run(IAction action) {
        if (this.selectedItem instanceof OwnSchedule) {
            OwnSchedule schedule = (OwnSchedule)this.selectedItem;
            OwnRuntime runtime = schedule.getRuntime();
            EngineRegistry.getDefault().resumeTrigger(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword(), schedule.getTriggerName(), "Deliveries");
            NotificationManager.getInstance().refreshItem((IResource)schedule);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.selectedItem != null && action.isEnabled()) {
            if (this.selectedItem instanceof OwnSchedule) {
                String host = ((OwnSchedule)this.selectedItem).getRuntime().getHost();
                int port = ((OwnSchedule)this.selectedItem).getRuntime().getPort();
                String user = ((OwnSchedule)this.selectedItem).getRuntime().getUser();
                String password = ((OwnSchedule)this.selectedItem).getRuntime().getPassword();
                if (EngineRegistry.getDefault().isRuntimes17_1_14(host, Integer.valueOf(port), user, password)) {
                    if (EngineRegistry.getDefault().isSchedulePaused(host, port, user, password, ((OwnSchedule)this.selectedItem).getTriggerName(), "Deliveries")) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
    }
}

