/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IResourceChanged;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.app.authorization.Action;
import com.stambia.ui.navigator.NavigatorFacade;
import com.stambia.ui.navigator.cnf.DataModelLabelProvider;
import com.stambia.ui.navigator.cnf.IDataModelViewer;
import com.stambia.ui.navigator.data.IDataModel;
import com.stambia.ui.navigator.data.INavigatorItem;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnRuntimes;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DataModel
implements IDataModel {
    private final Object lock = new Object();
    private Set<IDataModelViewer> changeListeners = new HashSet<IDataModelViewer>();
    private Map<String, IResource> navigatorRoots = new HashMap<String, IResource>();
    private OwnRuntimes ownRuntimes = new OwnRuntimes();

    public DataModel() {
        this.initNavigatorRoot();
    }

    private void initNavigatorRoot() {
        this.navigatorRoots.putAll(NavigatorFacade.getNavigatorAdditionalRoots());
        if (NavigatorFacade.isAuthorized(Action.RUNTIME_ACCESS)) {
            this.navigatorRoots.put(Constante.OWN_RUNTIMES, this.ownRuntimes);
        }
    }

    @Override
    public Set<IDataModelViewer> getChangeListeners() {
        return this.changeListeners;
    }

    @Override
    public List<IResource> getRoots() {
        return new ArrayList<IResource>(this.navigatorRoots.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(INavigatorItem element) {
        Object object = this.lock;
        synchronized (object) {
            element.remove();
        }
    }

    @Override
    public void moveElement(IResource elementSource, IResource elementDestination) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAdd(IResource re) {
        Set<IDataModelViewer> set = this.changeListeners;
        synchronized (set) {
            for (IDataModelViewer listener : this.changeListeners) {
                listener.addItem(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdate(IResourceChanged re) {
        Set<IDataModelViewer> set = this.changeListeners;
        synchronized (set) {
            for (IDataModelViewer listener : this.changeListeners) {
                listener.updateItem(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemove(IResource re) {
        Set<IDataModelViewer> set = this.changeListeners;
        synchronized (set) {
            for (IDataModelViewer listener : this.changeListeners) {
                listener.removeItem(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIsAboutToBeMoved(IResource re) {
        Set<IDataModelViewer> set = this.changeListeners;
        synchronized (set) {
            for (IDataModelViewer listener : this.changeListeners) {
                listener.moveItem(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshItem(IResource re) {
        Set<IDataModelViewer> set = this.changeListeners;
        synchronized (set) {
            for (IDataModelViewer listener : this.changeListeners) {
                listener.refreshItem(re);
            }
        }
    }

    private Image createDecoratedImage(final Image baseImage, final ImageData decorator) {
        if (baseImage != null && baseImage.getImageData() != null) {
            CompositeImageDescriptor compositeImg = new CompositeImageDescriptor(){

                protected Point getSize() {
                    return new Point(baseImage.getBounds().width, baseImage.getBounds().height);
                }

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(baseImage.getImageData(), 0, 0);
                    this.drawImage(decorator, 0, this.getSize().y - decorator.height);
                }
            };
            return compositeImg.createImage();
        }
        return baseImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRuntimes(List<IStambiaRuntime> oldRuntimes, List<IStambiaRuntime> newRuntimes) {
        Object object;
        ArrayList<IStambiaRuntime> toRemove = new ArrayList<IStambiaRuntime>();
        ArrayList<IStambiaRuntime> toAdd = new ArrayList<IStambiaRuntime>();
        ArrayList<IStambiaRuntime> toModify = new ArrayList<IStambiaRuntime>();
        HashMap<String, IStambiaRuntime> oldIndex = new HashMap<String, IStambiaRuntime>();
        HashMap<String, IStambiaRuntime> newIndex = new HashMap<String, IStambiaRuntime>();
        if (newRuntimes.isEmpty()) {
            toRemove.addAll(oldRuntimes);
        } else if (oldRuntimes.isEmpty()) {
            toAdd.addAll(newRuntimes);
        } else {
            for (IStambiaRuntime runtime : oldRuntimes) {
                oldIndex.put(runtime.getUUID(), runtime);
            }
            for (IStambiaRuntime runtime : newRuntimes) {
                newIndex.put(runtime.getUUID(), runtime);
            }
            for (IStambiaRuntime runtime : oldRuntimes) {
                IStambiaRuntime newRuntime = (IStambiaRuntime)newIndex.get(runtime.getUUID());
                if (newRuntime == null) continue;
                toRemove.remove(runtime);
            }
            for (IStambiaRuntime runtime : newRuntimes) {
                IStambiaRuntime oldRuntime = (IStambiaRuntime)oldIndex.get(runtime.getUUID());
                if (oldRuntime == null) {
                    toAdd.add(runtime);
                    continue;
                }
                toModify.add(runtime);
            }
        }
        for (IStambiaRuntime runtime : toAdd) {
            object = this.lock;
            synchronized (object) {
                OwnRuntime runtimeToAdd = new OwnRuntime(runtime, (IResource)this.ownRuntimes, this.ownRuntimes.getSynchronizer());
                ((OwnRuntimes)runtimeToAdd.getParent()).addChild(runtimeToAdd, true);
                runtimeToAdd.getParent().synchronize(false, new HashMap());
            }
        }
        for (IStambiaRuntime runtime : toRemove) {
            object = this.lock;
            synchronized (object) {
                OwnRuntime runtimeToRemove = new OwnRuntime(runtime, (IResource)this.ownRuntimes, this.ownRuntimes.getSynchronizer());
                IResource deletedRuntime = ((OwnRuntimes)runtimeToRemove.getParent()).removeChild(runtimeToRemove);
                if (deletedRuntime != null && deletedRuntime instanceof ResourceWithChildren) {
                    ((ResourceWithChildren)deletedRuntime).removeChildrens(deletedRuntime);
                }
            }
        }
        for (IStambiaRuntime runtime : toModify) {
            object = this.lock;
            synchronized (object) {
                IStambiaRuntime _old = (IStambiaRuntime)oldIndex.get(runtime.getUUID());
                OwnRuntime ownRuntime = (OwnRuntime)this.ownRuntimes.getChildren().get(_old.getUUID());
            }
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataModel.this.refreshItem(DataModel.this.ownRuntimes);
            }
        });
    }

    private void updateStatus(IResource children, DataModelLabelProvider modelLabelProvier) {
        modelLabelProvier._fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)modelLabelProvier, (Object)children));
        for (IResource child : children.getResources()) {
            this.updateStatus(child, modelLabelProvier);
        }
    }

    public OwnRuntimes getOwnRuntimes() {
        return this.ownRuntimes;
    }

    public void dispose() {
        this.ownRuntimes.dispose();
        this.ownRuntimes = null;
        this.changeListeners.clear();
        this.changeListeners = null;
    }

    @Override
    public IResource getRoot(String root) {
        if (this.navigatorRoots.containsKey(root)) {
            return this.navigatorRoots.get(root);
        }
        return null;
    }

    @Override
    public void refreshAllNavigator() {
        for (IResource rootResource : this.getRoots()) {
            rootResource.synchronize(true, new HashMap());
        }
    }
}

