/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.DeliveryEditorInput;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.app.authorization.Action;
import com.stambia.app.authorization.AuthManager;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.data.IDeliveries;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnRuntimeRepositories;
import com.stambia.ui.navigator.internal.data.OwnSchedule;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OwnDelivery
extends ResourceWithChildren
implements IDeliveries {
    private String deliveryId;
    private String logLevel;
    private static final Logger LOGGER = Logger.getLogger(OwnDelivery.class.getName());

    public OwnDelivery(String name, IResource parent, String resourceId, String deliveryId, String logLevel) {
        super(name, parent, resourceId);
        this.deliveryId = deliveryId;
        this.logLevel = logLevel;
        ((OwnRuntimeRepositories)parent).getChildren().put(resourceId, this);
    }

    public OwnRuntime getRuntime() {
        return (OwnRuntime)this.getParent().getParent();
    }

    public String getRepoDir() {
        if (this.getParent() instanceof OwnRuntimeRepositories) {
            return ((OwnRuntimeRepositories)this.getParent()).getDirName();
        }
        return null;
    }

    public void synchronize(boolean deeply, Map<String, Object> requestInfo) {
        boolean syncSchedule = AuthManager.isAuthorized((Action)Action.RUNTIME_DELIVERY_SCHEDULE_ACCESS);
        if (syncSchedule && this.getParent() != null && ((OwnRuntimeRepositories)this.getParent()).isDefault().booleanValue()) {
            ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
            String id = "Delivery Synch " + this.name + " ";
            IStambiaRuntime runtime = ((OwnRuntimeRepositories)this.getParent()).getRuntime();
            try {
                List list;
                Map<String, ArrayList<ScheduleInfo>> schedules = null;
                if (requestInfo != null) {
                    schedules = (Map)requestInfo.get("schedules_" + runtime.getUUID());
                }
                if (schedules == null || !EngineRegistry.getDefault().isRuntimes17_3_0(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword())) {
                    schedules = new HashMap();
                    List _schedules = EngineRegistry.getDefault().getLstSchedules(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword(), this.name);
                    if (_schedules != null) {
                        for (Map map : _schedules) {
                            ScheduleInfo si = new ScheduleInfo();
                            si.triggerName = (String)map.get("triggerName");
                            si.jobName = (String)map.get("jobName");
                            si.scheduleName = (String)map.get("scheduleName");
                            si.deliveryName = (String)map.get("deliveryName");
                            si.deliveryName = si.deliveryName == null ? si.jobName : si.deliveryName;
                            ArrayList<ScheduleInfo> strs = (ArrayList<ScheduleInfo>)schedules.get(si.deliveryName);
                            if (strs == null) {
                                strs = new ArrayList<ScheduleInfo>();
                                schedules.put(si.deliveryName, strs);
                            }
                            strs.add(si);
                        }
                        requestInfo.put("schedules_" + runtime.getUUID(), schedules);
                    } else {
                        requestInfo.put("schedules_" + runtime.getUUID(), Collections.EMPTY_MAP);
                    }
                }
                if (schedules != null && (list = (List)schedules.get(this.name)) != null) {
                    for (final ScheduleInfo si : list) {
                        final String resourceId = String.valueOf(this.getResourceId()) + "/" + si.triggerName;
                        resources.add(new IPotentialResource(){

                            @Override
                            public String getName() {
                                String label = si.scheduleName != null ? si.scheduleName : si.triggerName;
                                if (!si.jobName.equals(si.deliveryName)) {
                                    label = String.valueOf(si.jobName) + "/" + label;
                                }
                                return label;
                            }

                            @Override
                            public IResource createResource() {
                                return new OwnSchedule(this.getName(), OwnDelivery.this, resourceId, si.triggerName);
                            }

                            @Override
                            public String getId() {
                                return resourceId;
                            }
                        });
                    }
                }
                this.synchronize(resources, deeply, requestInfo);
                resources.clear();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public Image getImage() {
        return NavigatorActivator.getDefault().getImage("ExecDelivery16x16.png");
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        boolean result = false;
        try {
            activePage.openEditor((IEditorInput)new DeliveryEditorInput(this.getName(), this.getResourceId(), this.getRuntime().getName(), this.getRuntime().getPort(), this.getRuntime().getHost(), this.getRuntime().getUser(), this.getRuntime().getPassword(), this.getRepoDir(), this.getRuntime().isNoSessionAccess()), Constante.DELIVERY_FORM_EDITOR);
        }
        catch (PartInitException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            result = false;
        }
        return result;
    }

    @Override
    public void remove() {
        block2: {
            try {
                String host = this.getRuntime().getHost();
                int port = this.getRuntime().getPort();
                String user = this.getRuntime().getUser();
                String password = this.getRuntime().getPassword();
                EngineRegistry.getDefault().deleteDelivery(host, Integer.valueOf(port), user, password, this.getName(), this.getParent().getName());
                ((OwnRuntimeRepositories)this.getParent()).removeChild(this);
            }
            catch (Exception e) {
                if (!(e instanceof ServerException)) break block2;
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Deletion error", (String)((ServerException)e).detail.getMessage());
            }
        }
    }

    class ScheduleInfo {
        String jobName;
        String scheduleName;
        String triggerName;
        String deliveryName;

        ScheduleInfo() {
        }
    }
}

