/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IRuntime;
import com.indy.ui.common.resource.IRuntimeChanged;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.ui.navigator.RuntimeSynchronizer;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.Map;
import java.util.UUID;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OwnRuntime
extends ResourceWithChildren
implements IRuntime,
IRuntimeChanged {
    private IStambiaRuntime runtime;
    private Exception connectionException;
    private RuntimeSynchronizer sync;
    int status = 0;
    private String version;
    private String host;

    public String getHost() {
        return this.runtime.getHost();
    }

    public int getPort() {
        return this.runtime.getPort();
    }

    public Boolean isNoSessionAccess() {
        return this.runtime.isNoSessionAccess();
    }

    public OwnRuntime(IStambiaRuntime runtime, IResource parent, RuntimeSynchronizer sync) {
        super(runtime.getName(), parent, UUID.randomUUID().toString());
        this.runtime = runtime;
        this.sync = sync;
    }

    public String getUser() {
        return this.runtime.getUser();
    }

    public String getPassword() {
        return this.runtime.getPassword();
    }

    public String getLogLevel() {
        return this.runtime.getLogLevel();
    }

    public IStambiaRuntime getRuntime() {
        return this.runtime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setConnectionException(Exception connectionException) {
        this.connectionException = connectionException;
    }

    public void synchronize(boolean deeply, Map<String, Object> requestInfo) {
        this.sync.add(this, deeply, requestInfo);
    }

    @Override
    public void dispose() {
        this.runtime = null;
        super.dispose();
    }

    public Exception getConnectionException() {
        return this.connectionException;
    }

    public String getFullName() {
        if (this.version != null && !this.version.isEmpty()) {
            return String.valueOf(this.getName()) + " (" + this.getHost() + ":" + this.getPort() + ")" + " - " + this.version;
        }
        return String.valueOf(this.getName()) + " (" + this.getHost() + ":" + this.getPort() + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwnRuntime) {
            return this.resourceId.equals(((OwnRuntime)obj).resourceId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        try {
            activePage.openEditor((IEditorInput)new RuntimeEditorInput(this.getHost(), this.getPort(), this.getResourceId(), this.getName(), this.getUser(), this.getPassword()), Constante.RUNTIME_EDITOR_ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

