/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.log.ILog;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.NavigatorFacade;
import com.stambia.ui.navigator.RuntimeSynchronizer;
import com.stambia.ui.navigator.data.INavigatorItem;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OwnRuntimes
extends ResourceWithChildren
implements INavigatorItem {
    RuntimeSynchronizer sync = new RuntimeSynchronizer();

    public OwnRuntimes() {
        super("Runtimes", null, UUID.randomUUID().toString());
        this.setOrder("5");
        this.sync.setDisplay(PlatformUI.getWorkbench().getDisplay());
    }

    public void synchronize(boolean deeply, Map<String, Object> requestInfo) {
        ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
        for (final IStambiaRuntime runtime : NavigatorFacade.getRuntimes()) {
            resources.add(new IPotentialResource(){

                @Override
                public String getName() {
                    return runtime.getName();
                }

                @Override
                public IResource createResource() {
                    return new OwnRuntime(runtime, (IResource)OwnRuntimes.this, OwnRuntimes.this.sync);
                }

                @Override
                public String getId() {
                    return runtime.getUUID();
                }
            });
        }
        this.synchronize(resources, deeply, requestInfo);
    }

    public void updateStatus(ILog log) {
        for (IResource resource : this.getResources()) {
            if (!(resource instanceof OwnRuntime) || !((OwnRuntime)resource).getRuntime().getUUID().equals(log.getLogId())) continue;
            ((OwnRuntime)resource).status = log.getConnectionException() != null && log.getConnectionException().getMessage() != null ? -1 : (log.isConnected() != false ? 1 : 0);
        }
    }

    @Override
    public Image getImage() {
        return NavigatorActivator.getDefault().getImage("listRuntimes.png");
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        return false;
    }

    @Override
    public void remove() {
    }

    public RuntimeSynchronizer getSynchronizer() {
        return this.sync;
    }
}

