/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileManagment;

import com.stambia.jdbc.driver.file.fileManagment.ILineContext;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.IStambiaReader;
import com.stambia.jdbc.driver.file.fileManagment.Messages;
import com.stambia.jdbc.driver.file.fileManagment.TransformInputStreamWithScript;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilterSet;
import com.stambia.jdbc.driver.file.tools.BinaryNumber;
import com.stambia.jdbc.driver.file.tools.Pointer;
import com.stambia.jdbc.driver.file.tools.StbScriptEngineManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class StambiaBufferedReaderI
extends Reader
implements IStambiaReader,
IReadContext {
    private Reader in;
    private String lineTerminator = System.getProperty("line.separator");
    private SeparatorComparator rowSeparatorComparator = new SeparatorComparator(System.getProperty("line.separator").toCharArray());
    private char[] cb;
    private int nChars;
    private int nextChar;
    int headerLineToSkipSize = 0;
    private String previousReturnCharSequence = "";
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private String stringDelimiter = null;
    private String escapeChar = null;
    private SeparatorComparator stringDelimiterComparator = new SeparatorComparator("".toCharArray());
    private SeparatorComparator fieldSeparator = new SeparatorComparator(",".toCharArray());
    private boolean eof = false;
    private boolean eol;
    private int lineSize = -1;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;
    String languageLineTransformation = null;
    String scriptLineTransformation = null;
    int lineSizePositionStart = -1;
    int lineSizePositionEnd = -1;
    String lineSizeExpression;
    LineSizeMode lineSizeMode = LineSizeMode.NO;
    boolean hasFilter = false;
    int endPosition = -1;
    int endingLineToSkip = 0;
    int lastLineToStore = 0;
    public int readLineModeVersion = 1;
    StringBuilder sb = new StringBuilder();
    MetadataFilterSet filterSet;
    private boolean hasFilterSet;
    MetadataFilterSet currentSet;
    private ScriptEngine scriptEngine;
    private Bindings bindings;
    private int linePosition = -1;
    ILineContext rootContext = new ILineContext(){
        String uuid;

        @Override
        public String getUUID() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
            }
            return this.uuid;
        }

        @Override
        public String getTimeStampPosition() throws IOException {
            return String.valueOf(StambiaBufferedReaderI.this.startTimeStamp()) + "." + this.getLocalPosition();
        }

        @Override
        public int getLocalPosition() {
            return StambiaBufferedReaderI.this.linePosition;
        }

        @Override
        public Pointer<String> getLine() {
            return null;
        }
    };
    String[] scriptReturn;
    int scriptReturIndex;
    private Map store;
    private Api api;
    private List __ret__;
    Queue<String> queue;
    int lineReaded;
    int lineSkiped;
    int rowLimit = -1;
    String sourceName;
    Long timestamp;
    int firstLinePosition;

    public void setLineToSkipBefore(int headerLineToSkipSize) {
        this.headerLineToSkipSize = headerLineToSkipSize;
    }

    public StambiaBufferedReaderI(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public StambiaBufferedReaderI(Reader in) {
        this(in, defaultCharBufferSize);
    }

    public void setLineTransformLanguage(String languageLineTransformation) {
        this.languageLineTransformation = languageLineTransformation != null && !languageLineTransformation.isEmpty() ? languageLineTransformation : null;
    }

    public void setLineTransformScript(String scriptLineTransformation) {
        this.scriptLineTransformation = scriptLineTransformation != null && !scriptLineTransformation.isEmpty() ? scriptLineTransformation : null;
    }

    public void setLineSeparator(String lineSep) {
        this.rowSeparatorComparator = lineSep != null && !lineSep.isEmpty() ? new SeparatorComparator(lineSep.toCharArray()) : new SeparatorComparator("".toCharArray());
        this.lineTerminator = lineSep;
    }

    public void setLineSize(String size) throws IOException {
        if (size == null || size.isEmpty() || size.equals("-1")) {
            this.lineSizeMode = LineSizeMode.NO;
        } else if (size.matches("[0-9]+")) {
            this.setLineSize(Integer.valueOf(size));
        } else {
            this.setLineSeparator("");
            String _size = size.trim();
            if (size.endsWith("le")) {
                this.lineSizeMode = LineSizeMode.LITTLE_ENDIAN;
                _size = size.substring(0, size.length() - 1);
            }
            if (size.endsWith("be") || size.endsWith("b")) {
                this.lineSizeMode = LineSizeMode.BIG_ENDIAN;
                _size = size.substring(0, size.length() - 1);
            } else {
                this.lineSizeMode = LineSizeMode.String;
            }
            String[] part = _size.trim().split(",");
            if (part.length != 2) {
                throw new IOException(String.valueOf(Messages.getString("StambiaBufferedReaderI.0")) + size);
            }
            String part1 = part[0].trim();
            String part2 = part[1].trim();
            if (part1.matches("[0-9]+")) {
                this.lineSizePositionStart = Integer.parseInt(part1);
                if (this.lineSizePositionStart < 1) {
                    throw new IOException(String.valueOf(Messages.getString("StambiaBufferedReaderI.1")) + size + Messages.getString("StambiaBufferedReaderI.2"));
                }
            } else {
                throw new IOException(String.valueOf(Messages.getString("StambiaBufferedReaderI.3")) + size + Messages.getString("StambiaBufferedReaderI.4"));
            }
            if (part2.matches("[0-9]+")) {
                this.lineSizePositionEnd = Integer.parseInt(part2);
                if (this.lineSizePositionStart < 1) {
                    throw new IOException(String.valueOf(Messages.getString("StambiaBufferedReaderI.5")) + size + Messages.getString("StambiaBufferedReaderI.6"));
                }
            } else {
                throw new IOException(String.valueOf(Messages.getString("StambiaBufferedReaderI.7")) + size + Messages.getString("StambiaBufferedReaderI.8"));
            }
            this.lineSizePositionEnd = this.lineSizePositionStart + this.lineSizePositionEnd - 1;
            this.lineSize = -2;
        }
    }

    public void setLineSize(int size) {
        this.lineSize = size;
        if (this.lineSize > -1 || this.lineSize == -2) {
            this.setLineSeparator("");
            this.lineSizeMode = LineSizeMode.Size;
        } else {
            this.lineSizeMode = LineSizeMode.NO;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException(Messages.getString("StambiaBufferedReaderI.9"));
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this.cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return this.cb[this.nextChar++];
        }
    }

    public int readWithoutLock() throws IOException {
        this.ensureOpen();
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            if (this.cb[this.nextChar] != '\n') break;
            ++this.nextChar;
        }
        return this.cb[this.nextChar++];
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (len >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        System.arraycopy(this.cb, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n1;
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = this.read1(cbuf, off, len);
            if (n <= 0) {
                return n;
            }
            while (n < len && this.in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
                n += n1;
            }
            return n;
        }
    }

    String readLine(boolean ignoreLF) throws IOException {
        String str;
        do {
            if ((str = this.readLine3(false)) != null) continue;
            return null;
        } while (++this.linePosition < this.headerLineToSkipSize);
        return str;
    }

    String readLine3(boolean ignoreLF) throws IOException {
        String str = this.readLine2(false);
        if (str == null) {
            return null;
        }
        if (this.endingLineToSkip > 0 && this.endPosition > -1 && this.endingLineToSkip > this.endPosition) {
            return null;
        }
        return str;
    }

    String readLine2(boolean ignoreLF) throws IOException {
        if (this.lastLineToStore > 0) {
            String str;
            if (this.queue == null) {
                this.queue = new MyQueue<String>(this.lastLineToStore);
                str = null;
                int i = 0;
                do {
                    ++i;
                    str = this.readLine1(ignoreLF);
                    if (str == null) continue;
                    this.queue.add(str);
                } while (str != null && i < this.lastLineToStore);
            }
            str = null;
            if (this.queue.size() == this.lastLineToStore) {
                str = this.queue.poll();
                String nstr = this.readLine1(ignoreLF);
                if (nstr != null) {
                    this.queue.add(nstr);
                } else {
                    this.endPosition = this.queue.size();
                }
                return str;
            }
            if (this.queue.size() > 0) {
                str = this.queue.poll();
                this.endPosition = this.queue.size();
                return str;
            }
            return null;
        }
        return this.readLine1(ignoreLF);
    }

    public void setLastLinePosition(int trailLineToSkip) {
        if (this.lastLineToStore < trailLineToSkip) {
            this.lastLineToStore = trailLineToSkip;
        }
        this.endingLineToSkip = trailLineToSkip;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String readLine1(boolean ignoreLF) throws IOException {
        if (this.readLineModeVersion == 2) {
            StringBuilder sb = this.readLineV2();
            if (sb == null) {
                return null;
            }
            return sb.toString();
        }
        StringBuffer s = null;
        boolean openStringDelimiter = false;
        int size = 0;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    this.eof = true;
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                this.eol = false;
                char c = '\u0000';
                String start = this.previousReturnCharSequence;
                char[] lineSizeBuffer = null;
                int i = this.nextChar;
                while (i < this.nChars) {
                    ++size;
                    c = this.cb[i];
                    start = String.valueOf(start) + c;
                    if (this.lineSize == -2) {
                        if (this.lineSizePositionStart == size) {
                            lineSizeBuffer = new char[this.lineSizePositionEnd - this.lineSizePositionStart + 1];
                        }
                        if (size >= this.lineSizePositionStart) {
                            lineSizeBuffer[size - this.lineSizePositionStart] = c;
                        }
                        if (this.lineSizePositionEnd == size) {
                            if (this.lineSizeMode == LineSizeMode.BIG_ENDIAN || this.lineSizeMode == LineSizeMode.LITTLE_ENDIAN) {
                                long l;
                                byte[] result = new byte[lineSizeBuffer.length];
                                int __i = 0;
                                while (__i < lineSizeBuffer.length) {
                                    result[__i] = BinaryNumber.getByte((byte)lineSizeBuffer[__i], Charset.forName(((InputStreamReader)this.in).getEncoding()));
                                    ++__i;
                                }
                                try {
                                    l = BinaryNumber.getLong(result, true, this.lineSizeMode == LineSizeMode.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                                }
                                catch (Exception e) {
                                    throw new IOException(Messages.getString("StambiaBufferedReaderI.10"), e);
                                }
                                this.lineSize = (int)l;
                            } else if (this.lineSizeMode == LineSizeMode.String) {
                                this.lineSize = Integer.valueOf(new String(lineSizeBuffer));
                            }
                        }
                    }
                    if (this.stringDelimiter != null) {
                        if (!openStringDelimiter) {
                            if (this.stringDelimiter.equals(start)) {
                                openStringDelimiter = true;
                                start = "";
                            }
                        } else {
                            if (this.stringDelimiter.equals(start)) {
                                openStringDelimiter = false;
                            }
                            start = "";
                        }
                    }
                    if (!openStringDelimiter) {
                        if (this.lineSize == -2) {
                            start = "";
                        } else {
                            if (this.lineSize > -1 && this.lineSize == size) {
                                this.eol = true;
                                start = "";
                                this.previousReturnCharSequence = "";
                                if (this.lineSizeMode == LineSizeMode.Size) break;
                                this.lineSize = -2;
                                break;
                            }
                            if (this.lineTerminator.startsWith(start)) {
                                if (this.lineTerminator.equals(start)) {
                                    this.eol = true;
                                    start = "";
                                    this.previousReturnCharSequence = "";
                                    break;
                                }
                                if (this.lineTerminator.startsWith(start)) {
                                    this.previousReturnCharSequence = start;
                                } else {
                                    start = "";
                                }
                            } else if (this.escapeChar == null || !this.escapeChar.startsWith(start)) {
                                start = "";
                            }
                        }
                    }
                    ++i;
                }
                int startChar = this.nextChar;
                this.nextChar = i;
                if (this.eol) {
                    String str = null;
                    if (s == null) {
                        str = new String(this.cb, startChar, i + 1 - startChar);
                    } else {
                        s.append(this.cb, startChar, i + 1 - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    return str.substring(0, str.length() - this.lineTerminator.length());
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(this.cb, startChar, i - startChar);
            }
        }
    }

    public void setReadLineModeVersion(int readLineModeVersion) {
        this.readLineModeVersion = readLineModeVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder readLineV2() throws IOException {
        this.sb.setLength(0);
        Object object = this.lock;
        synchronized (object) {
            int i;
            int size = 0;
            boolean enterDelimiter = false;
            char[] lineSizeBuffer = null;
            do {
                if ((i = this.readWithoutLock()) == -1) continue;
                ++size;
                char c = (char)i;
                this.sb.append(c);
                if (this.lineSize == -2) {
                    if (this.lineSizePositionStart == size) {
                        lineSizeBuffer = new char[this.lineSizePositionEnd - this.lineSizePositionStart + 1];
                    }
                    if (size >= this.lineSizePositionStart) {
                        lineSizeBuffer[size - this.lineSizePositionStart] = c;
                    }
                    if (this.lineSizePositionEnd == size) {
                        if (this.lineSizeMode == LineSizeMode.BIG_ENDIAN || this.lineSizeMode == LineSizeMode.LITTLE_ENDIAN) {
                            long l;
                            byte[] result = new byte[lineSizeBuffer.length];
                            int __i = 0;
                            while (__i < lineSizeBuffer.length) {
                                result[__i] = BinaryNumber.getByte((byte)lineSizeBuffer[__i], Charset.forName(((InputStreamReader)this.in).getEncoding()));
                                ++__i;
                            }
                            try {
                                l = BinaryNumber.getLong(result, true, this.lineSizeMode == LineSizeMode.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                            }
                            catch (Exception e) {
                                throw new IOException(Messages.getString("StambiaBufferedReaderI.11"), e);
                            }
                            this.lineSize = (int)l;
                        } else if (this.lineSizeMode == LineSizeMode.String) {
                            this.lineSize = Integer.valueOf(new String(lineSizeBuffer));
                        }
                    }
                }
                if (this.lineSize == -1 && this.stringDelimiterComparator.length() > 0 && this.stringDelimiterComparator.endsWith(this.sb, c)) {
                    enterDelimiter = !enterDelimiter;
                }
                if (enterDelimiter) continue;
                this.fieldSeparator.endsWith(this.sb, c);
                if (this.lineSize == -2) continue;
                if (this.lineSize > -1 && this.lineSize == size) {
                    if (this.lineSizeMode != LineSizeMode.Size) {
                        this.lineSize = -2;
                    }
                    return this.sb;
                }
                if (this.lineSize != -1 || !this.rowSeparatorComparator.endsWith(this.sb, c)) continue;
                this.sb = this.sb.delete(this.sb.length() - this.rowSeparatorComparator.length(), this.sb.length());
                return this.sb;
            } while (i != -1);
            if (this.sb.length() > 0) {
                return this.sb;
            }
        }
        return null;
    }

    public boolean isEol() {
        return this.eol;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setFilterSet(MetadataFilterSet filterSet) {
        this.filterSet = filterSet;
    }

    public MetadataFilterSet getFilterSet() {
        return this.filterSet;
    }

    @Override
    public ILineContext getAncestorContext(int ancestorLevel) {
        if (ancestorLevel == 0) {
            if (this.currentSet == null) {
                return this.rootContext;
            }
            return this.currentSet;
        }
        if (this.currentSet != null) {
            MetadataFilterSet filterSet = this.currentSet.getFilterSet(ancestorLevel);
            return filterSet;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String readLine() throws IOException {
        if (!this.hasFilterSet) {
            this.hasFilterSet = true;
            try {
                this.hasFilter = this.getFilterSet() != null && (this.getFilterSet().hasFilter() != false || this.getFilterSet().size() > 0);
            }
            catch (Exception e) {
                this.hasFilter = false;
            }
        }
        str = null;
        found = true;
        i = 0;
        do {
            if (i++ == 100 && Thread.interrupted()) {
                throw new IOException(Messages.getString("StambiaBufferedReaderI.12"));
            }
            if (i == 100) {
                i = 0;
            }
            filterSet = null;
            isSameSet = false;
            if (this.hasFilter && this.currentSet != null) {
                str = this.currentSet.nextLine();
                if (str == null && this.currentSet.getSameLineAncsetor() != null) {
                    this.currentSet = this.currentSet.getParent();
                }
                if (str != null) {
                    isSameSet = true;
                    filterSet = this.currentSet;
                } else {
                    filterSet = this.currentSet.nextSameLineMetadataFilterSet();
                    if (filterSet != null) {
                        str = (String)filterSet.getSameLineAncsetor().getLine().value;
                        if (!filterSet.testAncestor(false)) {
                            filterSet = null;
                        }
                    }
                }
            }
            if (filterSet == null) {
                str = null;
                while (this.scriptReturn != null && str == null && ++this.scriptReturIndex < this.scriptReturn.length) {
                    str = this.scriptReturn[this.scriptReturIndex];
                }
                if (str == null) {
                    this.scriptReturn = null;
                    str = this.readLine(false);
                    if (str == null) {
                        return null;
                    }
                }
                if (this.scriptReturn == null && this.scriptLineTransformation != null) {
                    if (this.scriptEngine == null) {
                        scriptEngineManager = new StbScriptEngineManager();
                        this.languageLineTransformation = this.languageLineTransformation == null ? "rhino" : this.languageLineTransformation;
                        this.scriptEngine = scriptEngineManager.getEngineByName(this.languageLineTransformation);
                        this.bindings = this.scriptEngine.getBindings(100);
                        this.store = new HashMap<K, V>();
                        this.api = new Api();
                        this.bindings.put("__map__", (Object)this.store);
                        this.bindings.put("__api__", (Object)this.api);
                        this.__ret__ = new LinkedList<E>();
                        this.bindings.put("__ret__", (Object)this.__ret__);
                    }
                    this.bindings.put("__string__", (Object)str);
                    this.bindings.put("__position__", (Object)this.linePosition);
                    try {
                        o = this.scriptEngine.eval(this.scriptLineTransformation);
                        str = null;
                        if (this.__ret__.size() > 0) {
                            this.scriptReturn = new String[this.__ret__.size()];
                            _i = 0;
                            for (E _o : this.__ret__) {
                                this.scriptReturn[_i++] = _o /* !! */ .toString();
                            }
                            this.__ret__.clear();
                        } else if (o instanceof String) {
                            str = (String)o;
                        } else if (o instanceof List) {
                            this.scriptReturn = new String[((List)o).size()];
                            _i = 0;
                            for (E _o : (List)o) {
                                this.scriptReturn[_i++] = _o /* !! */ .toString();
                            }
                        } else if (o instanceof String[]) {
                            this.scriptReturn = (String[])o;
                        } else {
                            try {
                                if (o instanceof NativeArray) {
                                    arr = (NativeArray)o;
                                    this.scriptReturn = new String[(int)arr.getLength()];
                                    var11_39 = arr.getIds();
                                    var10_35 = var11_39.length;
                                    var9_25 = 0;
                                    while (var9_25 < var10_35) {
                                        _o /* !! */  = var11_39[var9_25];
                                        index = (Integer)_o /* !! */ ;
                                        this.scriptReturn[index] = (String)arr.get(index, null);
                                        ++var9_25;
                                    }
                                }
                                try {
                                    cls = Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
                                    if (!cls.isAssignableFrom(o.getClass()) || (result = (isArray = cls.getMethod("isArray", new Class[0])).invoke(o, new Object[0])) == null || !result.equals(true) || !((vals = (values = cls.getMethod("values", new Class[0])).invoke(o, new Object[0])) instanceof Collection)) ** GOTO lbl158
                                    coll = (Collection)vals;
                                    this.scriptReturn = coll.toArray(new String[0]);
                                }
                                catch (ClassNotFoundException cls) {
                                }
                                catch (NoSuchMethodException cls) {
                                }
                                catch (SecurityException cls) {
                                }
                                catch (IllegalAccessException cls) {
                                }
                                catch (IllegalArgumentException cls) {
                                }
                                catch (InvocationTargetException cls) {}
                            }
                            catch (NoClassDefFoundError e1) {
                                try {
                                    if (!o.getClass().getName().equals("sun.org.mozilla.javascript.internal.NativeArray")) ** GOTO lbl158
                                    try {
                                        m = o.getClass().getMethod("getLength", new Class[0]);
                                        __r = m.invoke(o, new Object[0]);
                                        k = (Integer)__r;
                                        this.scriptReturn = new String[k];
                                        m = o.getClass().getMethod("getIds", new Class[0]);
                                        m2 = o.getClass().getMethod("get", new Class[]{Integer.TYPE, Scriptable.class});
                                        var15_48 = (Object[])m.invoke(o, new Object[0]);
                                        var14_46 = var15_48.length;
                                        var13_44 = 0;
                                        while (var13_44 < var14_46) {
                                            _o = var15_48[var13_44];
                                            index = (Integer)_o;
                                            this.scriptReturn[index] = (String)m2.invoke(o, new Object[]{index, null});
                                            ++var13_44;
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                catch (NoClassDefFoundError e2) {
                                    try {
                                        cls = Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
                                        if (!cls.isAssignableFrom(o.getClass()) || (result = (isArray = cls.getMethod("isArray", new Class[0])).invoke(o, new Object[0])) == null || !result.equals(true) || !((vals = (values = cls.getMethod("values", new Class[0])).invoke(o, new Object[0])) instanceof Collection)) ** GOTO lbl158
                                        coll = (Collection)vals;
                                        this.scriptReturn = coll.toArray(new String[0]);
                                    }
                                    catch (ClassNotFoundException var9_29) {
                                    }
                                    catch (NoSuchMethodException var9_30) {
                                    }
                                    catch (SecurityException var9_31) {
                                    }
                                    catch (IllegalAccessException var9_32) {
                                    }
                                    catch (IllegalArgumentException var9_33) {
                                    }
                                    catch (InvocationTargetException var9_34) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
lbl158:
                        // 24 sources

                        if (this.scriptReturn != null) {
                            this.scriptReturIndex = -1;
                            str = null;
                            while (this.scriptReturn != null && str == null && ++this.scriptReturIndex < this.scriptReturn.length) {
                                str = this.scriptReturn[this.scriptReturIndex];
                            }
                        }
                        if (str == null) {
                            return null;
                        }
                    }
                    catch (ScriptException e) {
                        throw new IOException(Messages.getString("StambiaBufferedReaderI.13"), e);
                    }
                }
            }
            if (!this.hasFilter) continue;
            found = false;
            _currentSet = null;
            if (filterSet != null) {
                _currentSet = filterSet;
            } else {
                if (this.currentSet == null) {
                    this.currentSet = this.getFilterSet();
                }
                _currentSet = this.currentSet.determineFilterSet(str, this.linePosition, this.endPosition);
            }
            if (_currentSet == null) {
                ++this.lineSkiped;
                continue;
            }
            this.currentSet = _currentSet;
            if (!isSameSet) {
                this.currentSet.setCurrentLine(str, this.linePosition, this.endPosition);
                str = this.currentSet.nextLine();
            }
            if (str == null || this.sourceName != null && !this.currentSet.getName().equals(this.sourceName)) {
                ++this.lineSkiped;
                continue;
            }
            found = true;
        } while (this.hasFilter && !found && (this.rowLimit == -1 || this.rowLimit > this.lineSkiped + this.lineReaded));
        if (this.rowLimit != -1 && this.rowLimit <= this.lineSkiped + this.lineReaded) {
            return null;
        }
        if (found) {
            ++this.lineReaded;
            return str;
        }
        return null;
    }

    public int getLineReaded() {
        return this.lineReaded;
    }

    public int getLineSkiped() {
        return this.lineSkiped;
    }

    public int lineReaded() {
        return this.lineReaded;
    }

    public int lineSkiped() {
        return this.lineSkiped;
    }

    public void setRowsLimit(int limit) {
        this.rowLimit = limit;
    }

    @Override
    public MetadataFilterSet getCurrentSet() {
        return this.currentSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException(Messages.getString("StambiaBufferedReaderI.14"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            long r = n;
            while (r > 0L) {
                long d;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (r <= (d = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + r);
                    r = 0L;
                    break;
                }
                r -= d;
                this.nextChar = this.nChars;
            }
            return n - r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException(Messages.getString("StambiaBufferedReaderI.15"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = readAheadLimit;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? Messages.getString("StambiaBufferedReaderI.16") : Messages.getString("StambiaBufferedReaderI.17"));
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
            this.eof = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
            this.scriptEngine = null;
            if (this.bindings != null) {
                this.bindings.clear();
                this.bindings = null;
            }
            this.store = null;
        }
    }

    public void setStringDelimiter(String stringDelimiter) {
        this.stringDelimiterComparator = stringDelimiter != null && !stringDelimiter.isEmpty() ? new SeparatorComparator(stringDelimiter.toCharArray()) : new SeparatorComparator("".toCharArray());
        this.stringDelimiter = stringDelimiter;
    }

    @Override
    public void setMonoSourceName(String name) {
        this.sourceName = name;
    }

    @Override
    public int position() {
        return this.lineReaded;
    }

    @Override
    public long startTimeStamp() {
        if (this.timestamp == null) {
            this.timestamp = System.currentTimeMillis();
        }
        return this.timestamp;
    }

    @Override
    public String getEncoding() {
        if (this.in != null && this.in instanceof InputStreamReader) {
            return ((InputStreamReader)this.in).getEncoding();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        BigInteger bi = new BigInteger("-12335");
        byte[] array = bi.toByteArray();
        System.out.println(bi.shortValue());
        bi = new BigInteger(array);
        System.out.println(bi.shortValue());
        ByteBuffer bb = ByteBuffer.allocate(array.length);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put((byte)-49);
        bb.put((byte)-47);
        byte[] array2 = bb.array();
        System.out.println(bb.getShort(0));
        byte[] array3 = new byte[array.length];
        bb.get(array2);
        bi = new BigInteger(array);
        System.out.println(bi.shortValue());
        bb = ByteBuffer.allocate(4);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(array);
        System.out.println(bb.getInt());
        int min = -13;
        int max2 = 128;
        max2 = (short)(max2 * max2 * 2 - 1);
        long max = 10L;
        ShortBuffer sb = ShortBuffer.allocate(1);
        short s = 32397;
        sb.put(s);
        byte[] in = new byte[]{-127, -127};
        ByteBuffer _bb = ByteBuffer.allocate(in.length);
        _bb.order(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while (i < in.length) {
            _bb.put(in[i]);
            ++i;
        }
        short ret = _bb.getShort(0);
        if (ret < 0) {
            int i2 = max2 + ret;
            System.out.println((short)i2);
        } else {
            System.out.println();
        }
        Long l = new Long(-121213L);
        Short s2 = -12121;
        byte by = s2.byteValue();
        s2 = new Short(by);
        byte[] in2 = new byte[]{-127};
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        ByteBuffer _bb2 = ByteBuffer.allocate(8);
        if (order != null) {
            _bb2.order(order);
        }
        int delta = 8 - in2.length;
        int i3 = 0;
        while (i3 < 8) {
            if (i3 < delta) {
                _bb2.put((byte)0);
            } else {
                _bb2.put(in2[i3 - delta]);
            }
            ++i3;
        }
        long ret2 = _bb2.getLong(0);
        System.out.println(ret2);
        byte[] b = new byte[]{-127};
        System.out.println(BinaryNumber.getLong(b, true, ByteOrder.BIG_ENDIAN));
    }

    @Override
    public int getCurrentLinePosition() {
        return this.linePosition;
    }

    public void setFirstLinePosition(int firstLinePosition) {
        this.firstLinePosition = firstLinePosition;
    }

    public void setMaxLasLineToBuffer(int searchMaxLastRowPosition) {
        if (this.lastLineToStore < searchMaxLastRowPosition) {
            this.lastLineToStore = searchMaxLastRowPosition;
        }
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public class Api
    extends TransformInputStreamWithScript.Api {
        public long parseFixedBinary(String str, ByteOrder order) throws Exception {
            return super.parseFixedBinary(str, true, order, StambiaBufferedReaderI.this.getEncoding());
        }

        public long parseFixedBinary(String str, boolean signed, ByteOrder order) throws Exception {
            return super.parseFixedBinary(str, signed, order, StambiaBufferedReaderI.this.getEncoding());
        }
    }

    static enum LineSizeMode {
        BIG_ENDIAN,
        LITTLE_ENDIAN,
        String,
        Size,
        NO;

    }

    class MyQueue<T>
    extends AbstractQueue<T> {
        int maxSize;
        List<T> list = new ArrayList<T>();

        MyQueue(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public boolean offer(T arg0) {
            if (this.list.size() < this.maxSize) {
                this.list.add(arg0);
                return true;
            }
            return false;
        }

        @Override
        public T poll() {
            T str = this.peek();
            if (str != null) {
                this.list.remove(0);
            }
            return str;
        }

        @Override
        public T peek() {
            if (this.size() > 0) {
                return this.list.get(0);
            }
            return null;
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    public static class SeparatorComparator {
        char[] compare;
        char lastchar;

        public SeparatorComparator(char[] compare) {
            this.compare = compare;
            this.lastchar = compare.length > 0 ? compare[compare.length - 1] : (char)'\u0000';
        }

        public boolean endsWith(CharSequence cs, char _lastchar) {
            int length;
            if (_lastchar == this.lastchar && (length = cs.length()) >= this.compare.length) {
                int j = 1;
                int i = this.compare.length - 1;
                while (i >= 1) {
                    if (this.compare[i] != cs.charAt(length - j)) {
                        return false;
                    }
                    ++j;
                    --i;
                }
                return true;
            }
            return false;
        }

        public int length() {
            return this.compare.length;
        }
    }
}

