/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.resultset.AbstractResultSet;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import com.stambia.jdbc.driver.file.resultset.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class FileDriverArrayListResultset
extends AbstractResultSet {
    protected int fetchSize = 50;
    protected FileDriverResultSetMetaData fResultSetMetadata;
    protected String[] currentRowValues = null;
    protected int isScrollable = 1003;
    ArrayList<String[]> allValues = null;
    protected int currentRow;
    int lastRow = -10;
    protected String tableName;
    String fieldSeparator = null;

    public FileDriverArrayListResultset(ArrayList<String[]> tm, FileDriverResultSetMetaData rsmd) {
        this.fResultSetMetadata = rsmd;
        this.allValues = tm;
        this.currentRow = -1;
        this.lastRow = tm != null ? tm.size() - 1 : -1;
    }

    @Override
    public boolean next() throws SQLException {
        boolean answer = false;
        ++this.currentRow;
        if (this.currentRow <= this.lastRow) {
            this.currentRowValues = this.allValues.get(this.currentRow);
            answer = true;
        }
        return answer;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.currentRowValues[columnIndex - 1];
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Boolean.valueOf(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.0")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.1") + name + Messages.getString("FileDriverArrayListResultset.2") + str + Messages.getString("FileDriverArrayListResultset.3") + Messages.getString("FileDriverArrayListResultset.4"), e);
        }
        return ret;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Byte.parseByte(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.5")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.6") + name + Messages.getString("FileDriverArrayListResultset.7") + str + Messages.getString("FileDriverArrayListResultset.8") + Messages.getString("FileDriverArrayListResultset.9"), e);
        }
        return ret;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Short.parseShort(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.10")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.11") + name + Messages.getString("FileDriverArrayListResultset.12") + str + Messages.getString("FileDriverArrayListResultset.13") + Messages.getString("FileDriverArrayListResultset.14"), e);
        }
        return ret;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Integer.parseInt(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.15")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.16") + name + Messages.getString("FileDriverArrayListResultset.17") + str + Messages.getString("FileDriverArrayListResultset.18") + Messages.getString("FileDriverArrayListResultset.19"), e);
        }
        return ret;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Long.parseLong(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.20")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.21") + name + Messages.getString("FileDriverArrayListResultset.22") + str + Messages.getString("FileDriverArrayListResultset.23") + Messages.getString("FileDriverArrayListResultset.24"), e);
        }
        return ret;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Float.parseFloat(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.25")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.26") + name + Messages.getString("FileDriverArrayListResultset.27") + str + Messages.getString("FileDriverArrayListResultset.28") + Messages.getString("FileDriverArrayListResultset.29"), e);
        }
        return ret;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Double.parseDouble(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.30")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.31") + name + Messages.getString("FileDriverArrayListResultset.32") + str + Messages.getString("FileDriverArrayListResultset.33") + Messages.getString("FileDriverArrayListResultset.34"), e);
        }
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal ret = null;
        return ret;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        byte[] ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = str.getBytes();
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.35")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.36") + name + Messages.getString("FileDriverArrayListResultset.37") + str + Messages.getString("FileDriverArrayListResultset.38") + Messages.getString("FileDriverArrayListResultset.39"), e);
        }
        return ret;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Date ret;
        SimpleDateFormat dateFormat;
        IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex].lstExpressionColumns.firstEntry().getValue();
        try {
            dateFormat = metCol == null ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S") : (!metCol.equals("") ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S") : new SimpleDateFormat(metCol.getFormat()));
        }
        catch (Exception e) {
            int col = columnIndex - 1;
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.40")) + col, e);
        }
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = (Date)dateFormat.parse(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.41")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.42") + name + Messages.getString("FileDriverArrayListResultset.43") + str + Messages.getString("FileDriverArrayListResultset.44") + Messages.getString("FileDriverArrayListResultset.45"), e);
        }
        return ret;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Time ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = Time.valueOf(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.46")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.47") + name + Messages.getString("FileDriverArrayListResultset.48") + str + Messages.getString("FileDriverArrayListResultset.49") + Messages.getString("FileDriverArrayListResultset.50"), e);
        }
        return ret;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        SimpleDateFormat dateFormat;
        IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex].lstExpressionColumns.firstEntry().getValue();
        try {
            dateFormat = metCol == null ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S") : (!metCol.equals("") ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S") : new SimpleDateFormat(metCol.getFormat()));
        }
        catch (Exception e) {
            int col = columnIndex - 1;
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.51")) + col, e);
        }
        String str = this.currentRowValues[columnIndex - 1];
        try {
            long l = dateFormat.parse(str).getTime();
            ret = new Timestamp(l);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.52")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.53") + name + Messages.getString("FileDriverArrayListResultset.54") + str + Messages.getString("FileDriverArrayListResultset.55") + Messages.getString("FileDriverArrayListResultset.56"), e);
        }
        return ret;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteArrayInputStream ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = new ByteArrayInputStream(str.getBytes());
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.57")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.58") + name + Messages.getString("FileDriverArrayListResultset.59") + str + Messages.getString("FileDriverArrayListResultset.60") + Messages.getString("FileDriverArrayListResultset.61"), e);
        }
        return ret;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.fResultSetMetadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getString(columnName);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.fResultSetMetadata.getColumnId(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        StringReader ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = new StringReader(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.62")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.63") + name + Messages.getString("FileDriverArrayListResultset.64") + str + Messages.getString("FileDriverArrayListResultset.65") + Messages.getString("FileDriverArrayListResultset.66"), e);
        }
        return ret;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal ret;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = new BigDecimal(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException(String.valueOf(Messages.getString("FileDriverArrayListResultset.67")) + this.currentRow + Messages.getString("FileDriverArrayListResultset.68") + name + Messages.getString("FileDriverArrayListResultset.69") + str + Messages.getString("FileDriverArrayListResultset.70") + Messages.getString("FileDriverArrayListResultset.71"), e);
        }
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean ret = false;
        if (this.currentRow > this.lastRow) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRow == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRow == this.lastRow;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.currentRow = -1;
        this.currentRowValues = null;
    }

    @Override
    public void afterLast() throws SQLException {
        this.currentRow = this.lastRow + 1;
        this.currentRowValues = null;
    }

    @Override
    public boolean first() throws SQLException {
        boolean ret = false;
        if (this.lastRow >= 0) {
            this.currentRow = 0;
            this.currentRowValues = this.allValues.get(this.currentRow);
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean last() throws SQLException {
        boolean ret = false;
        if (this.lastRow >= 0) {
            this.currentRow = this.lastRow;
            this.currentRowValues = this.allValues.get(this.currentRow);
            ret = true;
        }
        return ret;
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.isScrollable;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }
}

