/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.support;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.TransformerHelper;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class PayloadRootUtils {
    private PayloadRootUtils() {
    }

    public static QName getPayloadRootQName(Source source, TransformerFactory transformerFactory) throws TransformerException {
        return PayloadRootUtils.getPayloadRootQName(source, new TransformerHelper(transformerFactory));
    }

    public static QName getPayloadRootQName(Source source, TransformerHelper transformerHelper) throws TransformerException {
        if (source == null) {
            return null;
        }
        try {
            PayloadRootSourceCallback callback = new PayloadRootSourceCallback();
            TraxUtils.doWithSource((Source)source, (TraxUtils.SourceCallback)callback);
            if (callback.result != null) {
                return callback.result;
            }
            DOMResult domResult = new DOMResult();
            transformerHelper.transform(source, (Result)domResult);
            Document document = (Document)domResult.getNode();
            return QNameUtils.getQNameForNode((Node)document.getDocumentElement());
        }
        catch (TransformerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class PayloadRootSourceCallback
    implements TraxUtils.SourceCallback {
        private QName result;

        private PayloadRootSourceCallback() {
        }

        public void domSource(Node node) throws Exception {
            if (node.getNodeType() == 1) {
                this.result = QNameUtils.getQNameForNode((Node)node);
            } else if (node.getNodeType() == 9) {
                Document document = (Document)node;
                this.result = QNameUtils.getQNameForNode((Node)document.getDocumentElement());
            }
        }

        public void staxSource(XMLEventReader eventReader) throws Exception {
            XMLEvent event = eventReader.peek();
            if (event != null && event.isStartDocument()) {
                event = eventReader.nextTag();
            }
            if (event != null) {
                if (event.isStartElement()) {
                    this.result = event.asStartElement().getName();
                } else if (event.isEndElement()) {
                    this.result = event.asEndElement().getName();
                }
            }
        }

        public void staxSource(XMLStreamReader streamReader) throws Exception {
            if (streamReader.getEventType() == 7) {
                try {
                    streamReader.nextTag();
                }
                catch (XMLStreamException ex) {
                    throw new IllegalStateException("Could not read next tag: " + ex.getMessage(), ex);
                }
            }
            if (streamReader.getEventType() == 1 || streamReader.getEventType() == 2) {
                this.result = streamReader.getName();
            }
        }

        public void saxSource(XMLReader reader, InputSource inputSource) throws Exception {
        }

        public void streamSource(InputStream inputStream) throws Exception {
        }

        public void streamSource(Reader reader) throws Exception {
        }

        public void source(String systemId) throws Exception {
        }
    }
}

