/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

final class Axiom12Utils {
    private Axiom12Utils() {
        throw new RuntimeException("Utility class not meant to be instantiated.");
    }

    static SOAPMessage getSOAPMessage(XMLInputFactory inputFactory, InputStream inputStream, String charSetEncoding, String namespace, SOAPFactory soapFactory) throws XMLStreamException {
        XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream, charSetEncoding);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, soapFactory, namespace);
        return builder.getSOAPMessage();
    }

    static SOAPMessage getSOAPMessage(String envelopeNamespace, Attachments attachments, SOAPFactory soapFactory, XMLStreamReader reader) {
        StAXSOAPModelBuilder builder;
        if ("text/xml".equals(attachments.getAttachmentSpecType()) || "application/soap+xml".equals(attachments.getAttachmentSpecType())) {
            builder = new StAXSOAPModelBuilder(reader, soapFactory, envelopeNamespace);
        } else if ("application/xop+xml".equals(attachments.getAttachmentSpecType())) {
            builder = new MTOMStAXSOAPModelBuilder(reader, attachments, envelopeNamespace);
        } else {
            throw new RuntimeException("Unknown attachment type: [" + attachments.getAttachmentSpecType() + "]");
        }
        return builder.getSOAPMessage();
    }
}

