/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPModelBuilder;

final class Axiom14Utils {
    private Axiom14Utils() {
        throw new RuntimeException("Utility class not meant to be instantiated.");
    }

    static SOAPMessage getSOAPMessage(XMLInputFactory inputFactory, InputStream inputStream, String charSetEncoding, SOAPFactory soapFactory) throws XMLStreamException {
        XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream, charSetEncoding);
        SOAPModelBuilder builder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)soapFactory.getMetaFactory(), (XMLStreamReader)reader);
        return builder.getSOAPMessage();
    }

    static SOAPMessage getSOAPMessage(Attachments attachments, SOAPFactory soapFactory, XMLStreamReader reader) {
        SOAPModelBuilder builder;
        if ("text/xml".equals(attachments.getAttachmentSpecType()) || "application/soap+xml".equals(attachments.getAttachmentSpecType())) {
            builder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)soapFactory.getMetaFactory(), (XMLStreamReader)reader);
        } else if ("application/xop+xml".equals(attachments.getAttachmentSpecType())) {
            builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)soapFactory.getMetaFactory(), (Attachments)attachments);
        } else {
            throw new RuntimeException("Unknown attachment type: [" + attachments.getAttachmentSpecType() + "]");
        }
        return builder.getSOAPMessage();
    }
}

