/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.axiom.AxiomPayloadUtils;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.Payload;
import org.springframework.ws.soap.axiom.StreamingOMDataSource;
import org.springframework.ws.soap.axiom.support.AxiomUtils;
import org.springframework.ws.stream.StreamingPayload;

abstract class AxiomSoapBody
extends AxiomSoapElement
implements SoapBody {
    private final Payload payload;

    protected AxiomSoapBody(SOAPBody axiomBody, SOAPFactory axiomFactory, boolean payloadCaching) {
        super((OMElement)axiomBody, axiomFactory);
        this.payload = payloadCaching ? AxiomPayloadUtils.createCachingPayload(axiomBody, axiomFactory) : AxiomPayloadUtils.createNonCachingPayload(axiomBody, axiomFactory);
    }

    @Override
    public Source getPayloadSource() {
        return this.payload.getSource();
    }

    @Override
    public Result getPayloadResult() {
        return this.payload.getResult();
    }

    @Override
    public boolean hasFault() {
        return this.getAxiomBody().hasFault();
    }

    protected final SOAPBody getAxiomBody() {
        return (SOAPBody)this.getAxiomElement();
    }

    public void setStreamingPayload(StreamingPayload payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        StreamingOMDataSource dataSource = new StreamingOMDataSource(payload);
        SOAPFactory factory = this.getAxiomFactory();
        QName name = payload.getName();
        OMSourcedElement payloadElement = factory.createOMElement((OMDataSource)dataSource, name.getLocalPart(), factory.createOMNamespace(name.getNamespaceURI(), null));
        SOAPBody soapBody = this.getAxiomBody();
        AxiomUtils.removeContents((OMContainer)soapBody);
        soapBody.addChild((OMNode)payloadElement);
    }
}

