/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.Global;
import com.indy.engine.Messages;
import com.indy.engine.common.sql.SqlUtils;
import com.indy.engine.main.connections.tools.JdbcFunctions;
import com.indy.engine.userLog.RdbmsUserLog;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.sessionlog.RdbmsLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerException;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.HikariCpPoolingConnectionProvider;

public class InternalDatabase {
    private static final Logger logger = LogManager.getLogger(InternalDatabase.class);
    private Map<String, String> lstSystemLogProperties = Global.getLstLogParametersInRepository(Global.USERLOG_DEFAULT_NAME);

    private static String getRuntimeLocation() {
        String runtimeFolder = System.getProperty("com.indy.engine.installation.folder");
        if (runtimeFolder == null || runtimeFolder.isEmpty()) {
            runtimeFolder = ".";
        }
        return runtimeFolder;
    }

    public static void prepareSystemSchedulerDatabase(boolean createSchema) throws EngineExceptionI {
        Properties prop = new Properties();
        prop.put("driver", "org.h2.Driver");
        String url = null;
        url = Global.HTTP_PORT != 42200 ? "jdbc:h2:" + InternalDatabase.getRuntimeLocation() + "/scheduler/" + Global.HTTP_PORT + "/internalDb" : "jdbc:h2:" + InternalDatabase.getRuntimeLocation() + "/scheduler/internalDb";
        prop.put("URL", String.valueOf(url) + ";SCHEMA=SCHEDULER");
        prop.put("user", "backend-user");
        prop.put("password", "backend-password");
        prop.put("maxConnections", (Object)5);
        try {
            DBConnectionManager.getInstance().addConnectionProvider("internal", (ConnectionProvider)new HikariCpPoolingConnectionProvider(prop));
        }
        catch (SQLException | SchedulerException e1) {
            logger.debug(Messages.getString("InternalDatabase.1"), e1);
            Global.dLog.write("EngineServerI=>addInternalConnectionProvider()", "Exception " + e1.getMessage(), 0, 0, "INFO");
            throw new EngineExceptionI(e1);
        }
        if (createSchema) {
            try {
                Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "preparing internal Scheduler Database !", 0, 0, "INFO");
                Connection jdbcConnection = JdbcFunctions.rapidConnect("org.h2.Driver", url, prop.getProperty("user"), prop.getProperty("password"), null);
                String sqlSchemaName = "SCHEDULER";
                Statement DMLStatement = jdbcConnection.createStatement();
                Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "CREATE SCHEMA " + sqlSchemaName, 0, 0, "INFO");
                String txtCode = "CREATE SCHEMA " + sqlSchemaName;
                String sqlQuery = "";
                try {
                    String thisLine;
                    DMLStatement.execute(txtCode);
                    FileReader fr = new FileReader(new File("scripts/scheduler/tables_h2.sql"));
                    BufferedReader br = new BufferedReader(fr);
                    while ((thisLine = br.readLine()) != null) {
                        sqlQuery = String.valueOf(sqlQuery) + thisLine + "\n";
                    }
                    for (String o : SqlUtils.splitSqlScript((String)sqlQuery, (String)";", (String[])new String[]{"--|\n", "/\\*|\\*/", "'"})) {
                        try {
                            Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Execute Query:\n" + o, 0, 0, "INFO");
                            DMLStatement.execute(o);
                        }
                        catch (Exception e) {
                            Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug(Messages.getString("InternalDatabase.2"), (Throwable)e);
                    Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                }
                jdbcConnection.close();
            }
            catch (Exception e) {
                logger.debug(Messages.getString("InternalDatabase.2"), (Throwable)e);
                Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                throw new EngineExceptionI((Throwable)e);
            }
        }
        Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Internal Scheduler Database prepared!", 0, 0, "INFO");
    }

    public InternalDatabase() throws EngineExceptionI {
        if (this.lstSystemLogProperties == null) {
            throw new EngineExceptionI("Impossible to find configuration for: " + Global.USERLOG_DEFAULT_NAME);
        }
    }

    public void prepareSystemDatabase() throws EngineExceptionI {
        if (this.lstSystemLogProperties.get("userLogClass").equals(RdbmsUserLog.class.getName()) || this.lstSystemLogProperties.get("userLogClass").equals(RdbmsLogger.class.getName())) {
            Global.dLog.write("EngineServerI=>prepareSystemDatabase()", "preparing internal Database !", 0, 0, "INFO");
            String userDriver = this.lstSystemLogProperties.get("userLogRdbmsDriver");
            if (userDriver.equals("org.h2.Driver")) {
                Connection jdbcConnection = JdbcFunctions.rapidConnect(this.lstSystemLogProperties.get("userLogRdbmsDriver"), this.lstSystemLogProperties.get("userLogRdbmsUrl"), this.lstSystemLogProperties.get("userLogRdbmsUser"), this.lstSystemLogProperties.get("userLogRdbmsPassword"), this.lstSystemLogProperties.get("userLogRdbmsEncryptedPassword"));
                String sqlSchemaName = this.lstSystemLogProperties.get("userLogRdbmsSchemaName");
                try {
                    Statement DMLStatement = jdbcConnection.createStatement();
                    if (sqlSchemaName != null) {
                        String txtCode = "CREATE SCHEMA " + sqlSchemaName;
                        try {
                            DMLStatement.execute(txtCode);
                        }
                        catch (Exception exception) {}
                        sqlSchemaName = String.valueOf(sqlSchemaName) + ".";
                    } else {
                        sqlSchemaName = "";
                    }
                    jdbcConnection.close();
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            Global.dLog.write("EngineServerI=>prepareSystemDatabase()", "Internal Database prepared!", 0, 0, "INFO");
        }
    }
}

