/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;

public class MemoryCleanerI
implements Runnable {
    EngineServerI engine;
    boolean isActive = false;
    long memoryLogScanDelay = 5000L;

    public MemoryCleanerI(EngineServerI eng) {
        this.engine = eng;
        this.isActive = true;
        try {
            this.memoryLogScanDelay = Global.MEMORY_LOG_SCAN_DELAY;
        }
        catch (Exception exception) {}
    }

    public void setScanDelay(int delay) {
        this.memoryLogScanDelay = delay;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean b) {
        this.isActive = b;
    }

    int cleanMemorySessions() {
        int ret = 0;
        this.engine.cleanMemoryClosedSessions();
        return ret;
    }

    @Override
    public synchronized void run() {
        while (this.isActive) {
            try {
                Thread.sleep(this.memoryLogScanDelay);
                this.cleanMemorySessions();
            }
            catch (InterruptedException interruptedException) {
                this.isActive = false;
            }
            catch (Exception exception) {
                this.isActive = false;
            }
        }
    }
}

