/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.Global;
import com.indy.engine.Messages;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.main.MainEngineEnv;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.service.Service;
import com.indy.engine.service.ServiceManager;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StartDelivery {
    private static String launchMode;
    static String jobname;
    static String sessionName;
    static String deliveryName;
    private static String parentSessionId;
    private static String sessionId;
    private static String repoName;
    private static String version;
    private static String confCode;
    private static String logLevel;
    private static String parentLoglevel;
    private static String returnCodePath;
    private static String logClassName;
    private static String outputFormat;

    public static void writeUsage() {
        System.out.println(Messages.getString("StartDelivery.47"));
        System.out.println(Messages.getString("StartDelivery.0"));
        System.out.println(Messages.getString("StartDelivery.1"));
        System.out.println("");
        System.out.println(Messages.getString("StartDelivery.2"));
        System.out.println(Messages.getString("StartDelivery.3"));
        System.out.println("");
        System.out.println(Messages.getString("StartDelivery.48"));
        System.out.println(Messages.getString("StartDelivery.4"));
        System.out.println(Messages.getString("StartDelivery.5"));
        System.out.println(Messages.getString("StartDelivery.6"));
        System.out.println(Messages.getString("StartDelivery.7"));
        System.out.println(Messages.getString("StartDelivery.8"));
        System.out.println(Messages.getString("StartDelivery.9"));
        System.out.println(Messages.getString("StartDelivery.10"));
        System.out.println(Messages.getString("StartDelivery.100"));
        System.out.println(Messages.getString("StartDelivery.11"));
        System.out.println(Messages.getString("StartDelivery.12"));
        System.out.println(Messages.getString("StartDelivery.13"));
    }

    public static void main(String[] args) throws EngineExceptionI {
        block97: {
            Global.commandLine = true;
            String fullCommandLine = "";
            try {
                File f;
                int i;
                TreeMap<String, String> lstParameters = new TreeMap<String, String>();
                boolean deliveryFound = false;
                boolean bDeliveryName = false;
                String fileConf = null;
                if (args != null && args.length >= 2) {
                    i = 0;
                    while (i < args.length) {
                        block96: {
                            if (args[i].toLowerCase().equals("-usage") || args[i].toLowerCase().equals("-h") || args[i].toLowerCase().equals("-help")) {
                                StartDelivery.writeUsage();
                                System.exit(-1);
                            } else if (args[i].toLowerCase().equals("-name")) {
                                if (i == args.length - 1) {
                                    System.err.println(Messages.getString("StartDelivery.14"));
                                    System.exit(-1);
                                }
                                deliveryName = args[++i];
                                bDeliveryName = true;
                            } else if (args[i].toLowerCase().equals("-file")) {
                                if (i == args.length - 1) {
                                    System.err.println(Messages.getString("StartDelivery.15"));
                                    StartDelivery.writeUsage();
                                    System.exit(-1);
                                }
                                deliveryName = args[++i];
                            } else if (args[i].toLowerCase().equals("-var")) {
                                if (i == args.length - 2) {
                                    System.err.println(Messages.getString("StartDelivery.16"));
                                    StartDelivery.writeUsage();
                                    System.exit(-1);
                                }
                                String tempArgName = args[++i];
                                String tempArgValue = args[++i];
                                lstParameters.put(tempArgName, tempArgValue);
                            } else {
                                if (args[i].toLowerCase().equals("-conf")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.17"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    fileConf = args[++i];
                                    try {
                                        if (fileConf.startsWith("\"")) {
                                            fileConf = fileConf.substring(1);
                                        }
                                        if (fileConf.endsWith("\"")) {
                                            fileConf = fileConf.substring(0, fileConf.length() - 1);
                                        }
                                        if (!(f = new File(fileConf)).exists()) {
                                            throw new EngineExceptionI(String.valueOf(Messages.getString("StartDelivery.18")) + f.getAbsolutePath());
                                        }
                                        break block96;
                                    }
                                    catch (SecurityException e) {
                                        throw new EngineExceptionI(Messages.getString("StartDelivery.19"), (Throwable)e);
                                    }
                                    catch (Exception e) {
                                        throw new EngineExceptionI(Messages.getString("StartDelivery.20"), (Throwable)e);
                                    }
                                }
                                if (args[i].toLowerCase().equals("-sessionname")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.21"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    sessionName = args[++i];
                                } else if (args[i].toLowerCase().equals("-launchmode")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.22"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    launchMode = args[++i];
                                } else if (args[i].toLowerCase().equals("-jobname")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.23"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    jobname = args[++i];
                                } else if (args[i].toLowerCase().equals("-parentsessionid")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.24"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    parentSessionId = args[++i];
                                } else if (args[i].toLowerCase().equals("-sessionid")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.25"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    sessionId = args[++i];
                                } else if (args[i].toLowerCase().equals("-repository")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.26"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    repoName = args[++i];
                                } else if (args[i].toLowerCase().equals("-version")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.27"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    version = args[++i];
                                } else if (args[i].toLowerCase().equals("-configuration") || args[i].toLowerCase().equals("-confcode")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.28"));
                                        System.exit(-1);
                                    }
                                    confCode = args[++i];
                                } else if (args[i].toLowerCase().equals("-loglevel")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.29"));
                                        System.exit(-1);
                                    }
                                    logLevel = args[++i];
                                } else if (args[i].toLowerCase().equals("-parentloglevel")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.30"));
                                        System.exit(-1);
                                    }
                                    parentLoglevel = args[++i];
                                } else if (args[i].toLowerCase().equals("-sessionidsalt")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.31"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    ++i;
                                } else if (args[i].toLowerCase().equals("-returncodepath")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.32"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    returnCodePath = args[++i];
                                } else if (args[i].toLowerCase().equals("-logclass")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.33"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    logClassName = args[++i];
                                } else if (args[i].toLowerCase().equals("-outputformat")) {
                                    if (i == args.length - 1) {
                                        System.err.println(Messages.getString("StartDelivery.34"));
                                        StartDelivery.writeUsage();
                                        System.exit(-1);
                                    }
                                    outputFormat = args[++i];
                                }
                            }
                        }
                        ++i;
                    }
                } else {
                    StartDelivery.writeUsage();
                    System.exit(-1);
                    return;
                }
                i = 0;
                while (i < args.length) {
                    fullCommandLine = String.valueOf(fullCommandLine) + args[i];
                    ++i;
                }
                if (deliveryName == null) {
                    StartDelivery.writeUsage();
                    System.exit(-1);
                }
                if (fileConf != null) {
                    Global.XML_ENGINE_REPOSITORY = fileConf;
                }
                Global.InitRessources(true);
                IDeliveryRepository repo = Global.getRepository(repoName);
                if (sessionName != null) {
                    if (sessionName.startsWith("\"")) {
                        sessionName = sessionName.substring(1);
                    }
                    if (sessionName.endsWith("\"")) {
                        sessionName = sessionName.substring(0, sessionName.length() - 1);
                    }
                }
                if (deliveryName.startsWith("\"")) {
                    deliveryName = deliveryName.substring(1);
                }
                if (deliveryName.endsWith("\"")) {
                    deliveryName = deliveryName.substring(0, deliveryName.length() - 1);
                }
                if (bDeliveryName) {
                    if (!repo.exists(deliveryName)) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("StartDelivery.36")) + deliveryName);
                    }
                    deliveryFound = true;
                } else {
                    try {
                        f = new File(deliveryName);
                        if (!f.exists()) {
                            throw new EngineExceptionI(String.valueOf(Messages.getString("StartDelivery.37")) + deliveryName);
                        }
                        deliveryFound = true;
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI(Messages.getString("StartDelivery.38"), (Throwable)e);
                    }
                }
                PrintStream err = System.err;
                System.setErr(System.out);
                if (deliveryFound) {
                    Service service = ServiceManager.INSTANCE.getService("listener");
                    service.start();
                    service = ServiceManager.INSTANCE.getService("execution");
                    service.start();
                    final MainEngineI m = new MainEngineI(false, false);
                    if (logLevel != null) {
                        m.setLogLevel(Integer.valueOf(logLevel));
                    }
                    if (parentLoglevel != null) {
                        m.setParentLogLevel(Integer.valueOf(parentLoglevel));
                    }
                    m.useDeliveryConfiguration(confCode);
                    m.setParentSessionId(parentSessionId);
                    if (launchMode != null) {
                        m.setLaunchMode(launchMode);
                    } else {
                        m.setLaunchMode("COMMAND_LINE");
                    }
                    m.setExecutionMode("AUTONOMOUS");
                    m.setGuestHost(Global.getLocalHost().getHostName());
                    if (logClassName != null && !logClassName.isEmpty()) {
                        m.lstLogProperties.put("userLogClass", logClassName);
                    }
                    String vmid = sessionId != null ? sessionId : MainEngineEnv.createId(fullCommandLine);
                    File sessions = new File("sessions");
                    if (!sessions.exists()) {
                        sessions.mkdir();
                    }
                    final File ctrlFile = new File("sessions" + File.separator + vmid + ".session");
                    ctrlFile.deleteOnExit();
                    final HashMap pattern = new HashMap();
                    if (bDeliveryName) {
                        m.initSession(repo.getMemoryDelivery(deliveryName, confCode), deliveryName, vmid);
                    } else {
                        m.initSession(deliveryName, vmid);
                    }
                    if (sessionName != null) {
                        m.setSessionName(sessionName);
                    }
                    m.initVariables(lstParameters);
                    final StringBuffer errors = new StringBuffer();
                    final StringBuffer stack = new StringBuffer();
                    final StringBuffer processReturnCode = new StringBuffer();
                    m.addHandler(new MainEngineI.EngineHandler(){

                        @Override
                        public void beforeStoping(MainEngineI mainEngine) {
                            try {
                                Date d = mainEngine.getBeginDate();
                                if (d != null) {
                                    long l = d.getTime();
                                    long end = mainEngine.getEndDate() != null ? mainEngine.getEndDate().getTime() : System.currentTimeMillis();
                                    String result = new SimpleDateFormat("HH:mm:ss,SSS").format(end - l - 3600000L).toString();
                                    pattern.put("DURATION", result);
                                }
                            }
                            catch (Exception exception) {}
                            if (Global.statisticsOnStdOutput.booleanValue() && Global.sumVariables != null && Global.sumVariables.size() > 0) {
                                ArrayList<Variable> sumStats = new ArrayList<Variable>();
                                for (String variableName : Global.sumVariables) {
                                    Variable sumStat = mainEngine.aggregateVariable(null, variableName, 1, "/", "$NO_SCRIPT$");
                                    if (sumStat == null) continue;
                                    sumStats.add(sumStat);
                                }
                                if (sumStats.size() > 0) {
                                    String stat = "";
                                    for (Variable sumStat : sumStats) {
                                        stat = String.valueOf(stat) + sumStat.getName() + "=" + sumStat.getValue() + "\n";
                                    }
                                    pattern.put("STATISTICS", stat);
                                }
                            }
                            Map<String, Variable> vars = mainEngine.getLstSessionErrors();
                            String failureCauseActionId = mainEngine.getSessionDataExchange().getFailureCauseActionId();
                            if (vars.size() > 0) {
                                for (String actionPath : vars.keySet()) {
                                    Variable var = vars.get(actionPath);
                                    if (var != null && var.getValue() != null && !var.getValue().equals("Error in process")) {
                                        String actionId;
                                        String actionName = var.getName().substring(0, var.getName().lastIndexOf("/"));
                                        String string = actionId = failureCauseActionId != null ? mainEngine.getActionId(actionName) : null;
                                        if (failureCauseActionId == null || failureCauseActionId.equals(actionId)) {
                                            Variable stackTrace = null;
                                            try {
                                                stackTrace = mainEngine.getEngineContext().getVariable(String.valueOf(actionName) + "/CORE_STACK_TRACE");
                                                if (stackTrace != null) {
                                                    errors.append("\n----------- FOR " + actionName + "\n " + stackTrace.getValue());
                                                    stack.append(stackTrace.getValue());
                                                }
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    if (errors.length() <= 0) continue;
                                    pattern.put("ERRORS", errors.toString());
                                }
                            }
                            Global.userConsoleLogger.info("\n-- DURATION = " + (String)pattern.get("DURATION"));
                            Global.userConsoleLogger.info("");
                            if (pattern.get("STATISTICS") != null) {
                                Global.userConsoleLogger.info("##### STATISTICS #####");
                                Global.userConsoleLogger.info("");
                                Global.userConsoleLogger.info((String)pattern.get("STATISTICS"));
                            }
                            if (Global.stackTraceOnStdOutput.booleanValue() && pattern.get("ERRORS") != null) {
                                Global.userConsoleLogger.info("####### ERRORS #######");
                                Global.userConsoleLogger.info((String)pattern.get("ERRORS"));
                            }
                            if (returnCodePath != null) {
                                try {
                                    Variable returnCodeVariable = mainEngine.getEngineContext().getExpressionVariable(returnCodePath, deliveryName);
                                    if (returnCodeVariable != null) {
                                        processReturnCode.append(returnCodeVariable.getValue());
                                    } else {
                                        System.err.println(String.valueOf(Messages.getString("StartDelivery.39")) + returnCodePath + Messages.getString("StartDelivery.40"));
                                    }
                                }
                                catch (EngineExceptionI e) {
                                    System.err.println(String.valueOf(Messages.getString("StartDelivery.41")) + returnCodePath + Messages.getString("StartDelivery.42") + e.getStackTraceString());
                                }
                            }
                        }

                        @Override
                        public void beforeStarting(MainEngineI mainEngine) {
                            if (outputFormat != null) {
                                String rep = outputFormat.replace("%id", mainEngine.getSessionID());
                                Global.userConsoleLogger.info(rep);
                            }
                        }
                    });
                    Global.userConsoleLogger.info("##### BEGIN #####");
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (ctrlFile.exists()) {
                                ctrlFile.delete();
                            }
                            try {
                                ctrlFile.createNewFile();
                                ctrlFile.deleteOnExit();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            try {
                                while (ctrlFile.exists()) {
                                    Thread.sleep(500L);
                                }
                                m.stopSession(true);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    thread.setName("Watch file session");
                    thread.start();
                    m.runMainEngineSync(false, true);
                    System.setErr(err);
                    thread.stop();
                    Global.userConsoleLogger.info("##### END #####");
                    int status = m.getSessionStatus();
                    if (status == -2) {
                        System.err.println("Session: " + m.getSessionID() + " Killed");
                    } else if (status == -1) {
                        System.err.println("Session: " + m.getSessionID() + " Error" + (stack.length() > 0 ? "\n" + stack.toString() : ""));
                    }
                    int n = status = status == 1 ? 0 : status;
                    if (processReturnCode != null && !processReturnCode.toString().equals("")) {
                        try {
                            status = Integer.parseInt(processReturnCode.toString());
                        }
                        catch (Exception exception) {
                            System.err.println(String.valueOf(Messages.getString("StartDelivery.43")) + returnCodePath + Messages.getString("StartDelivery.44") + processReturnCode.toString() + "'");
                        }
                    }
                    System.exit(status);
                    break block97;
                }
                Global.userConsoleLogger.error(String.valueOf(Messages.getString("StartDelivery.45")) + deliveryName + "'");
                System.err.println(String.valueOf(Messages.getString("StartDelivery.46")) + deliveryName + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        System.err.println("Error");
        System.exit(-1);
    }
}

