/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="stop session", removeString="stop", usage="stop session <id> [synch [format %<columnName>[,<%columnName2>...]]]", description="Stop the running session <id>. If \"synch\" then wait for the end of the session.")
public class StopSessionCommand
implements RuntimeCommand {
    @CommandParameter(name="session", valueSample="sessionId", usage="Session ID")
    public String sessId;
    @CommandParameter(name="synch")
    public Boolean synch;
    @CommandParameter(name="format")
    public String format;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        block8: {
            if (!(this.format == null || this.synch != null && this.synch.booleanValue())) {
                out.print(Messages.getString("StopSessionCommand.0"));
                return;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("sessionId", this.sessId);
            try {
                out.println(String.valueOf(Messages.getString("StopSessionCommand.1")) + this.sessId + "...");
                int ret = engineAPI.stopSession(this.sessId, false);
                if (ret == -1) {
                    out.println(String.valueOf(Messages.getString("StopSessionCommand.2")) + this.sessId + Messages.getString("StopSessionCommand.3"));
                    break block8;
                }
                if (this.synch == null || !this.synch.booleanValue()) {
                    out.println(String.valueOf(Messages.getString("StopSessionCommand.4")) + this.sessId);
                    break block8;
                }
                HashMap<String, String> quest = new HashMap<String, String>();
                quest.put("sessionId", this.sessId);
                out.println(String.valueOf(Messages.getString("StopSessionCommand.5")) + this.sessId + Messages.getString("StopSessionCommand.6"));
                try {
                    engineAPI.waitSession(quest);
                }
                catch (Throwable t) {
                    out.println(String.valueOf(Messages.getString("StopSessionCommand.7")) + this.sessId + Messages.getString("StopSessionCommand.8") + t.getMessage());
                }
                if (this.format == null) {
                    this.format = "%id,%status,%returncode";
                }
                this.format(this.sessId, engineAPI, out);
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Messages.getString("StopSessionCommand.9")) + this.sessId, e);
            }
        }
    }

    private void format(String id, IEngineClient engineAPI, PrintStream out) throws Exception {
        Map session = engineAPI.getSessionInfo(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Map<String, InternalEngineCommandsI.Column> columns = InternalEngineCommandsI.createSessionsColumns(this.format != null && (this.format.contains("errormessage") || this.format.contains("exception")));
        InternalEngineCommandsI.fillSessionsColumns(columns, session, sdf, engineAPI);
        out.println(InternalEngineCommandsI.formatList2(columns, this.format));
    }
}

