/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.compiler;

import com.indy.engine.Global;
import com.indy.engine.compiler.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class CompileAndLoad {
    File dir;
    private Method method;

    public static void main(String[] args) {
        CompileAndLoad cal = new CompileAndLoad("c:/temp/class");
        cal.compile();
        try {
            cal.loadClassPath((URLClassLoader)ClassLoader.getSystemClassLoader());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public CompileAndLoad(String dir) {
        this.dir = new File(dir);
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            this.method = sysclass.getDeclaredMethod("addURL", URL.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.method.setAccessible(true);
    }

    public void compile() {
        this.compileAllFiles(this.dir);
    }

    public void loadClassPath(URLClassLoader classLoader) throws SecurityException, IllegalArgumentException, MalformedURLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.method.invoke((Object)classLoader, this.dir.toURL());
    }

    protected void compileAllFiles(File directory) {
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String path = file.getAbsolutePath();
            if (file.isDirectory()) {
                this.compileAllFiles(file);
            } else if (file.getAbsolutePath().endsWith(".java")) {
                try {
                    String classFileName = String.valueOf(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(".java"))) + ".class";
                    File classFile = new File(classFileName);
                    if (!classFile.exists() || classFile.lastModified() < file.lastModified()) {
                        Global.getConsoleLogger().info(String.valueOf(Messages.getString("CompileAndLoad.0")) + path);
                        jc.run(null, null, null, path);
                        Global.getConsoleLogger().info(String.valueOf(path) + Messages.getString("CompileAndLoad.1"));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Global.getConsoleLogger().warn(String.valueOf(Messages.getString("CompileAndLoad.2")) + path);
                    Global.getConsoleLogger().warn(Messages.getString("CompileAndLoad.3"));
                    Global.getLogger().error(String.valueOf(Messages.getString("CompileAndLoad.4")) + path);
                }
            }
            ++n2;
        }
    }
}

