/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.delivery;

import com.indy.engine.delivery.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Delivery {
    private long lastAccess;
    private String name;
    private String configurationCode;
    private String allowedScriptErrors;
    private String allowedVariableErrors;
    private String id;
    private Map<String, Route> map = new HashMap<String, Route>();
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private List<Connection> connection = new ArrayList<Connection>();
    private boolean produceOutputIfError = false;
    private String defaultXmlEncoding = null;
    private String keepInputMessage = null;
    private String keepOutputMessage = null;
    private String keepFaultMessage = null;
    private boolean defauktWriteXmlDeclation = true;
    InOutType inputType = InOutType.nothing;
    InOutType outputType = InOutType.nothing;
    String firstOutputInternetMediaType = null;
    List<AltId> altIds = new ArrayList<AltId>();
    private boolean externalized;
    private String procId;
    private String userName;
    private Date buildDate;
    private Date exportDate;
    String exportUser;
    String packageId;
    String version;
    String description;
    HttpRestDeliveryProperties hrdp;
    private String checksum;
    private String checksumVersion;

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public String getDefaultXmlEncoding() {
        return this.defaultXmlEncoding;
    }

    public boolean isDefaultWriteXmlDeclation() {
        return this.defauktWriteXmlDeclation;
    }

    public boolean isProduceOutputIfError() {
        return this.produceOutputIfError;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Route> getRoutes() {
        return this.map.values();
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfigurationCode() {
        return this.configurationCode;
    }

    public void setConfigurationCode(String configurationCode) {
        this.configurationCode = configurationCode;
    }

    public String getAllowedScriptErrors() {
        return this.allowedScriptErrors;
    }

    public void setAllowedScriptErrors(String allowedScriptErrors) {
        this.allowedScriptErrors = allowedScriptErrors;
    }

    public String getAllowedVariableErrors() {
        return this.allowedVariableErrors;
    }

    public void setAllowedVariableErrors(String allowedVariableErrors) {
        this.allowedVariableErrors = allowedVariableErrors;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InOutType getInputType() {
        return this.inputType;
    }

    public InOutType getOutputType() {
        return this.inputType;
    }

    public void setRoute(String name, Route r) {
        if (this.firstOutputInternetMediaType == null && r.getInternetMediaType() != null && !r.getInternetMediaType().isEmpty()) {
            this.firstOutputInternetMediaType = r.getInternetMediaType();
        }
        InOutType type = InOutType.nothing;
        if (r.getType() != null) {
            try {
                type = InOutType.valueOf(r.getType());
            }
            catch (Exception exception) {
                type = InOutType.other;
            }
        }
        if (r.isInput()) {
            if (this.inputType == InOutType.nothing) {
                this.inputType = type;
            } else if (this.inputType != type) {
                this.inputType = InOutType.mix;
            }
        }
        if (r.isOutput()) {
            if (this.outputType == InOutType.nothing) {
                this.outputType = type;
            } else if (this.outputType != type) {
                this.outputType = InOutType.mix;
            }
        }
        this.map.put(name, r);
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Connection> getConnection() {
        return this.connection;
    }

    public void setConnection(List<Connection> connection) {
        this.connection = connection;
    }

    public void setProduceOutputIfError(boolean b) {
        this.produceOutputIfError = b;
    }

    public void setDefaultXmlEncoding(String tmp) {
        this.defaultXmlEncoding = tmp;
    }

    public void setdefaultriteXmlDeclation(boolean b) {
        this.defauktWriteXmlDeclation = b;
    }

    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(String value) {
        Calendar c = DatatypeConverter.parseDateTime((String)value);
        this.exportDate = c.getTime();
    }

    public List<AltId> getAltId() {
        return this.altIds;
    }

    public AltId createAltId() {
        return new AltId();
    }

    public void setProcId(String id2) {
        this.procId = id2;
    }

    public String getProcId() {
        return this.procId;
    }

    public String getBuildUser() {
        return this.userName;
    }

    public void setBuildUser(String userName) {
        this.userName = userName;
    }

    public String getExportUser() {
        return this.exportUser;
    }

    public void setExportUser(String exportUser) {
        this.exportUser = exportUser;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public void setBuildDate(String value) {
        Calendar c = DatatypeConverter.parseDateTime((String)value);
        this.buildDate = c.getTime();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isExternalized() {
        return this.externalized;
    }

    public void setExternalized(boolean valueOf) {
        this.externalized = valueOf;
    }

    public String getFirstOutputInternetMediaType() {
        return this.firstOutputInternetMediaType;
    }

    public void setHttpRestDeliveryProperties(HttpRestDeliveryProperties hrdp) {
        this.hrdp = hrdp;
    }

    public HttpRestDeliveryProperties getHttpRestDeliveryProperties() {
        return this.hrdp;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setChecksumVersion(String checksumVersion) {
        this.checksumVersion = checksumVersion;
    }

    public String getChecksumVersion() {
        return this.checksumVersion;
    }

    public String getKeepInputMessage() {
        return this.keepInputMessage;
    }

    public void setKeepInputMessage(String keepInputMessage) {
        this.keepInputMessage = keepInputMessage;
    }

    public String getKeepOutputMessage() {
        return this.keepOutputMessage;
    }

    public void setKeepOutputMessage(String keepOutputMessage) {
        this.keepOutputMessage = keepOutputMessage;
    }

    public String getKeepFaultMessage() {
        return this.keepFaultMessage;
    }

    public void setKeepFaultMessage(String keepFaultMessage) {
        this.keepFaultMessage = keepFaultMessage;
    }

    public class AltId {
        String id;
        String origin;

        public String getId() {
            return this.id;
        }

        public void setOrigin(String value) {
            this.origin = value;
        }

        public void setValue(String value) {
            this.id = value;
        }

        public String getOrigin() {
            return this.origin;
        }
    }

    public class Connection {
        private Map<String, String> connectionParam = new HashMap<String, String>();
        private List<String> transaction = new ArrayList<String>();
        private String name;
        private String type;

        public Map<String, String> getConnectionParam() {
            return this.connectionParam;
        }

        public void setConnectionParam(Map<String, String> connectionParam) {
            this.connectionParam = connectionParam;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getTransaction() {
            return this.transaction;
        }

        public void setTransaction(List<String> transaction) {
            this.transaction = transaction;
        }
    }

    public static enum InOutType {
        json,
        xsd,
        nothing,
        other,
        mix;


        public boolean isXmlOnly() {
            return this == nothing || this == xsd;
        }
    }

    public class Parameter {
        private boolean fault;
        private boolean output;
        private boolean input;
        private String name;
        private String type;
        private String defaultValue;

        public boolean isFault() {
            return this.fault;
        }

        public void setFault(boolean fault) {
            this.fault = fault;
        }

        public boolean isOutput() {
            return this.output;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public boolean isInput() {
            return this.input;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDefaultValue(String value) {
            this.defaultValue = value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    public class Route {
        private boolean fault;
        private boolean output;
        private boolean input;
        private String id;
        private String targetNameSpace;
        private String elementName;
        private String resource;
        private String type;
        private String checkSum;
        private String internetMediaType;
        private String targetPrefix;

        public String getInternetMediaType() {
            return this.internetMediaType;
        }

        public void setInternetMediaType(String internetMediaType) {
            this.internetMediaType = internetMediaType;
        }

        public boolean isFault() {
            return this.fault;
        }

        public void setFault(boolean fault) {
            this.fault = fault;
        }

        public boolean isOutput() {
            return this.output;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public boolean isInput() {
            return this.input;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTargetNameSpace(boolean newNameSpace) {
            if (this.targetPrefix == null) {
                return WsdlAPI.STAMBIA_NO_NAMESPACE_URI(newNameSpace);
            }
            return this.targetNameSpace;
        }

        public void setTargetNameSpace(String targetNameSpace) {
            this.targetNameSpace = targetNameSpace;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setTargetPrefix(String string) {
            this.targetPrefix = string;
        }

        public String getTargetPrefix(boolean newNameSpace) {
            if (this.targetPrefix == null) {
                return WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(newNameSpace);
            }
            return this.targetPrefix;
        }

        public void write(InputStream _is, SOAPElement root, boolean wsiCompliant) throws SOAPException, XMLStreamException, FactoryConfigurationError {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XMLEventReader reader = factory.createXMLEventReader(_is);
            SOAPElement current = root;
            HashSet<String> uris = new HashSet<String>();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            String path = Messages.getString("Delivery.0");
            boolean first = true;
            while (reader.hasNext()) {
                XMLEvent event = (XMLEvent)reader.next();
                if (event.isStartElement()) {
                    StartElement start = event.asStartElement();
                    QName name = start.getName();
                    this.writeNameSpace(name, current, path, uris, map, wsiCompliant);
                    path = String.valueOf(path) + Messages.getString("Delivery.1") + name.toString();
                    current = current.addChildElement(start.getName());
                    if (first) {
                        first = false;
                        if (!(current.getNamespaceURI() != null && !current.getNamespaceURI().isEmpty() || current.getPrefix() != null && !current.getPrefix().isEmpty() || this.getTargetNameSpace(wsiCompliant) == null || this.getTargetNameSpace(wsiCompliant).isEmpty())) {
                            current = current.setElementQName(new QName(this.getTargetNameSpace(wsiCompliant), current.getNodeName(), this.getTargetPrefix(wsiCompliant)));
                        }
                    }
                    Iterator<Attribute> it = start.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        QName _name = attr.getName();
                        this.writeNameSpace(_name, current, path, uris, map, wsiCompliant);
                        current.addAttribute(attr.getName(), attr.getValue());
                    }
                    continue;
                }
                if (event.isEndElement()) {
                    List list = (List)map.get(path = path.substring(0, path.lastIndexOf(Messages.getString("Delivery.2"))));
                    if (list != null) {
                        uris.removeAll(list);
                    }
                    current = current.getParentElement();
                    continue;
                }
                if (!event.isCharacters()) continue;
                current.addTextNode(event.asCharacters().getData());
            }
        }

        void writeNameSpace(QName name, SOAPElement current, String path, Set<String> uris, Map<String, List<String>> map, boolean wsiCompliant) throws SOAPException {
            String uri = name.getNamespaceURI();
            String prefix = name.getPrefix();
            if (uri != null && prefix != null && uri.equals(this.getTargetNameSpace(wsiCompliant)) && !uris.contains(uri)) {
                current.addNamespaceDeclaration(prefix, uri);
                uris.add(uri);
                List<String> list = map.get(path);
                if (list == null) {
                    list = new ArrayList<String>();
                    map.put(path, list);
                }
                list.add(uri);
            }
        }

        public void setType(String value) {
            this.type = value;
        }

        public String getType() {
            return this.type;
        }

        public void setCheckSum(String checkSum2) {
            this.checkSum = checkSum2;
        }

        public String getCheckSum() {
            return this.checkSum;
        }
    }
}

