/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main;

import com.indy.engine.Global;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.IScriptingEngineProvider;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.main.action.variable.VariableContainer;
import com.indy.engine.core.manager.INamedObjectManager;
import com.indy.engine.main.MainEngineEnv;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.Messages;
import com.indy.engine.main.scripting.ScriptingEngineProvider;
import com.indy.engine.manager.ActionSynchronizer;
import com.indy.runtime.utils.StringUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;

public class EngineContextI
extends VariableContainer
implements Cloneable,
ISessionContext {
    private MainEngineI mainEngine;
    private ActionSynchronizer actionSynchronizer = new ActionSynchronizer();
    public final ScriptingEngineProvider scriptingContext = new ScriptingEngineProvider();
    private final ReentrantLock connectionlock = new ReentrantLock();
    INamedObjectManager namedObjectManager;
    Map<String, ClassLoader> sessionClassloader = Collections.synchronizedMap(new HashMap());

    public ActionSynchronizer getActionSynchronizer() {
        return this.actionSynchronizer;
    }

    public String createSessionId() {
        return MainEngineEnv.createId();
    }

    public int stopSession(String sessionId, boolean waitMode) throws InterruptedException {
        if (Global.engineServer != null) {
            return Global.engineServer.stopSession(sessionId, waitMode);
        }
        return -1;
    }

    public VariableContainer getRootContainer() {
        return this;
    }

    public Map<String, Variable> getAllCopiedVariables() {
        return this.getAllCopiedVariables(null);
    }

    public String resolveVariableName(String pToResolveVar, String callingVariable) {
        String sToResolveVar = pToResolveVar;
        try {
            if (sToResolveVar.startsWith("/*")) {
                String name = this.getVariable(VariableType.CORE_ROOT.getName()).getValue();
                sToResolveVar = sToResolveVar.replaceFirst("\\*", name);
            }
            if (sToResolveVar.startsWith("../")) {
                try {
                    URI uri = new URI(String.valueOf(StringUtils.percentEncodeExceptSlash((String)callingVariable)) + "/" + StringUtils.percentEncodeExceptSlash((String)sToResolveVar));
                    sToResolveVar = uri.normalize().getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    sToResolveVar = String.valueOf(sToResolveVar) + Messages.getString("EngineContextI.0");
                }
            } else if (sToResolveVar.startsWith("./")) {
                try {
                    URI uri = new URI(String.valueOf(StringUtils.percentEncodeExceptSlash((String)callingVariable)) + "/" + StringUtils.percentEncodeExceptSlash((String)sToResolveVar.substring(1)));
                    sToResolveVar = uri.normalize().getPath();
                }
                catch (URISyntaxException e) {
                    sToResolveVar = String.valueOf(sToResolveVar) + Messages.getString("EngineContextI.1") + e.getMessage();
                }
            } else if (sToResolveVar.startsWith("/")) {
                sToResolveVar = sToResolveVar.substring(1);
            } else if (sToResolveVar.startsWith("~/")) {
                sToResolveVar = String.valueOf(this.getVariable(VariableType.CORE_ROOT.getName()).getValue().toString()) + sToResolveVar.substring(1);
            } else {
                try {
                    String _callingVariable = URLEncoder.encode(callingVariable, "UTF-8");
                    String _sToResolveVar = URLEncoder.encode(sToResolveVar, "UTF-8");
                    URI uri = new URI(String.valueOf(_callingVariable) + "/" + _sToResolveVar);
                    sToResolveVar = URLDecoder.decode(uri.normalize().toString(), "UTF-8");
                }
                catch (URISyntaxException e) {
                    sToResolveVar = String.valueOf(sToResolveVar) + Messages.getString("EngineContextI.2") + e.getMessage();
                }
            }
        }
        catch (Exception exception) {
            sToResolveVar = pToResolveVar;
        }
        return sToResolveVar;
    }

    public VariableContainer getVariableContainer(String actName) {
        return this.getActionVariableContainer(actName);
    }

    public EngineContextI(MainEngineI mainEngine) {
        super("", null);
        this.mainEngine = mainEngine;
    }

    public Variable addSessionVariable(VariableType varType, Object value, boolean report, boolean cumul) {
        return this.addVariable(varType.getName(), null, value, varType.getType(), report, cumul);
    }

    public Variable addSessionVariable(VariableType varType, Object value) {
        return this.addVariable(varType.getName(), null, value, varType.getType(), false, false);
    }

    public Variable addVariable(String varName, String actName, Object varValue, String varType, boolean varRealTimeReport, boolean isCumulative) {
        return this.addVariable(varName, actName, varValue, varType, varRealTimeReport, isCumulative, VariablePublicationMode.DYNAMIC);
    }

    public Variable addVariable(String varName, String actName, Object varValue, String varType, boolean varRealTimeReport, boolean isCumulative, VariablePublicationMode mode) {
        String _value;
        Variable var = null;
        String _varName = null;
        _varName = actName != null ? this.resolveVariableName(varName, actName) : varName;
        String string = _value = varValue != null ? varValue.toString() : null;
        String _type = varType != null ? varType : (_value != null ? _value.getClass().getSimpleName() : "String");
        var = this.getVariable(_varName);
        if (var != null) {
            var.setValue(_value, isCumulative);
            var.setRealTimeReport(varRealTimeReport);
            var.setType(_type);
        } else {
            var = new Variable(_varName, _value, _type, varRealTimeReport, isCumulative);
            this.addVariable(var);
        }
        var.setMode(mode);
        if (var.isRealTimeReport()) {
            this.mainEngine.reportVariable(var, null);
        }
        return var;
    }

    private static String getActioFullName(String varFullName) {
        int index = varFullName.lastIndexOf(47);
        if (index > -1) {
            return varFullName.substring(0, index - 1);
        }
        return null;
    }

    private static String getVariableShortName(String varFullName) {
        int index = varFullName.lastIndexOf(47);
        if (index > -1) {
            return varFullName.substring(index + 1);
        }
        return varFullName;
    }

    public Variable getVariable(String varName) {
        return this.getAbsolutVariable(varName);
    }

    public boolean existsVariable(String varName) {
        return this.getVariable(varName) != null;
    }

    public Variable getExpressionVariable(String varName, String actname) throws EngineExceptionI {
        return this.getVariable(this.resolveVariableName(varName, actname));
    }

    public Variable getVariable(String varName, String actName) throws EngineExceptionI {
        VariableContainer vc = this.getVariableContainer(actName);
        if (vc != null) {
            vc.getLocalVariable(varName);
        }
        return null;
    }

    public Map<String, Variable> getAllActionVariables(String actName) throws EngineExceptionI {
        VariableContainer vc = this.getVariableContainer(actName);
        if (vc != null) {
            return vc.getAllCopiedLocalVariables(null);
        }
        return null;
    }

    public String toString() {
        final StringBuffer ret = new StringBuffer();
        ret.append(String.valueOf(Messages.getString("EngineContextI.3")) + Global.dLog.getCarriageReturn());
        ret.append("--- " + Global.dLog.getCarriageReturn());
        ret.append(String.valueOf(Messages.getString("EngineContextI.4")) + Global.dLog.getCarriageReturn());
        ret.append("--- --" + Global.dLog.getCarriageReturn());
        try {
            this.getRootContainer().scanAllVariable(new VariableContainer.Scaner(){

                public void scan(Variable v) throws EngineExceptionI {
                    ret.append("--- -- --" + v.getName() + ": \t\t" + v.getValue() + Global.dLog.getCarriageReturn());
                }
            });
        }
        catch (EngineExceptionI e) {
            e.printStackTrace();
        }
        return ret.toString();
    }

    public MainEngineI getMainEngine() {
        return this.mainEngine;
    }

    public void clear() throws Exception {
        this.mainEngine = null;
        this.namedObjectManager = null;
        this.sessionClassloader.clear();
        super.clear();
    }

    public String getThreadName() {
        return "SESSION|" + this.mainEngine.getSessionID() + "|" + this.mainEngine.getSessionIter() + "|" + this.mainEngine.getSessionName();
    }

    public synchronized ReentrantLock getConnectionlock() {
        return this.connectionlock;
    }

    public IEngineClient getEngineApi() throws EngineExceptionI {
        if (this.mainEngine != null) {
            return this.getMainEngine().getEngineApi();
        }
        return null;
    }

    public String getSessionID() {
        if (this.mainEngine != null) {
            return this.mainEngine.getSessionID();
        }
        return null;
    }

    public Variable aggregateVariable(String callingAction, String variableName, int function, String startingPath, String valueFilter) {
        if (this.mainEngine != null) {
            return this.mainEngine.aggregateVariable(callingAction, variableName, function, startingPath, valueFilter);
        }
        return null;
    }

    public Map<String, Variable> getLstSessionVariablesByName(String callingAction, String variableName, String startingPath, boolean withError) {
        if (this.mainEngine != null) {
            return this.mainEngine.getLstSessionVariablesByName(callingAction, variableName, startingPath, withError);
        }
        return null;
    }

    public String getSessionName() {
        return this.mainEngine.getSessionName();
    }

    public String transformVariableExpression(String callingVariable, String vCode) {
        return Global.transformVariableExpression(callingVariable, this, vCode);
    }

    public RuntimeContext getRuntimeContext() {
        return Global.runtimeContext;
    }

    public INamedObjectManager createNamedObjectManager() {
        return new NamedObjectManager(false);
    }

    public INamedObjectManager getNamedObjectManager() {
        if (this.namedObjectManager == null) {
            this.namedObjectManager = this.getMainEngine().getEngineContext().createNamedObjectManager();
        }
        return this.namedObjectManager;
    }

    public IScriptingEngineProvider getScriptingProvider() {
        return this.scriptingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionClassLoader(String name, ClassLoader cl) throws Exception {
        Map<String, ClassLoader> map = this.sessionClassloader;
        synchronized (map) {
            ClassLoader _cl = this.sessionClassloader.get(name);
            if (_cl != null) {
                throw new Exception(Messages.getString("EngineContextI.15"));
            }
            this.sessionClassloader.put(name, cl);
        }
    }

    public ClassLoader getSessionClassLoader(String name) throws Exception {
        ClassLoader _cl = this.sessionClassloader.get(name);
        if (_cl == null) {
            throw new Exception(String.valueOf(Messages.getString("EngineContextI.16")) + name + "\"");
        }
        return _cl;
    }

    private static class NamedObjectContainer {
        Semaphore semForObject = new Semaphore(1);
        Semaphore semForStart = new Semaphore(1);
        Semaphore semForEnd = new Semaphore(1);
        Object object;
        boolean isDispose;
        public String name;

        private NamedObjectContainer() throws InterruptedException {
            this.semForObject.acquire();
            this.semForStart.acquire();
            this.semForEnd.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object waitObject() throws Exception {
            this.checkIsDispose();
            this.semForObject.acquire();
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.semForObject.release();
            }
            return this.object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIsDispose() throws Exception {
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                if (this.isDispose) {
                    throw new Exception(String.valueOf(Messages.getString("EngineContextI.5")) + this.name + Messages.getString("EngineContextI.6"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setObject(Object ps) throws Exception {
            this.checkIsDispose();
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                if (this.object != null) {
                    throw new Exception(String.valueOf(Messages.getString("EngineContextI.7")) + this.name + Messages.getString("EngineContextI.8"));
                }
                this.object = ps;
                this.semForObject.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitReady() throws Exception {
            this.checkIsDispose();
            this.semForStart.acquire();
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.semForStart.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleted() throws Exception {
            this.checkIsDispose();
            this.semForEnd.acquire();
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.semForEnd.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCompleted() throws Exception {
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.semForEnd.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setReady() throws Exception {
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.semForStart.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() throws Exception {
            NamedObjectContainer namedObjectContainer = this;
            synchronized (namedObjectContainer) {
                this.isDispose = true;
                this.semForStart.release();
                this.semForObject.release();
                this.semForEnd.release();
            }
        }
    }

    public static class NamedObjectManager
    implements INamedObjectManager {
        boolean autoDeclare = false;
        Map<String, NamedObjectContainer> namedPreparedStatements = new HashMap<String, NamedObjectContainer>();

        public NamedObjectManager(boolean autoDeclare) {
            this.autoDeclare = autoDeclare;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void declare(String name) throws Exception {
            Map<String, NamedObjectContainer> map = this.namedPreparedStatements;
            synchronized (map) {
                NamedObjectContainer pm = this.namedPreparedStatements.get(name);
                if (pm == null) {
                    pm = new NamedObjectContainer();
                    pm.name = name;
                    this.namedPreparedStatements.put(name, pm);
                } else if (!this.autoDeclare) {
                    throw new Exception(String.valueOf(Messages.getString("EngineContextI.9")) + name + Messages.getString("EngineContextI.10"));
                }
            }
        }

        public void setObject(String name, Object ps) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            pm.setObject(ps);
        }

        public Object waitObject(String name) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            return pm.waitObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NamedObjectContainer getObjectContainer(String name) throws Exception {
            NamedObjectContainer pm;
            if (this.autoDeclare) {
                this.declare(name);
            }
            Map<String, NamedObjectContainer> map = this.namedPreparedStatements;
            synchronized (map) {
                pm = this.namedPreparedStatements.get(name);
                if (pm == null) {
                    throw new Exception(String.valueOf(Messages.getString("EngineContextI.11")) + name + Messages.getString("EngineContextI.12"));
                }
            }
            return pm;
        }

        public void waitCompleted(String name) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            pm.waitCompleted();
        }

        public void setCompleted(String name) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            pm.setCompleted();
        }

        public void setReady(String name) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            pm.setReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unDeclare(String name) throws Exception {
            Map<String, NamedObjectContainer> map = this.namedPreparedStatements;
            synchronized (map) {
                NamedObjectContainer pm = this.namedPreparedStatements.get(name);
                if (pm == null) {
                    throw new Exception(String.valueOf(Messages.getString("EngineContextI.13")) + name + Messages.getString("EngineContextI.14"));
                }
                pm.dispose();
                this.namedPreparedStatements.remove(name);
            }
        }

        public void waitReady(String name) throws Exception {
            NamedObjectContainer pm = this.getObjectContainer(name);
            pm.waitReady();
        }
    }
}

