/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main;

import com.indy.engine.Global;
import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.engine.core.common.UUID32;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.main.action.variable.VariableContainer;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.EngineContextI;
import com.indy.engine.main.MainEngineEnv;
import com.indy.engine.main.Messages;
import com.indy.engine.main.WaitMainEngine;
import com.indy.engine.main.action.ActionBindI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ActionStaticProcess;
import com.indy.engine.main.action.statics.ConnectionStore;
import com.indy.engine.main.action.statics.LinkStatic;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.main.repository.internal.MemoryDelivery;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.ActionProcess;
import com.indy.engine.manager.ThreadManager;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.service.Service;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.service.ServiceState;
import com.indy.engine.userLog.IUserLogManager;
import com.indy.engine.userLog.UserLogManagerI;
import com.indy.engine.userLog.UserLogfactory;
import com.semarchy.xdi.engine.common.EngineFactory;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MainEngineI
implements Runnable {
    List<EngineHandler> handlers = Collections.synchronizedList(new ArrayList());
    int numVar = 0;
    String lockNumVar = new String();
    int numAction = 0;
    String lockNumAction = new String();
    public IUserLogManager uLog;
    public Map<String, Action> lstActions = new TreeMap<String, Action>();
    public Map<String, Action> lstActionsId = new TreeMap<String, Action>();
    Map<String, Map> lstActionsAltId = new TreeMap<String, Map>();
    private Map<ActionStatic, Action> actionStaticToAction = new HashMap<ActionStatic, Action>();
    public TreeMap<String, ActionGraphLinkI> lstLinks = new TreeMap();
    public Map<String, ConnectionManagerI> lstConnectionManager = new ConcurrentHashMap<String, ConnectionManagerI>();
    public Map<String, String> lstChildSessions = new ConcurrentHashMap<String, String>();
    public Map<String, String> lstLogProperties;
    public EngineContextI engineContext;
    Action startAction = null;
    boolean debugMode = false;
    boolean isRunning = false;
    boolean progressivesConnections = true;
    boolean allowedScriptErrors = false;
    boolean allowedVariableErrors = false;
    boolean stoppingSession = false;
    boolean startByCommand = false;
    String fileName = null;
    private ThreadManager threadManager;
    private RemoteSessionInfo remoteSessionInfo;
    int logLevel = noLogLevel;
    int parentLogLevel = noLogLevel;
    public static int noLogLevel = -295959526;
    private Thread thread;
    private ToWait toWait;
    private String deliveryName;
    SessionStatic sessionStatic;
    IMemoryDelivery delivery;
    VariableContainer.Selector warningSelector = new VariableContainer.Selector(){

        public String selectReturnKey(Variable variable) {
            Action act;
            if (variable.getActionName() != null && (act = MainEngineI.this.lstActions.get(variable.getActionName())) != null) {
                if (variable.getShortName().equals(VariableType.CORE_WARNING.getName())) {
                    return act.getActionId();
                }
                if (variable.getShortName().equals(VariableType.CORE_RET_MESS.getName()) && (act.getIsRedirectedKO() || act.getActionStatic().getToleratedError())) {
                    return act.getActionId();
                }
            }
            return null;
        }
    };
    VariableContainer.Selector errorSelector = new VariableContainer.Selector(){

        public String selectReturnKey(Variable variable) {
            Action act;
            if (variable.getActionName() != null && (act = MainEngineI.this.lstActions.get(variable.getActionName())) != null && variable.getShortName().equals(VariableType.CORE_RET_MESS.getName()) && !act.getIsRedirectedKO() && !act.getActionStatic().getToleratedError()) {
                return act.getActionId();
            }
            return null;
        }
    };
    private int status;
    static final String strDateFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    String sessionId;
    private ISessionDataExchange sde = new SessionDataExchange();
    private boolean isClosing;
    int userLogNum = 0;
    boolean isClear = false;
    Thread rdbmsSessionActivityThread;
    private RdbmsSessionActivity rdbmsSessionActivity;
    boolean forceStartSession = false;
    String useDeliveryConfiguration = null;
    Integer retryNumber;
    Integer retryInterval;
    UserLogManagerI.SynchMode synchLogMode = null;

    public void setSessionId() {
        this.setSessionID(MainEngineEnv.createId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrNumVar() {
        String string = this.lockNumVar;
        synchronized (string) {
            return ++this.numVar;
        }
    }

    public void setNumVar(int numVar) {
        this.numVar = numVar;
    }

    public void setNumAction(int numAction) {
        this.numAction = numAction;
    }

    public int getNumVar() {
        return this.numVar;
    }

    public int getNumAction() {
        return this.numAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrNumAction() {
        String string = this.lockNumAction;
        synchronized (string) {
            return ++this.numAction;
        }
    }

    public Action getActionInstance(ActionStatic action) {
        return this.actionStaticToAction.get(action);
    }

    public MainEngineI(boolean pDebugMode, boolean forceStartSession) throws EngineExceptionI {
        this("", pDebugMode, forceStartSession);
    }

    public String getSessionName() {
        return this.sde.getName();
    }

    public void setSessionName(String sessionName) {
        this.sde.setName(sessionName);
    }

    public boolean isStartByCommand() {
        return this.startByCommand;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        int result = this.logLevel != noLogLevel && this.logLevel != Global.INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE ? this.checkDefaultSessionLogLevel(this.logLevel) : (this.getSessionStatic().getLogLevel() != noLogLevel && this.getSessionStatic().getLogLevel() != Global.INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE ? this.checkDefaultSessionLogLevel(this.getSessionStatic().getLogLevel()) : (this.parentLogLevel != noLogLevel && (Global.DEFAULT_CHILD_SESSION_LOG_LEVEL_INHERITANCE || this.getSessionStatic().getLogLevel() == Global.INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE || this.logLevel == Global.INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE) ? this.parentLogLevel : Global.DEFAULT_SESSION_LOG_LEVEL));
        return result;
    }

    private int checkDefaultSessionLogLevel(int pLogLevel) {
        int result = pLogLevel != Global.DEFAULT_SESSION_LOG_LEVEL_VALUE ? pLogLevel : Global.DEFAULT_SESSION_LOG_LEVEL;
        return result;
    }

    public void setParentLogLevel(int parentLogLevel) {
        this.parentLogLevel = parentLogLevel;
    }

    public MainEngineI(String dName, boolean pDebugMode, boolean forceStartSession) throws EngineExceptionI {
        this.forceStartSession = forceStartSession;
        this.isRunnable();
        try {
            this.isRunning = false;
            this.debugMode = pDebugMode;
            this.engineContext = new EngineContextI(this);
            this.setSessionName(dName);
            this.setSessionStatus(0);
            this.lstLogProperties = Global.getLstLogParametersInRepository(Global.USERLOG_DEFAULT_NAME);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), String.valueOf(Messages.getString("MainEngineI.0")) + e.getMessage(), 0, 0, "ERROR");
            Global.dLog.write(this.getSessionName(), String.valueOf(Messages.getString("MainEngineI.1")) + e.getStackTraceString(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.2"), (Throwable)e);
        }
    }

    public MainEngineI(int i, String logName, boolean pDebugMode, String sessionName, String sessionId) throws EngineExceptionI {
        try {
            this.isRunning = false;
            this.debugMode = pDebugMode;
            this.engineContext = new EngineContextI(this);
            this.setSessionName(sessionName);
            this.setSessionID(sessionId);
            this.setSessionStatus(0);
            this.lstLogProperties = Global.getLstLogParametersInRepository(logName);
            this.uLog = UserLogfactory.createInstance(this, false);
            this.uLog.initLog(this.lstLogProperties, Global.USERLOG_DEFAULT_NAME, "u");
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), String.valueOf(Messages.getString("MainEngineI.3")) + e.getMessage(), 0, 0, "ERROR");
            Global.dLog.write(this.getSessionName(), String.valueOf(Messages.getString("MainEngineI.4")) + e.getStackTraceString(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.5"), (Throwable)e);
        }
    }

    public EngineContextI getEngineContext() {
        return this.engineContext;
    }

    public void setEngineContext(EngineContextI engineContext) {
        this.engineContext = engineContext;
    }

    public void clear() throws Exception {
        if (this.getSessionStatus() != 6 && this.getSessionStatus() != 2 && this.getSessionStatus() != 9 && this.getSessionStatus() != -99) {
            this.isClear = true;
            if (this.handlers != null) {
                this.handlers.clear();
            }
            this.handlers = null;
            WaitMainEngine wait = MainEngineEnv.pileHandler.get(this.sessionStatic.getDlvId());
            if (wait != null) {
                wait.remove(this);
            }
            this.toWait = null;
            this.lstActionsAltId.clear();
            this.lstActionsAltId = null;
            this.lstActionsId.clear();
            this.lstActionsId = null;
            this.lstLinks.clear();
            this.lstLinks = null;
            this.lstChildSessions.clear();
            this.lstChildSessions = null;
            this.startAction = null;
            this.lstActions.clear();
            this.lstActions = null;
            this.sessionId = null;
            this.setFileName(null);
            if (this.lstConnectionManager != null) {
                for (ConnectionManagerI conn : this.lstConnectionManager.values()) {
                    conn.clear();
                }
                this.lstConnectionManager.clear();
                this.lstConnectionManager = null;
            }
            this.engineContext.clear();
            this.engineContext = null;
            this.lstLogProperties = null;
            if (this.uLog != null) {
                this.uLog.clear();
            }
            this.uLog = null;
            this.sde = null;
            this.errorSelector = null;
            this.warningSelector = null;
            this.sessionStatic = null;
            this.rdbmsSessionActivity = null;
            this.thread = null;
            this.threadManager = null;
        }
    }

    public String getActionId(String actName) {
        String ret = null;
        try {
            ret = this.lstActions.get(actName).getActionId();
        }
        catch (Exception exception) {}
        return ret;
    }

    public Map<String, IIdDataExchange> getLstIds(String altId) {
        return this.lstActionsAltId.get(altId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildSession(String sessId, int iteration, IAction act) throws EngineExceptionI {
        Map<String, String> map = this.lstChildSessions;
        synchronized (map) {
            this.lstChildSessions.put(sessId, act.getActionName());
        }
        this.uLog.addChildSession(act, iteration, sessId);
    }

    public boolean getAllowsScriptingErrors() {
        return this.sessionStatic.isAllowedScriptErrors();
    }

    public void setDebugMode(boolean dMode) {
        this.debugMode = dMode;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public synchronized void runMainEngineSync(boolean isRestart, boolean _wait) throws EngineExceptionI {
        this.runMainEngine(isRestart, _wait);
    }

    private void isRunnable() throws EngineExceptionI {
        if (!this.forceStartSession) {
            Service service = ServiceManager.INSTANCE.getService("execution");
            if (service == null) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("MainEngineI.6")) + "execution" + Messages.getString("MainEngineI.9"));
            }
            if (service.getState() != ServiceState.Running) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("MainEngineI.7")) + "execution" + Messages.getString("MainEngineI.8") + (Object)((Object)ServiceState.Running));
            }
        }
    }

    public void runMainEngine(boolean isRestart, boolean _wait) throws EngineExceptionI {
        this.isRunnable();
        boolean immediateRun = true;
        if (this.getNbMaxParallelSessions() > 0 && !Global.commandLine) {
            immediateRun = false;
            WaitMainEngine wait = MainEngineEnv.pileHandler.get(this.deliveryName);
            if (wait == null) {
                wait = new WaitMainEngine(this.getNbMaxParallelSessions());
                MainEngineEnv.pileHandler.put(this.deliveryName, wait);
            }
            wait.add(this);
            this.toWait = null;
            Thread waitingThread = null;
            WaitMainEngine wait2 = wait;
            this.toWait = new ToWait(wait2, _wait, isRestart);
            if (_wait) {
                this.toWait.run();
            } else {
                waitingThread = new Thread(this.toWait);
                waitingThread.start();
            }
        }
        if (immediateRun) {
            this.runMainEngine2(isRestart, _wait);
        }
    }

    public Integer getNbMaxParallelSessions() {
        return this.sessionStatic.getNbMaxParallelSessions();
    }

    private void runMainEngine2(boolean isRestart, boolean _wait) throws EngineExceptionI {
        if (this.uLog == null) {
            this.uLog = UserLogfactory.createInstance(this, this.getLogLevel() == -1);
            this.uLog.initLog(this.lstLogProperties, Global.USERLOG_DEFAULT_NAME, "u");
        }
        this.sde.setProcessId(this.sessionStatic.getProcId());
        this.setBeginDate(new Date());
        if (isRestart) {
            this.setSessionMsg(null);
            this.setEndDate(null);
            this.setLaunchMode("RESTART");
            this.setExecutionMode("MEMORY");
            this.sde.setEngineHost(Global.HTTP_HOST);
            this.sde.setEnginePort(Global.HTTP_PORT);
            this.setSessionIter(this.getSessionIter() + 1);
            this.setLaunchMode("RESTART");
            this.uLog.restartSession();
        } else {
            try {
                this.uLog.createDelivery();
                this.uLog.createSession();
            }
            catch (EngineExceptionI e) {
                this.setSessionMsg(Messages.getString("MainEngineI.10"));
                this.setSessionStatus(-1);
                throw new EngineExceptionI(this.getSessionMsg(), (Throwable)e);
            }
        }
        this.setIsRunning(true);
        this.startRdbmsSessionActivity();
        this.thread = new Thread(this);
        this.thread.setName(this.engineContext.getThreadName());
        this.thread.start();
        if (_wait) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void waitForThread() throws InterruptedException {
        while (this.thread == null) {
            if (this.toWait == null) continue;
            this.toWait._wait(100);
        }
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    public void setIsRunning(boolean b) {
        this.isRunning = b;
    }

    public void setProgressivesConnections(boolean b) {
        this.progressivesConnections = b;
    }

    public int getSessionStatus() {
        return this.sde.getStatus();
    }

    public String getSessionID() {
        return this.sde.getId();
    }

    public String getProcessID() {
        return this.sde.getProcessId();
    }

    public String getDeliveryName() {
        return this.sde.getDeliveryName();
    }

    int prepareSession() throws EngineExceptionI {
        int ret = 0;
        this.getMemoryLogger().info(String.valueOf(this.getSessionID()) + Messages.getString("MainEngineI.11"));
        Global.dLog.write(this.getSessionName(), "MainEngine->run", Messages.getString("MainEngineI.12"), 0, 0, "INFO");
        Global.dLog.write(this.getSessionName(), "MainEngine->run", "Session ID=" + this.getSessionID(), 0, 0, "INFO");
        this.deserializeXML();
        if (this.getSessionStatic().isExternalized()) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("MainEngineI.13")) + this.getSessionStatic().getConfiguration());
        }
        Global.dLog.write(this.getSessionName(), "MainEngine->run", "Deserialize XML - OK", 0, 0, "DEBUG");
        this.initCoreVariable(false);
        this.getMemoryLogger().info(String.valueOf(this.getSessionID()) + Messages.getString("MainEngineI.14"));
        return ret;
    }

    private Logger getMemoryLogger() {
        return LogManager.getLogger((String)"com.indy.engine.memory");
    }

    public int initSession(IMemoryDelivery idp, String sID, Boolean bReportMode) throws EngineExceptionI {
        this.delivery = idp;
        this.isRunnable();
        int ret = 0;
        this.getMemoryLogger().info(String.valueOf(sID) + Messages.getString("MainEngineI.15"));
        if (!bReportMode.booleanValue()) {
            ret = this.initSession(sID);
        } else {
            Global.dLog.write(this.getSessionName(), "MainEngine->initSession", Messages.getString("MainEngineI.16"), 0, 0, "DEBUG");
            this.setIsRunning(false);
            this.setSessionStatus(11);
            this.setSessionID(sID);
            ret = this.prepareSession();
            this.initSessionName();
            if (ret == 0) {
                this.setSessionStatus(12);
            } else {
                this.setSessionMsg(Messages.getString("MainEngineI.17"));
                this.setSessionStatus(-11);
            }
        }
        this.getMemoryLogger().info(String.valueOf(sID) + Messages.getString("MainEngineI.18"));
        return ret;
    }

    private void initSessionName() throws EngineExceptionI {
        if (this.getSessionName() != null && this.getSessionName().isEmpty()) {
            this.setSessionName(null);
        }
        if (this.getSessionName() == null && this.getFileName() != null && !this.getFileName().isEmpty()) {
            String tmp = new File(this.getFileName()).getName();
            tmp = tmp.substring(0, tmp.lastIndexOf(".deliv"));
            this.setSessionName(tmp);
        }
        if (this.sessionStatic != null && this.getSessionName() == null) {
            this.setSessionName(this.sessionStatic.getProcName());
        }
    }

    public int initSession(IMemoryDelivery memoryDelivery, String deliveryName, String sID) throws EngineExceptionI {
        this.delivery = memoryDelivery;
        this.deliveryName = deliveryName;
        return this.initSession(sID);
    }

    public int initSession(String fName, String sID) throws EngineExceptionI {
        this.setFileName(fName);
        File f = new File(fName);
        if (!f.exists()) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("MainEngineI.19")) + this.getFileName() + Messages.getString("MainEngineI.20"));
        }
        this.deliveryName = f.getName().substring(0, f.getName().lastIndexOf("."));
        try {
            FileInputStream fis = new FileInputStream(f);
            this.delivery = new MemoryDelivery(fis, this.deliveryName, this.useDeliveryConfiguration);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return this.initSession(sID);
    }

    private int initSession(String sID) throws EngineExceptionI {
        this.isRunnable();
        int ret = 0;
        Global.dLog.write(this.getSessionName(), "MainEngine->initSession", Messages.getString("MainEngineI.21"), 0, 0, "DEBUG");
        this.setIsRunning(true);
        this.setSessionStatus(9);
        this.setSessionID(sID);
        this.setBeginDate(new Date());
        if (ret == 0) {
            ret = this.prepareSession();
            this.initSessionName();
            if (ret == 0) {
                this.setSessionStatus(10);
            } else {
                this.setSessionMsg(Messages.getString("MainEngineI.22"));
                this.setSessionStatus(-9);
            }
        } else {
            this.setSessionMsg(Messages.getString("MainEngineI.23"));
            this.setSessionStatus(-9);
        }
        return ret;
    }

    public int stopSession(Boolean waitMode) throws InterruptedException {
        int ret = 0;
        if (this.startAction != null) {
            if (this.startAction.getActionState() == 2 || this.startAction.getActionState() == 4 || this.startAction.getActionState() == -3) {
                Global.dLog.write(this.getSessionName(), "MainEngineI=>stopSession : ", this.getSessionID(), 1, 0, "DEBUG");
                this.threadManager.kill();
                while (!this.startAction.isEnded() && waitMode.booleanValue()) {
                    this.thread.join(1000L);
                }
            } else {
                ret = -2;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public void closeLogSession() {
        try {
            this.uLog.closeSession();
            this.uLog.closeConnection();
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", "uLog.closeSession - EngineExceptionI : " + e.getMessage(), 0, 1, "DEBUG");
            this.getMemoryLogger().warn("An exception occured : ", (Throwable)e);
        }
    }

    public String getMainEngineName() {
        return this.startAction.getActionName();
    }

    public Date getMainEngineDate() {
        return new Date();
    }

    String getSessionNameInXML(String fileName) throws EngineExceptionI {
        Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", String.valueOf(Messages.getString("MainEngineI.24")) + fileName, 0, 1, "DEBUG");
        try {
            String processName = "";
            processName = this.getSessionNameInXML(new FileInputStream(fileName));
            return processName;
        }
        catch (FileNotFoundException e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", String.valueOf(Messages.getString("MainEngineI.25")) + e.getMessage(), 2, 2, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.26"), (Throwable)e);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", Messages.getString("MainEngineI.27"), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.28"), (Throwable)e);
        }
    }

    String getSessionNameInXML(InputStream io) throws EngineExceptionI {
        Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", " : (InputStream) : Begin", 0, 1, "DEBUG");
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(io);
            String processName = "";
            processName = this.getSessionNameInXML(doc);
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
            io.close();
            io = null;
            return processName;
        }
        catch (SAXParseException e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", "SAXParseException : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.29"), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", String.valueOf(Messages.getString("MainEngineI.30")) + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.31"), (Throwable)e);
        }
        catch (SAXException e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", String.valueOf(Messages.getString("MainEngineI.32")) + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.33"), (Throwable)e);
        }
        catch (IOException e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", String.valueOf(Messages.getString("MainEngineI.34")) + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.35"), (Throwable)e);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", Messages.getString("MainEngineI.36"), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MainEngineI.37"), (Throwable)e);
        }
    }

    String getSessionNameInXML(Document doc) throws EngineExceptionI {
        Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", Messages.getString("MainEngineI.38"), 0, 1, "DEBUG");
        Document document = doc;
        synchronized (document) {
            try {
                String processName = "";
                doc.getDocumentElement().normalize();
                Node root = doc.getFirstChild();
                NodeList nlProcesses = root.getChildNodes();
                Global.dLog.write(this.getSessionName(), "MainEngine->deserializeXML", String.valueOf(Messages.getString("MainEngineI.39")) + nlProcesses.getLength(), 1, 2, "DEBUG");
                int i = 0;
                while (i < nlProcesses.getLength()) {
                    Node nodeProcess = nlProcesses.item(i);
                    if (nodeProcess.getNodeName().equals("process")) {
                        NamedNodeMap procAtts = nodeProcess.getAttributes();
                        processName = procAtts.getNamedItem("actionName").getNodeValue();
                        if (procAtts.getNamedItem("isBeginProcess").getNodeValue().equals("true")) break;
                    }
                    ++i;
                }
                return processName;
            }
            catch (Exception e) {
                Global.dLog.write(this.getSessionName(), "MainEngine->getSessionNameInXML", Messages.getString("MainEngineI.40"), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("MainEngineI.41"), (Throwable)e);
            }
        }
    }

    public IMemoryDelivery getMemoryDelivery() {
        return this.delivery;
    }

    void deserializeXML() throws EngineExceptionI {
        try {
            this.getMemoryLogger().info(String.valueOf(Messages.getString("MainEngineI.43")) + this.getSessionName() + Messages.getString("MainEngineI.42"));
            this.sessionStatic = this.delivery.getSessionStatic();
            this.setConfiguration(this.sessionStatic.getConfiguration());
            this.sde.setDeliveryId(this.sessionStatic.getDlvId());
            this.sde.setDeliveryName(this.sessionStatic.getDeliveryName());
            for (ConnectionStore conn : this.sessionStatic.getConnection()) {
                ConnectionManagerI aConn = new ConnectionManagerI((ISessionContext)this.engineContext, conn.name, conn.type);
                for (String key : conn.getProperties().keySet()) {
                    aConn.addConnectionParameter(key, conn.getProperties().get(key));
                }
                for (String transacton : conn.getTransactions()) {
                    aConn.addTransaction(transacton);
                }
                this.lstConnectionManager.put(conn.name, aConn);
            }
            for (ActionStatic action : this.sessionStatic.getDefaultActions()) {
                this.actionStaticToAction.put(action, action.initDynamic(this));
            }
            for (ActionStatic action : this.sessionStatic.getDefaultActions()) {
                if (!(action instanceof ActionStaticProcess)) continue;
                ActionProcess process = (ActionProcess)this.lstActions.get(action.getActionName());
                for (LinkStatic ls : ((ActionStaticProcess)action).getLinkStores()) {
                    ActionGraphLinkI agl = new ActionGraphLinkI(ls, this);
                    this.lstLinks.put(ls.getId(), agl);
                    process.addActionLinkName(this.actionStaticToAction.get(ls.getTarget()).getActionName());
                }
                process.computeBeginNodes();
            }
            this.lstActionsAltId.putAll(this.sessionStatic.getAltIds());
            this.startAction = this.lstActions.get(this.sessionStatic.getStartAction().getActionName());
            this.getMemoryLogger().info(String.valueOf(Messages.getString("MainEngineI.44")) + this.getSessionName() + Messages.getString("MainEngineI.45"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.getMemoryLogger().error(String.valueOf(Messages.getString("MainEngineI.46")) + this.getSessionName() + Messages.getString("MainEngineI.47"), (Throwable)e1);
            throw new EngineExceptionI((Throwable)e1);
        }
        Global.dLog.write(this.getSessionName(), "MainEngine->deserializeXML", Messages.getString("MainEngineI.48"), 0, 1, "DEBUG");
    }

    public synchronized void NotifyThreadMainEngine() {
        this.notifyAll();
    }

    void closeAllConnections(EngineContextI ctx, int engineState) throws EngineExceptionI {
        Global.dLog.write(this.getSessionName(), "MainEngine->closeConnections", Messages.getString("MainEngineI.49"), 0, 0, "INFO");
        if (this.lstConnectionManager != null) {
            for (ConnectionManagerI aConn : this.lstConnectionManager.values()) {
                aConn.closeAllConnections(engineState != -1 && engineState != -2);
            }
            Iterator<ConnectionManagerI> it = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addConnectionManager(String connName, ConnectionManagerI conn) throws EngineExceptionI {
        int ret;
        block5: {
            ret = 0;
            try {
                if (this.existsConnectionManager(connName).booleanValue()) break block5;
                Map<String, ConnectionManagerI> map = this.lstConnectionManager;
                synchronized (map) {
                    this.lstConnectionManager.put(connName, conn);
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeConnectionManager(String connName) throws EngineExceptionI {
        int ret;
        block5: {
            ret = 0;
            try {
                if (this.existsConnectionManager(connName).booleanValue()) break block5;
                Map<String, ConnectionManagerI> map = this.lstConnectionManager;
                synchronized (map) {
                    this.lstConnectionManager.remove(connName);
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean existsConnectionManager(String connName) throws EngineExceptionI {
        Boolean ret = false;
        try {
            Map<String, ConnectionManagerI> map = this.lstConnectionManager;
            synchronized (map) {
                ret = this.lstConnectionManager.containsKey(connName);
            }
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("MainEngineI.50"), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new EngineExceptionI(Messages.getString("MainEngineI.51"), (Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("MainEngineI.52"), (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManagerI getConnectionManager(String connName) throws EngineExceptionI {
        ConnectionManagerI superConn = null;
        try {
            Map<String, ConnectionManagerI> map = this.lstConnectionManager;
            synchronized (map) {
                superConn = this.lstConnectionManager.get(connName);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return superConn;
    }

    public void reportVariable(Variable var, Action action) {
        if (var != null) {
            try {
                String id;
                Action act = action;
                if (act == null && var.getActionName() != null && !var.getActionName().isEmpty() && (id = this.getActionId(var.getActionName())) != null) {
                    act = this.lstActionsId.get(id);
                }
                this.uLog.reportProperty(act, var, this.incrNumVar());
            }
            catch (EngineExceptionI e2) {
                Global.dLog.write(this.getSessionName(), "MainEngineI=>reportVariable", String.valueOf(action.getActionName()) + Messages.getString("MainEngineI.53") + e2.getMessage(), 0, action.getActionStatic().getActionLevel(), "ERROR");
            }
        }
    }

    void initCoreVariable(boolean report) {
        File f = new File(Global.TEMPORARY_FOLDER);
        this.engineContext.addSessionVariable(VariableType.CORE_TEMPORARY_FOLDER, f.getAbsolutePath(), report, false);
        String str = f.getAbsolutePath().replaceAll("\\\\", "/");
        this.engineContext.addSessionVariable(VariableType.CORE_JAVA_TEMPORARY_FOLDER, str, report, false);
        this.engineContext.addSessionVariable(VariableType.CORE_ROOT, this.startAction.getActionName());
        this.engineContext.addSessionVariable(VariableType.CORE_ROOT_ID, this.startAction.getActionId());
        this.engineContext.addSessionVariable(VariableType.CORE_ENGINE_HOST, Global.HTTP_HOST);
        this.engineContext.addSessionVariable(VariableType.CORE_ENGINE_PORT, String.valueOf(Global.HTTP_PORT));
        this.engineContext.addSessionVariable(VariableType.CORE_SESSION_NAME, this.getSessionName());
        this.engineContext.addSessionVariable(VariableType.CORE_SESSION_ID, this.getSessionID());
        this.engineContext.addSessionVariable(VariableType.CORE_DELIVERY_ID, this.sessionStatic.getDlvId());
        Long ts = this.getTimestamp();
        if (ts != null) {
            this.engineContext.addSessionVariable(VariableType.CORE_SESSION_TIMESTAMP, Long.toString(ts));
        }
        this.engineContext.addSessionVariable(VariableType.CORE_SESSION_CONFIGURATION, this.getSessionConf());
    }

    private Long getTimestamp() {
        UUID32 uuid;
        String id = this.sde.getId();
        if (id != null && (uuid = UUID32.decode((String)id)) != null) {
            return uuid.getTimeStamp();
        }
        return null;
    }

    void execute() {
        if (this.getSessionID() == null) {
            this.setSessionID(this.getSessionID());
        }
        String name = String.valueOf(this.getSessionName()) + " (" + this.getSessionID() + ")";
        Global.getConsoleLogger().info(String.valueOf(name) + Messages.getString("MainEngineI.54") + this.getSessionName());
        Global.getConsoleLogger().info(String.valueOf(name) + Messages.getString("MainEngineI.55") + this.getDeliveryName());
        Global.getConsoleLogger().info(String.valueOf(name) + Messages.getString("MainEngineI.56") + this.getProcessID());
        Global.getConsoleLogger().info(String.valueOf(name) + Messages.getString("MainEngineI.57"));
        int ret = 0;
        ArrayList<EngineHandler> list = new ArrayList<EngineHandler>(this.handlers);
        for (EngineHandler _handler : list) {
            _handler.beforeStarting(this);
        }
        list.clear();
        list = null;
        this.setSessionStatus(2);
        this.initCoreVariable(true);
        Global.dLog.write(this.getSessionName(), "MainEngine->execute", Messages.getString("MainEngineI.58"), 0, 0, "DEBUG");
        Global.dLog.write(this.getSessionName(), "MainEngine->execute", Messages.getString("MainEngineI.59"), 0, 0, "DEBUG");
        this.writeContextToDebuglog();
        this.startAction.setBeginDate(this.getBeginDate());
        this.threadManager = new ThreadManager(this, this.startAction);
        this.threadManager.start();
        ret = this.startAction.getActionState();
        if (ret == -1) {
            this.setSessionMsg(Messages.getString("MainEngineI.60"));
        } else if (ret == 3) {
            ret = 1;
            this.startAction.setActionState(1);
        }
        String actionErrorId = null;
        if (this.startAction != null && ((ActionProcess)this.startAction).getCauseErrorAction() != null) {
            actionErrorId = ((ActionProcess)this.startAction).getCauseErrorAction().getActionId();
        }
        this.resetAllActions();
        try {
            this.closeAllConnections(this.engineContext, ret);
        }
        catch (EngineExceptionI e) {
            ret = -1;
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", String.valueOf(Messages.getString("MainEngineI.61")) + e.getMessage(), 0, 1, "ERROR");
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_CODE, (Object)String.valueOf(ret));
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_MESS, (Object)(String.valueOf(Messages.getString("MainEngineI.62")) + e.getMessage()));
        }
        if (ret == 1) {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", Messages.getString("MainEngineI.63"), 0, 1, "DEBUG");
        } else {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", Messages.getString("MainEngineI.64"), 0, 1, "DEBUG");
        }
        this.startAction.getActionContext().getPublisher().publishVariable(VariableType.CORE_RET_CODE, (Object)String.valueOf(ret));
        try {
            this.startAction.CopyContextToULog();
            this.engineContext.scanLocalVariable(new VariableContainer.Scaner(){

                public void scan(Variable var) throws EngineExceptionI {
                    if (var != null && !var.isRealTimeReport() && !var.isCore()) {
                        if (var.getValue() == null) {
                            var.setValueOnly("");
                        }
                        Action action = null;
                        if (MainEngineI.this.startAction.isProcess()) {
                            action = MainEngineI.this.startAction;
                        }
                        MainEngineI.this.reportVariable(var, action);
                    }
                }
            });
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", String.valueOf(Messages.getString("MainEngineI.65")) + e.getMessage(), 0, 1, "ERROR");
            ret = -1;
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_CODE, (Object)String.valueOf(ret));
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_MESS, (Object)(String.valueOf(Messages.getString("MainEngineI.66")) + e.getMessage()));
        }
        try {
            this.uLog.finalizeAction(this.startAction, this.incrNumAction());
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", String.valueOf(Messages.getString("MainEngineI.67")) + e.getMessage(), 0, 1, "DEBUG");
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_CODE, (Object)String.valueOf(ret));
            this.startAction.getActionContext().getPublisher().publishImmediateVariable(VariableType.CORE_RET_MESS, (Object)(String.valueOf(Messages.getString("MainEngineI.68")) + e.getMessage()));
        }
        if (actionErrorId != null) {
            this.sde.setFailureCauseActionId(actionErrorId);
            if (actionErrorId != null) {
                this.engineContext.addVariable("CORE_SESSION_FAILURE_CAUSE_ACTION_ID", null, actionErrorId, "String", true, false);
            }
        }
        this.setEndDate(new Date());
        this.writeContextToDebuglog();
        this.setSessionStatus(ret);
        for (EngineHandler _handler : this.handlers) {
            _handler.beforeStoping(this);
        }
        this.handlers.clear();
        try {
            this.stopRdbmsSessionActivity();
            this.uLog.closeSession();
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(this.getSessionName(), "MainEngine->execute", String.valueOf(Messages.getString("MainEngineI.69")) + e.getMessage(), 0, 1, "DEBUG");
            e.printStackTrace();
        }
        if (this.getSessionID() == null) {
            this.setSessionID(this.getSessionID());
        }
        String tmp = "";
        int st = this.getSessionStatus();
        switch (st) {
            case 1: {
                tmp = String.valueOf(name) + Messages.getString("MainEngineI.70");
                break;
            }
            case -1: {
                tmp = String.valueOf(name) + Messages.getString("MainEngineI.71");
                break;
            }
            case -2: {
                tmp = String.valueOf(name) + Messages.getString("MainEngineI.72");
            }
        }
        Global.getConsoleLogger().info(tmp);
    }

    private void resetAllActions() {
        for (IAction iAction : this.lstActions.values()) {
            iAction.reset();
            if (!iAction.getActionStatic().isSrcBindedAction()) continue;
            ActionBindI abind = (ActionBindI)iAction.getActionContext().getSrcBind(iAction.getActionName());
            abind.reset();
        }
    }

    public Map<String, Variable> getLstRootSessionVariables() {
        Map tm2 = this.engineContext.getRootContainer().getAllCopiedLocalVariables(null);
        return tm2;
    }

    public Map<String, Variable> getLstSessionWarnings() {
        Map tm2 = this.engineContext.getRootContainer().findAllVariable(this.warningSelector);
        return tm2;
    }

    public Map<String, Variable> getLstSessionErrors() {
        Map tm2 = this.engineContext.getRootContainer().findAllVariable(this.errorSelector);
        return tm2;
    }

    public Map<String, Variable> getLstSessionVariablesByName(String callingAction, String variableName, String startingPath, boolean withError) {
        String startMotif = null;
        try {
            startMotif = this.engineContext.resolveVariableName(startingPath, callingAction);
            if (startMotif == null) {
                startMotif = callingAction;
            }
        }
        catch (Exception exception) {
            startMotif = callingAction;
        }
        final String _startMotif = startMotif;
        final String _variableName = variableName;
        final boolean _withError = withError;
        Map tm2 = this.engineContext.getRootContainer().findAllVariable(new VariableContainer.Selector(){

            public String selectReturnKey(Variable v) {
                Action act;
                if (v.getName().startsWith(_startMotif) && v.getName().endsWith(_variableName) && (act = MainEngineI.this.lstActions.get(v.getName().substring(0, v.getName().indexOf(_variableName) - 1))) != null) {
                    if (!_withError) {
                        return act.getActionName();
                    }
                    if (!act.getIsRedirectedKO() && !act.getActionStatic().getToleratedError()) {
                        return act.getActionName();
                    }
                }
                return null;
            }
        });
        return tm2;
    }

    public Variable aggregateVariable(String callingAction, String variableName, int function, String startingPath, String valueFilter) {
        Variable ret = null;
        String startMotif = null;
        StbScriptEngineManager mgr = null;
        ScriptEngine engine = null;
        if (variableName == null) {
            return null;
        }
        if (variableName.equals("")) {
            return null;
        }
        try {
            startMotif = this.engineContext.resolveVariableName(startingPath, callingAction);
            if (startMotif == null) {
                startMotif = callingAction;
            }
        }
        catch (Exception exception) {
            startMotif = callingAction;
        }
        try {
            VariableContainer container;
            Map map;
            VariableContainer.AggregateNumeric aggr;
            if (!valueFilter.equals("$NO_SCRIPT$")) {
                mgr = null;
                mgr = new StbScriptEngineManager(ClassLoaderServiceProvider.INSTANCE.getClassLoader("internal"));
                engine = mgr.getEngineByName("rhino");
            }
            if ((aggr = (VariableContainer.AggregateNumeric)(map = (container = startMotif == null || startMotif.isEmpty() ? this.engineContext.getRootContainer() : this.engineContext.getRootContainer().getActionVariableContainer(startMotif)).aggregateNumeric(null)).get(variableName)) != null) {
                switch (function) {
                    case 5: {
                        ret = new Variable(variableName, (Object)aggr.getCount());
                        break;
                    }
                    case 1: {
                        ret = new Variable(variableName, (Object)aggr.getSum());
                        break;
                    }
                    case 4: {
                        ret = new Variable(variableName, (Object)aggr.getAvg());
                        break;
                    }
                    case 2: {
                        ret = new Variable(variableName, (Object)aggr.getMin());
                        break;
                    }
                    case 3: {
                        ret = new Variable(variableName, (Object)aggr.getMax());
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public void writeContextToDebuglog() {
        StringBuffer lstVarPrint = new StringBuffer(0);
        lstVarPrint.append(String.valueOf(Messages.getString("MainEngineI.73")) + Global.dLog.getCarriageReturn());
        lstVarPrint.append("--- " + Global.dLog.getCarriageReturn());
        lstVarPrint.append(String.valueOf(Messages.getString("MainEngineI.74")) + Global.dLog.getCarriageReturn());
        lstVarPrint.append("--- --" + Global.dLog.getCarriageReturn());
        try {
            final String header = String.valueOf(this.getSessionID()) + "/" + this.getSessionName() + Messages.getString("MainEngineI.75");
            Global.dLog.getLogger().debug(String.valueOf(header) + Messages.getString("MainEngineI.76"));
            final StringBuffer sb = new StringBuffer();
            sb.append("0");
            this.engineContext.getRootContainer().scanAllVariable(new VariableContainer.Scaner(){

                public void scan(Variable v) throws EngineExceptionI {
                    Global.dLog.getLogger().debug(String.valueOf(header) + v.getName() + ": \t\t" + v.getValue());
                    int i = Integer.valueOf(sb.toString());
                    sb.replace(0, sb.length(), String.valueOf(++i));
                }
            });
            Global.dLog.getLogger().debug(String.valueOf(header) + Messages.getString("MainEngineI.77") + sb + ")");
        }
        catch (EngineExceptionI e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void run() {
        String sessionId = this.getSessionID();
        int iter = this.getSessionIter();
        try {
            this.execute();
            Global.dLog.write(this.getSessionName(), "MainEngine->run", Messages.getString("MainEngineI.78"), 0, 0, "INFO");
            this.setIsRunning(false);
            this.notifyAll();
        }
        finally {
            try {
                this.stopRdbmsSessionActivity();
            }
            finally {
                this.uLog.closeConnection();
            }
        }
        if (iter <= this.getRetryNumber() && this.status == -1) {
            try {
                if (this.getRetryInterval() > 0) {
                    Thread.sleep(this.getRetryInterval());
                }
                this.getEngineApi().restartSession(sessionId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setGuestHost(String guestHost) {
        this.sde.setGuestHost(guestHost);
    }

    public Map<String, Action> getLstActions() {
        return this.lstActions;
    }

    public void setLstActions(TreeMap<String, Action> lstActions) {
        this.lstActions = lstActions;
    }

    public Map<String, Action> getLstActionsId() {
        return this.lstActionsId;
    }

    public IAction getMyAction() {
        return this.startAction;
    }

    public int getSessionIter() {
        return this.sde.getIter();
    }

    public void setSessionIter(int sessionIter) {
        this.sde.setIter(sessionIter);
    }

    public String getSessionMsg() {
        return this.sde.getMessage();
    }

    public void setSessionMsg(String sessionMsg) {
        this.sde.setMessage(sessionMsg);
    }

    public String getSessionConf() {
        return this.sde.getConfiguration();
    }

    public void setSessionConf(String sessionConf) {
        this.sde.setConfiguration(sessionConf);
    }

    public Date getBeginDate() {
        return this.sde.getBeginDate();
    }

    public void setBeginDate(Date beginDate) {
        this.sde.setBeginDate(beginDate);
        String ts = Long.toString(beginDate.getTime());
        this.engineContext.addSessionVariable(VariableType.CORE_TIMESTAMP, ts);
        this.engineContext.addSessionVariable(VariableType.CORE_BEGIN_DATE, this.dateFormat.format(beginDate));
    }

    public Date getEndDate() {
        if (this.sde == null) {
            return null;
        }
        return this.sde.getEndDate();
    }

    public void setEndDate(Date endDate) {
        this.sde.setEndDate(endDate);
        if (this.getEndDate() != null && this.getBeginDate() != null) {
            long s = this.getEndDate().getTime() - this.getBeginDate().getTime();
            this.engineContext.addSessionVariable(VariableType.CORE_DURATION, s);
        }
    }

    public void setfailureCauseActionId(String actionId) {
        this.sde.setFailureCauseActionId(actionId);
    }

    public boolean isAllowedScriptErrors() {
        return this.sessionStatic.isAllowedScriptErrors();
    }

    public boolean isAllowedVariableErrors() {
        return this.sessionStatic.isAllowedVariableErrors();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isProgressivesConnections() {
        return this.progressivesConnections;
    }

    public String getGuestHost() {
        return this.sde.getGuestHost();
    }

    public void setSessionStatus(int sessionStatus) {
        this.sde.setStatus(sessionStatus);
        this.status = sessionStatus;
    }

    public void setSessionID(String sessionID) {
        this.sde.setId(sessionID);
        this.sessionId = sessionID;
    }

    public String getLaunchMode() {
        return this.sde.getLaunchMode();
    }

    public void setLaunchMode(String startMode) {
        this.sde.setLaunchMode(startMode);
    }

    public String getConfiguration() {
        return this.sessionStatic.getConfiguration();
    }

    public void setConfiguration(String configuration) {
        this.sde.setConfiguration(configuration);
    }

    public ISessionDataExchange getSessionDataExchange() {
        return this.sde;
    }

    public void setIsClosing(boolean b) {
        this.isClosing = b;
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public void setExecutionMode(String executionMode) {
        this.sde.setExecutionMode(executionMode);
    }

    public String getExecutionMode() {
        return this.sde.getExecutionMode();
    }

    public void addHandler(EngineHandler handler) {
        this.handlers.add(handler);
    }

    public void initVariables(Map<String, String> lstParameters) {
        Iterator<String> it = lstParameters.keySet().iterator();
        Variable var = null;
        String vNameResolved = null;
        while (it.hasNext()) {
            var = null;
            String vName = it.next();
            try {
                vNameResolved = this.engineContext.resolveVariableName(vName, "");
                var = this.engineContext.getVariable(vNameResolved);
            }
            catch (Exception exception) {}
            if (var != null) {
                var.setValue(lstParameters.get(vName));
                var.setOriginalSourceModified(true);
                continue;
            }
            this.engineContext.addVariable(vNameResolved, null, lstParameters.get(vName), "String", false, false);
        }
    }

    public void setParentSessionId(String parentSessionId) {
        this.sde.setParentSessionId(parentSessionId);
    }

    private IAction getParentAction(IAction child) {
        String tmp = child.getActionName();
        if (tmp.contains("/")) {
            String parentName = tmp.substring(0, tmp.lastIndexOf("/"));
            return this.lstActions.get(parentName);
        }
        return null;
    }

    public void error(String message, Throwable t) {
        if (t != null) {
            Global.getLogger().error(String.valueOf(this.getSessionName()) + " " + message, t);
        } else {
            Global.getLogger().error(String.valueOf(this.getSessionName()) + " " + message, t);
        }
    }

    public void info(String message, Throwable t) {
        if (t != null) {
            Global.getLogger().info(String.valueOf(this.getSessionName()) + " " + message, t);
        } else {
            Global.getLogger().info(String.valueOf(this.getSessionName()) + " " + message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (t != null) {
            Global.getLogger().debug(String.valueOf(this.getSessionName()) + " " + message, t);
        } else {
            Global.getLogger().debug(String.valueOf(this.getSessionName()) + " " + message, t);
        }
    }

    public int incrUserLogNum() {
        return this.userLogNum++;
    }

    public void stopWaiting() {
        if (this.toWait != null) {
            this.toWait._notify();
        }
    }

    public boolean isClear() {
        return this.isClear;
    }

    public SessionStatic getSessionStatic() {
        return this.sessionStatic;
    }

    public void setSessionStatic(SessionStatic sessionStatic) {
        this.sessionStatic = sessionStatic;
    }

    public void setParentSessionIter(int parentSessionIter) {
        this.sde.setParentSessionIter(parentSessionIter);
    }

    public void setVersion(String version) {
        this.sde.setVersion(version);
    }

    public String getVersion() {
        return this.sde.getVersion();
    }

    private void startRdbmsSessionActivity() {
        if (this.getLogLevel() != -1 && this.uLog.getSessionActivityDelta() > 0L) {
            this.rdbmsSessionActivity = new RdbmsSessionActivity();
            this.rdbmsSessionActivityThread = new Thread(this.rdbmsSessionActivity);
            this.rdbmsSessionActivityThread.setName(String.valueOf(this.engineContext.getThreadName()) + "|RdbmsSessionActivity");
            this.rdbmsSessionActivityThread.start();
            this.info(Messages.getString("MainEngineI.79"), null);
        }
    }

    private void stopRdbmsSessionActivity() {
        try {
            if (this.rdbmsSessionActivity != null && !this.rdbmsSessionActivity.stop && this.rdbmsSessionActivityThread != null && this.rdbmsSessionActivityThread.isAlive()) {
                this.rdbmsSessionActivity.stop();
                this.rdbmsSessionActivityThread.join();
            }
        }
        catch (Exception e) {
            this.error(Messages.getString("MainEngineI.82"), e);
        }
    }

    public boolean isForceStartSession() {
        return this.forceStartSession;
    }

    public void setForceStartSession(boolean b) {
        this.forceStartSession = b;
    }

    public void useDeliveryConfiguration(String conf) {
        this.useDeliveryConfiguration = conf;
    }

    public void setRetryNumber(Integer retryNumber) {
        this.retryNumber = retryNumber;
    }

    public int getRetryNumber() {
        if (this.retryNumber != null) {
            return this.retryNumber;
        }
        if (this.getSessionStatic().getRetryNumber() != null) {
            return this.getSessionStatic().getRetryNumber();
        }
        return 0;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryInterval() {
        if (this.retryInterval != null) {
            return this.retryInterval;
        }
        if (this.getSessionStatic().getRetryInterval() != null) {
            return this.getSessionStatic().getRetryInterval();
        }
        return 0;
    }

    public IEngineClient getEngineApi() throws EngineExceptionI {
        try {
            if (Global.commandLine) {
                return EngineFactory.getEngine((String)Global.HTTP_HOST, (int)Global.HTTP_PORT, null).getRemoteObject();
            }
            return RemoteSessionManagement.INSTANCE.getRemote(this.getRemoteSessionInfo());
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public void setRemoteSessionInfo(RemoteSessionInfo remoteSessionInfo) {
        this.remoteSessionInfo = remoteSessionInfo;
        this.sde.setLaunchUser(this.remoteSessionInfo.getUser());
    }

    public String getLaunchUser() {
        return this.remoteSessionInfo != null ? this.remoteSessionInfo.getUser() : null;
    }

    public RemoteSessionInfo getRemoteSessionInfo() {
        return this.remoteSessionInfo;
    }

    public void setAsynchroneLog(UserLogManagerI.SynchMode synchLogMode) {
        this.synchLogMode = synchLogMode;
    }

    public UserLogManagerI.SynchMode getSynchLogMode() {
        return this.synchLogMode;
    }

    public static interface EngineHandler {
        public void beforeStarting(MainEngineI var1);

        public void beforeStoping(MainEngineI var1);
    }

    class RdbmsSessionActivity
    implements Runnable {
        boolean stop = false;

        RdbmsSessionActivity() {
        }

        @Override
        public synchronized void run() {
            while (MainEngineI.this.getEndDate() == null && MainEngineI.this.isRunning && !Thread.interrupted() && !this.stop) {
                try {
                    this.wait(MainEngineI.this.uLog.getSessionActivityDelta());
                    if (Thread.interrupted() || this.stop || MainEngineI.this.uLog == null) continue;
                    MainEngineI.this.uLog.updateSessionActivity();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (EngineExceptionI e) {
                    e.printStackTrace();
                    MainEngineI.this.error(Messages.getString("MainEngineI.80"), e);
                }
            }
            MainEngineI.this.info(Messages.getString("MainEngineI.81"), null);
        }

        public synchronized void stop() {
            this.stop = true;
            this.notify();
        }
    }

    class ToWait
    implements Runnable {
        WaitMainEngine wait2;
        boolean wait = false;
        private boolean restart;

        public ToWait(WaitMainEngine wait2, boolean wait, boolean restart) {
            this.wait2 = wait2;
            this.wait = wait;
            this.restart = restart;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            try {
                while (true) {
                    if (this.wait2.isRunning(MainEngineI.this)) {
                        MainEngineI.this.runMainEngine2(this.restart, this.wait);
                        return;
                    }
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (EngineExceptionI e) {
                e.printStackTrace();
            }
        }

        public synchronized void _notify() {
            this.notify();
        }

        public synchronized void _wait() throws InterruptedException {
            this.wait();
        }

        public synchronized void _wait(int timeout) throws InterruptedException {
            this.wait(timeout);
        }
    }
}

