/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.action;

import com.indy.engine.Global;
import com.indy.engine.core.IActionBind;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.Messages;
import com.indy.engine.objects.data.baseobjects.Int;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ActionBindI
implements IActionBind {
    IAction sourceAction;
    Object bindedObject;
    public HashMap lstBindedActions = new HashMap();
    public HashMap lstConsummations = new HashMap();
    public String bindName;
    public boolean bindFull = false;
    public boolean bindActif = false;
    public boolean bindWaiting = false;
    public boolean bindStopping = false;
    public boolean bindKilling = false;
    public int actualBindSize = 0;
    public String bindType = "DirectBind";
    public Map<String, ActionGraphLinkI> lstConditions = Collections.synchronizedMap(new TreeMap());

    public IAction getSourceAction() {
        return this.sourceAction;
    }

    public void reset() {
        this.bindFull = false;
        this.bindActif = false;
        this.bindWaiting = false;
        this.actualBindSize = 0;
        this.bindStopping = false;
        this.bindKilling = false;
        this.resetConsummations();
    }

    public ActionBindI(IAction srcAction, String bType) {
        this.sourceAction = srcAction;
        this.bindName = srcAction.getActionName();
        this.bindType = bType;
    }

    public void clear() throws Exception {
        if (this.lstBindedActions != null) {
            this.lstBindedActions.clear();
        }
        this.lstBindedActions = null;
        if (this.lstConsummations != null) {
            this.lstConsummations.clear();
        }
        this.lstConsummations = null;
        if (this.lstConditions != null) {
            this.lstConditions.clear();
        }
        this.lstConditions = null;
        this.sourceAction = null;
        this.bindedObject = null;
        this.bindName = null;
        this.bindType = null;
    }

    public void addBindedObject(Object bObj) {
        this.bindedObject = bObj;
    }

    public HashMap getLstBindedActions() {
        return this.lstBindedActions;
    }

    public void addBindedAction(IAction act) {
        this.lstBindedActions.put(act.getActionName(), act);
        this.lstConsummations.put(act.getActionName(), new Int(0));
    }

    public synchronized void stopBind() {
        this.bindActif = true;
        this.bindStopping = true;
        this.notifyAll();
    }

    public synchronized boolean isBindActif() throws EngineExceptionI {
        boolean ret = false;
        while (!ret) {
            if (!this.bindActif) {
                try {
                    this.bindWaiting = true;
                    this.wait();
                    this.bindWaiting = false;
                    continue;
                }
                catch (InterruptedException e) {
                    throw new EngineExceptionI(Messages.getString("ActionBindI.0"), (Throwable)e);
                }
            }
            ret = true;
        }
        return ret;
    }

    synchronized boolean isConsommable(String actionName, int actualReadSize) throws EngineExceptionI, InterruptedException {
        boolean ret = false;
        while (!ret) {
            if (this.bindActif && this.actualBindSize > actualReadSize) {
                ret = true;
                continue;
            }
            if (!this.bindFull || this.actualBindSize != actualReadSize) {
                try {
                    Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.8"), String.valueOf(this.sourceAction.getActionName()) + " : " + Messages.getString("ActionBindI.1") + actionName, 3, this.sourceAction.getActionStatic().getActionLevel(), "INFO");
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.7"), String.valueOf(this.sourceAction.getActionName()) + " : " + Messages.getString("ActionBindI.2"), 3, this.sourceAction.getActionStatic().getActionLevel(), "ERROR");
                    throw new InterruptedException();
                }
            }
            return false;
        }
        return ret;
    }

    public synchronized void modifyConsummation(String aName, int mId) {
        Int cons = (Int)this.lstConsummations.get(aName);
        cons.value = mId;
        this.notifyAll();
    }

    public synchronized void setBindActif(boolean b) {
        this.bindActif = b;
    }

    public Object getBindedObject() {
        return this.bindedObject;
    }

    public synchronized void notifyStop() {
        this.notifyAll();
    }

    public synchronized void notifyFetch() {
        this.notifyAll();
    }

    public synchronized int verifConsommation() throws EngineExceptionI, InterruptedException {
        int ret = 0;
        while (!this.isAllConsummed() && !this.bindKilling) {
            try {
                Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.6"), String.valueOf(this.sourceAction.getActionName()) + " : " + Messages.getString("ActionBindI.3"), 3, this.sourceAction.getActionStatic().getActionLevel(), "INFO");
                this.setBindActif(true);
                this.notifyFetch();
                Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.5"), String.valueOf(this.sourceAction.getActionName()) + " : " + Messages.getString("ActionBindI.4"), 3, this.sourceAction.getActionStatic().getActionLevel(), "INFO");
                this.wait();
            }
            catch (InterruptedException e) {
                Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.9"), String.valueOf(this.sourceAction.getActionName()) + Messages.getString("ActionBindI.10") + e.getMessage(), 3, this.sourceAction.getActionStatic().getActionLevel(), "INFO");
                throw new InterruptedException();
            }
            catch (Exception e) {
                Global.dLog.write(this.sourceAction.getSessionName(), Messages.getString("ActionBindI.11"), String.valueOf(this.sourceAction.getActionName()) + Messages.getString("ActionBindI.12") + e.getMessage(), 3, this.sourceAction.getActionStatic().getActionLevel(), "INFO");
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.resetConsummations();
        return ret;
    }

    void resetConsummations() {
        Iterator it2 = this.lstConsummations.keySet().iterator();
        String aName = null;
        Int i = null;
        while (it2.hasNext()) {
            aName = (String)it2.next();
            i = (Int)this.lstConsummations.get(aName);
            IAction cfr_ignored_0 = (IAction)this.lstBindedActions.get(aName);
            i.setValue(0);
        }
    }

    boolean isAllConsummed() {
        Int i;
        boolean allConsummed = false;
        int nbConsummed = 0;
        int nbConsummers = 0;
        String aName2 = null;
        IAction act = null;
        nbConsummers = this.lstConsummations.size();
        for (String aName2 : this.lstConsummations.keySet()) {
            i = (Int)this.lstConsummations.get(aName2);
            act = (IAction)this.lstBindedActions.get(aName2);
            if (i.getValue() != -1 && act.getNbExecution() <= this.sourceAction.getNbExecution() && act.getNbExecution() != act.getActionStatic().getNbCycles()) continue;
            ++nbConsummed;
        }
        Iterator it2 = null;
        act = null;
        i = null;
        aName2 = null;
        if (nbConsummed == nbConsummers) {
            allConsummed = true;
        }
        return allConsummed;
    }

    public void destroyBind() {
        this.lstBindedActions.clear();
        this.lstConsummations.clear();
        this.sourceAction = null;
    }

    public String getBindType() {
        return this.bindType;
    }

    public void setBindKilling(boolean b) {
        this.bindKilling = b;
    }
}

