/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.impl;

import com.indy.engine.Global;
import com.indy.engine.core.repository.DeliveryRepositoryPluginUtils;
import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.repository.impl.Messages;
import com.indy.engine.main.repository.stores.FileRepositoryStore;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.engine.wsdl.WsdlAPI;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;

public final class FileRepository
implements IDeliveryRepositoryPlugin {
    private FileRepositoryStore fileRepositoryStore;
    private final File repositoryFolder;
    private final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> deliveriesInfo = Collections.synchronizedMap(new HashMap());
    private WsdlAPI wsdlApi = null;
    private boolean isWebservice = false;
    private static final Pattern pattern = Pattern.compile("(.*)(\\." + Global.DELIVERY_EXTENSION + ")");
    private static final String extension = "." + Global.DELIVERY_EXTENSION;
    private static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File directory, String name) {
            Matcher matcher = pattern.matcher(name);
            boolean match = matcher.matches();
            return match;
        }
    };

    public FileRepository(IPluginFactory.IPluginConfiguration conf, IPluginFactory.IRelativePathResolver resolver) {
        this.fileRepositoryStore = new FileRepositoryStore(conf, resolver);
        if (this.fileRepositoryStore != null) {
            this.repositoryFolder = this.fileRepositoryStore.getAbsoluteFolder();
            if (this.repositoryFolder != null && !this.repositoryFolder.exists()) {
                this.repositoryFolder.mkdirs();
            }
        } else {
            this.repositoryFolder = null;
        }
        this.isWebservice = Boolean.valueOf(conf.getProperty("webservice"));
    }

    public final File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        if (deliveryInfo != null && deliveryInfo.getFile() != null && deliveryInfo.getFile().exists()) {
            return deliveryInfo.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> map = this.deliveriesInfo;
        synchronized (map) {
            if (refresh && this.repositoryFolder != null && this.repositoryFolder.exists()) {
                File[] filesArray = this.repositoryFolder.listFiles(filenameFilter);
                List<File> files = Arrays.asList(filesArray);
                HashSet<String> unexist = new HashSet<String>(this.deliveriesInfo.keySet());
                for (File file : files) {
                    unexist.remove(file.getName());
                    this.synch(file);
                }
                for (String key : unexist) {
                    this.deliveriesInfo.remove(key);
                }
            }
            return new HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo>(this.deliveriesInfo);
        }
    }

    IDeliveryRepositoryPlugin.DeliveryInfo synch(String deliveryName) throws Exception {
        return this.synch(this.getFile(deliveryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDeliveryRepositoryPlugin.DeliveryInfo synch(File file) throws Exception {
        Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> map = this.deliveriesInfo;
        synchronized (map) {
            IDeliveryRepositoryPlugin.DeliveryInfo info = this.deliveriesInfo.get(file.getName());
            if (file.exists()) {
                if ((info == null || info.getLastModified() != file.lastModified()) && (info = this.getDeliveryInfo(file)) != null) {
                    this.deliveriesInfo.put(file.getName(), info);
                }
            } else {
                if (info != null) {
                    this.deliveriesInfo.remove(file.getName());
                }
                info = null;
            }
            return info;
        }
    }

    public final IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        if (deliveryName == null || inputStream == null) {
            throw new Exception(Messages.getString("FileRepository.0"));
        }
        File file = this.getFile(deliveryName);
        DeliveryRepositoryPluginUtils.writeDelivery((File)file, (InputStream)inputStream);
        file = this.getFile(deliveryName);
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = this.synch(file);
        if (deliveryInfo != null) {
            this.deliveriesInfo.put(deliveryInfo.getName(), deliveryInfo);
        }
        return deliveryInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeDelivery(String deliveryName) throws Exception {
        if (deliveryName == null) return;
        File file = this.getFile(deliveryName);
        if (!file.exists()) throw new IOException(String.valueOf(Messages.getString("FileRepository.2")) + deliveryName + Messages.getString("FileRepository.3"));
        if (!file.delete()) throw new IOException(String.valueOf(Messages.getString("FileRepository.1")) + deliveryName);
        this.deliveriesInfo.remove(deliveryName);
    }

    private IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(File file) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = new IDeliveryRepositoryPlugin.DeliveryInfo();
        if (this.wsdlApi == null && this.isWebservice && Global.engineServer != null) {
            this.wsdlApi = Global.engineServer.getWsdlAPI();
        }
        try {
            Delivery delivery = Utils.parseDelivery(file, this.wsdlApi, false);
            if (delivery != null) {
                String id = delivery.getId();
                String name = delivery.getName();
                String version = delivery.getVersion();
                deliveryInfo.setId(id);
                deliveryInfo.setName(name);
                deliveryInfo.setVersion(version);
                deliveryInfo.setFile(file);
                long lastModified = file.lastModified();
                deliveryInfo.setLastModified(lastModified);
            }
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
        return deliveryInfo;
    }

    private static String extendDeliveryName(String deliveryName) {
        String extentedName = deliveryName.endsWith(extension) ? deliveryName : String.valueOf(deliveryName) + extension;
        return extentedName;
    }

    private File getFile(String deliveryName) {
        if (this.repositoryFolder != null && !this.repositoryFolder.exists()) {
            this.repositoryFolder.mkdirs();
        }
        String extendedName = FileRepository.extendDeliveryName(deliveryName);
        File file = new File(this.repositoryFolder, extendedName);
        return file;
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.fileRepositoryStore;
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        return this.synch(deliveryName);
    }

    public void setCacheFolder(File cacheFolder) {
    }
}

