/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.internal;

import com.indy.engine.Global;
import com.indy.engine.common.delivery.DeliveryBuilder;
import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.main.repository.internal.MemoryDelivery;
import com.indy.engine.main.repository.internal.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public final class DeliveryRepository
implements IDeliveryRepository {
    private final IDeliveryRepositoryPlugin deliveryRepositoryPlugin;
    private final IDeliveryRepositoryInfo deliveryRepositoryStore;
    private final Map<String, MemoryCache> memoryCaches = Collections.synchronizedMap(new HashMap());
    private static final String noConfigurationKey = "_|NO_CONF|_";
    private static final String cachedDeliveryPrefix = "cachefile.";
    private static final String cachedDeliverySuffix = ".deliv";
    private static final String deliveryNameMarkup = "deliveryName";
    private File cacheFolder;
    private boolean enableMemoryCache;

    public DeliveryRepository(String cacheFolderPath, boolean enableMemoryCache, IDeliveryRepositoryPlugin deliveryRepositoryPlugin) {
        this.deliveryRepositoryPlugin = deliveryRepositoryPlugin;
        this.deliveryRepositoryStore = deliveryRepositoryPlugin.getInfos();
        this.enableMemoryCache = enableMemoryCache;
        if (this.deliveryRepositoryStore != null) {
            this.cacheFolder = cacheFolderPath != null ? new File(cacheFolderPath) : new File(String.valueOf(Global.REPOSITORY_CACHE_FOLDER) + File.separator + this.getName());
            this.cacheFolder.mkdirs();
            this.deliveryRepositoryPlugin.setCacheFolder(this.cacheFolder);
        }
    }

    public final String toString() {
        return "name=" + this.getName() + " cacheFolder=" + this.getCacheFolder() + " webservice=" + this.isWebservice() + " default=" + this.isDefault() + " pollingInterval=" + this.getSynchronizationPollingInterval() + " scanMode=" + this.getScanMode();
    }

    @Override
    public final IDeliveryRepositoryInfo getInfo() {
        return this.deliveryRepositoryStore;
    }

    @Override
    public final File getCacheFolder() {
        return this.cacheFolder;
    }

    @Override
    public final String getName() {
        String name = this.deliveryRepositoryStore.getName();
        return name;
    }

    @Override
    public final boolean isWebservice() {
        boolean webService = this.deliveryRepositoryStore.isWebservice();
        return webService;
    }

    @Override
    public final boolean isDefault() {
        boolean default_ = this.deliveryRepositoryStore.isDefault();
        return default_;
    }

    @Override
    public final long getSynchronizationPollingInterval() {
        int pollingInterval = this.deliveryRepositoryStore.getSynchPollingInterval();
        return pollingInterval;
    }

    @Override
    public final String getScanMode() {
        String scanMode = this.deliveryRepositoryStore.getStringScanMode();
        return scanMode;
    }

    public final IDeliveryRepositoryPlugin.DeliveryDelta getDifferences() throws Exception {
        IDeliveryRepositoryPlugin.DeliveryDelta deliveryDelta = new IDeliveryRepositoryPlugin.DeliveryDelta();
        Map previousDeliveries = this.deliveryRepositoryPlugin.getDeliveriesInfo(false);
        Map actualDeliveries = this.deliveryRepositoryPlugin.getDeliveriesInfo(true);
        HashSet removedNames = new HashSet(previousDeliveries.keySet());
        HashSet actualNames = new HashSet(actualDeliveries.keySet());
        removedNames.removeAll(actualNames);
        deliveryDelta.getRemoved().addAll(removedNames);
        if (previousDeliveries.isEmpty()) {
            deliveryDelta.getCreated().addAll(actualNames);
        } else {
            for (Map.Entry entry : actualDeliveries.entrySet()) {
                boolean versionDiff;
                IDeliveryRepositoryPlugin.DeliveryInfo actualDelivery = (IDeliveryRepositoryPlugin.DeliveryInfo)entry.getValue();
                String name = (String)entry.getKey();
                IDeliveryRepositoryPlugin.DeliveryInfo previousDelivery = previousDeliveries.getOrDefault(name, null);
                if (previousDelivery == null) {
                    deliveryDelta.getCreated().add(name);
                    continue;
                }
                String previousId = previousDelivery.getId();
                String previousVersion = previousDelivery.getVersion();
                String actualId = actualDelivery.getId();
                String actualVersion = actualDelivery.getVersion();
                boolean idDiff = previousId == null && actualId != null || previousId != null && !previousId.equals(actualId);
                boolean bl = versionDiff = previousVersion == null && actualVersion != null || previousVersion != null && !previousVersion.equals(actualVersion);
                if (!idDiff && !versionDiff) continue;
                deliveryDelta.getUpdated().add(name);
            }
        }
        return deliveryDelta;
    }

    @Override
    public final List<String> getLstDeliveries(Long maxLastModifiedDate) throws Exception {
        ArrayList<String> deliveries = new ArrayList<String>();
        Collection deliveriesInfo = this.deliveryRepositoryPlugin.getDeliveriesInfo(true).values();
        for (IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo : deliveriesInfo) {
            long lastModified = deliveryInfo.getLastModified();
            if (maxLastModifiedDate != null && lastModified != 0L && lastModified <= maxLastModifiedDate) continue;
            String name = deliveryInfo.getName();
            deliveries.add(name);
        }
        return deliveries;
    }

    @Override
    public final boolean exists(String deliveryName) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo info = this.deliveryRepositoryPlugin.getDeliveryInfo(deliveryName);
        return info != null;
    }

    @Override
    public final IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = this.deliveryRepositoryPlugin.putDelivery(inputStream, deliveryName);
        return deliveryInfo;
    }

    @Override
    public final void removeDelivery(String deliveryName) throws Exception {
        this.deliveryRepositoryPlugin.removeDelivery(deliveryName);
    }

    @Override
    public final List<Delivery> getDeliveries(List<String> ids, Long maxLastModifiedDate) throws Exception {
        ArrayList<Delivery> deliveries = new ArrayList<Delivery>();
        Collection deliveriesInfo = this.deliveryRepositoryPlugin.getDeliveriesInfo(true).values();
        for (IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo : deliveriesInfo) {
            long lastModified = deliveryInfo.getLastModified();
            String id = deliveryInfo.getId();
            if (maxLastModifiedDate != null && lastModified != 0L && lastModified <= maxLastModifiedDate || ids != null && !ids.contains(id)) continue;
            Delivery delivery = this.getDelivery(deliveryInfo);
            deliveries.add(delivery);
        }
        return deliveries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IMemoryDelivery getMemoryDelivery(String name, String configuration) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo info = this.deliveryRepositoryPlugin.getDeliveryInfo(name);
        IMemoryDelivery memoryDelivery = null;
        if (this.enableMemoryCache) {
            MemoryCache memoryCache = this.getMemoryCache(info);
            memoryDelivery = configuration == null ? (IMemoryDelivery)memoryCache.memoryDeliveries.get(noConfigurationKey) : (IMemoryDelivery)memoryCache.memoryDeliveries.get(configuration);
            if (memoryDelivery == null) {
                MemoryCache memoryCache2 = memoryCache;
                synchronized (memoryCache2) {
                    memoryDelivery = (IMemoryDelivery)memoryCache.memoryDeliveries.get(configuration);
                    if (memoryDelivery == null) {
                        memoryDelivery = this.getMemoryDeliveryfromName(info, configuration);
                        if (configuration == null) {
                            memoryCache.memoryDeliveries.put(noConfigurationKey, memoryDelivery);
                        } else {
                            memoryCache.memoryDeliveries.put(configuration, memoryDelivery);
                        }
                    }
                }
            }
        } else {
            memoryDelivery = this.getMemoryDeliveryfromName(info, configuration);
        }
        return memoryDelivery;
    }

    @Override
    public final File getDeliveryFile(String deliveryName) throws Exception {
        return this.deliveryRepositoryPlugin.getDeliveryContent(this.deliveryRepositoryPlugin.getDeliveryInfo(deliveryName));
    }

    @Override
    public final Delivery getDelivery(String deliveryName, boolean force) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = this.deliveryRepositoryPlugin.getDeliveryInfo(deliveryName);
        return this.getDelivery(deliveryInfo);
    }

    private Delivery getDelivery(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        FileInputStream inputStream = new FileInputStream(this.deliveryRepositoryPlugin.getDeliveryContent(deliveryInfo));
        Delivery delivery = new Delivery();
        delivery.setName(deliveryInfo.getName());
        delivery = Utils.parseDelivery(inputStream, Global.engineServer.getWsdlAPI(), null, null, delivery);
        return delivery;
    }

    @Override
    public final InputStream getInputStream(String deliveryName) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = this.deliveryRepositoryPlugin.getDeliveryInfo(deliveryName);
        File deliveryContent = this.deliveryRepositoryPlugin.getDeliveryContent(deliveryInfo);
        return new FileInputStream(deliveryContent);
    }

    private IMemoryDelivery getMemoryDeliveryfromName(IDeliveryRepositoryPlugin.DeliveryInfo info, String configuration) throws Exception {
        MemoryDelivery memoryDelivery = null;
        try (InputStream inputStream = null;){
            inputStream = new FileInputStream(this.deliveryRepositoryPlugin.getDeliveryContent(info));
            memoryDelivery = new MemoryDelivery(inputStream, info.getName(), configuration);
        }
        return memoryDelivery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryCache getMemoryCache(IDeliveryRepositoryPlugin.DeliveryInfo info) throws Exception {
        Object object;
        MemoryCache cache = this.memoryCaches.get(info.getName());
        if (cache == null) {
            object = this.memoryCaches;
            synchronized (object) {
                cache = this.memoryCaches.get(info.getName());
                if (cache == null) {
                    cache = new MemoryCache();
                    this.memoryCaches.put(info.getName(), cache);
                }
            }
        }
        object = cache;
        synchronized (object) {
            File file = null;
            try {
                file = info.getFile();
            }
            catch (Exception e) {
                this.memoryCaches.remove(info.getName());
                throw e;
            }
            if (cache.file == null || cache.totalSpace != file.getTotalSpace() || cache.lastModified != file.lastModified()) {
                cache.file = file;
                cache.totalSpace = cache.file.getTotalSpace();
                cache.lastModified = cache.file.lastModified();
                cache.memoryDeliveries.clear();
            }
        }
        return cache;
    }

    public static final Document parseDelivery(InputStream io, String deliveryName, String useDeliveryConfiguration) throws EngineExceptionI {
        DeliveryBuilder db = null;
        try {
            if (useDeliveryConfiguration != null) {
                db = new DeliveryBuilder(useDeliveryConfiguration);
                io = db.pipedBuild(io);
            }
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            String externalEntitiesFeature = "http://xml.org/sax/features/external-general-entities";
            docBuilderFactory.setFeature(externalEntitiesFeature, false);
            externalEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities";
            docBuilderFactory.setFeature(externalEntitiesFeature, false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            doc = docBuilder.parse(io);
            doc.setUserData(deliveryNameMarkup, deliveryName, null);
            Document document = doc;
            return document;
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("DeliveryRepository.0"), (Throwable)e);
        }
        finally {
            if (db != null && db.getException() != null) {
                throw new EngineExceptionI(Messages.getString("DeliveryRepository.1"), db.getException());
            }
        }
    }

    @Override
    public IDeliveryRepositoryPlugin getPlugin() {
        return this.deliveryRepositoryPlugin;
    }

    private class MemoryCache {
        private File file;
        private Map<String, IMemoryDelivery> memoryDeliveries = new HashMap<String, IMemoryDelivery>();
        private long totalSpace;
        private long lastModified;

        private MemoryCache() {
        }
    }
}

