/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.internal;

import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.IDeliveryListener;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.IDeliverySyncrhonizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollingSynchronizer
implements IDeliverySyncrhonizer {
    IDeliveryRepository repo;
    IDeliveryRepositoryPlugin.IDeliveryDelta compare;
    private final Logger logger = LogManager.getLogger(this.getClass());
    List<IDeliveryListener> listeners = Collections.synchronizedList(new ArrayList());
    Thread synchTread;

    public PollingSynchronizer(IDeliveryRepository repo, IDeliveryRepositoryPlugin.IDeliveryDelta compare) {
        this.repo = repo;
        this.compare = compare;
    }

    @Override
    public void addListener(IDeliveryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IDeliveryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void startSyncrhonisation() throws Exception {
        this.synch();
        this.synchTread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        Thread.sleep(PollingSynchronizer.this.repo.getSynchronizationPollingInterval());
                        try {
                            PollingSynchronizer.this.synch();
                        }
                        catch (Exception e) {
                            PollingSynchronizer.this.logger.warn("Unexpected", (Throwable)e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!PollingSynchronizer.this.logger.isTraceEnabled()) return;
                    PollingSynchronizer.this.logger.trace("Interrupted !", (Throwable)e);
                }
            }
        });
        this.synchTread.setDaemon(true);
        this.synchTread.start();
    }

    public synchronized void synch() throws Exception {
        IDeliveryRepositoryPlugin.IDeliveryDelta dd = this.repo.getDifferences();
        if (dd.getCreatedOrUpdated().size() > 0 || dd.getRemoved().size() > 0) {
            this.fireDeliveryChanged(dd);
        }
    }

    @Override
    public void stopSyncrhonisation() {
        this.synchTread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireDeliveryChanged(IDeliveryRepositoryPlugin.IDeliveryDelta dd) throws Exception {
        List<IDeliveryListener> list = this.listeners;
        synchronized (list) {
            for (IDeliveryListener listener : this.listeners) {
                listener.handleDeliveryChanged(dd);
            }
        }
    }
}

