/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.stores;

import com.indy.engine.core.repository.CommonDeliveryRepositoryStore;
import com.indy.engine.main.repository.stores.Messages;
import com.indy.engine.shared.plugin.IPluginFactory;

public class HttpRepositoryStore
extends CommonDeliveryRepositoryStore {
    long unreachableTolerancePeriod = 0L;
    String url = null;
    String user = null;
    String password = null;
    String uncryptedPassword = null;
    public String remoteName = null;
    String environment = null;
    String defaultDeliveryPath = null;

    public HttpRepositoryStore(IPluginFactory.IPluginConfiguration cfg, IPluginFactory.IRelativePathResolver resolver) {
        super(cfg);
        try {
            this.unreachableTolerancePeriod = Long.valueOf(cfg.getProperty("unreachableTolerancePeriod"));
        }
        catch (Exception exception) {}
        this.url = cfg.getProperty("url");
        if (this.url == null || this.url.trim().isEmpty()) {
            throw new RuntimeException(String.format(Messages.getString("HttpRepositoryStore.0"), cfg.getProperty("name")));
        }
        if (cfg.getProperty("defaultDeliveryPath") != null && !cfg.getProperty("defaultDeliveryPath").isEmpty()) {
            this.defaultDeliveryPath = cfg.getProperty("defaultDeliveryPath");
            if (resolver != null) {
                this.defaultDeliveryPath = resolver.resolve(this.defaultDeliveryPath);
            }
        }
        this.user = cfg.getProperty("user");
        this.password = cfg.getProperty("password");
        this.uncryptedPassword = cfg.getProperty("uncryptedPassword");
        this.remoteName = cfg.getProperty("remoteName");
        this.environment = cfg.getProperty("environment");
    }

    public final String getRemoteName() {
        if (this.remoteName != null) {
            return this.remoteName;
        }
        return super.getName();
    }

    public final long getUnreachableTolerancePeriod() {
        return this.unreachableTolerancePeriod;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getUncryptedPassword() {
        return this.uncryptedPassword;
    }

    public final String getEnvironment() {
        return this.environment;
    }

    public final String getType() {
        return "Http";
    }

    public String getDefaultDeliveryPath() {
        return this.defaultDeliveryPath;
    }
}

