/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.manager;

import com.indy.a.PasswordManagerI;
import com.indy.engine.Global;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.IScriptContext;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.externalvalueresolver.ExternalValueResolverManager;
import com.indy.engine.core.main.action.variable.VariableContainer;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.core.main.connections.impl.DefaultRuntimeDataSource;
import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.core.manager.INamedObjectManager;
import com.indy.engine.core.manager.IVariableGetter;
import com.indy.engine.core.manager.IVariablePublisher;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.EngineContextI;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.ActionBindI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.MinAction;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.connections.JdbcRuntimeConnectionCreateFunction;
import com.indy.engine.main.listener.ListenerService;
import com.indy.engine.main.scripting.ScriptContextI;
import com.indy.engine.main.scripting.ScriptManagerI;
import com.indy.engine.manager.ActionCode;
import com.indy.engine.manager.ActionProcess;
import com.indy.engine.manager.Logger;
import com.indy.engine.manager.Messages;
import com.indy.engine.manager.ThreadManager;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.service.ServiceState;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Action
extends MinAction {
    Map<String, Variable> dynamicVars = new HashMap<String, Variable>();
    private boolean beginAction = false;
    IVariablePublisher variablePublisher = new VariablePublisher();
    private String actionRuntimeName;
    private String runtimeShortName;
    VariableContainer.Evaluator evaluator = new VariableContainer.Evaluator(){

        public String evaluate(String expression) throws EngineExceptionI {
            String varExpr = Global.transformVariableExpression(Action.this.getActionName(), Action.this.getMainContext(), expression);
            try {
                return Action.this.getActionContext().executeSubstitutionScript(varExpr, "e");
            }
            catch (EngineExceptionI e) {
                if (e.exceptionType != 7 || !Action.this.getActionContext().getAllowsScriptingErrors()) {
                    throw new EngineExceptionI((Throwable)e);
                }
                return varExpr;
            }
        }
    };
    ThreadManager threadManager;
    private VariableContainer variableContainer;
    private IVariableGetter variableGetter = new VariableGetter();
    Variable stateVar;
    private String stackTrace;
    static final String strDateFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    Variable beginDate;
    Variable endDate;
    protected Map<String, IActionBind> lstSrcBinds = new HashMap<String, IActionBind>();
    protected Map<String, IActionBind> lstTrgBinds = new HashMap<String, IActionBind>();
    private int nbExecution = 0;
    int iteration = 0;
    public Hashtable<String, ActionGraphLinkI> lstChildLinks;
    public Hashtable<String, ActionGraphLinkI> lstFatherLinks;
    private IActionContext actionContext = new ActionContextI();
    boolean connectedBindedAndRunning = false;

    private Variable addVariableWithULog(String pName, Object pValue, String pType, boolean pRealTimeReport, boolean isCumulative, VariablePublicationMode static1) {
        return this.addLocalVariable(pName, pValue, pType, pRealTimeReport, isCumulative, true, static1);
    }

    @Override
    public boolean getBeginAction() {
        return this.beginAction || this.store.isBeginAction();
    }

    @Override
    public void setBeginAction(boolean beg) throws EngineExceptionI {
        this.beginAction = beg;
        if (this.beginAction) {
            this.getActionContext().getPublisher().publishVariable(VariableType.CORE_BEGIN_ACTION, (Object)Boolean.toString(this.beginAction));
        }
    }

    public Variable addLocalVariable(String pName, Object pValue, String pType, boolean pRealTimeReport, boolean isCumulative, boolean replace, VariablePublicationMode mode) {
        if (pName != null && !pName.isEmpty()) {
            Variable var = this.variableContainer.addLocalVariable(pName, pValue, pType, pRealTimeReport, isCumulative, replace);
            var.setMode(mode);
            if (pRealTimeReport && var != null) {
                this.getMainEngine().reportVariable(var, this);
            }
            return var;
        }
        return null;
    }

    @Override
    public void CopyContextToULog() throws EngineExceptionI {
        this.variableContainer.scanLocalVariable(new VariableContainer.Scaner(){

            public void scan(Variable var) throws EngineExceptionI {
                if (var != null && !var.isRealTimeReport()) {
                    if (var.getValue() == null) {
                        var.setValueOnly("");
                    }
                    Action.this.getMainEngine().reportVariable(var, Action.this);
                }
            }
        });
    }

    public IVariablePublisher getVariablePublisher() {
        return this.variablePublisher;
    }

    @Override
    public void setActionRuntimeName(String actionRuntimeName) {
        this.actionRuntimeName = actionRuntimeName;
    }

    @Override
    public String getActionRuntimeName() {
        return this.actionRuntimeName != null ? this.actionRuntimeName : this.getActionName();
    }

    @Override
    public void evaluateActionVariables() throws EngineExceptionI {
        Variable _var;
        this.variableContainer.evaluateAllVariable(this.evaluator);
        if (this.getActionStatic().getActionDynamicName() != null && !this.getActionStatic().getActionDynamicName().isEmpty() && (_var = this.variableContainer.getLocalVariable(VariableType.CORE_DYNAMIC_NAME.getName())) != null) {
            this.actionRuntimeName = _var.getValue();
        }
        if (this.actionRuntimeName == null) {
            this.actionRuntimeName = this.evaluator.evaluate(this.getActionName());
        }
        this.runtimeShortName = this.actionRuntimeName.contains("/") ? this.actionRuntimeName.substring(this.actionRuntimeName.lastIndexOf("/") + 1) : this.actionRuntimeName;
    }

    @Override
    public String getRuntimeShortName() {
        return this.runtimeShortName;
    }

    @Override
    public String evaluateExpression(String expression) throws EngineExceptionI {
        return this.evaluator.evaluate(expression);
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void setThreadManager(ThreadManager threadManager) {
        this.threadManager = threadManager;
    }

    public IVariableGetter getVariableGetter() {
        return this.variableGetter;
    }

    public Action(ActionStatic store, MainEngineI mainEngine) throws EngineExceptionI {
        super(store, mainEngine);
        this.variableContainer = mainEngine.getEngineContext().getVariableContainer(this.getActionName());
        this.getVariablePublisher().publishVariable(VariableType.CORE_NB_EXECUTIONS, (Object)"0");
        this.getVariablePublisher().publishVolatileVariable("CORE_PATH", "String", (Object)store.getActionName());
        this.getVariablePublisher().publishVolatileVariable("CORE_NAME", "String", (Object)store.getShortName());
        this.lstChildLinks = new Hashtable();
        this.lstFatherLinks = new Hashtable();
    }

    public void writeErrorOnParent(String message, Exception e, boolean error) {
        ActionProcess parent = this.getParentAction();
        parent.getVariablePublisher().publishVariable(error ? VariableType.CORE_RET_MESS : VariableType.CORE_WARNING, (Object)(String.valueOf(message) + e.getMessage()));
    }

    public static NodeList parseMetaInf(String xml) throws ParserConfigurationException, SAXException, IOException {
        if (xml != null && !xml.isEmpty()) {
            xml = "<root>" + xml + "</root>";
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(new StringReader(xml)));
            NodeList nl = document.getElementsByTagName("root");
            return nl.item(0).getChildNodes();
        }
        return null;
    }

    @Override
    public Enumeration<ActionGraphLinkI> getActionChildGraphLink() {
        if (this.lstChildLinks != null) {
            return this.lstChildLinks.elements();
        }
        return EMPTY_ENUMERATION;
    }

    public static NodeList parseMetaInf2(NamedNodeMap actAtts) {
        if (actAtts != null) {
            try {
                if (actAtts.getNamedItem("metaInf") != null) {
                    String mInf = actAtts.getNamedItem("metaInf").getNodeValue();
                    return Action.parseMetaInf(mInf);
                }
            }
            catch (Exception e) {
                Exception exception = e;
            }
        }
        return null;
    }

    @Override
    public void setActionState(int state) {
        if (this.stateVar == null) {
            this.stateVar = this.getVariablePublisher().publishVariable(VariableType.CORE_RET_CODE, (Object)state);
        } else {
            this.stateVar.setValue(String.valueOf(state));
        }
        super.setActionState(state);
    }

    public void updateActionAndLinkGraph() throws EngineExceptionI {
        if (!((this.isOnError() || this.isKilled()) && this.raiseErrorIfFailed() || this.getParentAction() == null)) {
            this.getParentAction().updateActionAndLinkState(this);
        }
    }

    protected void writeEndVariable() {
        if (this.getEndDate() == null) {
            this.setEndDate(this.threadManager.getEndDate(this.getBeginDate()));
        }
        if (this.getActionState() != 1 && this.getActionErrorMsg() != null && !this.getActionErrorMsg().isEmpty() && !this.getMainEngine().engineContext.existsVariable(String.valueOf(Global.VAR_PREFIXE) + this.getActionName() + "/" + VariableType.CORE_RET_MESS.getName())) {
            this.getVariablePublisher().publishVariable(VariableType.CORE_RET_MESS, (Object)this.getActionErrorMsg());
        }
        if (this.getActionState() != 1 && this.stackTrace != null && !this.stackTrace.isEmpty() && !this.getMainEngine().engineContext.existsVariable(String.valueOf(Global.VAR_PREFIXE) + this.getActionName() + "/" + VariableType.CORE_STACK_TRACE.getName())) {
            this.getVariablePublisher().publishVariable(VariableType.CORE_STACK_TRACE, (Object)this.stackTrace);
        }
        this.getVariablePublisher().publishVariable(VariableType.CORE_RET_CODE, (Object)this.getActionState());
        this.writeLoggers(this.store.getAfterLoggers());
    }

    private void writeLoggers(List<Logger> loggers) {
        boolean listenerServiceIsRunning = false;
        boolean listenerServiceIsRunningIsSet = false;
        if (loggers != null) {
            try {
                for (Logger logger : loggers) {
                    if (logger.isEventLogger && !listenerServiceIsRunningIsSet) {
                        listenerServiceIsRunningIsSet = true;
                        ListenerService serviceListener = (ListenerService)ServiceManager.INSTANCE.getService("listener");
                        boolean bl = listenerServiceIsRunning = serviceListener.getState() == ServiceState.Running;
                    }
                    if (logger.isEventLogger && !listenerServiceIsRunning) continue;
                    for (Logger.Message _msg : logger.msgs.values()) {
                        if (_msg.status.size() != 0 && !_msg.status.contains(this.getActionState())) continue;
                        String msg = this.evaluateExpression(_msg.msg);
                        org.apache.logging.log4j.Logger _logger = null;
                        for (String loggerName : logger.loggers) {
                            if (loggerName.toLowerCase().equals("userconsole")) {
                                _logger = LogManager.getLogger((String)Global.comIndyEngineUserConsoleLogger);
                            } else if (loggerName.toLowerCase().equals("mainconsole")) {
                                _logger = LogManager.getLogger((String)Global.comIndyEngineConsoleLogger);
                            } else if (loggerName.toLowerCase().equals("stambialog")) {
                                Action actionPath = null;
                                String localPath = null;
                                if (logger.path != null && !logger.path.isEmpty()) {
                                    URI uri = new URI(String.valueOf(this.getActionName().replaceAll(" ", "%20")) + "/" + logger.path.replaceAll(" ", "%20"));
                                    String str = uri.normalize().getPath();
                                    localPath = "";
                                    while (actionPath == null) {
                                        localPath = String.valueOf(str.substring(str.lastIndexOf("/"))) + localPath;
                                        str = str.substring(0, str.lastIndexOf("/"));
                                        String id = this.getMainEngine().getActionId(str);
                                        if (id == null) continue;
                                        actionPath = this.getMainEngine().getLstActionsId().get(id);
                                    }
                                    if (localPath.endsWith("/")) {
                                        localPath = localPath.substring(0, localPath.length() - 1);
                                    }
                                    if (localPath.startsWith("/")) {
                                        localPath = localPath.substring(1);
                                    }
                                }
                                if (actionPath == null) {
                                    actionPath = this;
                                }
                                this.getMainEngine().uLog.addActionLog(this, actionPath, localPath, msg, this.getMainEngine().incrUserLogNum());
                            } else {
                                _logger = LogManager.getLogger((String)loggerName);
                            }
                            if (_logger == null) continue;
                            if (_msg.level == Level.INFO) {
                                _logger.info(msg);
                                continue;
                            }
                            if (_msg.level == Level.DEBUG) {
                                _logger.debug(msg);
                                continue;
                            }
                            if (_msg.level == Level.ERROR) {
                                _logger.error(msg);
                                continue;
                            }
                            if (_msg.level == Level.WARN) {
                                _logger.warn(msg);
                                continue;
                            }
                            if (_msg.level != Level.TRACE) continue;
                            _logger.trace(msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                Global.getActionCodeLogger().error("Error during user logging", (Throwable)e);
            }
        }
    }

    public void setStackTrace(Throwable t) {
        if (t != null) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            t.printStackTrace(printWriter);
            this.stackTrace = ((Object)result).toString();
            return;
        }
        this.stackTrace = null;
    }

    public void setToError(String message, Throwable t) {
        this.error(message, t);
        if (this.getBeginDate() == null) {
            this.initBeginDate();
        }
        this.setActionErrorMess(message);
        this.setStackTrace(t);
        this.setActionState(-1);
    }

    public static String getStrdateformat() {
        return strDateFormat;
    }

    protected void initBeginDate() {
        this.setEndDate(null);
        this.setBeginDate(new Date());
    }

    public void resetForReexecute() {
        this.reset();
        this.setNbExecution(0);
        this.getVariablePublisher().publishImmediateVariable(VariableType.CORE_NB_EXECUTIONS, (Object)Integer.toString(0));
        this.setActionState(0);
        this.setBeginDate(null);
        this.setActionRuntimeName(null);
        this.setEndDate(null);
        this.setStackTrace(null);
        this.setActionErrorMess(null);
        this.setIsRestartPoint(0);
        Enumeration<ActionGraphLinkI> _enum = this.getActionChildGraphLink();
        while (_enum.hasMoreElements()) {
            ActionGraphLinkI link = _enum.nextElement();
            link.resetForReexecute();
        }
    }

    @Override
    public void setBeginDate(Date pDate) {
        this.beginDate = pDate == null ? null : this.getVariablePublisher().publishVariable(VariableType.CORE_BEGIN_DATE, (Object)this.dateFormat.format(pDate));
    }

    @Override
    public Date getBeginDate() {
        if (this.beginDate == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(this.beginDate.getValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public void setEndDate(Date pDate) {
        if (pDate == null) {
            this.endDate = null;
        } else {
            this.endDate = this.getVariablePublisher().publishVariable(VariableType.CORE_END_DATE, (Object)this.dateFormat.format(pDate));
            Date begDate = this.getBeginDate();
            if (begDate != null) {
                this.getVariablePublisher().publishVariable(VariableType.CORE_DURATION, (Object)String.valueOf(pDate.getTime() - begDate.getTime()));
            }
        }
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(this.endDate.getValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public void createEngine() {
    }

    @Override
    public String getActionFatherId() {
        if (this.getParentAction() != null) {
            return this.getParentAction().getActionId();
        }
        return this.getActionId();
    }

    @Override
    public IActionContext getFatherContext() {
        if (this.getParentAction() != null) {
            return this.getParentAction().getActionContext();
        }
        return null;
    }

    @Override
    public String getFatherId() {
        if (this.getParentAction() != null) {
            return this.getParentAction().getActionId();
        }
        return null;
    }

    @Override
    public ActionProcess getParentAction() {
        if (this.store.getParent() != null) {
            return (ActionProcess)this.getMainEngine().getActionInstance(this.store.getParent());
        }
        return null;
    }

    public Map<String, IActionBind> getLstSrcBinds() {
        return this.lstSrcBinds;
    }

    public Map<String, IActionBind> getLstTrgBinds() {
        return this.lstTrgBinds;
    }

    public String getActionType() {
        return this instanceof ActionProcess ? "Process" : "Code";
    }

    @Override
    public void clear() throws Exception {
        this.threadManager = null;
        for (ActionGraphLinkI agl : this.lstChildLinks.values()) {
            agl.clear();
        }
        Iterator<ActionGraphLinkI> it = null;
        this.lstFatherLinks.clear();
        this.lstChildLinks.clear();
        this.lstChildLinks = null;
        this.lstFatherLinks = null;
        for (IActionBind ab : this.lstSrcBinds.values()) {
            ab.clear();
        }
        it = null;
        this.lstSrcBinds.clear();
        this.lstSrcBinds = null;
        this.lstTrgBinds.clear();
        this.lstTrgBinds = null;
        this.store = null;
        this.variableContainer = null;
        this.variablePublisher = null;
        this.variableGetter = null;
        this.actionContext = null;
        this.stateVar = null;
        this.evaluator = null;
        this.dateFormat = null;
        super.clear();
    }

    public void initStart() throws EngineExceptionI {
        this.incrIteration();
        this.stackTrace = null;
        this.cleanMemoryVar();
        this.updateActiveFatherLinks();
        this.initBeginDate();
        this.setActionErrorMess("");
        this.evaluateActionVariables();
        this.writeLoggers(this.store.getBeforeLoggers());
        this.setCanBeStopped(true);
    }

    @Override
    public boolean isActive() {
        return this.getActionState() == 2 || this.getActionState() == 4 || this.getActionState() == -3;
    }

    public boolean isEnded() {
        return this.getActionState() == 1 || this.getActionState() == 3 || this.getActionState() == -2 || this.getActionState() == -1;
    }

    public boolean isDone() {
        return this.getActionState() == 1 || this.isOnWarning();
    }

    public boolean isActivable() {
        for (ActionGraphLinkI link : this.lstFatherLinks.values()) {
            Action father = link.getActionSource();
            if (father == null || (!father.isEnded() || link.isActive()) && father.isActivable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getIteration() {
        if (!this.hasFather()) {
            return 1;
        }
        return this.iteration;
    }

    @Override
    public void incrNbExecution() {
        ++this.nbExecution;
        this.getVariablePublisher().publishVariable(VariableType.CORE_NB_EXECUTIONS, (Object)Integer.toString(this.getNbExecution()));
    }

    @Override
    public int getNbExecution() {
        return this.nbExecution;
    }

    @Override
    public void setNbExecution(int intValue) {
        this.nbExecution = intValue;
        this.getVariablePublisher().publishVariable(VariableType.CORE_NB_EXECUTIONS, (Object)Integer.toString(this.nbExecution));
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void incrIteration() {
        if (!this.hasFather()) {
            this.iteration = 1;
        } else if (this.iteration == 0) {
            this.iteration = 1;
        } else if (!this.hasForceRestartPoint()) {
            ++this.iteration;
        }
    }

    public boolean isBindedAndRunning() {
        return this.getActionState() == 4;
    }

    public boolean isNeverExecuted() {
        return this.getActionState() == 0;
    }

    public boolean isKilling() {
        return this.getActionState() == -3;
    }

    public boolean isKilled() {
        return this.getActionState() == -2;
    }

    public boolean isOnError() {
        return this.getActionState() == -1 && !this.getActionStatic().getToleratedError();
    }

    public boolean isKilledOrWithError() {
        return this.isOnError() || this.isKilled();
    }

    public boolean isOnWarning() {
        return this.getActionState() == -1 && this.getActionStatic().getToleratedError();
    }

    public Boolean hasSrcBind(Action parent) {
        if (this.getActionStatic().isTrgBindedAction()) {
            if (this.getActionContext().lstSrcBindsContainsKey(parent.getActionName()).booleanValue()) {
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "Action: " + this.getActionName();
    }

    @Override
    public boolean getIsStoping() {
        return this.isKilling();
    }

    public void error(String message, Throwable t) {
        if (t != null) {
            Global.getActionLogger().error(String.valueOf(this.getMainEngine().getSessionName()) + "(" + this.getMainEngine().getSessionID() + ") " + this.getActionName() + " " + message, t);
        } else {
            Global.getActionLogger().error(String.valueOf(this.getMainEngine().getSessionName()) + "(" + this.getMainEngine().getSessionID() + ") " + this.getActionName() + " " + message);
        }
    }

    public void debug(String message, Throwable t) {
        if (t != null) {
            Global.getActionLogger().debug(String.valueOf(this.getMainEngine().getSessionName()) + "(" + this.getMainEngine().getSessionID() + ") " + this.getActionName() + " " + message, t);
        } else {
            Global.getActionLogger().debug(String.valueOf(this.getMainEngine().getSessionName()) + "(" + this.getMainEngine().getSessionID() + ") " + this.getActionName() + " " + message);
        }
    }

    public void updateActiveFatherLinks() throws EngineExceptionI {
        Enumeration<ActionGraphLinkI> e4 = this.lstFatherLinks.elements();
        while (e4.hasMoreElements()) {
            ActionGraphLinkI agl = e4.nextElement();
            if (!agl.isActive()) continue;
            agl.setState(2);
            if (!agl.sCondition.sOriginScript.isEmpty()) {
                this.getMainEngine().uLog.reportLinkChanges(agl, new Boolean(true), agl.getDate());
                continue;
            }
            this.getMainEngine().uLog.reportLinkChanges(agl, new Boolean(false), agl.getDate());
        }
    }

    public void updatePreviousLinks(Set<IAction> precsNotRestart, Set<IAction> precsRestart) {
        Enumeration<ActionGraphLinkI> e4 = this.lstFatherLinks.elements();
        while (e4.hasMoreElements()) {
            ActionGraphLinkI agl = e4.nextElement();
            if (!precsNotRestart.contains(agl.getActionSource()) || !agl.hasActived()) continue;
            agl.setState(3);
        }
    }

    public Set<IAction> getPrecedentActions() {
        HashSet<IAction> precedent = new HashSet<IAction>();
        Enumeration<ActionGraphLinkI> l = this.lstFatherLinks.elements();
        while (l.hasMoreElements()) {
            ActionGraphLinkI lnk = l.nextElement();
            if (!lnk.hasActived()) continue;
            precedent.add(lnk.getActionSource());
        }
        return precedent;
    }

    public void addChildGraphLink(ActionGraphLinkI agl) {
        this.lstChildLinks.put(agl.getLinkStatic().getId(), agl);
    }

    public void addFatherLink(ActionGraphLinkI agl) {
        this.lstFatherLinks.put(agl.getLinkStatic().getId(), agl);
    }

    @Override
    public IActionContext getActionContext() {
        return this.actionContext;
    }

    @Override
    public Map<String, Variable> getActionLstVariables() {
        return this.variableContainer.getAllCopiedLocalVariables(null);
    }

    private String transformStringParameter(IActionContext callingAction, String pValue, EngineContextI engineContext) throws EngineExceptionI {
        String s;
        try {
            String sValue;
            block6: {
                sValue = null;
                String varExpr = Global.transformVariableExpression(callingAction.getActionName(), engineContext, pValue);
                try {
                    sValue = callingAction.executeSubstitutionScript(varExpr, "e");
                    sValue = callingAction.executeSubstitutionScript(sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && callingAction.getAllowsScriptingErrors()) break block6;
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            s = sValue;
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("Action.1")) + pValue + Messages.getString("Action.2"), (Throwable)e);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return s;
    }

    public boolean isConnectedBindedAndRunning() {
        return this.isBindedAndRunning() && this.connectedBindedAndRunning;
    }

    public class ActionContextI
    implements Cloneable,
    IActionContext {
        public Map<String, IActionBind> getLstTrgBinds() {
            return Action.this.lstTrgBinds;
        }

        public void notifyAction() {
            Action.this.notifyAction();
        }

        public IVariableGetter getGetter() {
            return Action.this.getVariableGetter();
        }

        public IVariablePublisher getPublisher() {
            return Action.this.getVariablePublisher();
        }

        public void setCurrentBindIteration(int numRecord) {
            Action.this.setCurrentBindIteration(numRecord);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean lstSrcBindsContainsKey(String strKey) {
            Boolean ret = false;
            Map<String, IActionBind> map = Action.this.getLstSrcBinds();
            synchronized (map) {
                Iterator<String> it = Action.this.getLstSrcBinds().keySet().iterator();
                while (it.hasNext() && !ret.booleanValue()) {
                    String str = it.next();
                    if (!str.equals(strKey)) continue;
                    ret = true;
                }
            }
            return ret;
        }

        public boolean existsConnectionManager(String managerName) throws EngineExceptionI {
            return Action.this.getMainEngine().existsConnectionManager(managerName);
        }

        public void addNewConnectionManager(String managerName, String connectionName, String connectionType) {
            Action.this.getMainEngine().lstConnectionManager.put(managerName, new ConnectionManagerI((ISessionContext)this.getEngineContext(), connectionName, connectionType));
        }

        public ConnectionManagerI getConnectionManager(String managerName) throws EngineExceptionI {
            return Action.this.getMainEngine().getConnectionManager(managerName);
        }

        public void addChildSession(String sessionID, int iteration) throws EngineExceptionI {
            Action.this.getMainEngine().addChildSession(sessionID, iteration, Action.this);
        }

        public String getSessionId() {
            return Action.this.getMainEngine().getSessionID();
        }

        public int getLogLevel() {
            return Action.this.getMainEngine().getLogLevel();
        }

        public boolean getActionToleratedError() {
            return Action.this.getActionStatic().getToleratedError();
        }

        public String getActionId() {
            return Action.this.getActionId();
        }

        public String getActionName() {
            return Action.this.getActionName();
        }

        public int getNbExecution() {
            return Action.this.getNbExecution();
        }

        public String getSessionConfiguration() {
            return Action.this.getMainEngine().getSessionConf();
        }

        public long getCurrentBindIteration() {
            return Action.this.getCurrentBindIteration();
        }

        public IActionBind getSrcBind(String actionName) {
            return Action.this.getLstSrcBinds().get(actionName);
        }

        public IActionBind getTrgBind(String actionName) {
            return Action.this.getLstTrgBinds().get(actionName);
        }

        public boolean getAllowsScriptingErrors() {
            return Action.this.getMainEngine().getAllowsScriptingErrors();
        }

        public void setCanBeStopped(boolean b) {
            Action.this.setCanBeStopped(b);
        }

        public boolean isSrcBindedAction() {
            return Action.this.getActionStatic().isSrcBindedAction();
        }

        public boolean isTrgBindedAction() {
            return Action.this.getActionStatic().isTrgBindedAction();
        }

        public String toString() {
            return "ActionContextI [action=" + Action.this.getActionName() + ", isSrcBindedAction=" + this.isSrcBindedAction() + ", isTrgBindedAction=" + this.isTrgBindedAction() + ", lstSrcBinds=" + Action.this.getLstSrcBinds().size() + ", lstTrgBinds=" + Action.this.getLstTrgBinds().size() + ", toleratedError=" + this.getActionToleratedError() + "]";
        }

        public boolean getIsStopping() {
            return Action.this.getIsStoping();
        }

        public boolean hasFather() {
            return Action.this.hasFather();
        }

        public IActionContext getFatherContext() {
            return Action.this.getFatherContext();
        }

        public boolean getToleratedError() {
            return Action.this.getActionStatic().getToleratedError();
        }

        public String decryptString(String s) throws EngineExceptionI {
            int index = ExternalValueResolverManager.INSTANCE.indexOf(s);
            if (index > -1) {
                try {
                    return ExternalValueResolverManager.INSTANCE.replace(s, index);
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            String ret = null;
            try {
                String ret2;
                PasswordManagerI passManager = PasswordManagerI.c;
                String ret1 = passManager.decryptPassword(s);
                if (ret1.contains("%ext{")) {
                    try {
                        ret1 = ExternalValueResolverManager.INSTANCE.replace(ret1);
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                ret = (ret2 = Action.this.transformStringParameter(Action.this.actionContext, ret1, Action.this.getMainEngine().getEngineContext())).equals(ret1) ? ret1 : passManager.decryptPassword(ret2);
            }
            catch (OtherExceptionI e) {
                throw new EngineExceptionI((Throwable)e);
            }
            return ret;
        }

        public void notifyIsConnectedBindedAndRunning() {
            if (Action.this instanceof ActionCode) {
                ((ActionCode)Action.this).notifyIsConnectedBindedAndRunning();
            }
        }

        public ReentrantLock getConnectionlock() {
            return Action.this.getMainContext().getConnectionlock();
        }

        public void bindWithTarget(NotFetchedResultSetBindI rsb) throws EngineExceptionI, InterruptedException {
            IActionBind aBind = this.getActionBind();
            aBind.addBindedObject((Object)rsb);
            aBind.setBindActif(true);
            aBind.notifyFetch();
            Action.this.actionContext.notifyIsConnectedBindedAndRunning();
            if (Action.this.actionContext.getIsStopping()) {
                throw new EngineExceptionI(Messages.getString("Action.0"));
            }
        }

        public IActionBind getActionBind() {
            IActionBind aBind = this.getSrcBind(this.getActionName());
            if (aBind != null && aBind.getBindType().equals("DirectBind")) {
                return aBind;
            }
            return null;
        }

        public PreparedStatement createBindePreparedStatement() throws SQLException {
            IActionBind aBind = this.getActionBind();
            if (aBind == null) {
                return null;
            }
            String[] ids = new String[aBind.getLstBindedActions().size()];
            int i = 0;
            boolean useFileQueue = false;
            for (Object value : aBind.getLstBindedActions().values()) {
                Action action = (Action)value;
                ids[i++] = action.getActionId();
                if (ids.length <= 1 || action.lstFatherLinks.size() <= 1) continue;
                useFileQueue = true;
            }
            JdbcPreparedStatementToResultSet jpstrs = new JdbcPreparedStatementToResultSet();
            jpstrs.setConsumers(useFileQueue, ids);
            return jpstrs;
        }

        public boolean isStopBindOnError() {
            return Action.this.getActionStatic().isStopBindOnError();
        }

        public EngineContextI getEngineContext() {
            return Action.this.getMainEngine().getEngineContext();
        }

        public String executeSubstitutionScript(String sTxt, String testType) throws EngineExceptionI {
            ScriptManagerI sm = new ScriptManagerI();
            return sm.executeSubstitutionScript(this, sTxt, testType);
        }

        public IScriptContext createScriptContext(String testType) {
            return new ScriptContextI(this, Action.this.getMainEngine().getEngineContext(), testType);
        }

        public String transformStringParameter(String pValue, boolean bindMode) throws EngineExceptionI {
            return Global.transformStringParameter(this, pValue, this.getEngineContext(), bindMode);
        }

        public IVariable getSourceVariable(String variableName) {
            IActionBind abind = this.getTrgBind(this.getActionName());
            return ((ActionBindI)abind).getSourceAction().getActionContext().getGetter().getLocalVariable(variableName);
        }

        public RuntimeDatasource<Connection> createJdbcContainer(ConnectionManagerI connManager) throws EngineExceptionI {
            return new DefaultRuntimeDataSource((Function)new JdbcRuntimeConnectionCreateFunction(this, connManager));
        }

        public INamedObjectManager getNamedObjectManager() {
            return Action.this.getMainEngine().getEngineContext().getNamedObjectManager();
        }

        public ClassLoader getSessionClassLoader(String sessionClassLoaderName) throws Exception {
            return Action.this.getMainEngine().getEngineContext().getSessionClassLoader(sessionClassLoaderName);
        }

        public String getSemaphoreLockName() {
            return Action.this.getActionStatic().getSemaphoreLockName();
        }

        public String encryptString(String decode) throws EngineExceptionI {
            if (decode != null) {
                try {
                    return PasswordManagerI.a.encryptPassword(decode);
                }
                catch (OtherExceptionI e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            return null;
        }
    }

    public class VariableGetter
    implements IVariableGetter {
        public boolean existsVariable(String name) {
            return this.getLocalVariable(name) != null;
        }

        public Variable getLocalVariable(String name) {
            if (Action.this.variableContainer != null) {
                return Action.this.variableContainer.getLocalVariable(name);
            }
            return null;
        }

        public Variable getAbsolutVariable(String name) {
            if (Action.this.variableContainer != null) {
                return Action.this.variableContainer.getAbsolutVariable(name);
            }
            return null;
        }

        public Variable getExpressionVariable(String name, String actName) {
            if (Action.this.variableContainer != null) {
                return Action.this.variableContainer.getAbsolutVariable(Action.this.getMainContext().resolveVariableName(name, actName));
            }
            return null;
        }

        public Map<String, VariableContainer.AggregateNumeric> getAllAggregate() {
            if (Action.this.variableContainer != null) {
                return Action.this.variableContainer.aggregateNumeric(null);
            }
            return null;
        }
    }

    public class VariablePublisher
    implements IVariablePublisher {
        public Variable publishCumulativeVariable(String name, Object value, String type, boolean immediate) {
            return Action.this.addVariableWithULog(name, value, type, immediate, true, VariablePublicationMode.DYNAMIC);
        }

        public Variable publishImmediateVariable(VariableType type, Object value) {
            return this.publishImmediateVariable(type, value, false);
        }

        public Variable publishImmediateVariable(VariableType type, Object value, boolean cumulative) {
            return this.publishVariable(type.getName(), value, type.getType(), true, cumulative, type.getPublicationMode());
        }

        public Variable publishVariable(VariableType type, Object value) {
            return this.publishVariable(type.getName(), value, type.getType(), false, false, type.getPublicationMode());
        }

        public Variable publishStaticVariable(String name, String type, Object value) {
            return this.publishVariable(name, value, type, false, false, VariablePublicationMode.STATIC);
        }

        public Variable publishVolatileVariable(String name, String type, Object value) {
            return this.publishVariable(name, value, type, false, false, VariablePublicationMode.VOLATILE);
        }

        public Variable publishVariable(String name, Object value, String type) {
            return this.publishVariable(name, value, type, false);
        }

        public Variable publishVariable(String name, Object value) {
            return this.publishVariable(name, value, null, false);
        }

        public Variable publishVariable(String name, Object value, String type, boolean pRealTimeReport) {
            return this.publishVariable(name, value, type, pRealTimeReport, false);
        }

        public Variable publishVariable(String name, Object value, String type, boolean pRealTimeReport, boolean cumulative, VariablePublicationMode static1) {
            return Action.this.addVariableWithULog(name, value, type, pRealTimeReport, cumulative, static1);
        }

        public Variable publishVariable(String name, Object value, String type, boolean pRealTimeReport, boolean cumulative) {
            return this.publishVariable(name, value, type, pRealTimeReport, cumulative, VariablePublicationMode.DYNAMIC);
        }
    }
}

