/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler;

import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.semarchy.xdi.runtime.connection.jdbc.HikariDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.quartz.utils.ConnectionProvider;

public class XdiQuartzConnectionProvider
implements ConnectionProvider {
    private HikariDataSourceImpl datasource;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String maxConnections;
    private String validationQuery;
    private String module;

    public Connection getConnection() throws SQLException {
        if (this.datasource == null) {
            try {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                ClassLoader moduleClassLoader = ClassLoaderServiceProvider.INSTANCE.getClassLoader(this.module);
                Thread.currentThread().setContextClassLoader(moduleClassLoader);
                try {
                    JdbcParameters jdbcParameters = new JdbcParameters();
                    jdbcParameters.driver(this.driver).moduleName(this.module).url(this.url).username(this.user).password(this.password).validationQuery(this.validationQuery);
                    int intMaxConnections = Integer.parseInt(this.maxConnections);
                    jdbcParameters.maximumPoolSize(intMaxConnections);
                    this.datasource = new HikariDataSourceImpl(jdbcParameters, false);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }

    public void initialize() throws SQLException {
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

