/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.userLog.IRecordWriter;
import com.indy.engine.userLog.Messages;
import com.indy.engine.userLog.SessionRecorder;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AsynchRecordWriter
implements IRecordWriter {
    IRecordWriter writer;
    Exception exception;
    SessionRecorder.Record currentRecord;
    AsynchroneThread asynchroneThread = new AsynchroneThread();
    boolean synchFirstRecord = true;
    Object waitObject = new Object();

    public AsynchRecordWriter(IRecordWriter writer, String threadName, boolean synchFirstRecord) {
        this.writer = writer;
        this.asynchroneThread.startThread(threadName);
        this.synchFirstRecord = synchFirstRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(SessionRecorder.Record o) throws EngineExceptionI {
        if (this.synchFirstRecord && o instanceof SessionRecorder.SessionEndRecord) {
            while (this.currentRecord == null && this.exception == null) {
                try {
                    AsynchRecordWriter asynchRecordWriter = this;
                    synchronized (asynchRecordWriter) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        if (this.exception != null) {
            Global.dLog.getLogger().error(String.valueOf(Messages.getString("AsynchRecordWriter.1")) + o.getSessionID(), (Throwable)this.exception);
        }
        this.asynchroneThread.queue.add(o);
    }

    final class AsynchroneThread
    implements Runnable {
        Thread thread;
        Queue<SessionRecorder.Record> queue = new ConcurrentLinkedQueue<SessionRecorder.Record>();

        AsynchroneThread() {
        }

        @Override
        public synchronized void run() {
            boolean stop = false;
            try {
                do {
                    SessionRecorder.Record _currentRecord;
                    if ((_currentRecord = this.queue.peek()) != null) {
                        AsynchRecordWriter.this.currentRecord = _currentRecord;
                        AsynchRecordWriter.this.writer.writeRecord(AsynchRecordWriter.this.currentRecord);
                        if (AsynchRecordWriter.this.currentRecord instanceof SessionRecorder.SessionEndRecord) {
                            stop = true;
                        }
                        this.queue.poll();
                        continue;
                    }
                    this.wait(10L);
                } while (!Thread.interrupted() && !stop);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (AsynchRecordWriter.this.currentRecord != null) {
                    Global.dLog.getLogger().error(String.valueOf(Messages.getString("AsynchRecordWriter.0")) + AsynchRecordWriter.this.currentRecord.getSessionID(), (Throwable)e);
                }
                AsynchRecordWriter.this.exception = e;
            }
        }

        private synchronized void startThread(String threadName) {
            this.thread = new Thread(this);
            this.thread.setName(threadName);
            this.thread.start();
        }
    }
}

