/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.core.common.CommonUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.DataFormatException;

public class Format {
    public static final String EXTERNAL_BLOB = "BINARY";
    public static final String EXTERNAL_COMPRESSED = "COMPRESSED";
    public static final String EXTERNAL_TEXT = "TEXT";
    public static final String INTERNAL_BLOB = "BLOB";
    public static final String INTERNAL_CLOB = "CLOB";
    public static final String INTERNAL_COMPRESSED = "BLOB_COMPRESSED";
    public static final String INTERNAL_VARCHAR = "VARCHAR";

    public static String getString(ResultSet rs, String prefix) throws IOException, SQLException, DataFormatException {
        Object o = Format.readData(rs, prefix);
        if (o != null) {
            Reader reader = null;
            if (o instanceof Reader) {
                reader = (Reader)o;
            } else if (o instanceof InputStream) {
                reader = new InputStreamReader((InputStream)o);
            }
            return CommonUtils.readerToString((Reader)reader);
        }
        return null;
    }

    public static Object readData(ResultSet rs, String prefix) throws SQLException, IOException, DataFormatException {
        Closeable result = null;
        String format = rs.getString(String.valueOf(prefix) + "FORMAT");
        if (format != null) {
            if (format.equals(INTERNAL_VARCHAR)) {
                result = rs.getCharacterStream(String.valueOf(prefix) + "VAR");
            } else if (format.equals(INTERNAL_CLOB)) {
                result = rs.getCharacterStream(String.valueOf(prefix) + "CLO");
            } else if (format.equals(INTERNAL_BLOB)) {
                result = rs.getBinaryStream(String.valueOf(prefix) + "BLO");
            } else if (format.equals(INTERNAL_COMPRESSED)) {
                InputStream is = rs.getBinaryStream(String.valueOf(prefix) + "BLO");
                byte[] b = CommonUtils.inputStreamToByteArray((InputStream)is);
                byte[] c = CommonUtils.unCompressByteArray((byte[])b);
                result = new ByteArrayInputStream(c);
            }
        }
        return result;
    }
}

