/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.core.common.LockById;
import com.indy.engine.core.common.VariableDataType;
import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.objects.LinkDataExchangeI;
import com.indy.engine.core.common.objects2.ActionDataExchange;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ActionStaticCode;
import com.indy.engine.main.action.statics.ActionStaticProcess;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.action.statics.VariableStatic;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.main.repository.internal.MemoryDelivery;
import com.indy.engine.manager.Action;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.userLog.Format;
import com.indy.engine.userLog.IUserLogI;
import com.indy.engine.userLog.Messages;
import com.indy.engine.userLog.SessionRecorder;
import com.indy.engine.userLog.UpdateDatabase;
import com.indy.engine.userLog.UserLogI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class RdbmsUserLog
extends UserLogI
implements IUserLogI {
    private boolean userLogRdbmsDeletionWithNotExists = true;
    String userLogRdbmsDriver = "";
    String userLogRdbmsModule = null;
    String userLogRdbmsUrl = "";
    String userLogRdbmsUser = "";
    String userLogRdbmsPassword = "";
    String userLogRdbmsSchemaName = "";
    String userLogRdbmsNumericType = "NUMERIC";
    String userLogRdbmsClobType = "CLOB";
    String userLogRdbmsVarcharType = "VARCHAR";
    String userLogRdbmsTimestampQuery = null;
    boolean userLogRdbmsPoolEnabled = !Boolean.getBoolean("com.semarchy.xdi.runtime.jdbc.disablePool");
    int userLogRdbmsPoolConnectionTimeout = Global.DEFAULT_JDBC_CONN_TIMEOUT * 1000;
    int userLogRdbmsPoolIdleTimeout = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolIdleTimeout", "600000"));
    int userLogRdbmsPoolKeepAliveTime = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolKeepAlive", "0"));
    int userLogRdbmsPoolMaxLifetime = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMaxLifetime", "-1"));
    int userLogRdbmsPoolMinimumIdle = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMinIdle", "0"));
    int userLogRdbmsPoolMaximumSize = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMaxSize", "20"));
    int userLogRdbmsPoolValidationTimeout = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolValidationTimeout", "5000"));
    String userLogRdbmsPoolConnectionTestQuery = System.getProperty("com.semarchy.xdi.runtime.jdbc.poolValidationQuery");
    long userLogRdbmsInactivityDetectionPeriodLong = 90000L;
    private long userLogRdbmsActivityRefreshIntervalLong = 60000L;
    String userLogRdbmsBlobType = Global.RDBMS_BLOB_TYPE;
    String userLogRdbmsDeleteSyntaxe = "Delete";
    Boolean useHaving = false;
    String columnAS = "AS";
    String tableAS = "";
    String FULL_DELIVERY = null;
    String FULL_SESSION = null;
    boolean autoUpdate = false;
    boolean userLogAvailable = false;
    private Set set;
    private Get get;
    String DELIVERY;
    String SESSION;
    String FULL_PROPERTY;
    String PROPERTY;
    String FULL_LINK;
    String LINK;
    String FULL_ACTION;
    String FULL_VERSION;
    String FULL_USER_LOG;
    String FULL_CHILD_SESSION;
    String LG_SESSION_CHILDS_CSES;
    String LG_VERSION_V;
    String ACTION;
    String USER_LOG;
    String deliveryFormat = "TEXT";
    int propertyVarcharMaxSize = 1000;
    int propertyClobMaxSize = -1;
    private Query query;
    DDL ddl;
    private String propertyBinaryFormat = "TEXT";
    String userLogRdbmsVarcharMaxSize;
    private int compressionLevel = 9;
    boolean userLogRdbmsUseSchemaNameForIndexCreation = true;
    private int intVersion;
    String version;
    String userLogRdbmsTablePrefix;
    private String TECH_LOG;
    private Logger logger;
    SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
    private String type;
    Exception connectionException;
    private DataSource dataSource;
    private long offset;
    String userLogRdbmsTableCreationOption;
    String userLogRdbmsIndexCreationOption;
    static final LockById deliveryLocks = new LockById();
    private boolean userLogRdbmsUseAliasTableForDeleteClause;

    public RdbmsUserLog() {
        this.logger = LogManager.getLogger((String)Global.comIndyEngineRdbmsLogger);
    }

    @Override
    public void cleanReportLog() {
        super.cleanReportLog();
        this.dataSource = null;
        this.userLogRdbmsDriver = null;
        this.userLogRdbmsUrl = null;
        this.userLogRdbmsUser = null;
        this.userLogRdbmsPassword = null;
        this.userLogRdbmsSchemaName = null;
    }

    Connection getConnection(boolean b, boolean c) throws EngineExceptionI {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    Exception getLastConnectionException() {
        return this.connectionException;
    }

    @Override
    public int initLog(Map<String, String> p, String logName, String type) throws EngineExceptionI {
        super.setProperties(p);
        this.type = type;
        int ret = this.setParameters();
        DataSourceConfiguration configuration = new DataSourceConfiguration().enablePool(this.userLogRdbmsPoolEnabled);
        configuration.jdbcParameters().driver(this.userLogRdbmsDriver).url(this.userLogRdbmsUrl).username(this.userLogRdbmsUser).password(this.userLogRdbmsPassword).moduleName(this.userLogRdbmsModule).connectionTimeout(this.userLogRdbmsPoolConnectionTimeout).minimumIdle(this.userLogRdbmsPoolMinimumIdle).maximumPoolSize(this.userLogRdbmsPoolMaximumSize).validationTimeout(this.userLogRdbmsPoolValidationTimeout).idleTimeout(this.userLogRdbmsPoolIdleTimeout).keepAliveTime(this.userLogRdbmsPoolKeepAliveTime).maxLifetime(this.userLogRdbmsPoolMaxLifetime).validationQuery(this.userLogRdbmsPoolConnectionTestQuery).autocommit(true);
        this.dataSource = DataSourceManager.instance().getDataSource(configuration);
        return ret;
    }

    @Override
    public IMemoryDelivery getSessionDelivery(String sessionId) throws EngineExceptionI {
        MemoryDelivery md;
        block14: {
            ResultSet rs;
            Statement st;
            Connection conn;
            block13: {
                System.currentTimeMillis();
                md = null;
                conn = null;
                st = null;
                rs = null;
                try {
                    try {
                        conn = this.getConnection(true, true);
                        st = conn.createStatement();
                        st.setFetchSize(1);
                        String query = this.query.getSessionDeliveryQuery(sessionId);
                        rs = st.executeQuery(query);
                        if (rs.next()) {
                            Reader reader = this.get.getReader(rs, "DLV_");
                            String name = rs.getString("DLV_NAME");
                            try (InputStream inputStream = null;){
                                inputStream = this.convertReaderToInputStream(reader);
                                md = new MemoryDelivery(inputStream, name, null);
                                break block13;
                            }
                        }
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.12"));
                    }
                    catch (SQLException e) {
                        Global.dLog.write(sessionId, "RdbmsUserLogI=>getSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.13")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.14"), (Throwable)e);
                    }
                    catch (ParserConfigurationException e) {
                        Global.dLog.write(sessionId, "RdbmsUserLogI=>getSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.15")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.16"), (Throwable)e);
                    }
                    catch (SAXException e) {
                        Global.dLog.write(sessionId, "RdbmsUserLogI=>getSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.17")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.18"), (Throwable)e);
                    }
                    catch (IOException e) {
                        Global.dLog.write(sessionId, "RdbmsUserLogI=>getSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.19")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.20"), (Throwable)e);
                    }
                    catch (DataFormatException e) {
                        e.printStackTrace();
                        this.releaseConnection(conn, rs, st);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    this.releaseConnection(conn, rs, st);
                    throw throwable;
                }
            }
            this.releaseConnection(conn, rs, st);
        }
        Global.dLog.write("RdbmsUserLogI=>getLstClosedSessions", Messages.getString("RdbmsUserLog.21"), 9, 0, "DEBUG");
        return md;
    }

    private InputStream convertReaderToInputStream(Reader reader) throws IOException {
        int numCharsRead;
        char[] charBuffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        while ((numCharsRead = reader.read(charBuffer, 0, charBuffer.length)) != -1) {
            builder.append(charBuffer, 0, numCharsRead);
        }
        return new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    private void saveSessionDelivery(SessionRecorder.DeliveryRecord mainEngine) throws EngineExceptionI {
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean done = false;
        boolean exists = true;
        conn = this.getConnection(true, false);
        boolean lockAcquire = false;
        String DLV_ID = mainEngine.getSessionStatic().getDlvId();
        try {
            try {
                deliveryLocks.lock(DLV_ID);
                lockAcquire = true;
                Global.dLog.write(mainEngine.getProcessName(), "RdbmsUserLogI=>saveSessionDelivery", Messages.getString("RdbmsUserLog.22"), 5, 0, "DEBUG");
                int i = this.get.exists(this.query.exsistsDeliveryQuery(DLV_ID), true);
                if (i == 1 && this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    stmt = conn.prepareStatement(this.query.updateDeliveryHeader());
                    stmt.setString(1, mainEngine.getSessionStatic().getProcId());
                    stmt.setString(2, DLV_ID);
                    stmt.executeUpdate();
                    exists = false;
                } else if (i == 0) {
                    String str;
                    String txtCode = this.deliveryFormat.equals("BINARY") || this.deliveryFormat.equals("COMPRESSED") ? this.query.getSaveDeliveryBloQuery() : this.query.getSaveDeliveryCloQuery();
                    stmt = conn.prepareStatement(txtCode);
                    stmt.setString(1, DLV_ID);
                    ByteArrayOutputStream out = mainEngine.getBaos();
                    if (this.deliveryFormat.equals("COMPRESSED")) {
                        stmt.setString(2, "BLOB_COMPRESSED");
                        this.set.putInputStreamnCompressed(new ByteArrayInputStream(out.toByteArray()), stmt, 3);
                    } else if (this.deliveryFormat.equals("BINARY")) {
                        stmt.setString(2, "BLOB");
                        str = out.toString();
                        this.set.putStringBlob(str, stmt, 3);
                    } else {
                        stmt.setString(2, "CLOB");
                        str = out.toString();
                        this.set.putStringClob(str, stmt, 3);
                    }
                    stmt.setString(4, mainEngine.getProcessName());
                    stmt.setString(5, mainEngine.getSessionStatic().getProcId());
                    stmt.setString(6, mainEngine.getConfiguration());
                    if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                        Date dte = mainEngine.getSessionStatic().getBuildDate();
                        if (dte != null) {
                            stmt.setLong(7, dte.getTime());
                        } else {
                            stmt.setLong(7, 0L);
                        }
                        stmt.setString(8, mainEngine.getSessionStatic().getVersion());
                        stmt.setString(9, mainEngine.getSessionStatic().getBuildUser());
                        stmt.setString(10, mainEngine.getSessionStatic().getDescription());
                    }
                    if (this.intVersion >= UpdateDatabase.Version.V1709.num()) {
                        stmt.setString(11, mainEngine.getSessionStatic().getPackageId());
                    }
                    if (this.intVersion >= UpdateDatabase.Version.V1770.num()) {
                        stmt.setString(12, mainEngine.getSessionStatic().getChecksum());
                    }
                    stmt.executeUpdate();
                    exists = false;
                }
                Global.dLog.write(mainEngine.getProcessName(), "RdbmsUserLogI=>saveSessionDelivery", Messages.getString("RdbmsUserLog.23"), 5, 0, "DEBUG");
                done = true;
                if (!exists && done && this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    this.saveSessionDeliveryAction(mainEngine.getSessionStatic(), mainEngine.getProcessName());
                }
            }
            catch (Exception e) {
                Global.dLog.write(mainEngine.getProcessName(), "RdbmsUserLogI=>saveSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.24")) + e.getMessage(), 0, 0, "ERROR");
                e.printStackTrace();
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.25"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.releaseConnection(conn, null, stmt);
            }
            finally {
                if (lockAcquire) {
                    try {
                        deliveryLocks.unlock(DLV_ID);
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI(Messages.getString("RdbmsUserLog.26"), (Throwable)e);
                    }
                }
            }
            throw throwable;
        }
        try {
            this.releaseConnection(conn, null, stmt);
        }
        finally {
            if (lockAcquire) {
                try {
                    deliveryLocks.unlock(DLV_ID);
                }
                catch (Exception e) {
                    throw new EngineExceptionI(Messages.getString("RdbmsUserLog.26"), (Throwable)e);
                }
            }
        }
    }

    private void saveSessionDeliveryAction(SessionStatic sess, String procName) throws EngineExceptionI {
        String script;
        Connection conn = null;
        PreparedStatement stmt = null;
        String DLV_ID = sess.getDlvId();
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDeliveryAction", Messages.getString("RdbmsUserLog.27"), 5, 0, "DEBUG");
                script = this.getUpdateDatabase().insertSACT.createInsertIntoScript(this, UpdateDatabase.TableName.ACTION_S_ACT, new UpdateDatabase.ColumnName[0]);
                stmt = conn.prepareStatement(script);
                for (ActionStatic actionStatic : sess.getDefaultActions()) {
                    stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.DLV_ID), DLV_ID);
                    stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_ID), actionStatic.getActionId());
                    if (actionStatic.getParent() != null) {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_PARENT_ID), actionStatic.getParent().getActionId());
                    } else {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_PARENT_ID), null);
                    }
                    if (actionStatic instanceof ActionStaticCode) {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_TECH), ((ActionStaticCode)actionStatic).getActionTechnology());
                    } else {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_TECH), null);
                    }
                    stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_SHORT_NAME), actionStatic.getShortName());
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_HAS_DYN_NAME), actionStatic.getActionDynamicName() != null && !actionStatic.getActionDynamicName().isEmpty() ? 1 : 0);
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_TYPE), actionStatic instanceof ActionStaticProcess ? (((ActionStaticProcess)actionStatic).isMapping() ? 2 : 1) : 3);
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_ERROR_ACCEPTED), actionStatic.getToleratedError() ? 1 : 0);
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_IS_BEGIN), actionStatic.isBeginAction() ? 1 : 0);
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_NB_CYCLE), actionStatic.getNbCycles());
                    stmt.setInt(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_RESTART_MODE), actionStatic.isRestartOpenMode() ? 2 : (actionStatic.isRestartCloseMode() ? 3 : 1));
                    if (actionStatic.getParent() != null) {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_PARENT_PATH), actionStatic.getParent().getActionName());
                    } else {
                        stmt.setString(this.getUpdateDatabase().insertSACT.index(UpdateDatabase.ColumnName.ACT_PARENT_PATH), null);
                    }
                    stmt.execute();
                }
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDeliveryAction", Messages.getString("RdbmsUserLog.28"), 5, 0, "DEBUG");
            }
            catch (Exception e) {
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.29")) + e.getMessage(), 0, 0, "ERROR");
                e.printStackTrace();
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.30"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, stmt);
            throw throwable;
        }
        this.releaseConnection(conn, null, stmt);
        conn = null;
        stmt = null;
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDeliveryVars", Messages.getString("RdbmsUserLog.31"), 5, 0, "DEBUG");
                for (ActionStatic action : sess.getDefaultActions()) {
                    for (VariableStatic var : action.getAllStaticVariables().values()) {
                        String format = "VAR";
                        stmt = null;
                        try {
                            format = var.getValue() == null || var.getValue().length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || var.getValue().length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                            UpdateDatabase.ColList colList = format.equals("VAR") ? this.getUpdateDatabase().insertSACP.copy(UpdateDatabase.ColumnName.ASP_SRC_BLO, UpdateDatabase.ColumnName.ASP_SRC_CLO) : (format.equals("CLO") ? this.getUpdateDatabase().insertSACP.copy(UpdateDatabase.ColumnName.ASP_SRC_VAR, UpdateDatabase.ColumnName.ASP_SRC_BLO) : this.getUpdateDatabase().insertSACP.copy(UpdateDatabase.ColumnName.ASP_SRC_VAR, UpdateDatabase.ColumnName.ASP_SRC_CLO));
                            String script2 = colList.createInsertIntoScript(this, UpdateDatabase.TableName.ACTION_SPROP_ASP, new UpdateDatabase.ColumnName[0]);
                            stmt = conn.prepareStatement(script2);
                            if (format.equals("VAR")) {
                                this.set.setValue(format, stmt, var.getValue(), colList.index(UpdateDatabase.ColumnName.ASP_SRC_FORMAT), colList.index(UpdateDatabase.ColumnName.ASP_SRC_VAR));
                            } else if (format.equals("CLO")) {
                                this.set.setValue(format, stmt, var.getValue(), colList.index(UpdateDatabase.ColumnName.ASP_SRC_FORMAT), colList.index(UpdateDatabase.ColumnName.ASP_SRC_CLO));
                            } else {
                                this.set.setValue(format, stmt, var.getValue(), colList.index(UpdateDatabase.ColumnName.ASP_SRC_FORMAT), colList.index(UpdateDatabase.ColumnName.ASP_SRC_BLO));
                            }
                            stmt.setString(colList.index(UpdateDatabase.ColumnName.DLV_ID), DLV_ID);
                            stmt.setString(colList.index(UpdateDatabase.ColumnName.ACT_ID), action.getActionId());
                            stmt.setString(colList.index(UpdateDatabase.ColumnName.ACP_SHORT_NAME), var.getShortName());
                            stmt.setInt(colList.index(UpdateDatabase.ColumnName.PTY_TYPE_N), var.getDataType().getNum());
                            stmt.execute();
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.32")) + e.getMessage(), 0, 0, "ERROR");
                e.printStackTrace();
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.33"), (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(conn, null, stmt);
        }
        conn = null;
        stmt = null;
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDeliveryVars", Messages.getString("RdbmsUserLog.34"), 5, 0, "DEBUG");
                script = this.getUpdateDatabase().insertALTID.createInsertIntoScript(this, UpdateDatabase.TableName.ACTION_ALTID_AAI, new UpdateDatabase.ColumnName[0]);
                stmt = conn.prepareStatement(script);
                for (ActionStatic actionStatic : sess.getDefaultActions()) {
                    for (String id : actionStatic.getAltIds().keySet()) {
                        String origin = actionStatic.getAltIds().get(id);
                        stmt.setString(this.getUpdateDatabase().insertALTID.index(UpdateDatabase.ColumnName.DLV_ID), DLV_ID);
                        stmt.setString(this.getUpdateDatabase().insertALTID.index(UpdateDatabase.ColumnName.ACT_ID), actionStatic.getActionId());
                        stmt.setString(this.getUpdateDatabase().insertALTID.index(UpdateDatabase.ColumnName.AAI_ID), id);
                        stmt.setString(this.getUpdateDatabase().insertALTID.index(UpdateDatabase.ColumnName.AAI_ORIGIN), origin);
                        stmt.execute();
                    }
                }
            }
            catch (Exception e) {
                Global.dLog.write(procName, "RdbmsUserLogI=>saveSessionDelivery", String.valueOf(Messages.getString("RdbmsUserLog.35")) + e.getMessage(), 0, 0, "ERROR");
                e.printStackTrace();
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.36"), (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(conn, null, stmt);
        }
    }

    private int getIntParameter(String parameter, int defaultValue) {
        try {
            String tmp = this.getProperty(parameter);
            if (tmp != null) {
                return Integer.parseInt(tmp);
            }
        }
        catch (Exception e) {
            Global.getLogger().debug("Invalid Configuration for " + parameter + ", fallback to default", (Throwable)e);
        }
        return defaultValue;
    }

    private boolean getBooleanParameter(String parameter, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getProperty(parameter));
        }
        catch (Exception e) {
            Global.getLogger().debug("Invalid Configuration for " + parameter + ", fallback to default", (Throwable)e);
            return defaultValue;
        }
    }

    private String getStringParameter(String parameter, String defaultValue) {
        try {
            String tmp = this.getProperty(parameter);
            if (tmp != null & !tmp.isEmpty()) {
                return tmp;
            }
        }
        catch (Exception e) {
            Global.getLogger().debug("Invalid Configuration for " + parameter + ", fallback to default", (Throwable)e);
        }
        return defaultValue;
    }

    int setParameters() throws EngineExceptionI {
        String userLogRdbmsInactivityDetectionPeriod;
        String userLogRdbmsActivityRefreshInterval;
        int ret = 0;
        try {
            this.userLogRdbmsDriver = this.getProperty("userLogRdbmsDriver");
            this.userLogRdbmsUrl = this.getProperty("userLogRdbmsUrl");
            this.userLogRdbmsUser = this.getProperty("userLogRdbmsUser");
            this.userLogRdbmsPassword = null;
            try {
                this.userLogRdbmsPassword = this.getProperty("userLogRdbmsPassword");
            }
            catch (EngineExceptionI e) {
                try {
                    String userLogRdbmsEncryptedPassword = this.getProperty("userLogRdbmsEncryptedPassword");
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    this.userLogRdbmsPassword = semaphoreManager.getStringAsciiInfo(userLogRdbmsEncryptedPassword);
                }
                catch (EngineExceptionI engineExceptionI) {
                    throw e;
                }
            }
            this.userLogRdbmsModule = this.getStringParameter("userLogRdbmsModule", null);
            this.userLogRdbmsPoolConnectionTimeout = this.getIntParameter("userLogRdbmsPoolConnectionTimeout", this.userLogRdbmsPoolConnectionTimeout);
            this.userLogRdbmsPoolEnabled = this.getBooleanParameter("userLogRdbmsPoolEnabled", this.userLogRdbmsPoolEnabled);
            this.userLogRdbmsPoolIdleTimeout = this.getIntParameter("userLogRdbmsPoolIdleTimeout", this.userLogRdbmsPoolIdleTimeout);
            this.userLogRdbmsPoolKeepAliveTime = this.getIntParameter("userLogRdbmsPoolKeepAliveTime", this.userLogRdbmsPoolKeepAliveTime);
            this.userLogRdbmsPoolMaxLifetime = this.getIntParameter("userLogRdbmsPoolMaxLifetime", this.userLogRdbmsPoolMaxLifetime);
            this.userLogRdbmsPoolMinimumIdle = this.getIntParameter("userLogRdbmsPoolMinimumIdle", this.userLogRdbmsPoolMinimumIdle);
            this.userLogRdbmsPoolMaximumSize = this.getIntParameter("userLogRdbmsPoolMaximumSize", this.userLogRdbmsPoolMaximumSize);
            this.userLogRdbmsPoolValidationTimeout = this.getIntParameter("userLogRdbmsPoolValidationTimeout", this.userLogRdbmsPoolValidationTimeout);
            this.userLogRdbmsPoolConnectionTestQuery = this.getStringParameter("userLogRdbmsPoolConnectionTestQuery", null);
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("RdbmsUserLog.37"), (Throwable)e);
        }
        this.autoUpdate = this.getBooleanParameter("autoUpdate", this.autoUpdate);
        this.useHaving = this.getBooleanParameter("useHavingInRequests", this.useHaving);
        try {
            this.columnAS = this.getProperty("columnAsKeyword");
            this.columnAS.trim();
            this.columnAS = this.columnAS.length() > 0 ? " " + this.columnAS + " " : " ";
        }
        catch (Exception exception) {}
        try {
            this.tableAS = this.getProperty("tableAsKeyword");
            this.tableAS.trim();
            this.tableAS = this.tableAS.length() > 0 ? " " + this.tableAS + " " : " ";
        }
        catch (Exception exception) {}
        this.userLogRdbmsDeleteSyntaxe = this.getStringParameter("userLogRdbmsDeleteSyntaxe", this.userLogRdbmsDeleteSyntaxe);
        try {
            this.userLogRdbmsSchemaName = this.getProperty("userLogRdbmsSchemaName");
            if (this.userLogRdbmsSchemaName == null) {
                this.userLogRdbmsSchemaName = "";
            }
            if (!this.userLogRdbmsSchemaName.equals("")) {
                this.userLogRdbmsSchemaName = String.valueOf(this.userLogRdbmsSchemaName) + ".";
            }
        }
        catch (EngineExceptionI engineExceptionI) {
            this.userLogRdbmsSchemaName = "";
        }
        this.userLogRdbmsNumericType = this.getStringParameter("userLogRdbmsNumericType", this.userLogRdbmsNumericType);
        this.userLogRdbmsVarcharType = this.getStringParameter("userLogRdbmsVarcharType", this.userLogRdbmsVarcharType);
        this.userLogRdbmsClobType = this.getStringParameter("userLogRdbmsClobType", this.userLogRdbmsClobType);
        this.userLogRdbmsBlobType = this.getStringParameter("userLogRdbmsBlobType", this.userLogRdbmsBlobType);
        this.userLogRdbmsVarcharMaxSize = this.getStringParameter("userLogRdbmsVarcharMaxSize", this.userLogRdbmsVarcharMaxSize);
        this.propertyVarcharMaxSize = this.getIntParameter("userLogRdbmsPropertyMaxVarcharSize", this.propertyVarcharMaxSize);
        this.propertyClobMaxSize = this.getIntParameter("userLogRdbmsPropertyMaxClobSize", this.propertyClobMaxSize);
        try {
            String deliveryCompression = this.getProperty("userLogRdbmsDeliveryFormat");
            if (deliveryCompression != null && (deliveryCompression.toUpperCase().equals("BINARY") || deliveryCompression.toUpperCase().equals("COMPRESSED"))) {
                this.deliveryFormat = deliveryCompression.toUpperCase();
            }
        }
        catch (EngineExceptionI engineExceptionI) {}
        try {
            String userLogRdbmsPropertyBinaryFormat = this.getProperty("userLogRdbmsPropertyBinaryFormat");
            if (userLogRdbmsPropertyBinaryFormat != null) {
                this.propertyBinaryFormat = userLogRdbmsPropertyBinaryFormat.toUpperCase();
            }
        }
        catch (EngineExceptionI engineExceptionI) {}
        try {
            String userLogRdbmsCompressedLevel = this.getProperty("userLogRdbmsCompressedLevel");
            if (userLogRdbmsCompressedLevel != null) {
                if (userLogRdbmsCompressedLevel.equals("bestCompression")) {
                    this.compressionLevel = 9;
                } else if (userLogRdbmsCompressedLevel.equals("bestSpeed")) {
                    this.compressionLevel = 9;
                } else if (userLogRdbmsCompressedLevel.equals("default")) {
                    this.compressionLevel = -1;
                }
            }
        }
        catch (EngineExceptionI engineExceptionI) {}
        this.userLogRdbmsUseSchemaNameForIndexCreation = this.getBooleanParameter("userLogRdbmsUseSchemaNameForIndexCreation", this.userLogRdbmsUseSchemaNameForIndexCreation);
        this.userLogRdbmsTablePrefix = this.getStringParameter("userLogRdbmsTablePrefix", "STB_LOG_");
        this.userLogRdbmsTimestampQuery = this.getStringParameter("userLogRdbmsTimestampQuery", this.userLogRdbmsTimestampQuery);
        try {
            this.userLogRdbmsTableCreationOption = this.getProperty("userLogRdbmsTableCreationOption");
            this.userLogRdbmsTableCreationOption = this.userLogRdbmsTableCreationOption.replace("\\n", "\n");
            this.userLogRdbmsTableCreationOption = this.userLogRdbmsTableCreationOption.replace("\\t", "\t");
            this.userLogRdbmsTableCreationOption = this.userLogRdbmsTableCreationOption.replace("\\r", "\r");
        }
        catch (EngineExceptionI engineExceptionI) {
            this.userLogRdbmsTableCreationOption = "";
        }
        try {
            this.userLogRdbmsIndexCreationOption = this.getProperty("userLogRdbmsIndexCreationOption");
            this.userLogRdbmsIndexCreationOption = this.userLogRdbmsIndexCreationOption.replace("\\n", "\n");
            this.userLogRdbmsIndexCreationOption = this.userLogRdbmsIndexCreationOption.replace("\\t", "\t");
            this.userLogRdbmsIndexCreationOption = this.userLogRdbmsIndexCreationOption.replace("\\r", "\r");
        }
        catch (EngineExceptionI engineExceptionI) {
            this.userLogRdbmsIndexCreationOption = "";
        }
        if (this.userLogRdbmsTimestampQuery == null) {
            try {
                this.userLogRdbmsTimestampQuery = this.getProperty("userLogRdbmsQueryTimestamp");
            }
            catch (EngineExceptionI engineExceptionI) {
                this.userLogRdbmsTimestampQuery = null;
            }
        }
        try {
            userLogRdbmsActivityRefreshInterval = this.getProperty("userLogRdbmsActivityRefreshInterval");
        }
        catch (EngineExceptionI engineExceptionI) {
            userLogRdbmsActivityRefreshInterval = null;
        }
        if (userLogRdbmsActivityRefreshInterval != null) {
            try {
                this.userLogRdbmsActivityRefreshIntervalLong = Long.parseLong(userLogRdbmsActivityRefreshInterval);
                if (this.userLogRdbmsActivityRefreshIntervalLong > 0L && this.userLogRdbmsActivityRefreshIntervalLong < 1000L) {
                    this.userLogRdbmsActivityRefreshIntervalLong = 10000L;
                }
            }
            catch (Exception exception) {
                this.userLogRdbmsActivityRefreshIntervalLong = 60000L;
            }
        }
        try {
            userLogRdbmsInactivityDetectionPeriod = this.getProperty("userLogRdbmsInactivityDetectionPeriod");
        }
        catch (EngineExceptionI engineExceptionI) {
            userLogRdbmsInactivityDetectionPeriod = null;
        }
        if (userLogRdbmsInactivityDetectionPeriod != null) {
            try {
                this.userLogRdbmsInactivityDetectionPeriodLong = Long.parseLong(userLogRdbmsInactivityDetectionPeriod);
            }
            catch (Exception exception) {
                this.userLogRdbmsInactivityDetectionPeriodLong = 90000L;
            }
        }
        if (this.userLogRdbmsInactivityDetectionPeriodLong <= 0L) {
            this.userLogRdbmsActivityRefreshIntervalLong = -1L;
        }
        if (this.userLogRdbmsActivityRefreshIntervalLong <= 0L) {
            this.userLogRdbmsInactivityDetectionPeriodLong = -1L;
        }
        if (this.userLogRdbmsInactivityDetectionPeriodLong < this.userLogRdbmsActivityRefreshIntervalLong) {
            this.userLogRdbmsInactivityDetectionPeriodLong = this.userLogRdbmsActivityRefreshIntervalLong * 10L / 8L;
        }
        try {
            String _userLogRdbmsDeletionWithNotExists = this.getProperty("userLogRdbmsDeletionWithNotExists");
            this.userLogRdbmsDeletionWithNotExists = Boolean.valueOf(_userLogRdbmsDeletionWithNotExists);
        }
        catch (EngineExceptionI engineExceptionI) {
            this.userLogRdbmsDeletionWithNotExists = true;
        }
        try {
            String _userLogRdbmsUseAliasTableForDeleteClause = this.getProperty("userLogRdbmsUseAliasTableForDeleteClause");
            this.userLogRdbmsUseAliasTableForDeleteClause = Boolean.valueOf(_userLogRdbmsUseAliasTableForDeleteClause);
        }
        catch (EngineExceptionI engineExceptionI) {
            this.userLogRdbmsUseAliasTableForDeleteClause = false;
        }
        this.DELIVERY = "DELIVERY_DLV";
        this.SESSION = "SESSION_SESS";
        this.PROPERTY = "ACTION_PROP_ACP";
        this.LINK = "LINK_LNK";
        this.ACTION = "ACTION_ACT";
        this.LG_VERSION_V = "VERSION_V";
        this.USER_LOG = "USER_ACTION_LOG_UAL";
        this.TECH_LOG = "TECH_ACTION_LOG_TAL";
        this.LG_SESSION_CHILDS_CSES = "SESSION_CHILDS_CSES";
        this.FULL_PROPERTY = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.PROPERTY;
        this.FULL_DELIVERY = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.DELIVERY;
        this.FULL_SESSION = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.SESSION;
        this.FULL_LINK = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.LINK;
        this.FULL_CHILD_SESSION = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.LG_SESSION_CHILDS_CSES;
        this.FULL_VERSION = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.LG_VERSION_V;
        this.FULL_ACTION = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.ACTION;
        this.FULL_USER_LOG = String.valueOf(this.userLogRdbmsSchemaName) + this.userLogRdbmsTablePrefix + this.USER_LOG;
        this.set = new Set();
        this.get = new Get();
        this.query = new Query();
        this.ddl = new DDL();
        return ret;
    }

    private void cleanInexist(Statement stmt, String msg) throws SQLException {
        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.38"));
        stmt.execute(this.query.getDeleteInexistantActionQuery());
        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.39"));
        stmt.execute(this.query.getDeleteInexistantChildSessionQuery());
        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.40"));
        stmt.execute(this.query.getDeleteInexistantDeliveryQuery());
        if (this.intVersion >= 1611) {
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.41"));
            stmt.execute(this.query.getDeleteInexistantUALQuery());
        }
        if (this.intVersion >= 1700) {
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.42"));
            stmt.execute(this.query.getDeleteInexistantActionStatic());
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.43"));
            stmt.execute(this.query.getDeleteInexistantPropertiesStaticQuery());
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.44"));
            stmt.execute(this.query.getDeleteInexistantActionStat());
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.45"));
            stmt.execute(this.query.getDeleteInexistantProcessStat());
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.46"));
            stmt.execute(this.query.getDeleteInexistantSessionStat());
            this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.47"));
            stmt.execute(this.query.getDeleteInexistantAltId());
        }
        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.48"));
        stmt.execute(this.query.getDeleteInexistantLinksQuery());
        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.49"));
        stmt.execute(this.query.getDeleteInexistantPropertiesQuery());
    }

    @Override
    public int purgeLogs(Date untilDate, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        int ret = 0;
        Connection conn = null;
        Statement stmt = null;
        Statement ps = null;
        try {
            try {
                conn = this.getConnection(true, true);
                SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
                String date = dateFormat.format(untilDate);
                String msg = String.valueOf(Messages.getString("RdbmsUserLog.50")) + date;
                stmt = conn.createStatement();
                String _queryDoneBatch = this.formatQueryWitiSessFilters(this.query.deleteDoneSessionBetweenQuery(), filters, statusList, currentRuntime);
                String _queryDoneUntil = this.formatQueryWitiSessFilters(this.query.deleteSessionUntilQuery(date), filters, statusList, currentRuntime);
                HashMap<String, String> dates = new HashMap<String, String>();
                int deleted = 0;
                int i = 0;
                if (Global.logPurgeBatchSize > 0) {
                    this.logger.info(String.valueOf(Messages.getString("RdbmsUserLog.51")) + Global.logPurgeBatchSize + ")...");
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.52"));
                    PreparedStatement selectPs = null;
                    String _select = String.valueOf(this.formatQueryWitiSessFilters(this.query.selectSessionUntil(date), filters, statusList, currentRuntime)) + " order by SESS_BEGIN_DATE";
                    selectPs = conn.prepareStatement(_select);
                    ResultSet rs = selectPs.executeQuery();
                    String curDate = null;
                    String beginDate = null;
                    while (rs.next()) {
                        curDate = rs.getString(1);
                        if (++i == 1) {
                            beginDate = curDate;
                        }
                        if (i != Global.logPurgeBatchSize) continue;
                        i = 0;
                        dates.put(beginDate, curDate);
                        curDate = null;
                        beginDate = null;
                    }
                    if (beginDate != null && curDate != null) {
                        dates.put(beginDate, curDate);
                    }
                    for (Map.Entry entry : dates.entrySet()) {
                        ps = conn.prepareStatement(_queryDoneBatch);
                        ps.setString(1, (String)entry.getKey());
                        ps.setString(2, (String)entry.getValue());
                        int size = ps.executeUpdate();
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.53") + size + Messages.getString("RdbmsUserLog.54") + (size > 1 ? "s" : ""));
                        deleted += size;
                    }
                } else {
                    this.logger.info(Messages.getString("RdbmsUserLog.55"));
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.56"));
                    this.formatQueryWitiSessFilters(this.query.deleteSessionUntilQuery(date), filters, statusList, currentRuntime);
                    ps = conn.prepareStatement(_queryDoneUntil);
                    int size = ps.executeUpdate();
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.57") + size + Messages.getString("RdbmsUserLog.58") + (size > 1 ? "s" : ""));
                    deleted += size;
                }
                this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.59") + deleted);
                this.cleanInexist(stmt, msg);
                this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.60"));
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.61"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.62")) + e.getMessage());
                }
                ps = null;
            }
            this.releaseConnection(conn, null, stmt);
            throw throwable;
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.62")) + e.getMessage());
            }
            ps = null;
        }
        this.releaseConnection(conn, null, stmt);
        return ret;
    }

    @Override
    public int deleteSession(String sessionId, int loglevel) throws EngineExceptionI {
        int ret = 0;
        Connection conn = null;
        Statement st = null;
        try {
            try {
                conn = this.getConnection(true, true);
                String msg = String.valueOf(Messages.getString("RdbmsUserLog.63")) + sessionId;
                this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.64"));
                st = conn.createStatement();
                if (loglevel < 100) {
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.65"));
                    st.execute(this.query.deleteSessionQuery(sessionId));
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.66"));
                    st.execute(this.query.deleteChildSessionQuery(sessionId));
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.67"));
                    st.execute(this.query.getDeleteInexistantDeliveryQuery());
                    if (this.intVersion >= 1700) {
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.68"));
                        st.execute(this.query.deleteSessionStat(sessionId));
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.69"));
                        st.execute(this.query.getDeleteInexistantActionStatic());
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.70"));
                        st.execute(this.query.getDeleteInexistantPropertiesStaticQuery());
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.71"));
                        st.execute(this.query.getDeleteInexistantAltId());
                    }
                }
                if (loglevel < 200) {
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.72"));
                    st.execute(this.query.deleteSessionProcessStat(sessionId));
                    if (this.intVersion >= 1700) {
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.73"));
                        st.execute(this.query.deleteActionSessionQuery(sessionId, false));
                    }
                }
                if (loglevel < 300) {
                    if (loglevel >= 200) {
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.74"));
                        st.execute(this.query.deleteActionSessionQuery(sessionId, true));
                    }
                    if (this.intVersion >= 1700) {
                        this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.75"));
                        st.execute(this.query.deleteSessionActionStat(sessionId));
                    }
                    if (this.intVersion >= 1611) {
                        st.execute(this.query.deleteUALSessionQuery(sessionId));
                    }
                }
                if (loglevel < 400) {
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.76"));
                    st.execute(this.query.deleteLinkSessionQuery(sessionId));
                    this.logger.info(String.valueOf(msg) + Messages.getString("RdbmsUserLog.77"));
                    st.execute(this.query.deletePropertySessionQuery(sessionId));
                }
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.78"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, st);
            throw throwable;
        }
        this.releaseConnection(conn, null, st);
        return ret;
    }

    @Override
    public int createDelivery(SessionRecorder.DeliveryRecord dr) throws EngineExceptionI {
        this.saveSessionDelivery(dr);
        return 0;
    }

    @Override
    public int createSession(SessionRecorder.SessionStartRecord ssr) throws EngineExceptionI {
        this.saveSession(ssr);
        return 0;
    }

    @Override
    public void updateSessionActivity(SessionRecorder.SessionActivityRecord sar) throws EngineExceptionI {
        if (sar.getSessionStatus() == 2) {
            Connection conn = null;
            PreparedStatement st = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    PreparedStatement stmt = st = conn.prepareStatement(this.query.updateSessionDelta());
                    stmt.setLong(1, System.currentTimeMillis());
                    stmt.setString(2, sar.getSessionID());
                    stmt.setInt(3, sar.getSessionIter());
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    Global.dLog.write(sar.getSessionName(), "RdbmsUserLogI=>updateSessionActivity", String.valueOf(Messages.getString("RdbmsUserLog.79")) + e.getMessage(), 0, 0, "ERROR");
                    this.error("createSession", String.valueOf(Messages.getString("RdbmsUserLog.80")) + sar.getSessionName(), e);
                    throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.81")) + sar.getSessionName(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, st);
                throw throwable;
            }
            this.releaseConnection(conn, null, st);
        }
    }

    private int saveSession(SessionRecorder.SessionStartRecord mainEngine) throws EngineExceptionI {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
        Connection conn = null;
        PreparedStatement st = null;
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>createSession", Messages.getString("RdbmsUserLog.82"), 5, 0, "DEBUG");
                PreparedStatement stmt = st = conn.prepareStatement(this.query.createSessionQuery(this.getSessionActivityDelta() > 0L));
                stmt.setString(1, mainEngine.getSessionID());
                stmt.setString(2, mainEngine.getSessionName());
                stmt.setInt(3, mainEngine.getSessionIter());
                stmt.setString(4, dateFormat.format(mainEngine.getBeginDate()));
                stmt.setString(5, Global.HTTP_HOST);
                stmt.setInt(6, Global.HTTP_PORT);
                stmt.setString(7, mainEngine.getSessionStatic().getDlvId());
                stmt.setString(8, mainEngine.getLaunchMode());
                stmt.setString(9, mainEngine.getExecutionMode());
                stmt.setString(10, mainEngine.getGuestHost());
                stmt.setString(11, mainEngine.getConfiguration());
                if (this.intVersion >= 1604) {
                    stmt.setString(12, mainEngine.getParentSessionId());
                }
                if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    int index = 13;
                    stmt.setString(index++, this.version);
                    stmt.setLong(index++, mainEngine.getBeginDate().getTime());
                    stmt.setString(index++, mainEngine.getActionId());
                    stmt.setLong(index++, this.offset);
                    stmt.setInt(index++, mainEngine.getParentSessionIter());
                    if (this.getSessionActivityDelta() > 0L) {
                        stmt.setLong(index++, this.userLogRdbmsInactivityDetectionPeriodLong);
                        stmt.setLong(index++, System.currentTimeMillis());
                    }
                    if (this.intVersion >= 1740) {
                        stmt.setString(index++, mainEngine.getUserName());
                    }
                }
                stmt.executeUpdate();
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>createSession", Messages.getString("RdbmsUserLog.83"), 5, 0, "DEBUG");
            }
            catch (Exception e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>createSession", String.valueOf(Messages.getString("RdbmsUserLog.84")) + e.getMessage(), 0, 0, "ERROR");
                this.error("createSession", String.valueOf(Messages.getString("RdbmsUserLog.85")) + mainEngine.getSessionName(), e);
                throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.86")) + mainEngine.getSessionName(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, st);
            throw throwable;
        }
        this.releaseConnection(conn, null, st);
        return ret;
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public int closeSession(SessionRecorder.SessionEndRecord mainEngine) throws EngineExceptionI {
        int ret = 0;
        Connection conn = null;
        PreparedStatement st = null;
        boolean done = false;
        try {
            try {
                conn = this.getConnection(true, false);
                SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>closeSession", Messages.getString("RdbmsUserLog.87"), 5, 0, "DEBUG");
                st = conn.prepareStatement(this.query.closeSessionQuery());
                int index = 1;
                st.setString(index++, dateFormat.format(mainEngine.getEndDate()));
                mainEngine.getSessionStatus();
                st.setInt(index++, mainEngine.getSessionStatus());
                st.setString(index++, mainEngine.getSessionMsg());
                if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    st.setLong(index++, mainEngine.getElapseTIme());
                }
                st.setString(index++, mainEngine.getSessionID());
                st.setInt(index++, mainEngine.getSessionIter());
                st.executeUpdate();
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>closeSession", Messages.getString("RdbmsUserLog.88"), 5, 0, "DEBUG");
                done = true;
            }
            catch (Exception e) {
                this.error("closeSession", String.valueOf(Messages.getString("RdbmsUserLog.89")) + mainEngine.getSessionName(), e);
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>closeSession", String.valueOf(Messages.getString("RdbmsUserLog.90")) + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.91"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, st);
            throw throwable;
        }
        this.releaseConnection(conn, null, st);
        if (done && this.intVersion >= UpdateDatabase.Version.V1700.num()) {
            this.closeSessionStat(mainEngine);
        }
        return ret;
    }

    private void closeSessionStat(SessionRecorder.SessionEndRecord mainEngine) throws EngineExceptionI {
        Collection<SessionRecorder.AggregateRecord> aggrs = mainEngine.getAggregates();
        if (aggrs != null && aggrs.size() > 0) {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    String script = this.getUpdateDatabase().insertSST.createInsertIntoScript(this, UpdateDatabase.TableName.SESSION_STAT_SST, new UpdateDatabase.ColumnName[0]);
                    stmt = conn.prepareStatement(script);
                    for (SessionRecorder.AggregateRecord aggr : aggrs) {
                        stmt.setString(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SESS_ID), mainEngine.getSessionID());
                        stmt.setInt(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SESS_ITER), mainEngine.getSessionIter());
                        stmt.setString(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.ACP_SHORT_NAME), aggr.getName());
                        stmt.setLong(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SST_STAT_SUM), aggr.getSum());
                        stmt.setInt(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SST_STAT_COUNT), aggr.getCount());
                        stmt.setLong(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SST_STAT_MIN), aggr.getMin());
                        stmt.setLong(this.getUpdateDatabase().insertSST.index(UpdateDatabase.ColumnName.SST_STAT_MAX), aggr.getMax());
                        stmt.execute();
                    }
                }
                catch (Exception e) {
                    this.error("closeSession", String.valueOf(Messages.getString("RdbmsUserLog.92")) + mainEngine.getSessionName(), e);
                    Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>closeSession", String.valueOf(Messages.getString("RdbmsUserLog.93")) + e.getMessage(), 0, 0, "ERROR");
                    throw new EngineExceptionI(Messages.getString("RdbmsUserLog.94"), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, stmt);
        }
    }

    @Override
    public int restartSession(SessionRecorder.SessionStartRecord mainEngine) throws EngineExceptionI {
        int ret = 0;
        try {
            this.saveSession(mainEngine);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLogI=>restartSession", String.valueOf(Messages.getString("RdbmsUserLog.95")) + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("RdbmsUserLog.96"), (Throwable)e);
        }
        return ret;
    }

    @Override
    public int finalizeAction(SessionRecorder.ActionEndRecord action) throws EngineExceptionI {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean done = false;
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>finalizeAction", String.valueOf(Messages.getString("RdbmsUserLog.97")) + action.getAction().getActionName(), 6, 0, "DEBUG");
                stmt = conn.prepareStatement(this.query.finalizeActionQuery());
                int index = 1;
                stmt.setString(index++, dateFormat.format(action.getEndDate()));
                stmt.setInt(index++, action.getActionState());
                if (action.getActionErrorMsg() != null && !action.getActionErrorMsg().isEmpty()) {
                    stmt.setString(index++, action.getActionErrorMsg());
                } else {
                    stmt.setString(index++, null);
                }
                if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    stmt.setInt(index++, action.getNbExecution());
                    stmt.setLong(index++, action.getCurrentBindIteration());
                    stmt.setInt(index++, action.getNumAction());
                }
                stmt.setString(index++, action.getSessionID());
                stmt.setInt(index++, action.getSessionIter());
                stmt.setString(index++, action.getAction().getActionId());
                stmt.setInt(index++, action.getAction().getActionIteration());
                stmt.executeUpdate();
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>finalizeAction", String.valueOf(Messages.getString("RdbmsUserLog.98")) + action.getAction().getActionName(), 6, 0, "DEBUG");
                done = true;
            }
            catch (SQLException e) {
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>finalizeAction", String.valueOf(Messages.getString("RdbmsUserLog.99")) + action.getAction().getActionName() + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.100"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, stmt);
            throw throwable;
        }
        this.releaseConnection(conn, null, stmt);
        if (done && this.intVersion >= UpdateDatabase.Version.V1700.num()) {
            if (action.isProcess()) {
                this.finalizeProcessStat(action);
            } else {
                this.finalizeActionStat(action);
            }
        }
        return ret;
    }

    private void finalizeActionStat(SessionRecorder.ActionEndRecord action) throws EngineExceptionI {
        Collection<SessionRecorder.AggregateRecord> aggrs = action.getAggregates();
        if (aggrs != null && aggrs.size() > 0) {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>action", String.valueOf(Messages.getString("RdbmsUserLog.101")) + action.getAction().getActionName(), 6, 0, "DEBUG");
                    String script = this.getUpdateDatabase().insertAST.createInsertIntoScript(this, UpdateDatabase.TableName.ACTION_STAT_AST, new UpdateDatabase.ColumnName[0]);
                    stmt = conn.prepareStatement(script);
                    for (SessionRecorder.AggregateRecord _aggr : aggrs) {
                        stmt.setString(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.SESS_ID), action.getSessionID());
                        stmt.setInt(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.SESS_ITER), action.getSessionIter());
                        stmt.setString(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.ACT_ID), action.getAction().getActionId());
                        stmt.setInt(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.ACT_ITER), action.getAction().getActionIteration());
                        stmt.setString(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.ACP_SHORT_NAME), _aggr.getName());
                        stmt.setLong(this.getUpdateDatabase().insertAST.index(UpdateDatabase.ColumnName.AST_STAT_SUM), _aggr.getSum());
                        stmt.execute();
                    }
                }
                catch (SQLException e) {
                    Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>finalizeActionStat", String.valueOf(Messages.getString("RdbmsUserLog.102")) + action.getAction().getActionName() + " : " + e.getMessage(), 0, 0, "ERROR");
                    throw new EngineExceptionI(Messages.getString("RdbmsUserLog.103"), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, stmt);
        }
    }

    private void finalizeProcessStat(SessionRecorder.ActionEndRecord action2) throws EngineExceptionI {
        Collection<SessionRecorder.AggregateRecord> aggrs = action2.getAggregates();
        if (aggrs != null && aggrs.size() > 0) {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    Global.dLog.write(action2.getSessionID(), "RdbmsUserLogI=>finalizeActionStat", String.valueOf(Messages.getString("RdbmsUserLog.104")) + action2.getAction().getActionName(), 6, 0, "DEBUG");
                    String script = this.getUpdateDatabase().insertPST.createInsertIntoScript(this, UpdateDatabase.TableName.PROCESS_STAT_PST, new UpdateDatabase.ColumnName[0]);
                    stmt = conn.prepareStatement(script);
                    for (SessionRecorder.AggregateRecord _aggr : aggrs) {
                        stmt.setString(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.SESS_ID), action2.getSessionID());
                        stmt.setInt(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.SESS_ITER), action2.getSessionIter());
                        stmt.setString(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.ACT_ID), action2.getAction().getActionId());
                        stmt.setInt(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.ACT_ITER), action2.getAction().getActionIteration());
                        stmt.setString(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.ACP_SHORT_NAME), _aggr.getName());
                        stmt.setLong(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.PST_STAT_SUM), _aggr.getSum());
                        stmt.setInt(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.PST_STAT_COUNT), _aggr.getCount());
                        stmt.setLong(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.PST_STAT_MIN), _aggr.getMin());
                        stmt.setLong(this.getUpdateDatabase().insertPST.index(UpdateDatabase.ColumnName.PST_STAT_MAX), _aggr.getMax());
                        stmt.execute();
                    }
                }
                catch (SQLException e) {
                    Global.dLog.write(action2.getSessionID(), "RdbmsUserLogI=>finalizeActionStat", String.valueOf(Messages.getString("RdbmsUserLog.105")) + action2.getAction().getActionName() + " : " + e.getMessage(), 0, 0, "ERROR");
                    throw new EngineExceptionI(Messages.getString("RdbmsUserLog.106"), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, stmt);
        }
    }

    @Override
    public int addAction(SessionRecorder.ActionStartRecord action) throws EngineExceptionI {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection(true, false);
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>addAction", Messages.getString("RdbmsUserLog.107"), 6, 0, "DEBUG");
                stmt = conn.prepareStatement(this.query.addActionQuery());
                stmt.setString(1, action.getSessionID());
                stmt.setInt(2, action.getSessionIter());
                stmt.setString(3, action.getAction().getActionId());
                stmt.setInt(4, action.getAction().getActionIteration());
                stmt.setString(5, action.getActionRuntimeName());
                stmt.setString(6, action.getActionStatic().getActionType());
                stmt.setString(7, dateFormat.format(action.getBeginDate()));
                String tmp = action.getFatherId();
                if (tmp == null) {
                    tmp = "";
                }
                stmt.setString(8, tmp);
                if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                    if (action.hasFather()) {
                        stmt.setInt(9, action.getParentIteration());
                    } else {
                        stmt.setInt(9, 0);
                    }
                    stmt.setString(10, action.getRuntimeShortName());
                    stmt.setInt(11, action.getBeginAction() ? 1 : 0);
                    stmt.setInt(12, action.getNumAction());
                    stmt.setInt(13, action.getActionState());
                }
                stmt.executeUpdate();
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>addProcess", Messages.getString("RdbmsUserLog.108"), 5, 0, "DEBUG");
            }
            catch (Exception e) {
                this.error("addAction", String.valueOf(Messages.getString("RdbmsUserLog.109")) + action.getAction().getActionName(), e);
                Global.dLog.write(action.getSessionID(), "RdbmsUserLogI=>addAction", String.valueOf(Messages.getString("RdbmsUserLog.110")) + action.getAction().getActionName() + "' : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.111")) + action.getAction().getActionName(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, stmt);
            throw throwable;
        }
        this.releaseConnection(conn, null, stmt);
        return ret;
    }

    @Override
    public int addChildSession(SessionRecorder.ChildSessionRecord csr) throws EngineExceptionI {
        int ret;
        block6: {
            ret = 0;
            String sessId = csr.getSessionID();
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    Global.dLog.write(csr.getSessionID(), "RdbmsUserLogI=>addChildSession", String.valueOf(Messages.getString("RdbmsUserLog.112")) + sessId, 6, 0, "DEBUG");
                    stmt = conn.prepareStatement(this.query.addChildSessionQuery());
                    stmt.setString(1, sessId);
                    stmt.setInt(2, csr.getSessionIter());
                    stmt.setString(3, csr.getAction().getActionId());
                    stmt.setString(4, csr.getChildSessionId());
                    if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                        stmt.setInt(5, csr.getAction().getActionIteration());
                        stmt.setInt(6, csr.getIteration());
                    }
                    stmt.executeUpdate();
                    Global.dLog.write(csr.getSessionID(), "RdbmsUserLogI=>addChildSession", Messages.getString("RdbmsUserLog.113"), 6, 0, "DEBUG");
                }
                catch (SQLException e) {
                    this.error("addChildSession", Messages.getString("RdbmsUserLog.114"), e);
                    Global.dLog.write(csr.getSessionID(), "RdbmsUserLogI=>addChildSession", String.valueOf(Messages.getString("RdbmsUserLog.115")) + e.getMessage(), 0, 0, "ERROR");
                    ret = -1;
                    this.releaseConnection(conn, null, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, stmt);
        }
        return ret;
    }

    @Override
    public int reportProperty(SessionRecorder.VariableRecord var) throws EngineExceptionI {
        int ret = 0;
        String varValue = var.getValue();
        String varSource = var.getSource();
        String varName = var.getName();
        boolean equals = varSource != null && varSource.equals(varValue);
        String bndVal = null;
        bndVal = var.getLastBindedValue();
        if (var.getVariablePublicationMode() == VariablePublicationMode.DYNAMIC || var.getVariablePublicationMode() == VariablePublicationMode.STATIC && var.isOriginalSourceModified() || !equals || bndVal != null) {
            Connection conn = null;
            Object stmt = null;
            String txtCode = null;
            try {
                try {
                    conn = this.getConnection(true, false);
                    String fields = "SESS_ID, SESS_ITER, ACT_ID, ACT_ITER, ACP_NAME, ACP_TYPE, ACP_SHORT_NAME, ACP_CUMUL";
                    String values = "?,?,?,?,?,?,?,?";
                    Global.dLog.write(var.getSessionID(), "RdbmsUserLogI=>reportProperty", String.valueOf(Messages.getString("RdbmsUserLog.116")) + varName + "' in " + this.FULL_PROPERTY + " : " + varName, 6, 0, "DEBUG");
                    BigDecimal cumul = null;
                    if (var.getCumulativeValue() != null) {
                        if (var.getType().equals("Integer")) {
                            cumul = BigDecimal.valueOf(Integer.valueOf((Integer)var.getCumulativeValue()).intValue());
                        } else if (var.getType().equals("Long")) {
                            cumul = BigDecimal.valueOf((Long)var.getCumulativeValue());
                        } else if (var.getType().equals("Float")) {
                            cumul = BigDecimal.valueOf((Double)var.getCumulativeValue());
                        }
                    }
                    String exeFormat = "";
                    exeFormat = varValue == null || varValue.length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || varValue.length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                    fields = String.valueOf(fields) + ",ACP_EXE_FORMAT";
                    fields = String.valueOf(fields) + ",ACP_EXE_" + exeFormat;
                    values = String.valueOf(values) + ",?,?";
                    String srcFormat = "";
                    if (!equals && var.getVariablePublicationMode() == VariablePublicationMode.DYNAMIC) {
                        srcFormat = varSource == null || varSource.length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || varSource.length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                        fields = String.valueOf(fields) + ",ACP_SRC_FORMAT, ";
                        fields = String.valueOf(fields) + "ACP_SRC_" + srcFormat;
                        values = String.valueOf(values) + ",?,?";
                    }
                    String bndFormat = "";
                    if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                        fields = String.valueOf(fields) + "," + (Object)((Object)UpdateDatabase.ColumnName.PTY_TYPE_N);
                        fields = String.valueOf(fields) + "," + (Object)((Object)UpdateDatabase.ColumnName.ACP_NUM);
                        values = String.valueOf(values) + ",?,?";
                        if (bndVal != null) {
                            bndFormat = bndVal.length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || bndVal.length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                            fields = String.valueOf(fields) + ",ACP_BND_FORMAT, ";
                            fields = String.valueOf(fields) + "ACP_BND_" + bndFormat;
                            values = String.valueOf(values) + ",?,?";
                        }
                    }
                    txtCode = "Insert into " + this.FULL_PROPERTY + " (" + fields + ") values (" + values + ")";
                    stmt = conn.prepareStatement(txtCode);
                    int index = 1;
                    stmt.setString(index++, var.getSessionID());
                    stmt.setInt(index++, var.getSessionIter());
                    if (!var.isSession()) {
                        stmt.setString(index++, var.getAction().getActionId());
                        stmt.setInt(index++, var.getAction().getActionIteration());
                    } else {
                        stmt.setString(index++, "0");
                        stmt.setInt(index++, 0);
                    }
                    stmt.setString(index++, varName);
                    stmt.setString(index++, var.getType());
                    stmt.setString(index++, var.getShortName());
                    stmt.setBigDecimal(index++, cumul);
                    if (exeFormat.equals("VAR")) {
                        stmt.setString(index++, "VARCHAR");
                        stmt.setString(index++, varValue);
                    } else if (exeFormat.equals("CLO")) {
                        stmt.setString(index++, "CLOB");
                        this.set.putStringClob(varValue, (PreparedStatement)stmt, index++);
                    } else if (this.propertyBinaryFormat.equals("COMPRESSED")) {
                        stmt.setString(index++, "BLOB_COMPRESSED");
                        this.set.putInputStreamnCompressed((InputStream)new StringInputStream(varValue), (PreparedStatement)stmt, index++);
                    } else {
                        stmt.setString(index++, "BLOB");
                        this.set.putStringBlob(varValue, (PreparedStatement)stmt, index++);
                    }
                    if (!equals && var.getVariablePublicationMode() == VariablePublicationMode.DYNAMIC) {
                        if (srcFormat.equals("VAR")) {
                            stmt.setString(index++, "VARCHAR");
                            stmt.setString(index++, varSource);
                        } else if (srcFormat.equals("CLO")) {
                            stmt.setString(index++, "CLOB");
                            this.set.putStringClob(varSource, (PreparedStatement)stmt, index++);
                        } else if (this.propertyBinaryFormat.equals("COMPRESSED")) {
                            stmt.setString(index++, "BLOB_COMPRESSED");
                            this.set.putInputStreamnCompressed((InputStream)new StringInputStream(varSource), (PreparedStatement)stmt, index++);
                        } else {
                            stmt.setString(index++, "BLOB");
                            this.set.putStringBlob(varSource, (PreparedStatement)stmt, index++);
                        }
                    }
                    if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                        VariableDataType vdt = VariableDataType.getVariableDataType((String)var.getType());
                        if (vdt != null) {
                            stmt.setInt(index++, vdt.getNum());
                        } else {
                            stmt.setInt(index++, -1);
                        }
                        stmt.setLong(index++, var.getNum());
                        if (bndVal != null) {
                            if (bndFormat.equals("VAR")) {
                                stmt.setString(index++, "VARCHAR");
                                stmt.setString(index++, bndVal);
                            } else if (bndFormat.equals("CLO")) {
                                stmt.setString(index++, "CLOB");
                                this.set.putStringClob(bndVal, (PreparedStatement)stmt, index++);
                            } else if (this.propertyBinaryFormat.equals("COMPRESSED")) {
                                stmt.setString(index++, "BLOB_COMPRESSED");
                                this.set.putInputStreamnCompressed((InputStream)new StringInputStream(bndVal), (PreparedStatement)stmt, index++);
                            } else {
                                stmt.setString(index++, "BLOB");
                                this.set.putStringBlob(bndVal, (PreparedStatement)stmt, index++);
                            }
                        }
                    }
                    stmt.executeUpdate();
                    Global.dLog.write(var.getSessionID(), "RdbmsUserLogI=>reportProperty", Messages.getString("RdbmsUserLog.117"), 6, 0, "DEBUG");
                }
                catch (Exception e) {
                    Global.dLog.write(var.getSessionID(), "RdbmsUserLogI=>reportProperty", String.valueOf(Messages.getString("RdbmsUserLog.118")) + e.getMessage(), 0, 0, "ERROR");
                    ret = -1;
                    String msg = String.valueOf(Messages.getString("RdbmsUserLog.119")) + (var.getAction() != null ? var.getAction().getActionName() : "") + "\n" + var + "\nquery: " + txtCode + "\nstatement: " + stmt != null ? stmt.toString() : "";
                    this.error("reportProperty", msg, e);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, (Statement)stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, (Statement)stmt);
        }
        return ret;
    }

    @Override
    public int reportLinkChanges(SessionRecorder.LinkRecord lr) throws EngineExceptionI {
        int ret;
        block21: {
            ret = 0;
            Connection conn = null;
            PreparedStatement stmt = null;
            conn = this.getConnection(true, false);
            try {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
                    String source = lr.getsCondition_sOriginScript();
                    String exe = lr.getsCondition_sScript();
                    String tmp = "";
                    String tmp2 = "";
                    String exeFormat = "";
                    String srcFormat = "";
                    boolean equals = true;
                    if (lr.getWithTxt() && exe != null && !exe.isEmpty()) {
                        tmp = ", LNK_EXE_FORMAT, ";
                        tmp2 = ",?,?";
                        exeFormat = exe.length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || exe.length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                        tmp = String.valueOf(tmp) + "LNK_EXE_" + exeFormat;
                        boolean bl = equals = source != null && source.equals(exe);
                        if (!equals) {
                            tmp = String.valueOf(tmp) + ",LNK_SRC_FORMAT, ";
                            tmp2 = String.valueOf(tmp2) + ",?,?";
                            srcFormat = source.length() <= this.propertyVarcharMaxSize ? "VAR" : (this.propertyClobMaxSize == -1 || source.length() <= this.propertyClobMaxSize ? "CLO" : "BLO");
                            tmp = String.valueOf(tmp) + "LNK_SRC_" + srcFormat;
                        }
                    }
                    String txtCode = "Insert into " + this.FULL_LINK + " (SESS_ID, SESS_ITER, LNK_ID, LNK_ITER, LNK_DATE, LNK_TYPE, LNK_MANDATORY, LNK_STATUS" + tmp + ") values (?,?,?,?,?,?,?,?" + tmp2 + ")";
                    stmt = conn.prepareStatement(txtCode);
                    stmt.setString(1, lr.getSessionID());
                    stmt.setInt(2, lr.getSessionIter());
                    stmt.setString(3, lr.getLinkStatic().getId());
                    stmt.setInt(4, lr.getIter());
                    stmt.setString(5, dateFormat.format(lr.getDate()));
                    stmt.setString(6, lr.getLinkStatic().getType());
                    stmt.setInt(7, lr.getLinkStatic().getMandatory());
                    stmt.setInt(8, lr.getState());
                    if (!exeFormat.isEmpty()) {
                        if (exeFormat.equals("VAR")) {
                            stmt.setString(9, "VARCHAR");
                            stmt.setString(10, exe);
                        } else if (exeFormat.equals("CLO")) {
                            stmt.setString(9, "CLOB");
                            this.set.putStringClob(exe, stmt, 10);
                        } else if (this.propertyBinaryFormat.equals("COMPRESSED")) {
                            stmt.setString(9, "BLOB_COMPRESSED");
                            this.set.putInputStreamnCompressed((InputStream)new StringInputStream(exe), stmt, 10);
                        } else {
                            stmt.setString(9, "BLOB");
                            this.set.putStringBlob(exe, stmt, 10);
                        }
                    }
                    if (!equals && !srcFormat.isEmpty()) {
                        if (srcFormat.equals("VAR")) {
                            stmt.setString(11, "VARCHAR");
                            stmt.setString(12, source);
                        } else if (srcFormat.equals("CLO")) {
                            stmt.setString(11, "CLOB");
                            this.set.putStringClob(source, stmt, 12);
                        } else if (this.propertyBinaryFormat.equals("COMPRESSED")) {
                            stmt.setString(11, "BLOB_COMPRESSED");
                            this.set.putInputStreamnCompressed((InputStream)new StringInputStream(source), stmt, 12);
                        } else {
                            stmt.setString(11, "BLOB");
                            this.set.putStringBlob(source, stmt, 12);
                        }
                    }
                    stmt.executeUpdate();
                    Global.dLog.write(lr.getSessionID(), "RdbmsUserLogI=>reportLinkChanges", Messages.getString("RdbmsUserLog.120"), 6, 0, "DEBUG");
                }
                catch (Exception e) {
                    Global.dLog.write(lr.getSessionID(), "RdbmsUserLogI=>reportLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.121")) + e.getMessage(), 0, 0, "ERROR");
                    ret = -1;
                    this.releaseConnection(conn, null, stmt);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, null, stmt);
                throw throwable;
            }
            this.releaseConnection(conn, null, stmt);
        }
        return ret;
    }

    @Override
    public Map<String, ISessionDataExchange> getLstClosedSessions() throws EngineExceptionI {
        Global.dLog.write("RdbmsUserLogI=>getLstClosedSessions", Messages.getString("RdbmsUserLog.122"), 6, 0, "DEBUG");
        return this.getSessionDataExchangeMapByQuery(this.query.getLstCloseSessionsQuery);
    }

    @Override
    public Map<String, ISessionDataExchange> getLstInactiveSessions() throws EngineExceptionI {
        Global.dLog.write("RdbmsUserLogI=>getLstInactiveSessions", Messages.getString("RdbmsUserLog.122"), 6, 0, "DEBUG");
        return this.getSessionDataExchangeMapByQuery(this.query.getLstInactiveSessionsQuery);
    }

    private Map<String, ISessionDataExchange> getSessionDataExchangeMapByQuery(String stringQuery) throws EngineExceptionI {
        TreeMap<String, ISessionDataExchange> lstSess = new TreeMap<String, ISessionDataExchange>();
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                sourceRSet = stmtSelect.executeQuery(stringQuery);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
                while (sourceRSet.next()) {
                    SessionDataExchange sde = new SessionDataExchange();
                    sde.setId(sourceRSet.getString("SESS_ID"));
                    sde.setName(sourceRSet.getString("SESS_NAME"));
                    sde.setBeginDate(dateFormat.parse(sourceRSet.getString("SESS_BEGIN_DATE")));
                    String sessionEndDate = sourceRSet.getString("SESS_END_DATE");
                    sde.setEndDate(sessionEndDate != null ? dateFormat.parse(sessionEndDate) : null);
                    sde.setStatus(sourceRSet.getInt("SESS_RET_CODE"));
                    sde.setIter(sourceRSet.getInt("SESS_ITER"));
                    sde.setMessage(sourceRSet.getString("SESS_RET_MSG"));
                    sde.setLogType("Log");
                    sde.setLogClassName("com.semarchy.xdi.runtime.sessionlog.RdbmsLogger");
                    lstSess.put(sde.getId(), (ISessionDataExchange)sde);
                }
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.123"), (Throwable)e);
            }
            catch (ParseException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.124"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        return lstSess;
    }

    private void copyRsetToSessionDataExchange(ResultSet sourceRSet, ISessionDataExchange sde, String sessId, long tstamp) throws SQLException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
        sde.setId(sessId);
        sde.setName(sourceRSet.getString("SESS_NAME"));
        sde.setIter(sourceRSet.getInt("SESS_ITER"));
        sde.setExecutionMode(sourceRSet.getString("SESS_EXECUTION_MODE"));
        sde.setLaunchMode(sourceRSet.getString("SESS_LAUNCH_MODE"));
        if (this.intVersion >= UpdateDatabase.Version.V1740.num()) {
            sde.setLaunchUser(sourceRSet.getString("SESS_LAUNCH_USER"));
        }
        sde.setGuestHost(sourceRSet.getString("SESS_GUEST_HOST"));
        sde.setBeginDate(dateFormat.parse(sourceRSet.getString("SESS_BEGIN_DATE")));
        String temp = sourceRSet.getString("SESS_END_DATE");
        if (temp != null) {
            sde.setEndDate(dateFormat.parse(temp));
        } else {
            sde.setEndDate(null);
        }
        temp = sourceRSet.getString("SESS_RET_CODE");
        if (temp != null) {
            sde.setStatus(sourceRSet.getInt("SESS_RET_CODE"));
        } else if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
            long SESS_INACT_TIMEOUT = sourceRSet.getLong("SESS_INACT_TIMEOUT");
            long SESS_LAST_TSTAMP = sourceRSet.getLong("SESS_LAST_TSTAMP");
            long SESS_TSTAMP_OFFSET = sourceRSet.getLong("SESS_TSTAMP_OFFSET");
            long tmp = SESS_LAST_TSTAMP + SESS_TSTAMP_OFFSET + SESS_INACT_TIMEOUT - tstamp;
            if (SESS_INACT_TIMEOUT <= 0L || tmp > 0L) {
                sde.setStatus(2);
            } else {
                sde.setStatus(-4);
            }
        } else {
            sde.setStatus(2);
        }
        temp = sourceRSet.getString("SESS_RET_MSG");
        if (temp != null) {
            sde.setMessage(temp);
        } else {
            sde.setMessage("");
        }
        sde.setEngineHost(sourceRSet.getString("SESS_ENGINE_HOST"));
        BigDecimal bd = sourceRSet.getBigDecimal("SESS_ENGINE_PORT");
        if (bd != null) {
            sde.setEnginePort(Integer.valueOf(bd.intValue()));
        }
        sde.setLogType("Log");
        sde.setLogClassName("com.semarchy.xdi.runtime.sessionlog.RdbmsLogger");
        sde.setConfiguration(sourceRSet.getString("SESS_CONF"));
        if (this.intVersion >= 1604) {
            sde.setParentSessionId(sourceRSet.getString("SESS_PARENT_ID"));
        }
        if (this.intVersion >= UpdateDatabase.Version.V1700.num()) {
            sde.setVersion(sourceRSet.getString(UpdateDatabase.ColumnName.V_VERSION.name()));
            sde.setDeliveryId(sourceRSet.getString(UpdateDatabase.ColumnName.DLV_ID.name()));
        }
    }

    @Override
    public int getActions(String sessionId, int sessIter, int lastNum, Map<String, IActionDataExchange> lstAct) throws EngineExceptionI {
        Global.dLog.write("RdbmsUserLog=>getActions", String.valueOf(Messages.getString("RdbmsUserLog.125")) + sessionId, 6, 0, "DEBUG");
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        int maxActNum = 0;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                String _query = this.query.getActionsQuery(sessionId, sessIter, lastNum);
                sourceRSet = stmtSelect.executeQuery(_query);
                HashSet<String> set = new HashSet<String>();
                while (sourceRSet.next()) {
                    String actId = sourceRSet.getString(UpdateDatabase.ColumnName.ACT_ID.name());
                    if (set.contains(actId)) continue;
                    int actIter = sourceRSet.getInt(UpdateDatabase.ColumnName.ACT_ITER.name());
                    int actNum = sourceRSet.getInt(UpdateDatabase.ColumnName.ACT_NUM.name());
                    if (actNum > maxActNum) {
                        maxActNum = actNum;
                    }
                    set.add(actId);
                    String strBeginDate = sourceRSet.getString(UpdateDatabase.ColumnName.ACT_BEGIN_DATE.name());
                    String strEndDate = sourceRSet.getString(UpdateDatabase.ColumnName.ACT_END_DATE.name());
                    int retCode = sourceRSet.getInt(UpdateDatabase.ColumnName.ACT_RET_CODE.name());
                    String realName = sourceRSet.getString(UpdateDatabase.ColumnName.ACT_REAL_NAME.name());
                    int _isBeginAction = sourceRSet.getInt(UpdateDatabase.ColumnName.ACT_IS_BEGIN.name());
                    int nbExec = sourceRSet.getInt(UpdateDatabase.ColumnName.ACT_NB_EXE.name());
                    ActionDataExchange ade = new ActionDataExchange();
                    if (_isBeginAction == 1) {
                        ade.setBeginAction(true);
                    } else {
                        ade.setBeginAction(false);
                    }
                    ade.setNbExecution(nbExec);
                    ade.setId(actId);
                    SimpleDateFormat df = new SimpleDateFormat(Action.getStrdateformat());
                    ade.setBeginDate(df.parse(strBeginDate));
                    if (strEndDate != null) {
                        ade.setEndDate(df.parse(strEndDate));
                    }
                    ade.setState(retCode);
                    ade.setModifDate(new Date());
                    ade.setName(realName);
                    ade.setIteration(actIter);
                    lstAct.put(actId, (IActionDataExchange)ade);
                }
            }
            catch (Exception e) {
                this.error("getActions", "query: " + this.query, e);
                throw new EngineExceptionI(String.valueOf(Messages.getString("RdbmsUserLog.126")) + sessionId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        return maxActNum;
    }

    public TreeMap<String, ISessionDataExchange> getLstSessions(int nbSessions, List<SessionFilterCriteria> lstfilters) throws EngineExceptionI {
        TreeMap<String, ISessionDataExchange> lstSess = new TreeMap<String, ISessionDataExchange>();
        int numSession = 1;
        Global.dLog.write("RdbmsUserLog=>getLstSessions", Messages.getString("RdbmsUserLog.127"), 6, 0, "DEBUG");
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                try {
                    if (nbSessions != 0x7FFFFFFE) {
                        stmtSelect.setFetchSize(nbSessions);
                    } else {
                        stmtSelect.setFetchSize(Global.DEFAULT_FETCH_SIZE);
                    }
                }
                catch (Exception exception) {}
                String _query = this.query.getLstSessionsQuery();
                long tstamp = this.getBddCurrentTimeStamp();
                sourceRSet = stmtSelect.executeQuery(_query);
                boolean acceptFilter = true;
                HashSet<String> _sets = new HashSet<String>();
                while (sourceRSet.next() && numSession <= nbSessions) {
                    String sessId = sourceRSet.getString("SESS_ID");
                    if (sessId == null || _sets.contains(sessId)) continue;
                    _sets.add(sessId);
                    SessionDataExchange sde = new SessionDataExchange();
                    this.copyRsetToSessionDataExchange(sourceRSet, (ISessionDataExchange)sde, sessId, tstamp);
                    acceptFilter = lstfilters != null ? RdbmsUserLog.verifFilters((ISessionDataExchange)sde, lstfilters) : true;
                    if (!acceptFilter) continue;
                    lstSess.put(sde.getId(), (ISessionDataExchange)sde);
                    ++numSession;
                }
                _sets.clear();
                _sets = null;
            }
            catch (Exception e) {
                this.error("getLstSessions", "query: " + this.query, e);
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.128"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        return lstSess;
    }

    void releaseConnection(Connection conn, ResultSet rs, Statement st) throws EngineExceptionI {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
                rs = null;
                if (st != null) {
                    st.close();
                }
                st = null;
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.129"), (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.warn("exception while closing result set", (Throwable)e);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    this.logger.warn("exception while closing statement", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.warn("exception while closing connection", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ISessionDataExchange getSession(MainEngineI mainEngine) throws EngineExceptionI {
        SessionDataExchange sde = null;
        String sessionId = mainEngine.getSessionID();
        Global.dLog.write("RdbmsUserLog=>getLstClosedSessions", Messages.getString("RdbmsUserLog.130"), 9, 0, "DEBUG");
        String txtCode = this.query.getSessionQuery(sessionId);
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                long tstamp = this.getBddCurrentTimeStamp();
                sourceRSet = stmtSelect.executeQuery(txtCode);
                new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
                if (sourceRSet.next()) {
                    sde = new SessionDataExchange();
                    this.copyRsetToSessionDataExchange(sourceRSet, (ISessionDataExchange)sde, sessionId, tstamp);
                }
            }
            catch (SQLException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getSession", String.valueOf(Messages.getString("RdbmsUserLog.131")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.132"), (Throwable)e);
            }
            catch (ParseException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getSession", String.valueOf(Messages.getString("RdbmsUserLog.133")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.134"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        return sde;
    }

    public TreeMap<String, String> getLstChildSessions(MainEngineI mainEngine) throws EngineExceptionI {
        String sessionId = mainEngine.getSessionID();
        int sessIter = mainEngine.getSessionIter();
        TreeMap<String, String> lstVar = null;
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstChildSessions", String.valueOf(Messages.getString("RdbmsUserLog.135")) + sessionId + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        String txtCode = this.query.getLstChildSessionsQuery(sessionId);
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                sourceRSet = stmtSelect.executeQuery(txtCode);
                lstVar = new TreeMap<String, String>();
                while (sourceRSet.next()) {
                    lstVar.put(sourceRSet.getString("CSES_ID"), sourceRSet.getString("ACT_ID"));
                }
            }
            catch (SQLException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstChildSessions", String.valueOf(Messages.getString("RdbmsUserLog.136")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.137"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstChildSessions", String.valueOf(lstVar.size()) + Messages.getString("RdbmsUserLog.138") + sessionId + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        return lstVar;
    }

    @Override
    public int getLstProperties(MainEngineI mainEngine, int lastVarNum, Map<String, Variable> lstVar) throws EngineExceptionI {
        System.currentTimeMillis();
        int sessIter = mainEngine.getSessionIter();
        Variable var = null;
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstProperties", String.valueOf(Messages.getString("RdbmsUserLog.139")) + mainEngine.getSessionID() + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        String txtCode = null;
        txtCode = this.query.getLstPropertiesQuery(mainEngine.getSessionID(), lastVarNum);
        HashSet<String> set = new HashSet<String>();
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        int maxVarNum = 0;
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                sourceRSet = stmtSelect.executeQuery(txtCode);
                BigDecimal cumul = null;
                while (sourceRSet.next()) {
                    int varNum = sourceRSet.getInt(UpdateDatabase.ColumnName.ACP_NUM.name());
                    if (varNum > maxVarNum) {
                        maxVarNum = varNum;
                    }
                    String name = sourceRSet.getString("ACP_NAME");
                    int _sessIter = sourceRSet.getInt("SESS_ITER");
                    if (set.contains(name) || _sessIter > sessIter) continue;
                    set.add(name);
                    var = new Variable();
                    var.setName(sourceRSet.getString("ACP_NAME"));
                    var.setType(sourceRSet.getString("ACP_TYPE"));
                    var.setMode(VariablePublicationMode.DYNAMIC);
                    lstVar.put(var.getName(), var);
                    String value = Format.getString(sourceRSet, "ACP_EXE_");
                    cumul = sourceRSet.getBigDecimal("ACP_CUMUL");
                    Number _cumul = null;
                    if (cumul != null) {
                        if (var.getType().equals("Integer")) {
                            _cumul = cumul.intValue();
                        } else if (var.getType().equals("Long")) {
                            _cumul = cumul.longValue();
                        } else if (var.getType().equals("Float")) {
                            _cumul = cumul.doubleValue();
                        }
                    } else {
                        _cumul = cumul;
                    }
                    if (_cumul != null) {
                        var.setValue(value, (Object)_cumul);
                    } else {
                        var.setValue(value);
                    }
                    String source = Format.getString(sourceRSet, "ACP_SRC_");
                    if (source == null) continue;
                    var.setSource(source);
                }
            }
            catch (SQLException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstProperties", String.valueOf(Messages.getString("RdbmsUserLog.140")) + mainEngine.getSessionID() + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.141"), (Throwable)e);
            }
            catch (IOException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstProperties", String.valueOf(Messages.getString("RdbmsUserLog.142")) + mainEngine.getSessionID() + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.143"), (Throwable)e);
            }
            catch (DataFormatException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstProperties", String.valueOf(Messages.getString("RdbmsUserLog.144")) + mainEngine.getSessionID() + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.145"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstProperties", String.valueOf(lstVar.size()) + Messages.getString("RdbmsUserLog.146") + mainEngine.getSessionID() + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        return maxVarNum;
    }

    public TreeMap<String, LinkDataExchangeI> getLstLinkChanges(MainEngineI mainEngine) throws EngineExceptionI {
        String sessionId = mainEngine.getSessionID();
        int sessIter = mainEngine.getSessionIter();
        TreeMap<String, LinkDataExchangeI> lstLnk = null;
        LinkDataExchangeI lnk = null;
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.147")) + sessionId + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        String txtCode = this.query.getlstLinkChangesQuery(sessionId);
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
        try {
            try {
                conn = this.getConnection(true, true);
                stmtSelect = conn.createStatement();
                sourceRSet = stmtSelect.executeQuery(txtCode);
                String lLnkId = null;
                lstLnk = new TreeMap<String, LinkDataExchangeI>();
                HashMap<String, LinkDataExchangeI> set = new HashMap<String, LinkDataExchangeI>();
                while (sourceRSet.next()) {
                    String value;
                    int _sessIter = sourceRSet.getInt("SESS_ITER");
                    lLnkId = sourceRSet.getString("LNK_ID");
                    lnk = (LinkDataExchangeI)set.get(lLnkId);
                    if (lnk != null || _sessIter > sessIter) continue;
                    Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.149")) + lLnkId, 9, 4, "DEBUG");
                    Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", Messages.getString("RdbmsUserLog.148"), 9, 5, "DEBUG");
                    lnk = new LinkDataExchangeI();
                    set.put(lLnkId, lnk);
                    lnk.linkId = lLnkId;
                    lnk.linkIter = sourceRSet.getInt("LNK_ITER");
                    try {
                        lnk.linkDate = dateFormat.parse(sourceRSet.getString("LNK_DATE"));
                    }
                    catch (ParseException e) {
                        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.150")) + sessionId + " : " + e.getMessage(), 0, 0, "WARNING");
                        lnk.linkDate = null;
                    }
                    lnk.linkType = sourceRSet.getString("LNK_TYPE");
                    lnk.linkMandatory = sourceRSet.getInt("LNK_MANDATORY");
                    lnk.linkStatus = sourceRSet.getInt("LNK_STATUS");
                    lstLnk.put(lLnkId, lnk);
                    lnk.linkExecutedCondition = value = Format.getString(sourceRSet, "LNK_EXE_");
                    String source = Format.getString(sourceRSet, "LNK_SRC_");
                    if (source == null) continue;
                    lnk.linkCondition = source;
                }
                set.clear();
                set = null;
            }
            catch (SQLException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.151")) + sessionId + " : " + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.152"), (Throwable)e);
            }
            catch (NullPointerException e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.153")) + sessionId + Messages.getString("RdbmsUserLog.154") + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.155"), (Throwable)e);
            }
            catch (Exception e) {
                Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(Messages.getString("RdbmsUserLog.156")) + sessionId + Messages.getString("RdbmsUserLog.157") + e.getMessage(), 0, 0, "ERROR");
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.158"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        Global.dLog.write(mainEngine.getSessionName(), "RdbmsUserLog=>getLstLinkChanges", String.valueOf(lstLnk.size()) + Messages.getString("RdbmsUserLog.159") + sessionId + ", iter : " + String.valueOf(sessIter), 9, 3, "DEBUG");
        return lstLnk;
    }

    private String formatQueryWitiSessFilters(String query, List<String> filters, List<Integer> statusList, boolean currentRuntime) {
        Object fil;
        int i;
        String tmp = "";
        if (filters != null && filters.size() > 0) {
            tmp = String.valueOf(tmp) + " AND (";
            i = 0;
            while (i < filters.size()) {
                fil = filters.get(i);
                if (i > 0) {
                    tmp = String.valueOf(tmp) + " OR ";
                }
                tmp = ((String)fil).contains("%") ? String.valueOf(tmp) + "SESS_NAME like '" + (String)fil + "'" : String.valueOf(tmp) + "SESS_NAME = '" + (String)fil + "'";
                ++i;
            }
            tmp = String.valueOf(tmp) + ")";
        }
        if (statusList != null && statusList.size() > 0) {
            tmp = String.valueOf(tmp) + " AND SESS_RET_CODE in (";
            i = 0;
            while (i < statusList.size()) {
                fil = statusList.get(i);
                if (i > 0) {
                    tmp = String.valueOf(tmp) + ", ";
                }
                tmp = String.valueOf(tmp) + fil;
                ++i;
            }
            tmp = String.valueOf(tmp) + ")";
        }
        if (currentRuntime) {
            tmp = String.valueOf(tmp) + " AND (SESS_ENGINE_HOST = '" + Global.HTTP_HOST + "' AND SESS_ENGINE_PORT = " + Global.HTTP_PORT + ") ";
        }
        return String.format(query, tmp);
    }

    @Override
    public void purgeLogs(int nbSessions, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        Connection conn = null;
        Statement stmtSelect = null;
        ResultSet sourceRSet = null;
        Date date = null;
        try {
            try {
                conn = this.getConnection(true, true);
                SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
                stmtSelect = conn.createStatement();
                String query = this.formatQueryWitiSessFilters(this.query.selectAllEndedSessions, filters, statusList, currentRuntime);
                sourceRSet = stmtSelect.executeQuery(query);
                int i = 0;
                String str = null;
                boolean hasElement = false;
                while ((hasElement = sourceRSet.next()) && ++i < nbSessions + 1) {
                }
                if (hasElement) {
                    str = sourceRSet.getString("SESS_BEGIN_DATE");
                }
                if (str != null) {
                    date = dateFormat.parse(str);
                }
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.160"), (Throwable)e);
            }
            catch (ParseException e) {
                throw new EngineExceptionI(Messages.getString("RdbmsUserLog.161"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, sourceRSet, stmtSelect);
            throw throwable;
        }
        this.releaseConnection(conn, sourceRSet, stmtSelect);
        if (date != null) {
            this.purgeLogs(date, filters, statusList, currentRuntime);
        }
    }

    private void error(String method, String msg, Throwable t) {
        String _msg = "RdbmsUserLogI." + method + " " + msg;
        this.logger.error(_msg, t);
    }

    @Override
    public void addActionLog(SessionRecorder.ActionLogRecord alr) throws EngineExceptionI {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection(true, false);
                Map querys = this.set.getPropertyQuery("UAL", null, this.query.addActionUserLogQuery(), alr.getMessage(), null);
                stmt = conn.prepareStatement((String)querys.get("query"));
                stmt.setString(1, alr.getSessionID());
                stmt.setInt(2, alr.getSessionIter());
                int i = alr.getNum();
                stmt.setInt(3, i);
                stmt.setString(4, alr.getAction().getActionId());
                stmt.setInt(5, alr.getAction().getActionIteration());
                stmt.setString(6, alr.getActionPath().getActionId());
                stmt.setInt(7, alr.getActionPath().getActionIteration());
                stmt.setLong(8, alr.getTimeInMillis());
                stmt.setString(9, alr.getPath());
                this.set.setValue((String)querys.get("format1"), stmt, alr.getMessage(), 10);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.error("addActionLog", String.valueOf(Messages.getString("RdbmsUserLog.162")) + alr.getAction().getActionName(), e);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, null, stmt);
            throw throwable;
        }
        this.releaseConnection(conn, null, stmt);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void updateLog(boolean force) throws EngineExceptionI {
        if (this.autoUpdate || force) {
            String version = null;
            try {
                version = this.get.getVersion();
            }
            catch (Exception e) {
                Global.getLogger().error(Messages.getString("RdbmsUserLog.163"), (Throwable)e);
            }
            if (version == null || version.isEmpty()) {
                Global.dLog.write("RdbmsUserLogI::initLog()", String.valueOf(Messages.getString("RdbmsUserLog.164")) + this.getProperty("userLogName"), 1, 0, "INFO");
                this.ddl.createTables();
            }
            Global.dLog.write("RdbmsUserLogI::initLog()", String.valueOf(Messages.getString("RdbmsUserLog.165")) + this.getProperty("userLogName"), 1, 0, "INFO");
            if (this.type.equals("r")) {
                this.ddl.chekLogVersion();
            }
        }
    }

    @Override
    public boolean connect() throws EngineExceptionI {
        this.ddl.setVersion(this.get.getVersion());
        if (this.userLogRdbmsTimestampQuery != null && !this.userLogRdbmsTimestampQuery.isEmpty()) {
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                try {
                    conn = this.getConnection(true, true);
                    st = conn.createStatement();
                    rs = st.executeQuery(this.userLogRdbmsTimestampQuery);
                    long ms = System.currentTimeMillis();
                    rs.next();
                    Timestamp tstamp = rs.getTimestamp(1);
                    if (tstamp != null) {
                        this.offset = tstamp.getTime() - ms;
                    }
                }
                catch (Exception e) {
                    this.error("SQL Exception During userLogRdbmsTimestampQuery", "query: " + this.userLogRdbmsTimestampQuery, e);
                    this.offset = 0L;
                    throw new EngineExceptionI(Messages.getString("RdbmsUserLog.166"), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, rs, st);
                throw throwable;
            }
            this.releaseConnection(conn, rs, st);
        }
        return true;
    }

    private long getBddCurrentTimeStamp() {
        return System.currentTimeMillis() + this.offset;
    }

    @Override
    public long getSessionActivityDelta() {
        if (this.userLogRdbmsInactivityDetectionPeriodLong <= 0L) {
            return -1L;
        }
        return this.userLogRdbmsActivityRefreshIntervalLong;
    }

    private UpdateDatabase getUpdateDatabase() {
        return UpdateDatabase.INSTANCE;
    }

    public void debug(String message) {
        this.logger.debug("STBLOG " + message);
    }

    public void info(String message) {
        this.logger.info("STBLOG " + message);
    }

    public void error(String message, Throwable t) {
        this.logger.error("STBLOG " + message, t);
    }

    public void info(String message, Throwable t) {
        this.logger.info("STBLOG " + message, t);
    }

    @Override
    public void writeRecord(SessionRecorder.Record record) throws EngineExceptionI {
        if (record instanceof SessionRecorder.ActionStartRecord) {
            this.addAction((SessionRecorder.ActionStartRecord)record);
        } else if (record instanceof SessionRecorder.ActionEndRecord) {
            this.finalizeAction((SessionRecorder.ActionEndRecord)record);
        } else if (record instanceof SessionRecorder.SessionStartRecord) {
            this.createSession((SessionRecorder.SessionStartRecord)record);
        } else if (record instanceof SessionRecorder.SessionEndRecord) {
            this.closeSession((SessionRecorder.SessionEndRecord)record);
        } else if (record instanceof SessionRecorder.ChildSessionRecord) {
            this.addChildSession((SessionRecorder.ChildSessionRecord)record);
        } else if (record instanceof SessionRecorder.ActionLogRecord) {
            this.addActionLog((SessionRecorder.ActionLogRecord)record);
        } else if (record instanceof SessionRecorder.LinkRecord) {
            this.reportLinkChanges((SessionRecorder.LinkRecord)record);
        } else if (record instanceof SessionRecorder.VariableRecord) {
            this.reportProperty((SessionRecorder.VariableRecord)record);
        } else if (record instanceof SessionRecorder.DeliveryRecord) {
            this.createDelivery((SessionRecorder.DeliveryRecord)record);
        } else if (record instanceof SessionRecorder.SessionActivityRecord) {
            this.updateSessionActivity((SessionRecorder.SessionActivityRecord)record);
        }
    }

    class DDL {
        DDL() {
        }

        void addColumn(Statement DMLStatement, String tableName, String columnName, String type, Integer size, Integer precision, boolean MANDATORY) throws SQLException {
            String txtCode = "ALTER TABLE " + tableName + " DROP " + columnName;
            try {
                RdbmsUserLog.this.info(txtCode);
                DMLStatement.execute(txtCode);
            }
            catch (Exception exception) {
                RdbmsUserLog.this.info(String.valueOf(Messages.getString("RdbmsUserLog.3")) + columnName);
            }
            txtCode = "ALTER TABLE " + tableName + " ADD " + this.columMask(columnName, type, size, precision, MANDATORY);
            RdbmsUserLog.this.info(txtCode);
            DMLStatement.execute(txtCode);
        }

        void alterTablesTo1_6_0_2() throws EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    Global.dLog.write("RdbmsUserLogI=>alterTablesTo1_6_0_2()", Messages.getString("RdbmsUserLog.4"), 1, 0, "INFO");
                    st = conn.createStatement();
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_CUMUL", RdbmsUserLog.this.userLogRdbmsNumericType, 20, null, false);
                    this.updateVersion(st, "1.6.0.2");
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
            Global.dLog.write("RdbmsUserLogI=>alterTablesTo1_6_0_2()", Messages.getString("RdbmsUserLog.5"), 1, 0, "INFO");
        }

        void alterTablesTo1_6_0_3() throws EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    Global.dLog.write("RdbmsUserLogI=>alterTablesTo1_6_0_3()", Messages.getString("RdbmsUserLog.6"), 1, 0, "INFO");
                    st = conn.createStatement();
                    this.createTable(st, RdbmsUserLog.this.FULL_DELIVERY, this.columMask("DLV_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false), this.columMask("DLV_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null, null, false), this.columMask("DLV_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null, null, false), this.columMask("DLV_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false), this.columMask("DLV_NAME", RdbmsUserLog.this.userLogRdbmsVarcharType, 255, null, false), this.columMask("PROC_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false), this.columMask("DLV_CONF", RdbmsUserLog.this.userLogRdbmsVarcharType, 100, null, false));
                    this.createUniqueIndex(st, RdbmsUserLog.this.FULL_DELIVERY, "IDX_" + RdbmsUserLog.this.DELIVERY + "01", "DLV_ID");
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "DLV_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "SESS_LAUNCH_MODE", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "SESS_EXECUTION_MODE", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "SESS_GUEST_HOST", RdbmsUserLog.this.userLogRdbmsVarcharType, 100, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "SESS_CONF", RdbmsUserLog.this.userLogRdbmsVarcharType, 100, null, false);
                    this.createIndex(st, RdbmsUserLog.this.FULL_SESSION, "IDX_" + RdbmsUserLog.this.SESSION + "01", "DLV_ID");
                    this.createIndex(st, RdbmsUserLog.this.FULL_SESSION, "IDX_" + RdbmsUserLog.this.SESSION + "02", "SESS_BEGIN_DATE");
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_EXE_VAR", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize), null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_EXE_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_EXE_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_EXE_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_SRC_VAR", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize), null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_SRC_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_SRC_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_LINK, "LNK_SRC_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_EXE_VAR", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize), null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_EXE_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_EXE_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_EXE_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_SRC_VAR", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize), null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_SRC_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_SRC_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null, null, false);
                    this.addColumn(st, RdbmsUserLog.this.FULL_PROPERTY, "ACP_SRC_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.updateVersion(st, "1.6.0.3");
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
            Global.dLog.write("RdbmsUserLogI=>alterTablesTo1_6_0_3()", Messages.getString("RdbmsUserLog.7"), 1, 0, "INFO");
        }

        void createIndex(Statement DMLStatement, String tableName, String indexName, String ... columns) throws SQLException {
            String tmp = "";
            int i = 0;
            while (i < columns.length) {
                if (i > 0) {
                    tmp = String.valueOf(tmp) + ", ";
                }
                tmp = String.valueOf(tmp) + columns[i];
                ++i;
            }
            String txtCode = RdbmsUserLog.this.userLogRdbmsUseSchemaNameForIndexCreation ? "CREATE INDEX " + RdbmsUserLog.this.userLogRdbmsSchemaName + indexName + "0" + " ON " + tableName + " (" + tmp + ")" + RdbmsUserLog.this.userLogRdbmsIndexCreationOption : "CREATE INDEX " + indexName + "0" + " ON " + tableName + " (" + tmp + ")" + RdbmsUserLog.this.userLogRdbmsIndexCreationOption;
            RdbmsUserLog.this.info(txtCode);
            DMLStatement.execute(txtCode);
        }

        void createTable(Statement DMLStatement, String tableName, List list) throws SQLException {
            String[] lst = new String[list.size()];
            list.toArray(lst);
            this.createTable(DMLStatement, tableName, lst);
        }

        void createTable(Statement DMLStatement, String tableName, String ... columns) throws SQLException {
            String tmp = "";
            int i = 0;
            while (i < columns.length) {
                if (i > 0) {
                    tmp = String.valueOf(tmp) + ",";
                }
                tmp = String.valueOf(tmp) + columns[i] + "\n";
                ++i;
            }
            String txtCode = "CREATE TABLE " + tableName + "(\n" + tmp + "\n)" + RdbmsUserLog.this.userLogRdbmsTableCreationOption;
            RdbmsUserLog.this.info(txtCode);
            try {
                DMLStatement.execute(txtCode);
            }
            catch (SQLException e) {
                RdbmsUserLog.this.error(txtCode, e);
                throw e;
            }
        }

        void dropAllTables() throws SQLException, EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                conn = RdbmsUserLog.this.getConnection(true, true);
                st = conn.createStatement();
                this.dropTable(st, RdbmsUserLog.this.FULL_VERSION);
                this.dropTable(st, RdbmsUserLog.this.FULL_SESSION);
                this.dropTable(st, RdbmsUserLog.this.FULL_CHILD_SESSION);
                this.dropTable(st, RdbmsUserLog.this.FULL_LINK);
                this.dropTable(st, RdbmsUserLog.this.FULL_PROPERTY);
                this.dropTable(st, RdbmsUserLog.this.FULL_ACTION);
                this.dropTable(st, RdbmsUserLog.this.FULL_DELIVERY);
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
        }

        void createTables() throws EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                try {
                    Global.dLog.write("RdbmsUserLogI::createTables()", Messages.getString("RdbmsUserLog.8"), 1, 0, "INFO");
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    st = conn.createStatement();
                    this.createTable(st, RdbmsUserLog.this.FULL_VERSION, this.columMask("V_VERSION", RdbmsUserLog.this.userLogRdbmsVarcharType, 10, null, false));
                    this.createTable(st, RdbmsUserLog.this.FULL_SESSION, this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("SESS_NAME", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)), this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("SESS_BEGIN_DATE", RdbmsUserLog.this.userLogRdbmsVarcharType, 25), this.columMask("SESS_END_DATE", RdbmsUserLog.this.userLogRdbmsVarcharType, 25), this.columMask("SESS_RET_CODE", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("SESS_RET_MSG", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)), this.columMask("SESS_ENGINE_HOST", RdbmsUserLog.this.userLogRdbmsVarcharType, 255), this.columMask("SESS_ENGINE_PORT", RdbmsUserLog.this.userLogRdbmsNumericType, 6));
                    this.createTable(st, RdbmsUserLog.this.FULL_CHILD_SESSION, this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("CSES_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("ACT_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    this.createTable(st, RdbmsUserLog.this.FULL_LINK, this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("LNK_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("LNK_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("LNK_DATE", RdbmsUserLog.this.userLogRdbmsVarcharType, 25), this.columMask("LNK_TYPE", RdbmsUserLog.this.userLogRdbmsVarcharType, 3), this.columMask("LNK_MANDATORY", RdbmsUserLog.this.userLogRdbmsNumericType, 1), this.columMask("LNK_STATUS", RdbmsUserLog.this.userLogRdbmsNumericType, 1));
                    this.createTable(st, RdbmsUserLog.this.FULL_PROPERTY, this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("ACT_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("ACT_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("ACP_NAME", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)), this.columMask("ACP_SHORT_NAME", RdbmsUserLog.this.userLogRdbmsVarcharType, 255), this.columMask("ACP_TYPE", RdbmsUserLog.this.userLogRdbmsVarcharType, 35));
                    this.createTable(st, RdbmsUserLog.this.FULL_ACTION, this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("ACT_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50), this.columMask("ACT_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("ACT_NAME", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)), this.columMask("ACT_TYPE", RdbmsUserLog.this.userLogRdbmsVarcharType, 10), this.columMask("ACT_BEGIN_DATE", RdbmsUserLog.this.userLogRdbmsVarcharType, 25), this.columMask("ACT_END_DATE", RdbmsUserLog.this.userLogRdbmsVarcharType, 25), this.columMask("ACT_RET_CODE", RdbmsUserLog.this.userLogRdbmsNumericType, 10), this.columMask("ACT_RET_MSG", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)), this.columMask("ACT_FATHER_ENGINE_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    this.createIndex(st, RdbmsUserLog.this.FULL_PROPERTY, "IDX_" + RdbmsUserLog.this.PROPERTY + "01", "SESS_ID", "ACT_ID", "ACT_ITER", "SESS_ITER");
                    this.createIndex(st, RdbmsUserLog.this.FULL_ACTION, "IDX_" + RdbmsUserLog.this.ACTION + "01", "SESS_ID", "SESS_ITER", "ACT_ID", "ACT_ITER");
                    Global.dLog.write("RdbmsUserLogI::createTables()", Messages.getString("RdbmsUserLog.9"), 1, 0, "INFO");
                    this.updateVersion(st, "");
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
        }

        void createUniqueIndex(Statement DMLStatement, String tableName, String indexName, String ... columns) throws SQLException {
            String tmp = "";
            int i = 0;
            while (i < columns.length) {
                if (i > 0) {
                    tmp = String.valueOf(tmp) + ", ";
                }
                tmp = String.valueOf(tmp) + columns[i];
                ++i;
            }
            String txtCode = RdbmsUserLog.this.userLogRdbmsUseSchemaNameForIndexCreation ? "CREATE UNIQUE INDEX " + RdbmsUserLog.this.userLogRdbmsSchemaName + indexName + "0" + " ON " + tableName + " (" + tmp + ")" : "CREATE UNIQUE INDEX " + indexName + "0" + " ON " + tableName + " (" + tmp + ")";
            RdbmsUserLog.this.info(txtCode);
            DMLStatement.execute(txtCode);
        }

        void dropTable(Statement DMLStatement, String tableName) {
            String query = "DROP TABLE " + tableName;
            try {
                RdbmsUserLog.this.info(query);
                DMLStatement.execute(query);
            }
            catch (Exception exception) {
                RdbmsUserLog.this.info(String.valueOf(Messages.getString("RdbmsUserLog.10")) + tableName);
            }
        }

        void setVersion(String _version) {
            RdbmsUserLog.this.version = _version;
            if (!RdbmsUserLog.this.version.equals("")) {
                RdbmsUserLog.this.intVersion = Integer.parseInt(RdbmsUserLog.this.version.replaceAll("\\.", ""));
                Global.dLog.write("RdbmsUserLogI=>chekLogVersion", String.valueOf(Messages.getString("RdbmsUserLog.11")) + RdbmsUserLog.this.version, 4, 0, "DEBUG");
            } else {
                RdbmsUserLog.this.intVersion = 1000;
            }
        }

        void chekLogVersion() throws EngineExceptionI {
            if (RdbmsUserLog.this.intVersion < 1602) {
                RdbmsUserLog.this.ddl.alterTablesTo1_6_0_2();
            }
            if (RdbmsUserLog.this.intVersion < 1603) {
                RdbmsUserLog.this.ddl.alterTablesTo1_6_0_3();
            }
            if (RdbmsUserLog.this.intVersion < 1604) {
                RdbmsUserLog.this.ddl.alterTablesTo1_6_0_4();
            }
            if (RdbmsUserLog.this.intVersion < 1611) {
                RdbmsUserLog.this.ddl.alterTablesTo1_6_1_1();
            }
            RdbmsUserLog.this.getUpdateDatabase().alterTablesToXXX(RdbmsUserLog.this);
        }

        private void alterTablesTo1_6_0_4() throws EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    st = conn.createStatement();
                    this.addColumn(st, RdbmsUserLog.this.FULL_SESSION, "SESS_PARENT_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50, null, false);
                    this.updateVersion(st, "1.6.0.4");
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
        }

        private void alterTablesTo1_6_1_1() throws EngineExceptionI {
            Statement st = null;
            Connection conn = null;
            try {
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    st = conn.createStatement();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(this.columMask("SESS_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    list.add(this.columMask("SESS_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10));
                    list.add(this.columMask("UAL_NUM", RdbmsUserLog.this.userLogRdbmsNumericType, 10));
                    list.add(this.columMask("ACT_ID", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    list.add(this.columMask("ACT_ITER", RdbmsUserLog.this.userLogRdbmsNumericType, 10));
                    list.add(this.columMask("ACT_ID_P", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    list.add(this.columMask("ACT_ITER_P", RdbmsUserLog.this.userLogRdbmsNumericType, 10));
                    list.add(this.columMask("ACT_PATH", RdbmsUserLog.this.userLogRdbmsVarcharType, 255));
                    list.add(this.columMask("ACT_PATH_P", RdbmsUserLog.this.userLogRdbmsVarcharType, 255));
                    list.add(this.columMask("UAL_LEVEL", RdbmsUserLog.this.userLogRdbmsNumericType, 6));
                    list.add(this.columMask("UAL_TSTAMP", RdbmsUserLog.this.userLogRdbmsNumericType, 20));
                    list.add(this.columMask("UAL_PATH", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)));
                    list.add(this.columMask("UAL_VAR", RdbmsUserLog.this.userLogRdbmsVarcharType, Integer.valueOf(RdbmsUserLog.this.userLogRdbmsVarcharMaxSize)));
                    list.add(this.columMask("UAL_CLO", RdbmsUserLog.this.userLogRdbmsClobType, null));
                    list.add(this.columMask("UAL_BLO", RdbmsUserLog.this.userLogRdbmsBlobType, null));
                    list.add(this.columMask("UAL_FORMAT", RdbmsUserLog.this.userLogRdbmsVarcharType, 50));
                    this.createTable(st, RdbmsUserLog.this.FULL_USER_LOG, list);
                    this.createUniqueIndex(st, RdbmsUserLog.this.FULL_USER_LOG, "IDX_" + RdbmsUserLog.this.USER_LOG + "01", "SESS_ID", "UAL_NUM");
                    this.createIndex(st, RdbmsUserLog.this.FULL_USER_LOG, "IDX_" + RdbmsUserLog.this.USER_LOG + "02", "SESS_ID");
                    this.updateVersion(st, "1.6.1.1");
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                RdbmsUserLog.this.releaseConnection(conn, null, st);
                throw throwable;
            }
            RdbmsUserLog.this.releaseConnection(conn, null, st);
        }

        String columMask(String columnName, String type, Integer size) {
            return this.columMask(columnName, type, size, null, false);
        }

        String columMask(String columnName, String type, Integer size, Integer precision, boolean MANDATORY) {
            String tmp = size != null ? size.toString() : "";
            tmp = String.valueOf(tmp) + (precision != null && size != null ? "," + precision : "");
            tmp = !tmp.isEmpty() ? "(" + tmp + ")" : "";
            return String.valueOf(columnName) + "\t" + type + tmp;
        }

        void updateVersion(Statement DMLStatement, String version) throws SQLException {
            String txtCode = version.equals("") ? "insert into " + RdbmsUserLog.this.FULL_VERSION + " (" + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + ") values('" + version + "')" : (version.compareTo("1.7.0.0") < 0 ? "update " + RdbmsUserLog.this.FULL_VERSION + " SET " + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + " ='" + version + "'" : "update " + RdbmsUserLog.this.FULL_VERSION + " SET " + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + " ='" + version + "'," + (Object)((Object)UpdateDatabase.ColumnName.V_UPD_DATE) + " ='" + RdbmsUserLog.this.dateFormat.format(new Date()) + "'" + (RdbmsUserLog.this.userLogRdbmsTimestampQuery != null ? "," + (Object)((Object)UpdateDatabase.ColumnName.V_TSTAMP_SQL) + " ='" + RdbmsUserLog.this.userLogRdbmsTimestampQuery + "'" : ""));
            RdbmsUserLog.this.info(txtCode);
            DMLStatement.execute(txtCode);
            this.setVersion(version);
        }
    }

    class Get {
        Get() {
        }

        String getVersion() throws EngineExceptionI {
            String ret;
            block8: {
                ret = "";
                Global.dLog.write("RdbmsUserLogI=>getVersion", Messages.getString("RdbmsUserLog.0"), 4, 0, "DEBUG");
                String txtCode = RdbmsUserLog.this.query.getVersionQuery();
                Connection conn = null;
                Statement stmtSelect = null;
                ResultSet sourceRSet = null;
                try {
                    try {
                        conn = RdbmsUserLog.this.getConnection(true, true);
                        stmtSelect = conn.createStatement();
                        sourceRSet = stmtSelect.executeQuery(txtCode);
                        if (sourceRSet.next()) {
                            ret = sourceRSet.getString("V_VERSION");
                        }
                    }
                    catch (Exception e) {
                        if (Global.getLogger().isDebugEnabled()) {
                            Global.getLogger().debug(Messages.getString("RdbmsUserLog.1"), (Throwable)e);
                        } else {
                            Global.getLogger().info(Messages.getString("RdbmsUserLog.1"));
                        }
                        RdbmsUserLog.this.releaseConnection(conn, sourceRSet, stmtSelect);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    RdbmsUserLog.this.releaseConnection(conn, sourceRSet, stmtSelect);
                    throw throwable;
                }
                RdbmsUserLog.this.releaseConnection(conn, sourceRSet, stmtSelect);
            }
            Global.dLog.write("RdbmsUserLogI=>getVersion", String.valueOf(Messages.getString("RdbmsUserLog.2")) + ret, 4, 0, "DEBUG");
            return ret;
        }

        Document getDocument(ResultSet rs, String prefix) throws ParserConfigurationException, SQLException, IOException, DataFormatException, SAXException {
            Reader reader = this.getReader(rs, prefix);
            if (reader != null) {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                return docBuilder.parse(new InputSource(reader));
            }
            return null;
        }

        Reader getReader(ResultSet rs, String prefix) throws ParserConfigurationException, SQLException, IOException, DataFormatException, SAXException {
            Object o = Format.readData(rs, prefix);
            Reader reader = null;
            if (o instanceof Reader) {
                reader = (Reader)o;
            } else if (o instanceof InputStream) {
                reader = new InputStreamReader((InputStream)o, StandardCharsets.UTF_8);
            }
            return reader;
        }

        Object getFirstColFirstRowQuery(String query) throws SQLException, EngineExceptionI {
            ResultSet sourceRSet;
            Statement st;
            Connection conn;
            Object result;
            block2: {
                Object object;
                result = null;
                conn = null;
                st = null;
                sourceRSet = null;
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    st = conn.createStatement();
                    sourceRSet = st.executeQuery(query);
                    if (!sourceRSet.next()) break block2;
                    object = result = sourceRSet.getObject(1);
                }
                catch (Throwable throwable) {
                    RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
                    throw throwable;
                }
                RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
                return object;
            }
            RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
            return result;
        }

        boolean exists(String query) throws SQLException, EngineExceptionI {
            return this.exists(query, false) > 0;
        }

        int exists(String query, boolean testNotNull) throws SQLException, EngineExceptionI {
            boolean result;
            ResultSet sourceRSet;
            Statement st;
            Connection conn;
            block3: {
                int n;
                conn = null;
                st = null;
                sourceRSet = null;
                try {
                    conn = RdbmsUserLog.this.getConnection(true, true);
                    st = conn.createStatement();
                    sourceRSet = st.executeQuery(query);
                    result = sourceRSet.next();
                    if (!result || !testNotNull) break block3;
                    n = sourceRSet.getString(1) != null ? 2 : 1;
                }
                catch (Throwable throwable) {
                    RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
                    throw throwable;
                }
                RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
                return n;
            }
            int n = result ? 1 : 0;
            RdbmsUserLog.this.releaseConnection(conn, sourceRSet, st);
            return n;
        }

        boolean existsAllTables() throws EngineExceptionI {
            return this.existsTable(RdbmsUserLog.this.FULL_SESSION) && this.existsTable(RdbmsUserLog.this.FULL_CHILD_SESSION) && this.existsTable(RdbmsUserLog.this.FULL_LINK) && this.existsTable(RdbmsUserLog.this.FULL_PROPERTY) && this.existsTable(RdbmsUserLog.this.FULL_ACTION) && this.existsTable(RdbmsUserLog.this.FULL_DELIVERY) && this.existsTable(RdbmsUserLog.this.FULL_VERSION);
        }

        boolean existsTable(String sTableName) throws EngineExceptionI {
            Connection conn = null;
            try {
                conn = RdbmsUserLog.this.getConnection(true, true);
                boolean bl = CommonUtils.existsTable((Connection)conn, (String)sTableName);
                return bl;
            }
            finally {
                RdbmsUserLog.this.releaseConnection(conn, null, null);
            }
        }
    }

    class Query {
        public String getLstCloseSessionsQuery;
        public String getLstInactiveSessionsQuery;
        public String selectAllEndedSessions;

        Query() {
            this.getLstCloseSessionsQuery = "Select SESS_ID, SESS_ITER, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG  from " + RdbmsUserLog.this.FULL_SESSION + " " + RdbmsUserLog.this.tableAS + " LS1 " + "where LS1.SESS_RET_CODE is not null and " + "exists (select 'x' from " + RdbmsUserLog.this.FULL_SESSION + " LS2 where LS1.SESS_ID = LS2.SESS_ID GROUP BY LS2.SESS_ID HAVING MAX(LS2.SESS_ITER) = LS1.SESS_ITER)";
            this.getLstInactiveSessionsQuery = "Select SESS_ID, SESS_ITER, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG  from " + RdbmsUserLog.this.FULL_SESSION + " " + RdbmsUserLog.this.tableAS + " LS1 " + "where LS1.SESS_RET_CODE is null and " + " LS1.SESS_END_DATE is null";
            this.selectAllEndedSessions = "Select SESS_BEGIN_DATE from " + RdbmsUserLog.this.FULL_SESSION + " where SESS_END_DATE is not null %s" + " order by SESS_BEGIN_DATE DESC, SESS_END_DATE DESC";
        }

        String addChildSessionQuery() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "Insert into " + RdbmsUserLog.this.FULL_CHILD_SESSION + " (SESS_ID, SESS_ITER, ACT_ID, CSES_ID," + (Object)((Object)UpdateDatabase.ColumnName.ACT_ITER) + "," + (Object)((Object)UpdateDatabase.ColumnName.CSES_ITER) + ") values (?,?,?,?, ?,?)";
            }
            return "Insert into " + RdbmsUserLog.this.FULL_CHILD_SESSION + " (SESS_ID, SESS_ITER, ACT_ID, CSES_ID) values (?,?,?,?)";
        }

        String addActionQuery() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "Insert into " + RdbmsUserLog.this.FULL_ACTION + " (SESS_ID, SESS_ITER, ACT_ID, ACT_ITER, ACT_NAME, ACT_TYPE, ACT_BEGIN_DATE, ACT_FATHER_ENGINE_ID," + (Object)((Object)UpdateDatabase.ColumnName.ACT_PARENT_ITER) + "," + (Object)((Object)UpdateDatabase.ColumnName.ACT_REAL_NAME) + "," + (Object)((Object)UpdateDatabase.ColumnName.ACT_IS_BEGIN) + "," + (Object)((Object)UpdateDatabase.ColumnName.ACT_NUM) + "," + (Object)((Object)UpdateDatabase.ColumnName.ACT_RET_CODE) + ") values (?,?,?,?,?,?,?,?, ?,?,?,?,?)";
            }
            return "Insert into " + RdbmsUserLog.this.FULL_ACTION + " (SESS_ID, SESS_ITER, ACT_ID, ACT_ITER, ACT_NAME, ACT_TYPE, ACT_BEGIN_DATE, ACT_FATHER_ENGINE_ID) values (?,?,?,?,?,?,?,?)";
        }

        String closeSessionQuery() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "Update " + RdbmsUserLog.this.FULL_SESSION + " set SESS_END_DATE = ?, SESS_RET_CODE = ? , SESS_RET_MSG = ? ,  " + (Object)((Object)UpdateDatabase.ColumnName.SESS_DURATION) + "=?" + " WHERE SESS_ID= ? and SESS_ITER= ? ";
            }
            return "Update " + RdbmsUserLog.this.FULL_SESSION + " set SESS_END_DATE = ?, SESS_RET_CODE = ? , SESS_RET_MSG = ? WHERE SESS_ID= ? and SESS_ITER= ? ";
        }

        String updateSessionDelta() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "Update " + RdbmsUserLog.this.FULL_SESSION + " set " + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAST_TSTAMP) + "=?" + " WHERE SESS_ID= ? and SESS_ITER= ? ";
            }
            return null;
        }

        String updateDeliveryHeader() {
            return "Update " + RdbmsUserLog.this.FULL_DELIVERY + " set PROC_ID = ?" + " WHERE DLV_ID= ?";
        }

        String createSessionQuery(boolean activity) {
            if (RdbmsUserLog.this.intVersion < 1604) {
                return "Insert into " + RdbmsUserLog.this.FULL_SESSION + " (SESS_ID, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_ENGINE_HOST, SESS_ENGINE_PORT, DLV_ID, SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF) values (?,?,?,?,?,?,?,?,?,?,?)";
            }
            if (RdbmsUserLog.this.intVersion < UpdateDatabase.Version.V1700.num()) {
                return "Insert into " + RdbmsUserLog.this.FULL_SESSION + " (SESS_ID, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_ENGINE_HOST, SESS_ENGINE_PORT, DLV_ID, SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF,SESS_PARENT_ID) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            return "Insert into " + RdbmsUserLog.this.FULL_SESSION + " (SESS_ID, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_ENGINE_HOST, SESS_ENGINE_PORT, DLV_ID, SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF,SESS_PARENT_ID," + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_BEGIN_TSTAMP) + "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_ACT_ROOT_ID) + "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_TSTAMP_OFFSET) + "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_PARENT_ITER) + (activity ? "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_INACT_TIMEOUT) + "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAST_TSTAMP) : "") + (RdbmsUserLog.this.intVersion > UpdateDatabase.Version.V1740.num() ? "," + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAUNCH_USER) : "") + ") values (?,?,?,?,?,?,?,?,?,?,?,?, ?,?,?,?,?" + (activity ? ",?,?" : "") + (RdbmsUserLog.this.intVersion > UpdateDatabase.Version.V1740.num() ? ",?" : "") + ")";
        }

        String createSessionWithRestart() {
            return "Insert into " + RdbmsUserLog.this.FULL_SESSION + " (SESS_ID, SESS_NAME, SESS_ITER, SESS_BEGIN_DATE, SESS_ENGINE_HOST, SESS_ENGINE_PORT, DLV_ID) values (?,?,?,?,?,?,?)";
        }

        String finalizeActionQuery() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "Update " + RdbmsUserLog.this.FULL_ACTION + " set ACT_END_DATE = ?, ACT_RET_CODE = ? , ACT_RET_MSG = ?, " + (Object)((Object)UpdateDatabase.ColumnName.ACT_NB_EXE) + "=?," + (Object)((Object)UpdateDatabase.ColumnName.ACT_NB_BND_EXE) + "=?, " + (Object)((Object)UpdateDatabase.ColumnName.ACT_NUM) + "=?" + " WHERE SESS_ID= ?  and SESS_ITER= ?  and ACT_ID = ? and ACT_ITER = ?";
            }
            return "Update " + RdbmsUserLog.this.FULL_ACTION + " set ACT_END_DATE = ?, ACT_RET_CODE = ? , ACT_RET_MSG = ? WHERE SESS_ID= ?  and SESS_ITER= ?  and ACT_ID = ? and ACT_ITER = ?";
        }

        String getQueryFields() {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1740.num()) {
                return "SESS_ID, SESS_ITER, SESS_NAME, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG, SESS_ENGINE_HOST, SESS_ENGINE_PORT,SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF,SESS_PARENT_ID," + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAST_TSTAMP) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_TSTAMP_OFFSET) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_INACT_TIMEOUT) + ", " + (Object)((Object)UpdateDatabase.ColumnName.DLV_ID) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAUNCH_USER);
            }
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "SESS_ID, SESS_ITER, SESS_NAME, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG, SESS_ENGINE_HOST, SESS_ENGINE_PORT,SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF,SESS_PARENT_ID," + (Object)((Object)UpdateDatabase.ColumnName.V_VERSION) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_LAST_TSTAMP) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_TSTAMP_OFFSET) + ", " + (Object)((Object)UpdateDatabase.ColumnName.SESS_INACT_TIMEOUT) + ", " + (Object)((Object)UpdateDatabase.ColumnName.DLV_ID);
            }
            if (RdbmsUserLog.this.intVersion < 1604) {
                return "SESS_ID, SESS_ITER, SESS_NAME, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG, SESS_ENGINE_HOST, SESS_ENGINE_PORT,SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF";
            }
            return "SESS_ID, SESS_ITER, SESS_NAME, SESS_BEGIN_DATE, SESS_END_DATE, SESS_RET_CODE, SESS_RET_MSG, SESS_ENGINE_HOST, SESS_ENGINE_PORT,SESS_LAUNCH_MODE,SESS_EXECUTION_MODE,SESS_GUEST_HOST, SESS_CONF,SESS_PARENT_ID";
        }

        public String getLstSessionsQuery() {
            return "Select " + this.getQueryFields() + " from " + RdbmsUserLog.this.FULL_SESSION + " " + RdbmsUserLog.this.tableAS + " LS1 " + " order by SESS_BEGIN_DATE DESC, SESS_END_DATE DESC, SESS_ID, SESS_ITER DESC";
        }

        public String getDeleteInexistantLinksQuery() {
            return this.getDelete(UpdateDatabase.TableName.LINK_LNK, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantPropertiesQuery() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_PROP_ACP, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantActionQuery() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_ACT, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String FULL_CHILD_SESSION() {
            return this.getDelete(UpdateDatabase.TableName.DELIVERY_DLV, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        private String getDelete(UpdateDatabase.TableName table1, UpdateDatabase.TableName table2, String id) {
            String tmp = String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + table1.getFullName(RdbmsUserLog.this);
            if (RdbmsUserLog.this.userLogRdbmsUseAliasTableForDeleteClause) {
                tmp = String.valueOf(tmp) + " " + table1.getShortName(RdbmsUserLog.this);
            }
            if (RdbmsUserLog.this.userLogRdbmsDeletionWithNotExists) {
                tmp = String.valueOf(tmp) + " WHERE NOT EXISTS (SELECT 'X' FROM ";
                tmp = String.valueOf(tmp) + table2.getFullName(RdbmsUserLog.this);
                if (RdbmsUserLog.this.userLogRdbmsUseAliasTableForDeleteClause) {
                    tmp = String.valueOf(tmp) + " " + table2.getShortName(RdbmsUserLog.this);
                }
                tmp = String.valueOf(tmp) + " WHERE " + table1.getShortName(RdbmsUserLog.this) + "." + id + "=" + table2.getShortName(RdbmsUserLog.this) + "." + id + ")";
                return tmp;
            }
            tmp = String.valueOf(tmp) + " WHERE " + id + " NOT IN (SELECT " + id;
            tmp = String.valueOf(tmp) + " FROM " + table2.getFullName(RdbmsUserLog.this) + ")";
            return tmp;
        }

        public String getDeleteInexistantChildSessionQuery() {
            return this.getDelete(UpdateDatabase.TableName.SESSION_CHILDS_CSES, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantDeliveryQuery() {
            return this.getDelete(UpdateDatabase.TableName.DELIVERY_DLV, UpdateDatabase.TableName.SESSION_SESS, "DLV_ID");
        }

        public String getSaveDeliveryBloQuery() {
            if (RdbmsUserLog.this.intVersion < UpdateDatabase.Version.V1700.num()) {
                return "insert into " + RdbmsUserLog.this.FULL_DELIVERY + " (DLV_ID, DLV_FORMAT,DLV_BLO, DLV_NAME, PROC_ID,DLV_CONF) values(?,?,?,?,?,?)";
            }
            return "insert into " + RdbmsUserLog.this.FULL_DELIVERY + " (DLV_ID, DLV_FORMAT,DLV_BLO, DLV_NAME, PROC_ID,DLV_CONF," + (Object)((Object)UpdateDatabase.ColumnName.DLV_TSTAMP) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_VERSION) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_USER) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_COMMENT) + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1709.num() ? "," + (Object)((Object)UpdateDatabase.ColumnName.PCK_ID) : "") + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1770.num() ? "," + (Object)((Object)UpdateDatabase.ColumnName.CHECKSUM) : "") + ") values(?,?,?,?,?,?, ?,?,?,?" + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1709.num() ? ",?" : "") + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1770.num() ? ",?" : "") + ")";
        }

        public String getSaveDeliveryCloQuery() {
            if (RdbmsUserLog.this.intVersion < UpdateDatabase.Version.V1700.num()) {
                return "insert into " + RdbmsUserLog.this.FULL_DELIVERY + " (DLV_ID, DLV_FORMAT,DLV_CLO, DLV_NAME, PROC_ID,DLV_CONF) values(?,?,?,?,?,?)";
            }
            return "insert into " + RdbmsUserLog.this.FULL_DELIVERY + " (DLV_ID, DLV_FORMAT,DLV_CLO, DLV_NAME, PROC_ID,DLV_CONF," + (Object)((Object)UpdateDatabase.ColumnName.DLV_TSTAMP) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_VERSION) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_USER) + "," + (Object)((Object)UpdateDatabase.ColumnName.DLV_COMMENT) + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1709.num() ? "," + (Object)((Object)UpdateDatabase.ColumnName.PCK_ID) : "") + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1770.num() ? "," + (Object)((Object)UpdateDatabase.ColumnName.CHECKSUM) : "") + ") values(?,?,?,?,?,?, ?,?,?,?" + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1709.num() ? ",?" : "") + (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1770.num() ? ",?" : "") + ")";
        }

        public String getDeleteInexistantUALQuery() {
            return this.getDelete(UpdateDatabase.TableName.USER_ACTION_LOG_UAL, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantActionStatic() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_S_ACT, UpdateDatabase.TableName.DELIVERY_DLV, "DLV_ID");
        }

        public String getDeleteInexistantActionStat() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_STAT_AST, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantProcessStat() {
            return this.getDelete(UpdateDatabase.TableName.PROCESS_STAT_PST, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantSessionStat() {
            return this.getDelete(UpdateDatabase.TableName.SESSION_STAT_SST, UpdateDatabase.TableName.SESSION_SESS, "SESS_ID");
        }

        public String getDeleteInexistantAltId() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_ALTID_AAI, UpdateDatabase.TableName.DELIVERY_DLV, "DLV_ID");
        }

        public String getLstChildSessionsQuery(String sessionId) {
            return "SELECT\t ACT_ID, CSES_ID FROM " + RdbmsUserLog.this.FULL_CHILD_SESSION + " P1 " + "WHERE SESS_ID = '" + sessionId + "'";
        }

        public String getSessionQuery(String sessionId) {
            return "Select " + this.getQueryFields() + "  from " + RdbmsUserLog.this.FULL_SESSION + "  LS1 " + "where " + "LS1.SESS_ID = '" + sessionId + "' order by SESS_ITER desc";
        }

        public String getSessionDeliveryQuery(String sessionId) {
            return "select DLV_CLO, DLV_BLO, DLV_FORMAT, DLV_NAME from " + RdbmsUserLog.this.FULL_DELIVERY + " DLV, " + RdbmsUserLog.this.FULL_SESSION + " SESS" + " where SESS.DLV_ID=DLV.DLV_ID and SESS.SESS_ID='" + sessionId + "'";
        }

        public String getVersionQuery() {
            return "Select V_VERSION from " + RdbmsUserLog.this.FULL_VERSION;
        }

        public String selectSessionUntilQuery(String date) {
            return "Select SESS_ID from " + RdbmsUserLog.this.FULL_SESSION + " where SESS_BEGIN_DATE <= '" + date + "'";
        }

        public String deleteSessionUntilQuery(String date) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_SESSION + " WHERE SESS_BEGIN_DATE <= '" + date + "' and SESS_END_DATE is not null %s";
        }

        public String selectSessionUntil(String date) {
            return "SELECT SESS_BEGIN_DATE FROM " + RdbmsUserLog.this.FULL_SESSION + " WHERE SESS_BEGIN_DATE <= '" + date + "' and SESS_END_DATE is not null %s";
        }

        public String deleteDoneSessionBetweenQuery() {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_SESSION + " WHERE SESS_BEGIN_DATE >= ?" + " and SESS_BEGIN_DATE <= ?" + " and SESS_END_DATE is not null %s";
        }

        public String exsistsDeliveryQuery(String DLV_ID) {
            if (RdbmsUserLog.this.intVersion >= UpdateDatabase.Version.V1700.num()) {
                return "select PROC_ID from " + RdbmsUserLog.this.FULL_DELIVERY + " where DLV_ID='" + DLV_ID + "'";
            }
            return "select 'X' from " + RdbmsUserLog.this.FULL_DELIVERY + " where DLV_ID='" + DLV_ID + "'";
        }

        public String getLstPropertiesQuery(String sessionId, int lastVarNum) {
            return "SELECT\nP1.SESS_ID,\nP1.SESS_ITER,\nP1.ACT_ID,\nP1.ACP_NAME,\nP1.ACP_TYPE,\n1 AS ORDRE ,\nP1.ACP_CUMUL,\nP1.ACP_EXE_FORMAT,P1.ACP_EXE_VAR,P1.ACP_EXE_CLO,P1.ACP_EXE_BLO,\nP1.ACP_SRC_FORMAT,P1.ACP_SRC_VAR,P1.ACP_SRC_CLO,P1.ACP_SRC_BLO,\nP1." + (Object)((Object)UpdateDatabase.ColumnName.ACP_NUM) + "\n" + "from " + RdbmsUserLog.this.FULL_PROPERTY + "  P1\n" + "where  P1.SESS_ID='" + sessionId + "' and P1.ACP_NUM>" + lastVarNum + "\n " + "order by P1.SESS_ITER desc,P1.ACT_ITER desc";
        }

        public String getlstLinkChangesQuery(String sessionId) {
            return "SELECT\nLNK_ID, LNK_ITER, LNK_DATE, LNK_TYPE, LNK_MANDATORY, LNK_STATUS,LNK_EXE_FORMAT,LNK_EXE_VAR,LNK_EXE_CLO,LNK_EXE_BLO,\nLNK_SRC_FORMAT,LNK_SRC_VAR,LNK_SRC_CLO,LNK_SRC_BLO,\nSESS_ITER\nfrom " + RdbmsUserLog.this.FULL_LINK + "\n" + "where  SESS_ID='" + sessionId + "'\n" + "order by SESS_ITER desc, LNK_ITER desc, LNK_DATE desc, LNK_STATUS desc";
        }

        public String deleteSessionQuery(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_SESSION + " WHERE SESS_ID = '" + sessionId + "'";
        }

        public String deleteLinkSessionQuery(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_LINK + "  WHERE SESS_ID = '" + sessionId + "'";
        }

        public String deletePropertySessionQuery(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_PROPERTY + "  WHERE SESS_ID = '" + sessionId + "'";
        }

        public String deleteActionSessionQuery(String sessionId, boolean deleteOnlyAction) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_ACTION + " WHERE  SESS_ID = '" + sessionId + "'" + (deleteOnlyAction ? " AND ACT_TYPE='Code'" : "");
        }

        public String deleteUALSessionQuery(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_USER_LOG + " WHERE  SESS_ID = '" + sessionId + "'";
        }

        public String deleteChildSessionQuery(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + RdbmsUserLog.this.FULL_CHILD_SESSION + "  WHERE SESS_ID = '" + sessionId + "'";
        }

        public String addActionUserLogQuery() {
            return "Insert into " + RdbmsUserLog.this.FULL_USER_LOG + " (SESS_ID, SESS_ITER, UAL_NUM,ACT_ID, ACT_ITER,ACT_ID_P, ACT_ITER_P, UAL_TSTAMP, UAL_PATH";
        }

        public String getActionsQuery(String sessionId, int sessIter, int lastNum) {
            return "SELECT * FROM " + RdbmsUserLog.this.FULL_ACTION + " WHERE SESS_ID = '" + sessionId + "'" + " AND ACT_NUM>" + lastNum + "\n order by SESS_ITER desc, ACT_ITER desc";
        }

        public String getDeleteInexistantPropertiesStaticQuery() {
            return this.getDelete(UpdateDatabase.TableName.ACTION_SPROP_ASP, UpdateDatabase.TableName.DELIVERY_DLV, "DLV_ID");
        }

        public String deleteSessionStat(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + UpdateDatabase.TableName.SESSION_STAT_SST.getFullName(RdbmsUserLog.this) + "  WHERE SESS_ID = '" + sessionId + "'";
        }

        public String deleteSessionProcessStat(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + UpdateDatabase.TableName.PROCESS_STAT_PST.getFullName(RdbmsUserLog.this) + "  WHERE SESS_ID = '" + sessionId + "'";
        }

        public String deleteSessionActionStat(String sessionId) {
            return String.valueOf(RdbmsUserLog.this.userLogRdbmsDeleteSyntaxe) + " " + UpdateDatabase.TableName.ACTION_STAT_AST.getFullName(RdbmsUserLog.this) + "  WHERE SESS_ID = '" + sessionId + "'";
        }
    }

    class Set {
        Set() {
        }

        void putInputStreamnCompressed(InputStream in, PreparedStatement stmt, int position) throws Exception {
            byte[] b = CommonUtils.inputStreamToByteArray((InputStream)in);
            byte[] c = CommonUtils.compressByteArray((byte[])b, (int)RdbmsUserLog.this.compressionLevel);
            stmt.setBytes(position, c);
        }

        void putStringBlob(String str, PreparedStatement stmt, int position) throws Exception {
            StringInputStream in = new StringInputStream(str);
            stmt.setBinaryStream(position, (InputStream)in, str.length());
        }

        void putStringClob(String str, PreparedStatement stmt, int position) throws Exception {
            StringReader stringReader = new StringReader(str);
            stmt.setCharacterStream(position, (Reader)stringReader, str.length());
        }

        private Map<String, String> getPropertyQuery(String prefix1, String prefix2, String query, String value1, String value2) {
            String tmp = ", " + prefix1 + "_FORMAT, ";
            String format1 = "";
            format1 = value1 == null || value1.length() <= RdbmsUserLog.this.propertyVarcharMaxSize ? "VAR" : (RdbmsUserLog.this.propertyClobMaxSize == -1 || value1.length() <= RdbmsUserLog.this.propertyClobMaxSize ? "CLO" : "BLO");
            tmp = String.valueOf(tmp) + prefix1 + "_" + format1;
            boolean equals = value2 != null && value2.equals(value1);
            String format2 = "";
            if (value2 != null && !equals) {
                tmp = String.valueOf(tmp) + "," + prefix2 + "_FORMAT, ";
                format2 = value2 == null || value2.length() <= RdbmsUserLog.this.propertyVarcharMaxSize ? "VAR" : (RdbmsUserLog.this.propertyClobMaxSize == -1 || value2.length() <= RdbmsUserLog.this.propertyClobMaxSize ? "CLO" : "BLO");
                tmp = String.valueOf(tmp) + prefix2 + "_" + format2;
            }
            String result = String.valueOf(query) + tmp + ") values (";
            String values = null;
            String[] stringArray = result.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                values = values == null ? "?" : String.valueOf(values) + ",?";
                ++n2;
            }
            result = String.valueOf(result) + values + ")";
            HashMap<String, String> result2 = new HashMap<String, String>();
            result2.put("query", result);
            result2.put("format1", format1);
            if (value2 != null && !equals) {
                result2.put("format2", format2);
            }
            return result2;
        }

        private void setValue(String format, PreparedStatement stmt, String value, int position) throws Exception {
            this.setValue(format, stmt, value, position, position + 1);
        }

        private void setValue(String format, PreparedStatement stmt, String value, int positionFormat, int positionValue) throws Exception {
            if (format.equals("VAR")) {
                stmt.setString(positionFormat, "VARCHAR");
                stmt.setString(positionValue, value);
            } else if (format.equals("CLO")) {
                stmt.setString(positionFormat, "CLOB");
                RdbmsUserLog.this.set.putStringClob(value, stmt, positionValue);
            } else if (RdbmsUserLog.this.propertyBinaryFormat.equals("COMPRESSED")) {
                stmt.setString(positionFormat, "BLOB_COMPRESSED");
                RdbmsUserLog.this.set.putInputStreamnCompressed((InputStream)new StringInputStream(value), stmt, positionValue);
            } else {
                stmt.setString(positionFormat, "BLOB");
                RdbmsUserLog.this.set.putStringBlob(value, stmt, positionValue);
            }
        }
    }
}

