/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog.log4j;

import com.indy.engine.userLog.AbstractSessionLogWriter;
import com.indy.engine.userLog.SessionRecorder;
import com.indy.engine.userLog.log4j.SessionRecordDTO;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class Log4SessionLog
extends AbstractSessionLogWriter {
    private static final String LOGGER_PREFIX = "com.indy.engine.session.";
    private static final String SESSION_START_LOGGER = "com.indy.engine.session.session.start";
    private static final String SESSION_END_LOGGER = "com.indy.engine.session.session.end";
    private static final String ACTION_START_LOGGER = "com.indy.engine.session.action.start";
    private static final String ACTION_END_LOGGER = "com.indy.engine.session.action.end";
    static Logger sessionStartLogger = LogManager.getLogger((String)"com.indy.engine.session.session.start");
    static Logger sessionEndLogger = LogManager.getLogger((String)"com.indy.engine.session.session.end");
    static Logger actionStartLogger = LogManager.getLogger((String)"com.indy.engine.session.action.start");
    static Logger actionEndLogger = LogManager.getLogger((String)"com.indy.engine.session.action.end");

    private static Logger getSessionStartLogger() {
        return sessionStartLogger;
    }

    private static Logger getSessionEndLogger() {
        return sessionEndLogger;
    }

    private static Logger getActionStartLogger() {
        return actionStartLogger;
    }

    private static Logger getActionEndLogger() {
        return actionEndLogger;
    }

    private Logger getLogger(SessionRecorder.SessionRecord ssr) {
        if (ssr instanceof SessionRecorder.SessionStartRecord) {
            return Log4SessionLog.getSessionStartLogger();
        }
        if (ssr instanceof SessionRecorder.SessionEndRecord) {
            return Log4SessionLog.getSessionEndLogger();
        }
        if (ssr instanceof SessionRecorder.ActionStartRecord) {
            return Log4SessionLog.getActionStartLogger();
        }
        if (ssr instanceof SessionRecorder.ActionEndRecord) {
            return Log4SessionLog.getActionEndLogger();
        }
        return null;
    }

    private String getLogMessage(SessionRecordDTO.DTO dto) {
        if (dto instanceof SessionRecordDTO.SessionStartDTO) {
            return "Session start";
        }
        if (dto instanceof SessionRecordDTO.SessionEndDTO) {
            return "Session End";
        }
        if (dto instanceof SessionRecordDTO.ActionStartDTO) {
            if (((SessionRecordDTO.ActionStartDTO)dto).actionType.equals("Process")) {
                return "Process start";
            }
            return "Action start";
        }
        if (dto instanceof SessionRecordDTO.ActionEndDTO) {
            if (((SessionRecordDTO.ActionEndDTO)dto).actionType.equals("Process")) {
                return "Process end";
            }
            return "Action end";
        }
        return "";
    }

    private boolean isError(SessionRecordDTO.DTO dto) {
        if (dto instanceof SessionRecordDTO.SessionEndDTO) {
            return ((SessionRecordDTO.SessionEndDTO)dto).sessionStatus.equals("error");
        }
        if (dto instanceof SessionRecordDTO.ActionEndDTO) {
            return ((SessionRecordDTO.ActionEndDTO)dto).actionStatus.contains("error");
        }
        return false;
    }

    @Override
    protected void write(SessionRecorder.SessionRecord ssr) throws EngineExceptionI {
        Logger logger = this.getLogger(ssr);
        ThreadContext.clearMap();
        LoggerKeyValueReader kvr = new LoggerKeyValueReader(logger);
        try {
            List<SessionRecorder.VariableRecord> variables = this.getVariableManager().consume(ssr);
            SessionRecordDTO.DTO dto = SessionRecordDTO.convert(ssr, variables);
            if (dto != null) {
                dto.read(kvr);
                if (this.isError(dto)) {
                    logger.error(this.getLogMessage(dto));
                } else {
                    logger.info(this.getLogMessage(dto));
                }
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static boolean isActive() {
        Logger logger = Log4SessionLog.getSessionStartLogger();
        if (logger != null) {
            return true;
        }
        logger = Log4SessionLog.getSessionEndLogger();
        if (logger != null) {
            return true;
        }
        logger = Log4SessionLog.getActionStartLogger();
        if (logger != null) {
            return true;
        }
        logger = Log4SessionLog.getActionEndLogger();
        return logger != null;
    }

    class LoggerKeyValueReader
    implements SessionRecordDTO.KeyValueReader {
        Logger logger;

        LoggerKeyValueReader(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void read(String key, String value) {
            ThreadContext.put((String)key, (String)value);
        }
    }
}

