/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog.reportLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.userLog.IUserLogI;
import com.indy.engine.userLog.reportLog.Messages;
import com.indy.engine.userLog.reportLog.ReportLogManagerI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ReportLogEngineI {
    public Map<String, ReportLogManagerI> lstLogManager = new ConcurrentHashMap<String, ReportLogManagerI>();
    IUserLogI uLog;

    public void clean() {
        for (ReportLogManagerI rlm : this.lstLogManager.values()) {
            rlm.clean();
        }
        this.lstLogManager.clear();
        this.uLog = null;
    }

    public Map<String, ISessionDataExchange> getAllSessions(int nbSessions, List<SessionFilterCriteria> lstfilters) {
        TreeMap<String, ISessionDataExchange> ret = new TreeMap<String, ISessionDataExchange>();
        Iterator<ReportLogManagerI> it = this.lstLogManager.values().iterator();
        Iterator<String> it2 = null;
        ISessionDataExchange tempSDE = null;
        String keySDE2 = null;
        while (it.hasNext()) {
            ReportLogManagerI rLogM = it.next();
            try {
                Map<String, ISessionDataExchange> itRet = rLogM.getLstSessions(nbSessions, lstfilters);
                if (itRet != null) {
                    for (String keySDE2 : itRet.keySet()) {
                        tempSDE = itRet.get(keySDE2);
                        tempSDE.setLogName(rLogM.logName);
                        ret.put(keySDE2, tempSDE);
                    }
                    itRet.clear();
                }
            }
            catch (EngineExceptionI e) {
                Global.dLog.write("ReportEngineServer", "ReportLogEngineI->getAllSessions", "Log :" + rLogM.logName + ", EngineExceptionI : " + e.getMessage(), 3, 0, "WARNING");
                Global.dLog.write("ReportEngineServer", "ReportLogEngineI->getAllSessions", e.getStackTraceString(), 5, 0, "WARNING");
            }
            Object var4_8 = null;
        }
        return ret;
    }

    public Map<String, ISessionDataExchange> getAllInactiveSessions() {
        TreeMap<String, ISessionDataExchange> ret = new TreeMap<String, ISessionDataExchange>();
        for (ReportLogManagerI rLogM : this.lstLogManager.values()) {
            try {
                Map<String, ISessionDataExchange> itRet = rLogM.getLstInactiveSessions();
                if (itRet == null) continue;
                ret.putAll(itRet);
                itRet.clear();
            }
            catch (EngineExceptionI e) {
                Global.dLog.write("ReportEngineServer", "ReportLogEngineI->getAllInactiveSessions", "Log :" + rLogM.logName + ", EngineExceptionI : " + e.getMessage(), 3, 0, "ERROR");
                Global.dLog.write("ReportEngineServer", "ReportLogEngineI->getAllInactiveSessions", e.getStackTraceString(), 5, 0, "ERROR");
            }
        }
        return ret;
    }

    public int purgeLogs(Date untilDate, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        ReportLogManagerI rlm2;
        int ret = 0;
        for (ReportLogManagerI rlm2 : this.lstLogManager.values()) {
            rlm2.purgeLogs(untilDate, filters, statusList, currentRuntime);
        }
        Iterator<ReportLogManagerI> it = null;
        rlm2 = null;
        return ret;
    }

    public int purgeLogs(int nbSessions, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        ReportLogManagerI rlm2;
        int ret = 0;
        for (ReportLogManagerI rlm2 : this.lstLogManager.values()) {
            rlm2.purgeLogs(nbSessions, filters, statusList, currentRuntime);
        }
        Iterator<ReportLogManagerI> it = null;
        rlm2 = null;
        return ret;
    }

    public int purgeLog(String logName, Date untilDate, List<String> filters, List<Integer> statusList) throws EngineExceptionI {
        int ret = 0;
        ReportLogManagerI rlm = this.lstLogManager.get(logName);
        ret = rlm.purgeLogs(untilDate, filters, statusList, false);
        return ret;
    }

    public int deleteSession(String sessionId, String pLogName, int logLevel) throws EngineExceptionI {
        int ret = 0;
        ReportLogManagerI rlm = null;
        try {
            rlm = this.lstLogManager.get(pLogName);
            rlm.deleteSession(sessionId, logLevel);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write("ReportEngineServer", "ReportLogEngineI->deleteSession", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("ReportLogEngineI.0"), (Throwable)e);
        }
        return ret;
    }

    public IUserLogI getuLog() {
        return this.uLog;
    }

    public int fillLstLogManager() throws EngineExceptionI {
        int ret = 0;
        try {
            Global.dLog.write("ReportEngineServer", "ReportLogEngineI --> fillLstLogManager()", Messages.getString("ReportLogEngineI.4"), 0, 0, "DEBUG");
            for (Map<String, String> map : Global.getAllLogParameters().values()) {
                String userLogName = map.get("userLogName");
                if (userLogName == null || !userLogName.equals(Global.USERLOG_DEFAULT_NAME)) continue;
                String className = map.get("userLogClass");
                ReportLogManagerI rLM = null;
                if (className == null) continue;
                rLM = new ReportLogManagerI(userLogName);
                if (rLM.init() == 0) {
                    rLM.connect();
                    rLM.updateLog(false);
                    if (this.lstLogManager.put(userLogName, rLM) != null) {
                        throw new EngineExceptionI(String.format(Messages.getString("ReportLogEngineI.duplicateName"), userLogName));
                    }
                    if (this.uLog != null) continue;
                    this.uLog = rLM.uLog;
                    continue;
                }
                throw new EngineExceptionI(Messages.getString("ReportLogEngineI.5"));
            }
            Global.dLog.write("ReportEngineServer", "ReportLogEngineI --> fillLstLogManager()", Messages.getString("ReportLogEngineI.6"), 0, 0, "DEBUG");
        }
        catch (Exception e) {
            Global.getConsoleLogger().error(Messages.getString("ReportLogEngineI.7"), (Throwable)e);
            ret = -1;
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }
}

