/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.Global;
import com.indy.engine.RT_ERROR_CODE;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.wsdl.EmptyContentHandler;
import com.indy.engine.wsdl.InvocationCommon;
import com.indy.engine.wsdl.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.engine.wsdl._UUID;
import com.indy.runtime.xml.XMLOutputFactoryWrapper;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Invocation
extends InvocationCommon {
    boolean wrapped = false;
    String wrappedOutputName = null;
    private static final int PREPARED = 0;
    private static final int NOTHING = -1;
    private static final int RUNNING = 1;
    private static final int ENDED = 2;
    SOAPMessage inputMessage;
    private String randomID;
    private String userName;
    boolean writeErrorToRoot = false;
    private String clientHost;
    boolean isClear = false;
    private Integer logLevel = null;
    private boolean asynchronous = false;
    private String sessionName;
    private Delivery delivery;
    private HashMap<String, String> variables;
    List<VariableToGet> variablesToGet;
    WsdlAPI wsdlAPI;
    long delay;
    Logger log;
    private String sessionId;
    private String parentSessionId;
    private Map<String, IVariable> errors = new HashMap<String, IVariable>();
    private Map<String, IVariable> warnings = new HashMap<String, IVariable>();
    private List<Integer> status = new ArrayList<Integer>();
    Map<Delivery.Route, String> resourcesUUID = new HashMap<Delivery.Route, String>();
    Map<Delivery.Parameter, String> parametersValues = new HashMap<Delivery.Parameter, String>();
    private MainEngineI mainEngine;
    private int state = -1;
    private MessageFactory messageFactory;
    private File persistFile;
    long delayBeforeClear = 0L;
    private boolean askPrevious;

    void debug(String msg) {
        this.log.debug(String.valueOf(this.randomID) + " - " + msg);
    }

    void debug(String msg, Throwable t) {
        this.log.debug(String.valueOf(this.randomID) + " - " + msg, t);
    }

    void info(String msg) {
        this.log.info(String.valueOf(this.randomID) + " - " + msg);
    }

    void info(String msg, Throwable t) {
        this.log.info(String.valueOf(this.randomID) + " - " + msg, t);
    }

    void error(Throwable t) {
        this.log.error(this.randomID, t);
    }

    void error(String msg) {
        this.log.error(String.valueOf(this.randomID) + " - " + msg);
    }

    void error(String msg, Throwable t) {
        this.log.error(String.valueOf(this.randomID) + " - " + msg, t);
    }

    public void setWriteErrorToRoot(boolean writeErrorToRoot) {
        this.writeErrorToRoot = writeErrorToRoot;
    }

    public Invocation(SOAPMessage inputMessage, WsdlAPI wsdlAPI, String username, String clientHost) {
        this.clientHost = clientHost;
        this.inputMessage = inputMessage;
        this.wsdlAPI = wsdlAPI;
        this.log = wsdlAPI.log;
        this.randomID = _UUID.INSTANCE.uniqueNum();
        if (username == null) {
            Iterator it = inputMessage.getMimeHeaders().getAllHeaders();
            while (it.hasNext()) {
                MimeHeader o = (MimeHeader)it.next();
                if (!o.getName().equals("Authorization")) continue;
                this.userName = this.getUsernameFromHeader(o.getValue());
                break;
            }
        } else {
            this.userName = username;
        }
        this.info("Invocation");
    }

    private String getUsernameFromHeader(String value) {
        if (value.startsWith("Basic ")) {
            String encoded = value.split("Basic ")[1];
            String decoded = new String(Base64.getDecoder().decode(encoded));
            return decoded.split(":")[0];
        }
        return null;
    }

    public void clear() {
        if (!this.isClear) {
            this.isClear = true;
            this.delivery = null;
            this.inputMessage = null;
            this.wsdlAPI = null;
            this.sessionId = null;
            if (this.variablesToGet != null) {
                this.variablesToGet.clear();
                this.variablesToGet = null;
            }
            if (this.variables != null) {
                this.variables.clear();
                this.variables = null;
            }
            if (this.resourcesEvaluated != null) {
                this.resourcesEvaluated.clear();
            }
            this.resourcesEvaluated = null;
            if (this.parametersValues != null) {
                this.parametersValues.clear();
            }
            this.parametersValues = null;
            this.mainEngine = null;
            if (this.persistFile != null) {
                try {
                    boolean v = this.persistFile.delete();
                    if (!v) {
                        this.error(String.valueOf(Messages.getString("Invocation.0")) + this.persistFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
            this.persistFile = null;
        }
    }

    private void readMessage(SOAPMessage message) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        message.writeTo((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        InvokeContentHandler sch = new InvokeContentHandler();
        saxReader.setContentHandler(sch);
        saxReader.parse(new InputSource(is));
        sch.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SOAPMessage invoke() {
        SOAPMessage outPutMessage;
        block48: {
            FileInputStream is;
            HashMap<String, Object> parameters;
            String deliveryName;
            WsdlAPI wsdlAPI = this.wsdlAPI;
            this.variables = new HashMap();
            try {
                this.messageFactory = null;
                this.messageFactory = this.inputMessage.getClass().getName().equals("com.sun.xml.internal.messaging.saaj.soap.ver1_2.Message1_2Impl") ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance();
                String[] mh = this.inputMessage.getMimeHeaders().getHeader("Soapaction");
                String value = mh[0];
                deliveryName = value.replaceAll("\"", "");
                this.info(String.valueOf(Messages.getString("Invocation.1")) + deliveryName);
                this.variablesToGet = new ArrayList<VariableToGet>();
                this.delivery = wsdlAPI.allDeliveries.get(deliveryName);
                if (this.delivery == null) {
                    WebServiceException e = new WebServiceException(String.valueOf(deliveryName) + Messages.getString("Invocation.2"));
                    this.error((Throwable)e);
                    throw e;
                }
                this.errors = new HashMap<String, IVariable>();
                this.warnings = new HashMap<String, IVariable>();
                this.status = new ArrayList<Integer>();
                if (deliveryName == null) return null;
                parameters = new HashMap<String, Object>();
                parameters.put("launchMode", "WEB_SERVICE");
                parameters.put("executionMode", "MEMORY");
                parameters.put("guestHost", InetAddress.getLocalHost().getHostName());
                ArrayList<1> handlers = new ArrayList<1>();
                handlers.add(new MainEngineI.EngineHandler(){

                    @Override
                    public void beforeStoping(MainEngineI mainEngine) {
                        try {
                            Variable var2;
                            Invocation.this.status.add(mainEngine.getSessionStatus());
                            Invocation.this.parametersValues.clear();
                            Variable var = mainEngine.getEngineContext().getVariable(VariableType.CORE_ROOT.getName());
                            IAction mainAction = mainEngine.lstActions.get(var.getValue());
                            mainAction.evaluateActionVariables();
                            for (Delivery.Parameter param : Invocation.this.delivery.getParameters().values()) {
                                var2 = mainAction.getActionVariable(param.getName());
                                String value = null;
                                if (var2 != null && var2.getValue() != null) {
                                    value = var2.getValue();
                                    Invocation.this.parametersValues.put(param, value);
                                }
                                Invocation.this.debug("Param: " + param.getName() + "=" + value);
                            }
                            for (VariableToGet v : Invocation.this.variablesToGet) {
                                var2 = mainEngine.getEngineContext().getAbsolutVariable(v.path);
                                if (var2 == null) continue;
                                v.value = var2.getValue();
                            }
                            Map<String, Variable> map = mainEngine.getLstSessionErrors();
                            for (String name : map.keySet()) {
                                Invocation.this.errors.put(name, new Variable(map.get(name).toMap()));
                            }
                            map = mainEngine.getLstSessionWarnings();
                            for (String name : map.keySet()) {
                                Invocation.this.warnings.put(name, new Variable(map.get(name).toMap()));
                            }
                        }
                        catch (EngineExceptionI e) {
                            e.printStackTrace();
                        }
                        Invocation.this.debug(String.valueOf(Messages.getString("Invocation.3")) + mainEngine.getSessionID() + Messages.getString("Invocation.4"));
                    }

                    @Override
                    public void beforeStarting(MainEngineI mainEngine) {
                    }
                });
                parameters.put("handlers", handlers);
                parameters.put("dir", "webservices");
                this.readMessage(this.inputMessage);
                if (this.askPrevious) {
                    File file = new File(String.valueOf(wsdlAPI.getWsdlMessageDir().getAbsolutePath()) + File.separator + this.getSessionId() + ".xml");
                    if (!file.exists()) {
                        ISessionDataExchange sde = Global.engineServer.getSessionInfo(this.getSessionId());
                        if (sde == null) throw new SOAPException(RT_ERROR_CODE.RT_090_002.getMessage());
                        if (sde.getStatus() == 2) {
                            throw new SOAPException(RT_ERROR_CODE.RT_090_001.getMessage());
                        }
                        if (sde.getStatus() == 10) {
                            throw new SOAPException(RT_ERROR_CODE.RT_090_001.getMessage());
                        }
                        if (sde.getStatus() != 9) throw new SOAPException(RT_ERROR_CODE.RT_090_002.getMessage());
                        throw new SOAPException(RT_ERROR_CODE.RT_090_001.getMessage());
                    }
                    is = null;
                    is = new FileInputStream(file);
                    SOAPMessage message = this.messageFactory.createMessage(null, (InputStream)is);
                    ((InputStream)is).close();
                    is = null;
                    wsdlAPI.askToClear(this.sessionId, this.delay);
                    SOAPMessage sOAPMessage = message;
                    return sOAPMessage;
                }
                this.debug(Messages.getString("Invocation.5"));
                parameters.put("parentSessionId", this.parentSessionId);
            }
            catch (Exception e) {
                block49: {
                    if (e instanceof WebServiceException) {
                        this.error(e);
                        throw (WebServiceException)e;
                    }
                    break block49;
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                WebServiceException ex = new WebServiceException((Throwable)e);
                this.error((Throwable)ex);
                throw ex;
            }
            parameters.put("sessName", this.sessionName);
            if (this.logLevel != null) {
                parameters.put("logLevel", this.logLevel);
            }
            this.sessionId = Global.engineServer.initSession(deliveryName, parameters, this.variables);
            this.state = 0;
            this.info("SessionId is: " + this.getSessionId());
            this.randomID = this.getSessionId();
            if (this.parentSessionId != null) {
                this.debug("attach parentSessionId: " + this.parentSessionId);
                MainEngineI parentEngine = Global.engineServer.getMainEngine(this.parentSessionId);
                if (parentEngine != null) {
                    parentEngine.getMyAction().getActionContext().addChildSession(this.getSessionId(), 1);
                }
            }
            this.debug("session is prepared: " + this.getSessionId());
            this.mainEngine = Global.engineServer.getMainEngine(this.getSessionId());
            if (this.mainEngine == null) {
                WebServiceException e = new WebServiceException(String.valueOf(deliveryName) + Messages.getString("Invocation.6"));
                this.error((Throwable)e);
                throw e;
            }
            String remoteSessionUUID = UUID.randomUUID().toString();
            RemoteSessionManagement.INSTANCE.getRemote(remoteSessionUUID, this.clientHost, this.userName);
            this.mainEngine.setRemoteSessionInfo(RemoteSessionManagement.INSTANCE.getRemoteSessionInfo(remoteSessionUUID));
            Iterator<Delivery.Route> message = this.delivery.getRoutes().iterator();
            while (true) {
                if (!message.hasNext()) {
                    this.debug("Starting session " + this.getSessionId() + "...");
                    if (this.asynchronous) break;
                    outPutMessage = this.execute();
                    break block48;
                }
                Delivery.Route route = message.next();
                if (route.getResource() != null) {
                    boolean ret;
                    this.debug("Resource evaluation: " + route.getResource());
                    String evaluated = this.mainEngine.getMyAction().evaluateExpression(route.getResource());
                    this.resourcesEvaluated.put(route, evaluated);
                    this.debug("Resource evaluation result: " + evaluated);
                    String resourceUUID = this.resourcesUUID.get(route);
                    if (resourceUUID == null) continue;
                    File dest = new File(evaluated);
                    if (dest.exists()) {
                        this.debug("Resource " + evaluated + " already exists, erase...");
                        ret = dest.delete();
                        if (!ret) {
                            WebServiceException e = new WebServiceException(String.valueOf(deliveryName) + Messages.getString("Invocation.7") + dest.getAbsolutePath());
                            this.error((Throwable)e);
                            throw e;
                        }
                    }
                    try {
                        this.debug("Resource: " + resourceUUID + " renamed to: " + dest.getAbsolutePath() + "...");
                        ret = new File(resourceUUID).renameTo(dest);
                        if (!ret) {
                            WebServiceException e = new WebServiceException(String.valueOf(deliveryName) + Messages.getString("Invocation.8") + resourceUUID + " to:" + dest.getAbsolutePath());
                            this.error((Throwable)e);
                            throw e;
                        }
                        this.debug("Resource: " + resourceUUID + " is renamed to: " + dest.getAbsolutePath());
                    }
                    catch (Exception e1) {
                        WebServiceException e = new WebServiceException(String.valueOf(deliveryName) + Messages.getString("Invocation.9") + resourceUUID + Messages.getString("Invocation.10") + dest.getAbsolutePath(), (Throwable)e1);
                        this.error((Throwable)e);
                        throw e;
                    }
                }
                this.resourcesEvaluated.remove(route);
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Invocation.this.execute();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (EngineExceptionI e) {
                        e.printStackTrace();
                    }
                    catch (SOAPException e) {
                        e.printStackTrace();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                    catch (FactoryConfigurationError e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            thread.setName("Invoke WSDL: " + this.getSessionId());
            thread.start();
            this.state = 1;
            outPutMessage = this.messageFactory.createMessage();
            SOAPBody body = outPutMessage.getSOAPBody();
            body.addNamespaceDeclaration("stbPS", "http://stambia.com/xsd/standard");
            SOAPBody root = body;
            if (this.wrapped) {
                this.writeStandardParameters((SOAPElement)root);
            } else {
                SOAPElement stdOutput = root.addChildElement("stambiaOutput");
                this.writeStandardParameters(stdOutput);
            }
        }
        this.debug("Invocation is ended, return outputMessage");
        return outPutMessage;
        finally {
            try {
                if (!(this.asynchronous || this.getSessionId() == null || this.state != 0 || this.mainEngine != null && this.mainEngine.getSessionStatus() != 10)) {
                    Global.engineServer.deleteSession(this.getSessionId(), 0);
                }
            }
            catch (Exception e) {
                this.error(e);
            }
            if (this.askPrevious) {
                try {
                    this.clear();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
    }

    private SOAPMessage execute() throws EngineExceptionI, SOAPException, XMLStreamException, FactoryConfigurationError, IOException {
        this.mainEngine.runMainEngineSync(false, true);
        this.state = 2;
        int _status = this.status.get(0);
        boolean output = _status == 1;
        SOAPMessage outPutMessage = this.messageFactory.createMessage();
        SOAPBody body = outPutMessage.getSOAPBody();
        body.addNamespaceDeclaration("stbPS", "http://stambia.com/xsd/standard");
        body.addNamespaceDeclaration("stbXP", "http://stambia.com/xsd/parameters");
        SOAPBody root = body;
        if (this.wrappedOutputName != null) {
            root = body.addChildElement(new QName("http://stambia.com/document/literal/wrapped", this.wrappedOutputName, "stbWP"));
        }
        if (this.wrapped) {
            this.writeStandardParameters((SOAPElement)root);
        } else {
            SOAPElement stdOutput = root.addChildElement("stambiaOutput", "stbPS");
            this.writeStandardParameters(stdOutput);
        }
        if (this.wrapped) {
            this.writeOutputParameters((SOAPElement)root, false);
        } else {
            SOAPElement elt = root.addChildElement("userParameters");
            this.writeOutputParameters(elt, false);
            if (!elt.hasChildNodes()) {
                root.removeChild((Node)elt);
            }
        }
        if (output || this.delivery.isProduceOutputIfError()) {
            this.writeRoutes((SOAPElement)root);
        }
        if (!output) {
            SOAPFault fault = body.addFault();
            fault.setFaultCode(new QName(body.getNamespaceURI(), "server"));
            fault.setFaultString("Error in session");
            HashMap<String, SOAPElement> group = new HashMap<String, SOAPElement>();
            Detail detail = fault.addDetail();
            SOAPBody faultRoot = this.writeErrorToRoot ? root : detail;
            SOAPElement stambiaFault = faultRoot.addChildElement("stambiaFault", "stbPS");
            this.writeWarning(stambiaFault, this.warnings, group);
            this.writeError(stambiaFault, this.errors, group);
            if (!stambiaFault.hasChildNodes()) {
                detail.removeChild((Node)stambiaFault);
            }
        }
        if (this.delay > 0L) {
            OutputStream os = null;
            try {
                this.persistFile = new File(String.valueOf(this.wsdlAPI.getWsdlMessageDir().getAbsolutePath()) + File.separator + this.getSessionId() + ".xml");
                this.persistFile.deleteOnExit();
                os = new FileOutputStream(this.persistFile);
                outPutMessage.writeTo(os);
                os.close();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.clearRoute(this.errors.size() > 0);
        this.wsdlAPI.askToClear(this, this.delay);
        return outPutMessage;
    }

    private void writeOutputParameters(SOAPElement elt, boolean error) throws SOAPException {
        for (Delivery.Parameter param : this.delivery.getParameters().values()) {
            String value = this.parametersValues.get(param);
            if (value == null || (!param.isOutput() || error) && (!param.isFault() || !error)) continue;
            SOAPElement _var = elt.addChildElement(param.getName());
            _var.setTextContent(value);
        }
    }

    private void writeStandardParameters(SOAPElement elt) throws SOAPException {
        if (this.wrapped) {
            elt.addAttribute(new QName("pSessionId"), this.getSessionId());
        } else {
            elt.addAttribute(new QName("sessionId"), this.getSessionId());
        }
    }

    private void writeWarning(SOAPElement elt, Map<String, IVariable> sessionWarning, Map<String, SOAPElement> group) throws SOAPException {
        for (IVariable var : sessionWarning.values()) {
            if (var.getValue() == null || var.getValue().equals("Error in process")) continue;
            String tmp = var.getName().substring(0, var.getName().lastIndexOf(47));
            String tmp2 = var.getName().substring(var.getName().lastIndexOf(47));
            SOAPElement action = group.get(tmp);
            if (action == null) {
                action = elt.addChildElement("action");
                group.put(tmp, action);
                action.setAttribute("path", tmp);
            }
            SOAPElement _var = action.addChildElement("warning");
            _var.setAttribute("name", tmp2);
            _var.setAttribute("value", var.getValue());
        }
    }

    private void writeRoutes(SOAPElement root) throws SOAPException, XMLStreamException, FactoryConfigurationError, IOException {
        for (Delivery.Route route : this.delivery.getRoutes()) {
            String evaluated;
            File out;
            if (!route.isOutput() || !(out = new File(evaluated = (String)this.resourcesEvaluated.get(route))).exists()) continue;
            if (route.getTargetNameSpace(this.wrapped) != null && !route.getTargetNameSpace(this.wrapped).isEmpty()) {
                root.addNamespaceDeclaration(route.getTargetPrefix(this.wrapped), route.getTargetNameSpace(this.wrapped));
            }
            try (FileInputStream _is = null;){
                _is = new FileInputStream(evaluated);
                route.write(_is, root, this.wrapped);
            }
        }
    }

    private void writeError(SOAPElement elt, Map<String, IVariable> sessionError, Map<String, SOAPElement> group) throws SOAPException {
        for (IVariable var : sessionError.values()) {
            if (var.getValue() == null || var.getValue().equals("Error in process")) continue;
            String tmp = var.getName().substring(0, var.getName().lastIndexOf(47));
            String tmp2 = var.getName().substring(var.getName().lastIndexOf(47) + 1);
            SOAPElement action = group.get(tmp);
            if (action == null) {
                action = elt.addChildElement("action");
                group.put(tmp, action);
                action.setAttribute("path", tmp);
            }
            SOAPElement _var = action.addChildElement("error");
            _var.setAttribute("name", tmp2);
            _var.setAttribute("value", var.getValue());
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    class InvokeContentHandler
    extends EmptyContentHandler {
        String path = "";
        String documentPath = "";
        boolean startParameters = false;
        String varName = null;
        String varValue = null;
        XMLStreamWriter xsw;
        OutputStream os;
        Map<String, EmptyContentHandler> contentsHandler = new HashMap<String, EmptyContentHandler>();
        String wrappedInputName;
        int proof = 0;

        InvokeContentHandler() {
        }

        private void clear() {
            this.path = null;
            this.documentPath = null;
            this.varName = null;
            this.varValue = null;
            if (this.xsw != null) {
                this.xsw = null;
            }
            if (this.contentsHandler != null) {
                this.contentsHandler.clear();
                this.contentsHandler = null;
            }
        }

        private void statisticContentHandler() {
            this.contentsHandler.put("stambiaInput/get/variable", new EmptyContentHandler(){

                @Override
                public void endElement(String arg0, String arg1, String arg2) throws SAXException {
                }

                @Override
                public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
                }
            });
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            if (this.startParameters) {
                if (this.varName != null) {
                    if (this.varValue == null) {
                        this.varValue = "";
                    }
                    this.varValue = String.valueOf(this.varValue) + new String(ch, start, end);
                }
            } else if (this.xsw != null) {
                try {
                    this.xsw.writeCharacters(ch, start, end);
                }
                catch (XMLStreamException e) {
                    throw new SAXException(e);
                }
            }
        }

        private void readStandard(String arg0, String localName, String arg2, Attributes arg3) {
            String tmp;
            if (Invocation.this.wrapped) {
                tmp = arg3.getValue("pAsynchronous");
                Invocation.this.asynchronous = tmp != null && tmp.equals("true");
            } else {
                tmp = arg3.getValue("synchronous");
                Invocation.this.asynchronous = tmp != null && tmp.equals("false");
            }
            Invocation.this.parentSessionId = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pP" : "p") + "arentSessionId");
            Invocation.this.parentSessionId = (String)(Invocation.this.parentSessionId != null && (Invocation.this.parentSessionId.equals("?") || Invocation.this.parentSessionId.trim().isEmpty()) ? null : Invocation.this.parentSessionId);
            Invocation.this.sessionName = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pS" : "s") + "essionName");
            try {
                Invocation.this.logLevel = Integer.valueOf(arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pl" : "l") + "ogLevel"));
            }
            catch (Exception exception) {
                if (Invocation.this.wrapped) {
                    try {
                        Invocation.this.logLevel = Integer.valueOf(arg3.getValue("pLogLevel"));
                    }
                    catch (Exception exception2) {
                        Invocation.this.logLevel = null;
                    }
                }
                Invocation.this.logLevel = null;
            }
            Invocation.this.sessionName = (String)(Invocation.this.sessionName != null && (Invocation.this.sessionName.equals("?") || Invocation.this.sessionName.trim().isEmpty()) ? null : Invocation.this.sessionName);
            Invocation.this.sessionId = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pS" : "s") + "essionId");
            if (Invocation.this.getSessionId() != null && !Invocation.this.getSessionId().isEmpty() && !Invocation.this.getSessionId().equals("?")) {
                Invocation.this.askPrevious = true;
            }
            String _persistence = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pP" : "p") + "ersistence");
            String _inputMessageManagement = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pK" : "k") + "eepInputMessage");
            String _outputMessageManagement = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pK" : "k") + "eepOutputMessage");
            String _faultMessageManagement = arg3.getValue(String.valueOf(Invocation.this.wrapped ? "pK" : "k") + "eepFaultMessage");
            if (_inputMessageManagement == null) {
                _inputMessageManagement = Invocation.this.delivery.getKeepInputMessage();
            }
            Invocation.this.setInputMessageManagement(_inputMessageManagement);
            if (_outputMessageManagement == null || _outputMessageManagement.isEmpty()) {
                _outputMessageManagement = Invocation.this.delivery.getKeepOutputMessage();
            }
            Invocation.this.setOutputMessageManagement(_outputMessageManagement);
            if (_faultMessageManagement == null || _faultMessageManagement.isEmpty()) {
                _faultMessageManagement = Invocation.this.delivery.getKeepFaultMessage();
            }
            Invocation.this.setFaultMessageManagement(_faultMessageManagement);
            int _default = 900000;
            try {
                Invocation.this.delay = Long.valueOf(_persistence);
                if (Invocation.this.delay <= 0L) {
                    Invocation.this.delay = 0L;
                }
            }
            catch (Exception exception) {
                Invocation.this.delay = _default;
                Invocation.this.delay = _persistence != null && _persistence.equals("true") ? (long)_default : (_persistence != null && _persistence.equals("false") ? 0L : (Invocation.this.askPrevious ? 0L : (Invocation.this.asynchronous ? (long)_default : 0L)));
            }
        }

        @Override
        public void startElement(String arg0, String localName, String arg2, Attributes arg3) throws SAXException {
            ++this.proof;
            this.path = String.valueOf(this.path) + "/" + localName;
            if (Invocation.this.wrapped && this.proof == 4 && (arg0 == null || arg0.isEmpty())) {
                this.varName = localName;
                this.startParameters = true;
            } else if (!Invocation.this.wrapped && this.proof == 4 && this.startParameters) {
                this.varName = localName;
            }
            if (arg0 != null && arg0.equals("http://stambia.com/document/literal/wrapped")) {
                Invocation.this.wrapped = true;
                Invocation.this.wrappedOutputName = String.valueOf(localName.substring(0, localName.length() - 5)) + "Output";
                this.wrappedInputName = localName;
                this.readStandard(arg0, localName, arg2, arg3);
            } else if (this.proof == 3 && localName.equals("userParameters")) {
                Invocation.this.debug("ReadXml: startParameter " + this.path);
                this.startParameters = true;
            } else if (arg0 != null && arg0.equals("http://stambia.com/xsd/standard")) {
                this.readStandard(arg0, localName, arg2, arg3);
            } else if (this.xsw == null && Invocation.this.wsdlAPI.allNamepsaces.containsKey(arg0)) {
                this.documentPath = this.path;
                for (Delivery.Route r : Invocation.this.delivery.getRoutes()) {
                    if (!r.getTargetNameSpace(Invocation.this.wrapped).equals(arg0) || !r.getElementName().equals(localName)) continue;
                    XMLOutputFactory xof = null;
                    try {
                        xof = XMLOutputFactoryWrapper.newFactory((String)Global.defaultXmlOutputFactory, null);
                    }
                    catch (FactoryConfigurationError factoryConfigurationError) {
                        xof = XMLOutputFactory.newFactory();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        xof = XMLOutputFactory.newInstance();
                    }
                    try {
                        Invocation.this.debug("set route UUID");
                        String uuid = String.valueOf(Global.TEMPORARY_FOLDER) + File.separator + _UUID.INSTANCE.randomUUID(Invocation.this.log) + ".xml";
                        Invocation.this.resourcesUUID.put(r, uuid);
                        Invocation.this.debug(uuid);
                        this.os = new FileOutputStream(uuid);
                        this.xsw = Invocation.this.delivery.getDefaultXmlEncoding() != null ? xof.createXMLStreamWriter(this.os, Invocation.this.delivery.getDefaultXmlEncoding()) : xof.createXMLStreamWriter(this.os);
                        if (!Invocation.this.delivery.isDefaultWriteXmlDeclation()) continue;
                        this.xsw.writeStartDocument(Invocation.this.delivery.getDefaultXmlEncoding() != null ? Invocation.this.delivery.getDefaultXmlEncoding() : Charset.defaultCharset().displayName(), "1.0");
                    }
                    catch (Exception e) {
                        Invocation.this.error(e);
                    }
                }
            }
            if (this.xsw != null) {
                try {
                    this.xsw.writeStartElement(localName);
                    int i = 0;
                    while (i < arg3.getLength()) {
                        String name = arg3.getQName(i);
                        String value = arg3.getValue(i);
                        this.xsw.writeAttribute(name, value);
                        ++i;
                    }
                }
                catch (XMLStreamException e) {
                    Invocation.this.error(e);
                }
            }
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            --this.proof;
            if (Invocation.this.wrapped && arg0 != null && arg0.equals("http://stambia.com/document/literal/wrapped")) {
                return;
            }
            if (this.xsw != null) {
                try {
                    this.xsw.writeEndElement();
                    if (this.documentPath.equals(this.path)) {
                        this.xsw.writeEndDocument();
                        this.xsw.close();
                        this.xsw = null;
                        this.os.close();
                        this.os = null;
                    }
                }
                catch (XMLStreamException e) {
                    Invocation.this.error(e);
                }
                catch (IOException e) {
                    Invocation.this.error(e);
                }
            }
            this.path = this.path.substring(0, this.path.lastIndexOf("/"));
            if (this.startParameters) {
                Invocation.this.debug("ReadXml: endParameter " + this.varName + ", value=" + this.varValue);
                if (this.varName != null && this.varValue != null) {
                    Invocation.this.variables.put("/*/" + this.varName, this.varValue);
                }
                this.varValue = null;
                this.varName = null;
            }
            if (!Invocation.this.wrapped && this.proof == 2 && arg1 != null && arg1.equals("userParameters")) {
                this.startParameters = false;
            }
            if (Invocation.this.wrapped && this.startParameters) {
                this.startParameters = false;
            }
        }
    }

    static enum VariableOperation {
        sum,
        get;

    }

    class VariableToGet {
        String path;
        String label;
        String value;
        VariableOperation operation;

        VariableToGet() {
        }
    }
}

