/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.Global;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.userLog.UserLogManagerI;
import com.indy.engine.wsdl.InvocationCommon;
import com.indy.engine.wsdl.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.engine.wsdl._UUID;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.Logger;

public class InvocationRest
extends InvocationCommon {
    private static final int PREPARED = 0;
    private static final int NOTHING = -1;
    private static final int RUNNING = 1;
    private static final int ENDED = 2;
    InputStream inputStream;
    private String randomID;
    private String executionConfiguration = null;
    private OutputStream outputStream;
    private String path;
    private String userName;
    private String clientHost;
    boolean isClear = false;
    private boolean asynchronous = false;
    private Delivery delivery;
    private Map<String, String> variables;
    WsdlAPI wsdlAPI;
    long delay;
    Logger log;
    private String sessionId;
    private Map<String, IVariable> errors = new HashMap<String, IVariable>();
    String responseCode;
    private Map<String, IVariable> warnings = new HashMap<String, IVariable>();
    private List<Integer> status = new ArrayList<Integer>();
    Map<Delivery.Route, String> resourcesUUID = new HashMap<Delivery.Route, String>();
    Map<Delivery.Parameter, String> parametersValues = new HashMap<Delivery.Parameter, String>();
    Map<String, String> outputHeaderValues = new HashMap<String, String>();
    byte[] responseBodyValue = null;
    private MainEngineI mainEngine;
    private int state = -1;
    private File persistFile;
    long delayBeforeClear = 0L;
    private boolean askPrevious;

    void debug(String msg) {
        this.log.debug(String.valueOf(this.randomID) + " - " + msg);
    }

    void debug(String msg, Throwable t) {
        this.log.debug(String.valueOf(this.randomID) + " - " + msg, t);
    }

    void info(String msg) {
        this.log.info(String.valueOf(this.randomID) + " - " + msg);
    }

    void info(String msg, Throwable t) {
        this.log.info(String.valueOf(this.randomID) + " - " + msg, t);
    }

    void error(Throwable t) {
        this.log.error(this.randomID, t);
    }

    void error(String msg) {
        this.log.error(String.valueOf(this.randomID) + " - " + msg);
    }

    void error(String msg, Throwable t) {
        this.log.error(String.valueOf(this.randomID) + " - " + msg, t);
    }

    public InvocationRest(InputStream inputStream, OutputStream outputStream, Delivery delivery, String path, WsdlAPI wsdlAPI, Map<String, String> inputParameters, String userName, String clientHost) {
        this.clientHost = clientHost;
        this.variables = inputParameters;
        this.delivery = delivery;
        this.path = path;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.wsdlAPI = wsdlAPI;
        this.log = wsdlAPI.getLogger();
        this.randomID = _UUID.INSTANCE.uniqueNum();
        this.userName = userName;
        this.info(Messages.getString("InvocationRest.0"));
    }

    public void clear() {
        if (!this.isClear) {
            this.isClear = true;
            this.delivery = null;
            this.inputStream = null;
            this.wsdlAPI = null;
            this.sessionId = null;
            if (this.variables != null) {
                this.variables.clear();
                this.variables = null;
            }
            if (this.resourcesEvaluated != null) {
                this.resourcesEvaluated.clear();
            }
            this.resourcesEvaluated = null;
            if (this.parametersValues != null) {
                this.parametersValues.clear();
            }
            this.parametersValues = null;
            if (this.outputHeaderValues != null) {
                this.outputHeaderValues.clear();
            }
            this.outputHeaderValues = null;
            this.responseBodyValue = null;
            this.mainEngine = null;
            if (this.persistFile != null) {
                try {
                    boolean v = this.persistFile.delete();
                    if (!v) {
                        this.error(String.valueOf(Messages.getString("InvocationRest.1")) + this.persistFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
            this.persistFile = null;
        }
    }

    public Map<String, IVariable> getErrors() {
        return this.errors;
    }

    public Integer getResponseCode() {
        try {
            return Integer.valueOf(this.responseCode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int doRun(Handler handler) throws Exception {
        this.mainEngine = Global.engineServer.getMainEngine(this.getSessionId());
        if (this.mainEngine == null) {
            WebServiceException e = new WebServiceException(String.valueOf(this.delivery.getName()) + Messages.getString("InvocationRest.5"));
            this.error((Throwable)e);
            throw e;
        }
        String remoteSessionUUID = UUID.randomUUID().toString();
        RemoteSessionManagement.INSTANCE.getRemote(remoteSessionUUID, this.clientHost, this.userName);
        this.mainEngine.setRemoteSessionInfo(RemoteSessionManagement.INSTANCE.getRemoteSessionInfo(remoteSessionUUID));
        boolean inputIsRead = false;
        for (Delivery.Route route : this.delivery.getRoutes()) {
            if (route.getResource() != null) {
                WebServiceException e;
                Throwable e2;
                this.debug("Resource evaluation: " + route.getResource());
                String evaluated = this.mainEngine.getMyAction().evaluateExpression(route.getResource());
                this.resourcesEvaluated.put(route, evaluated);
                this.debug("Resource evaluation result: " + evaluated);
                String resourceUUID = String.valueOf(Global.TEMPORARY_FOLDER) + File.separator + _UUID.INSTANCE.randomUUID(this.log) + ".dat";
                if (!route.isInput()) continue;
                if (inputIsRead) {
                    e2 = new WebServiceException(String.valueOf(this.delivery.getName()) + Messages.getString("InvocationRest.6"));
                    this.error(e2);
                    throw e2;
                }
                e2 = null;
                Object var9_14 = null;
                try (FileOutputStream os = new FileOutputStream(resourceUUID);){
                    InvocationRest.copy(this.inputStream, os);
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
                inputIsRead = true;
                File dest = new File(evaluated);
                if (dest.exists()) {
                    this.debug("Resource " + evaluated + " already exists, erase...");
                    boolean ret = dest.delete();
                    if (!ret) {
                        e = new WebServiceException(String.valueOf(this.delivery.getName()) + Messages.getString("InvocationRest.7") + dest.getAbsolutePath());
                        this.error((Throwable)e);
                        throw e;
                    }
                }
                try {
                    this.debug("Resource: " + resourceUUID + " renamed to: " + dest.getAbsolutePath() + "...");
                    boolean ret = new File(resourceUUID).renameTo(dest);
                    if (!ret) {
                        e = new WebServiceException(String.valueOf(this.delivery.getName()) + Messages.getString("InvocationRest.8") + resourceUUID + Messages.getString("InvocationRest.9") + dest.getAbsolutePath());
                        this.error((Throwable)e);
                        throw e;
                    }
                    this.debug("Resource: " + resourceUUID + " is renamed to: " + dest.getAbsolutePath());
                    continue;
                }
                catch (Exception e1) {
                    e = new WebServiceException(String.valueOf(this.delivery.getName()) + Messages.getString("InvocationRest.10") + resourceUUID + " to:" + dest.getAbsolutePath(), (Throwable)e1);
                    this.error((Throwable)e);
                    throw e;
                }
            }
            this.resourcesEvaluated.remove(route);
        }
        this.debug("Starting session " + this.getSessionId() + "...");
        if (!this.asynchronous) {
            this.mainEngine.runMainEngineSync(false, true);
            this.state = 2;
            int _status = this.status.get(0);
            boolean output = _status == 1;
            this.debug("Invocation is ended, return outputMessage");
            if (output || this.delivery.isProduceOutputIfError()) {
                handler.handleDone(this.delivery, this.parametersValues, this.outputHeaderValues, this.responseBodyValue, this.getResponseCode());
                this.writeRoutes(this.outputStream);
            }
            return _status;
        }
        this.mainEngine.runMainEngine(false, false);
        this.state = 2;
        handler.handleDone(this.delivery, null, null, null, 200);
        return 1;
    }

    public int invoke(Handler handler, String parentSessionId, String sessionName, Integer logLevel, UserLogManagerI.SynchMode synchLogMode) {
        boolean error;
        block22: {
            error = false;
            this.info(String.valueOf(Messages.getString("InvocationRest.2")) + this.path);
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.delivery == null) {
                handler.handleDeliveryUnexists();
                WebServiceException e = new WebServiceException(String.valueOf(Messages.getString("InvocationRest.3")) + this.path + " ");
                this.error((Throwable)e);
                throw e;
            }
            handler.handleDeliveryFound(this.delivery, params);
            this.variables.putAll(params);
            this.errors = new HashMap<String, IVariable>();
            this.warnings = new HashMap<String, IVariable>();
            this.status = new ArrayList<Integer>();
            if (this.delivery == null) break block22;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("launchMode", "WEB_SERVICE");
            parameters.put("executionMode", "MEMORY");
            parameters.put("guestHost", InetAddress.getLocalHost().getHostName());
            ArrayList<1> handlers = new ArrayList<1>();
            handlers.add(new MainEngineI.EngineHandler(){

                @Override
                public void beforeStoping(MainEngineI mainEngine) {
                    try {
                        String value;
                        Variable var2;
                        InvocationRest.this.status.add(mainEngine.getSessionStatus());
                        InvocationRest.this.parametersValues.clear();
                        InvocationRest.this.outputHeaderValues.clear();
                        InvocationRest.this.responseBodyValue = null;
                        Variable var = mainEngine.getEngineContext().getVariable(VariableType.CORE_ROOT.getName());
                        IAction mainAction = mainEngine.lstActions.get(var.getValue());
                        mainAction.evaluateActionVariables();
                        HttpRestDeliveryProperties hrdp = InvocationRest.this.delivery.getHttpRestDeliveryProperties();
                        if (hrdp != null && hrdp.getResponseBodyMapper() != null) {
                            Variable variable = mainAction.getActionVariable(hrdp.getResponseBodyMapper().getParameterName());
                            Object value2 = null;
                            if (variable != null && variable.getValue() != null) {
                                value2 = variable.getValue();
                                InvocationRest.this.responseBodyValue = ((String)value2).getBytes();
                            } else {
                                byte[] byArray = InvocationRest.this.responseBodyValue = hrdp.getResponseBodyMapper().getValue() != null ? hrdp.getResponseBodyMapper().getValueBytes() : null;
                            }
                        }
                        if (hrdp != null && hrdp.getOutputHeaderMapper() != null) {
                            for (HttpRestDeliveryProperties.ResponseParameterHeader responseParameterHeader : hrdp.getOutputHeaderMapper()) {
                                var2 = mainAction.getActionVariable(responseParameterHeader.getParameterName());
                                value = null;
                                value = var2 != null && var2.getValue() != null ? var2.getValue() : responseParameterHeader.getValue();
                                if (value != null) {
                                    InvocationRest.this.outputHeaderValues.put(responseParameterHeader.getHeaderName(), value);
                                }
                                InvocationRest.this.debug("Output Param Header: " + responseParameterHeader.getHeaderName() + "=" + value);
                            }
                        }
                        for (Delivery.Parameter parameter : InvocationRest.this.delivery.getParameters().values()) {
                            var2 = mainAction.getActionVariable(parameter.getName());
                            value = null;
                            if (var2 != null && var2.getValue() != null) {
                                value = var2.getValue();
                                InvocationRest.this.parametersValues.put(parameter, value);
                            }
                            InvocationRest.this.debug("Param: " + parameter.getName() + "=" + value);
                        }
                        Map<String, Variable> map = mainEngine.getLstSessionErrors();
                        for (String name : map.keySet()) {
                            InvocationRest.this.errors.put(name, new Variable(map.get(name).toMap()));
                        }
                        if (hrdp != null && hrdp.getResponseCodeMapper() != null) {
                            Variable var23 = mainAction.getActionVariable(hrdp.getResponseCodeMapper().getParameterName());
                            String value3 = null;
                            InvocationRest.this.responseCode = var23 != null && var23.getValue() != null ? (value3 = var23.getValue()) : hrdp.getResponseCodeMapper().getValue();
                        }
                        Map<String, Variable> map2 = mainEngine.getLstSessionWarnings();
                        for (String name : map2.keySet()) {
                            InvocationRest.this.warnings.put(name, new Variable(map2.get(name).toMap()));
                        }
                    }
                    catch (EngineExceptionI e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    InvocationRest.this.debug("Session " + mainEngine.getSessionID() + " is ended");
                }

                @Override
                public void beforeStarting(MainEngineI mainEngine) {
                }
            });
            if (!this.asynchronous) {
                parameters.put("handlers", handlers);
            }
            parameters.put("dir", "webservices");
            this.debug("Preparing session...");
            parameters.put("parentSessionId", parentSessionId);
            parameters.put("sessName", sessionName);
            parameters.put("synchLogMode", (Object)synchLogMode);
            if (logLevel != null) {
                parameters.put("logLevel", logLevel);
            }
            if (this.delivery.isExternalized() && this.executionConfiguration != null) {
                parameters.put("configuration", this.executionConfiguration);
            }
            this.sessionId = Global.engineServer.initSession(this.delivery.getName(), parameters, this.variables);
            this.state = 0;
            this.info(String.valueOf(Messages.getString("InvocationRest.4")) + this.getSessionId());
            this.randomID = this.getSessionId();
            if (parentSessionId != null) {
                this.debug("attach parentSessionId: " + parentSessionId);
                MainEngineI parentEngine = Global.engineServer.getMainEngine(parentSessionId);
                if (parentEngine != null) {
                    parentEngine.getMyAction().getActionContext().addChildSession(this.getSessionId(), 1);
                }
            }
            this.debug("session is prepared: " + this.getSessionId());
            int n = this.doRun(handler);
            try {
                if (!(this.asynchronous || this.getSessionId() == null || this.state != 0 || this.mainEngine != null && this.mainEngine.getSessionStatus() != 10)) {
                    Global.engineServer.deleteSession(this.getSessionId(), 0);
                }
            }
            catch (Exception e) {
                this.error(e);
            }
            this.clearRoute(error || this.errors.size() > 0);
            try {
                this.clear();
            }
            catch (Exception e) {
                this.error(e);
            }
            return n;
        }
        try {
            try {
                throw new Exception(Messages.getString("InvocationRest.11"));
            }
            catch (Exception e) {
                error = true;
                if (e instanceof WebServiceException) {
                    this.error(e);
                    throw (WebServiceException)e;
                }
                WebServiceException ex = new WebServiceException((Throwable)e);
                this.error((Throwable)ex);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            try {
                if (!(this.asynchronous || this.getSessionId() == null || this.state != 0 || this.mainEngine != null && this.mainEngine.getSessionStatus() != 10)) {
                    Global.engineServer.deleteSession(this.getSessionId(), 0);
                }
            }
            catch (Exception e) {
                this.error(e);
            }
            this.clearRoute(error || this.errors.size() > 0);
            try {
                this.clear();
            }
            catch (Exception e) {
                this.error(e);
            }
            throw throwable;
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        int len = is.read(buffer);
        while (len != -1) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
        }
    }

    private void writeRoutes(OutputStream os) throws Exception, XMLStreamException, FactoryConfigurationError, IOException {
        for (Delivery.Route route : this.delivery.getRoutes()) {
            String evaluated;
            File out;
            if (!route.isOutput() || !(out = new File(evaluated = (String)this.resourcesEvaluated.get(route))).exists()) continue;
            try (FileInputStream _is = null;){
                _is = new FileInputStream(evaluated);
                InvocationRest.copy(_is, os);
            }
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setAsynchronous(String asynchronous) {
        if (asynchronous != null) {
            try {
                this.asynchronous = Boolean.valueOf(asynchronous);
            }
            catch (Exception exception) {}
        }
    }

    public void setExecutionConfiguration(String executionConfiguration) {
        this.executionConfiguration = executionConfiguration;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public static interface Handler {
        public void handleDone(Delivery var1, Map<Delivery.Parameter, String> var2, Map<String, String> var3, byte[] var4, Integer var5) throws IOException;

        public void handleDeliveryUnexists() throws IOException;

        public void handleDeliveryFound(Delivery var1, Map<String, String> var2) throws IOException;
    }
}

