/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.xpath;

import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeMapVariableToXml {
    Map<Element, List<Element>> children = new HashMap<Element, List<Element>>();
    Element root;
    MainEngineI session;
    private TreeMap<String, IAction> lstActions;
    private Map<String, IVariable> lstVar;
    private Document xmldoc;
    private static String varNameSpaceURI = "http://www.stambia.com/variable";
    private static String varNameSpace = "var";
    Map<String, Element> allNodes;

    public TreeMapVariableToXml(TreeMap<String, IAction> lstActions, Map<String, IVariable> lstVar) throws ParserConfigurationException {
        this.lstActions = lstActions;
        this.lstVar = lstVar;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        this.xmldoc = impl.createDocument(null, "ROOT", null);
        this.root = this.xmldoc.getDocumentElement();
        this.root.getClass().toString();
        this.root.setAttribute("xmlns:" + varNameSpace, varNameSpaceURI);
        this.allNodes = new TreeMap<String, Element>();
    }

    public String evaluate(String startPoint, String expression, String separator) throws XPathExpressionException, XPathFactoryConfigurationException {
        XPathFactory fabrique = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", null);
        XPath xpath = fabrique.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaceURI.equals(varNameSpaceURI)) {
                    return varNameSpace;
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals(varNameSpace)) {
                    return varNameSpaceURI;
                }
                return null;
            }
        });
        Element start = this.allNodes.get("/" + startPoint);
        if (start != null) {
            XPathExpression exp = xpath.compile(expression);
            Object obj = exp.evaluate(start, XPathConstants.NODESET);
            if (obj instanceof NodeList) {
                String ret = "";
                int i = 0;
                while (i < ((NodeList)obj).getLength()) {
                    Node it = ((NodeList)obj).item(i);
                    if (!ret.isEmpty()) {
                        ret = String.valueOf(ret) + separator;
                    }
                    ret = String.valueOf(ret) + it.toString();
                    ++i;
                }
                return ret;
            }
            return obj.toString();
        }
        return null;
    }

    public void buildXml() throws ParserConfigurationException {
        Element e = null;
        Element parent = this.root;
        for (String name : this.lstActions.keySet()) {
            IAction action = this.lstActions.get(name);
            e = this.xmldoc.createElementNS(null, "action");
            this.allNodes.put("/" + name, e);
            int index = action.getActionName().lastIndexOf("/");
            index = index >= 0 ? index + 1 : 0;
            String shortName = action.getActionName().substring(index);
            this.addAttribute(null, "shortName", shortName, e);
            this.addAttribute(null, "name", action.getActionName(), e);
            this.addAttribute(null, "toleratedError", action.getActionStatic().getToleratedError(), e);
            this.addAttribute(null, "type", action.getActionStatic().getActionType(), e);
            for (String variableName : action.getActionLstVariables().keySet()) {
                IVariable variable = (IVariable)action.getActionLstVariables().get(variableName);
                index = variableName.lastIndexOf("/");
                index = index >= 0 ? index + 1 : 0;
                shortName = variableName.substring(index);
                this.addAttribute(varNameSpaceURI, String.valueOf(varNameSpace) + ":" + shortName, variable.getValue(), e);
            }
        }
        for (String name : this.allNodes.keySet()) {
            e = this.allNodes.get(name);
            int index = name.substring(1).lastIndexOf("/");
            if (index == -1) {
                parent = this.root;
            } else {
                String parentName = name.substring(0, index + 1);
                parent = this.allNodes.get(parentName);
            }
            parent.appendChild(e);
        }
    }

    private void addAttribute(String nameSpaceURI, String name, Object value, Element elt) {
        if (value != null && !value.toString().isEmpty()) {
            Attr attr = this.xmldoc.createAttributeNS(nameSpaceURI, name);
            attr.setValue(value.toString());
            elt.setAttributeNode(attr);
        }
    }
}

