/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.wsdl.SoapService;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet1;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet3;
import com.semarchy.xdi.runtime.httpserver.RuntimeServlet;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@SpringBootApplication
public class Application {
    public static final String PATTERN_MAPPING_API_CLIENT = "/client/*";
    public static final String PATTERN_MAPPING_DELIVERY_3 = "/rest/DeliveryService/3/*";
    public static final String PATTERN_MAPPING_DELIVERY_2 = "/rest/DeliveryService/2/*";
    public static final String PATTERN_MAPPING_DELIVERY_1 = "/rest/DeliveryService/1/*";
    private static final String BACKWARD_COMPATIBILITY_PREFIX = "Stambia";
    public static final String PATTERN_MAPPING_DELIVERY_3_BACK = "/rest/StambiaDeliveryService/3/*";
    public static final String PATTERN_MAPPING_DELIVERY_2_BACK = "/rest/StambiaDeliveryService/2/*";
    public static final String PATTERN_MAPPING_DELIVERY_1_BACK = "/rest/StambiaDeliveryService/1/*";
    private static final String P_GLOBAL_INTERNAL_ACTIVATE_HTTP_RUNTIME = "global.internalActivateHttpRuntime";
    private static final String P_GLOBAL_HTTP_SERVER_THREAD_POOL_SIZE = "global.soapServerThreadPoolSize";
    ConfigurableApplicationContext appContext;

    public void start() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("server.port", Global.HTTP_PORT);
            if (Global.getUserConfiguration().isAllowLocalhostOnly()) {
                props.put("server.address", "127.0.0.1");
            }
            props.put(P_GLOBAL_INTERNAL_ACTIVATE_HTTP_RUNTIME, Boolean.toString(Global.internalActivateHttpRuntime));
            props.put("server.error.include-exception", "true");
            props.put("server.error.include-message", "always");
            props.put("server.error.whitelabel.enabled", "false");
            props.put("server.servlet.encoding.charset", "UTF-8");
            props.put("server.servlet.encoding.force-response", "true");
            props.put("spring.main.banner-mode", "off");
            props.put("spring.lifecycle.timeout-per-shutdown-phase", System.getProperty("com.semarchy.xdi.graceful-shutdown-delay", "2s"));
            if (Global.soapServerThreadPoolSize != null) {
                try {
                    Integer.parseInt(Global.soapServerThreadPoolSize);
                    props.put(P_GLOBAL_HTTP_SERVER_THREAD_POOL_SIZE, Global.soapServerThreadPoolSize);
                }
                catch (Exception ex) {
                    throw new Exception("Wrong value for the parameter soapServerThreadPoolSize. A number is expected.", ex);
                }
            }
            this.configureSSL(props);
            this.appContext = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{Application.class}).properties(props).run(new String[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void configureSSL(Map<String, Object> props) throws Exception {
        if (Global.webServiceSecureProtocolType != null) {
            props.put("server.ssl.enabled", true);
            props.put("server.ssl.protocol", "TLS");
            props.put("server.ssl.enabled-protocols", Global.webServiceSecureProtocolType);
            props.put("server.ssl.key-store-type", Global.webServiceHttpsKeyStoreType == null ? "JKS" : Global.webServiceHttpsKeyStoreType);
            if (Global.webServiceHttpsKeyStoreFile == null) {
                throw new Exception("Missing webServiceKeyStoreFile parameter in engineParameters.xml");
            }
            File keyStoreFile = new File(Global.webServiceHttpsKeyStoreFile);
            if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
                throw new Exception(String.format("The specified path %s for the parameter webServiceKeyStoreFile is not a file or does not exist.", Global.webServiceHttpsKeyStoreFile));
            }
            props.put("server.ssl.key-store", Global.webServiceHttpsKeyStoreFile);
            if (Global.webServiceHttpsKeyStorePassword != null) {
                props.put("server.ssl.key-store-password", Global.webServiceHttpsKeyStorePassword);
            }
            if (Global.webServiceHttpsKeyStoreAlias != null) {
                props.put("server.ssl.key-alias", Global.webServiceHttpsKeyStoreAlias);
            }
            if (Global.webServiceHttpsKeyPassword != null) {
                props.put("server.ssl.key-password", Global.webServiceHttpsKeyPassword);
            }
        }
    }

    public void stop() {
        SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Bean
    @ConditionalOnProperty(value={"global.internalActivateHttpRuntime"}, havingValue="true")
    ServletRegistrationBean<HttpServlet> registerRuntimeServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new RuntimeServlet());
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_API_CLIENT));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient3() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet3(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_3, PATTERN_MAPPING_DELIVERY_3_BACK));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient2() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet2(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_2, PATTERN_MAPPING_DELIVERY_2_BACK));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient1() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet1(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_1, PATTERN_MAPPING_DELIVERY_1_BACK));
        return bean;
    }

    @Bean
    HandlerExceptionResolver exceptionHandler() {
        DefaultHandlerExceptionResolver r = new DefaultHandlerExceptionResolver(){

            public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
                return super.resolveException(request, response, handler, ex);
            }
        };
        return r;
    }
}

