/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.wsdl.HttpSoapWrapper;
import com.indy.engine.wsdl.Invocation;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeliveryRestServlet1
extends HttpServlet {
    WsdlAPI wsdlApi;
    private static Logger logger = LogManager.getLogger(DeliveryRestServlet1.class);

    public DeliveryRestServlet1(WsdlAPI wsdlApi) {
        this.wsdlApi = wsdlApi;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream is = null;
        try {
            if (!DeliveryRestServlet2.checkExecutionPermission(req.getUserPrincipal())) {
                resp.sendError(HttpStatus.FORBIDDEN.value());
                return;
            }
            String uri = req.getPathInfo();
            String deliveryName = uri.substring(uri.lastIndexOf("/") + 1);
            XMLEventFactory xef = XMLEventFactory.newFactory();
            baos = new ByteArrayOutputStream();
            XMLEventWriter writer = XMLOutputFactory.newFactory().createXMLEventWriter(baos, "UTF-8");
            writer.add(xef.createStartDocument());
            writer.add(xef.createStartElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Envelope"));
            writer.add(xef.createNamespace("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope"));
            writer.add(xef.createNamespace("wrap12345", "http://stambia.com/document/literal/wrapped"));
            writer.add(xef.createStartElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Header"));
            writer.add(xef.createEndElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Header"));
            writer.add(xef.createStartElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Body"));
            if (req.getMethod().equals(HttpMethod.GET.name())) {
                Map<String, String> query_pair = HttpSoapWrapper.splitQuery(req.getQueryString());
                writer.add(xef.createStartElement("wrap12345", "http://stambia.com/document/literal/wrapped", String.valueOf(deliveryName) + "Input"));
                for (String key : query_pair.keySet()) {
                    String val = query_pair.get(key);
                    if (val == null) continue;
                    writer.add(xef.createStartElement(new QName(key), null, null));
                    writer.add(xef.createCharacters(query_pair.get(key)));
                    writer.add(xef.createEndElement(new QName(key), null));
                }
                writer.add(xef.createEndElement("wrap12345", "http://stambia.com/document/literal/wrapped", String.valueOf(deliveryName) + "Input"));
            } else if (req.getMethod().equals(HttpMethod.POST.name())) {
                String requestContentType = req.getHeader("Content-Type");
                if (requestContentType == null || !requestContentType.contains("text/xml") || !requestContentType.replace(" ", "").replace("-", "").toLowerCase().contains("charset=utf8")) {
                    resp.sendError(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value());
                    return;
                }
            } else {
                resp.sendError(HttpStatus.METHOD_NOT_ALLOWED.value());
                return;
            }
            try {
                MessageFactory messageFactory = MessageFactory.newInstance();
                if (req.getMethod().equals(HttpMethod.POST.name())) {
                    XMLInputFactory factory = XMLInputFactory.newFactory();
                    factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                    factory.setProperty("javax.xml.stream.supportDTD", false);
                    XMLEventReader reader = factory.createXMLEventReader((InputStream)req.getInputStream());
                    while (reader.hasNext()) {
                        XMLEvent event = reader.nextEvent();
                        if (event.isStartDocument() || event.isEndDocument()) continue;
                        writer.add(event);
                    }
                }
                writer.add(xef.createEndElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Body"));
                writer.add(xef.createEndElement("soapenv12345", "http://schemas.xmlsoap.org/soap/envelope", "Envelope"));
                writer.add(xef.createEndDocument());
                writer.close();
                MimeHeaders mh = new MimeHeaders();
                is = new ByteArrayInputStream(baos.toByteArray());
                resp.setHeader("Content-Type", "text/xml;charset=UTF-8");
                SOAPMessage message = messageFactory.createMessage(mh, (InputStream)is);
                message.getMimeHeaders().addHeader("Soapaction", deliveryName);
                Invocation invok = new Invocation(message, this.wsdlApi, req.getUserPrincipal() == null ? null : req.getUserPrincipal().getName(), req.getRemoteHost());
                invok.setWriteErrorToRoot(true);
                SOAPMessage response = invok.invoke();
                NodeList nl = response.getSOAPBody().getChildNodes();
                if (nl.getLength() == 1) {
                    Node node = nl.item(0);
                    resp.setStatus(HttpStatus.OK.value());
                    this.writeNode(node, (OutputStream)resp.getOutputStream());
                } else if (nl.getLength() > 1) {
                    Node node = nl.item(0);
                    resp.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                    this.writeNode(node, (OutputStream)resp.getOutputStream());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos);
                e.printStackTrace(ps);
                ps.flush();
                resp.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), new String(bos.toByteArray()));
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void writeNode(Node node, OutputStream os) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError, IOException {
        DOMSource xmlSource = new DOMSource(node);
        try (OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");){
            StreamResult outputTarget = new StreamResult(osw);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            factory.newTransformer().transform(xmlSource, outputTarget);
        }
    }
}

