/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.wsdl.SoapServer;
import com.indy.engine.wsdl.SoapService;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.runtime.httpserver.SoapEndpointMapping;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ws.config.annotation.EnableWs;
import org.springframework.ws.config.annotation.WsConfigurerAdapter;
import org.springframework.ws.server.EndpointAdapter;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.transport.http.MessageDispatcherServlet;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition;
import org.springframework.ws.wsdl.wsdl11.Wsdl11Definition;

@EnableWs
@Configuration
public class SoapConfig
extends WsConfigurerAdapter {
    private static final String SOAP_WSI_SERVICE_NAME = "DeliverableService";
    private static final String SOAP_NON_WSI_SERVICE_NAME = "DeliverableService";
    static final String SOAP_WSI_CTX_PATH = "/wsi";
    static final String SOAP_WSI_PATTERN_MAPPING = "/wsi/*";
    static final String SOAP_NON_WSI_CTX_PATH = "/nonwsi";
    static final String SOAP_NON_WSI__PATTERN_MAPPING = "/nonwsi/*";

    @Bean
    public ServletRegistrationBean<MessageDispatcherServlet> messageDispatcherServlet(ApplicationContext applicationContext) {
        MessageDispatcherServlet messageDispatcherServlet = new MessageDispatcherServlet(){

            private WsdlDefinition getWsdlDefinition(String key) throws Exception {
                Field f = MessageDispatcherServlet.class.getDeclaredField("wsdlDefinitions");
                boolean access = f.isAccessible();
                try {
                    f.setAccessible(true);
                    WsdlDefinition wsdlDefinition = (WsdlDefinition)((Map)f.get((Object)this)).get(key);
                    return wsdlDefinition;
                }
                finally {
                    f.setAccessible(access);
                }
            }

            protected WsdlDefinition getWsdlDefinition(HttpServletRequest request) {
                if ("WSDL".equals(request.getQueryString())) {
                    try {
                        return this.getWsdlDefinition("DeliverableService");
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)"failed to find wsdl", (Throwable)ex);
                        return null;
                    }
                }
                return null;
            }
        };
        messageDispatcherServlet.setApplicationContext(applicationContext);
        return new ServletRegistrationBean((Servlet)messageDispatcherServlet, new String[]{SOAP_WSI_PATTERN_MAPPING, SOAP_NON_WSI__PATTERN_MAPPING});
    }

    @Bean(value={"DeliverableService"})
    public Wsdl11Definition wsdlWsiDefinition() {
        SimpleWsdl11Definition simpleWsdl11Definition = new SimpleWsdl11Definition();
        simpleWsdl11Definition.setWsdl((Resource)new FileSystemResource(WsdlAPI.STAMBIA_WSDL_PATH));
        return simpleWsdl11Definition;
    }

    @Bean(value={"DeliverableService"})
    public Wsdl11Definition wsdlNonWsiDefinition() {
        SimpleWsdl11Definition simpleWsdl11Definition = new SimpleWsdl11Definition();
        simpleWsdl11Definition.setWsdl((Resource)new FileSystemResource(WsdlAPI.STAMBIA_WSDL_PATH_WSI));
        return simpleWsdl11Definition;
    }

    @Bean
    public EndpointMapping createSoapEndpointMapping() {
        SoapEndpointMapping m = new SoapEndpointMapping();
        return m;
    }

    public void addInterceptors(List<EndpointInterceptor> interceptors) {
        super.addInterceptors(interceptors);
    }

    @Bean
    EndpointAdapter createSoapEndpointAdapter() {
        SoapServer s = new SoapServer();
        s.setWsdlAPI(SoapService.getWsdlApi());
        return s;
    }
}

