/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.ui.mapper;

import com.indy.gmf.map.edit.provider.custom.MapperAdapter;
import com.indy.ui.text.editor.views.parsing.PartitionerProvider;
import com.indy.ui.text.editor.views.parsing.XPathViewerConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TextEditor {
    private static Font FONT = new Font((Device)Display.getCurrent(), new FontData("Courier New", 10, 0));
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private SourceViewer sourceViewer;
    private XPathViewerConfiguration viewerConfig;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Document doc;
    private IDocumentListener documentListener;
    private MapperAdapter.EditionHelper editionHelper;
    Timer timer = null;
    private TimerManager timerManager = new TimerManager();

    public TextEditor(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public Composite createContent(Composite parent) {
        Composite main = this.widgetFactory.createComposite(parent);
        main.setLayout((Layout)new FillLayout());
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(0));
        DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)access, 12, EditorsPlugin.getDefault().getSharedTextColors());
        LineNumberRulerColumn lineNumberRuler = new LineNumberRulerColumn();
        lineNumberRuler.setForeground(Display.getCurrent().getSystemColor(15));
        ruler.addDecorator(1, (IVerticalRulerColumn)lineNumberRuler);
        this.sourceViewer = new SourceViewer(main, (IVerticalRuler)ruler, (IOverviewRuler)overviewRuler, true, 2818);
        SourceViewerDecorationSupport fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, (IOverviewRuler)overviewRuler, (IAnnotationAccess)access, EditorsPlugin.getDefault().getSharedTextColors());
        ArrayList l = new ArrayList(EditorsPlugin.getDefault().getMarkerAnnotationPreferences().getAnnotationPreferences());
        for (Object o : l) {
            if (!(o instanceof AnnotationPreference)) continue;
            AnnotationPreference an = (AnnotationPreference)o;
            fSourceViewerDecorationSupport.setAnnotationPreference(an);
            if (!an.contributesToHeader()) continue;
            overviewRuler.addHeaderAnnotationType(an.getAnnotationType());
        }
        fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)new DefaultCharacterPairMatcher(new char[]{'\'', '\'', '(', ')', '{', '}', '[', ']', '<', '>', '\"', '\"'}));
        fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingTagHighlight", "matchingTagIndicationColor");
        fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingTagHighlight", "matchingTagIndicationColor", "matchingTagHighlight", "matchingTagHighlight");
        fSourceViewerDecorationSupport.install(EditorsPlugin.getDefault().getPreferenceStore());
        this.sourceViewer.getTextWidget().setFont(FONT);
        StyledText control = this.sourceViewer.getTextWidget();
        final Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()};
        ViewerDropAdapter vda = new ViewerDropAdapter((Viewer)this.sourceViewer){
            Point selection;
            Pattern p;
            {
                super($anonymous0);
                this.p = Pattern.compile("\\[(.*?)\\]");
            }

            public void dropAccept(DropTargetEvent event) {
                super.dropAccept(event);
                this.selection = TextEditor.this.sourceViewer.getTextWidget().getSelection();
            }

            public boolean performDrop(Object data) {
                String text = TextEditor.this.editionHelper.convertToText(data);
                StringBuffer buf = new StringBuffer();
                int lastIndex = 0;
                Matcher m = this.p.matcher(text);
                while (m.find()) {
                    buf.append(text.substring(lastIndex, m.start()));
                    lastIndex = m.end();
                }
                if (buf.length() == 0) {
                    buf.append(text);
                }
                return TextEditor.this.addTextInCurrentSelection(buf.toString(), this.selection);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                Transfer[] transferArray = transferTypes;
                int n = transferTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Transfer t = transferArray[n2];
                    if (t.isSupportedType(transferType)) {
                        this.overrideOperation(1);
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public void drop(DropTargetEvent event) {
                super.drop(event);
            }
        };
        DropTarget dropTarget = new DropTarget((Control)control, 7);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener((DropTargetListener)vda);
        this.sourceViewer.getTextWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 16) {
                    if (TextEditor.this.sourceViewer.canDoOperation(8)) {
                        TextEditor.this.sourceViewer.doOperation(8);
                    }
                    event.doit = false;
                } else if (event.detail == 8) {
                    if (TextEditor.this.sourceViewer.canDoOperation(9)) {
                        TextEditor.this.sourceViewer.doOperation(9);
                    }
                    event.doit = false;
                }
            }
        });
        this.sourceViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                if (verifyEvent.keyCode == 9 && ((TextEditor)TextEditor.this).sourceViewer.getSelectedRange().y > 0) {
                    verifyEvent.doit = false;
                }
            }
        });
        this.doc = new Document();
        this.doc.set("");
        this.sourceViewer.setDocument((IDocument)this.doc, (IAnnotationModel)new AnnotationModel());
        this.refreshContent();
        this.sourceViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    TextEditor.this.sourceViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    TextEditor.this.sourceViewer.doOperation(2);
                } else if (this.isContentAssistKeyPress(e)) {
                    TextEditor.this.sourceViewer.doOperation(13);
                }
            }

            private boolean isContentAssistKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && e.keyCode == 32;
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }
        });
        return main;
    }

    public void clearText() {
        StyledText ctrl = this.sourceViewer.getTextWidget();
        this.sourceViewer.getDocument().set("");
        ctrl.setFocus();
    }

    public boolean addTextInCurrentSelection(String text, Point location) {
        StyledText ctrl = this.sourceViewer.getTextWidget();
        Point _selection = this.sourceViewer.getTextWidget().getSelection();
        if (location != null && _selection.x >= location.x && _selection.y <= location.y) {
            _selection = location;
        }
        if (_selection.x > ctrl.getSize().x) {
            return false;
        }
        try {
            this.sourceViewer.getDocument().replace(_selection.x, _selection.y - _selection.x, text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ctrl.setFocus();
        ctrl.setSelection(_selection.x + text.length());
        return true;
    }

    public void setInput(MapperAdapter.EditionHelper helper) {
        this.sourceViewer.unconfigure();
        this.editionHelper = helper;
        this.refreshContent();
        if (helper != null && helper.getCodeCapability() != null) {
            this.installDocumentListener();
            this.viewerConfig = new XPathViewerConfiguration(helper.getCodeCapability(), true);
            IDocumentPartitioner partioner = PartitionerProvider.createPartitioner();
            this.doc.setDocumentPartitioner(partioner);
            if (partioner != null) {
                partioner.connect((IDocument)this.doc);
            }
            this.sourceViewer.configure((SourceViewerConfiguration)this.viewerConfig);
        }
    }

    protected void performChange() {
        this.editionHelper.performEdition(this.doc.get());
    }

    public void refreshContent() {
        Object text = null;
        if (this.editionHelper != null && this.editionHelper.getEditedObject() != null && this.editionHelper.getCodeCapability() != null && !((text = this.editionHelper.getEditedObject().eGet(this.editionHelper.getCodeCapability().getEStructuralFeature())) instanceof String)) {
            text = "";
        }
        if (text == null) {
            this.doc.set("");
            this.sourceViewer.getTextWidget().setBackground(Display.getDefault().getSystemColor(22));
            this.sourceViewer.getControl().setEnabled(false);
        } else {
            this.sourceViewer.getTextWidget().setBackground(null);
            this.doc.set((String)text);
            this.sourceViewer.getControl().setEnabled(true);
        }
    }

    public void disableListener() {
        this.removeDocumentListener();
    }

    public void enableListener() {
        this.installDocumentListener();
    }

    private void removeDocumentListener() {
        if (this.documentListener != null) {
            this.doc.removeDocumentListener(this.documentListener);
        }
        if (this.timerManager != null) {
            this.timerManager.join();
        }
    }

    private void installDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (TextEditor.this.timer != null) {
                        TextEditor.this.timer.cancel();
                        Iterator it = TextEditor.this.timerManager.createdTasks.iterator();
                        while (it.hasNext()) {
                            UpdateObjectRunnable r = (UpdateObjectRunnable)it.next();
                            if (r.started) continue;
                            it.remove();
                            TimerManager timerManager = TextEditor.this.timerManager;
                            timerManager.currentTimerTasks = timerManager.currentTimerTasks - 1;
                        }
                    }
                    TextEditor.this.timer = new Timer();
                    try {
                        TextEditor.this.timerManager.createTimeTask();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        this.doc.addDocumentListener(this.documentListener);
    }

    public <T> T adapt(Class<T> cl) {
        if (cl == SourceViewer.class) {
            return (T)this.sourceViewer;
        }
        return null;
    }

    public void setFocus() {
        this.sourceViewer.getControl().setFocus();
    }

    private class TimerManager {
        private volatile int currentTimerTasks = 0;
        private volatile boolean joining = false;
        private List<UpdateObjectRunnable> createdTasks = new ArrayList<UpdateObjectRunnable>();

        private TimerManager() {
        }

        public void createTimeTask() throws Exception {
            if (this.joining) {
                throw new Exception("Cannot schedule while joining");
            }
            TextEditor.this.timer.schedule((TimerTask)new UpdateObjectRunnable(), 300L);
        }

        public void join() {
            this.joining = true;
            while (this.currentTimerTasks != 0) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.joining = false;
            TextEditor.this.timer = null;
        }
    }

    private class UpdateObjectRunnable
    extends TimerTask {
        boolean started = false;

        UpdateObjectRunnable() {
            TimerManager timerManager = TextEditor.this.timerManager;
            timerManager.currentTimerTasks = timerManager.currentTimerTasks + 1;
            TextEditor.this.timerManager.createdTasks.add(this);
        }

        @Override
        public void run() {
            this.started = true;
            try {
                TextEditor.this.performChange();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (TextEditor.this.timer != null) {
                TextEditor.this.timer.cancel();
            }
            TimerManager timerManager = TextEditor.this.timerManager;
            timerManager.currentTimerTasks = timerManager.currentTimerTasks - 1;
            TextEditor.this.timerManager.createdTasks.remove(this);
        }
    }
}

