/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnMetaDataSet {
    List<ColumnMetaData> cols = new ArrayList<ColumnMetaData>();
    private Map<String, Integer> positions = new HashMap<String, Integer>();

    public Collection<ColumnMetaData> getColumns() {
        return this.cols;
    }

    public ColumnMetaData getColumnMetaData(int position) {
        return this.cols.get(position);
    }

    public ColumnMetaDataSet(ResultSet rs, Collection<String> _cols, Map<String, String> aliases, String catalogName, String tableName, HashMap<String, Integer> cellsIndex) throws SQLException {
        this(rs, _cols, aliases, catalogName, tableName);
        for (ColumnMetaData c : this.cols) {
            String columnName = c.getColumnName();
            Integer cellIndex = cellsIndex.get(columnName);
            if (cellIndex == null) continue;
            c.setPosition(cellIndex);
        }
    }

    public ColumnMetaDataSet(ResultSet rs, Collection<String> _cols, Map<String, String> aliases, String catalogName, String tableName, boolean caseSensitive) throws SQLException {
        int k;
        ArrayList<String> __cols;
        ArrayList<String> arrayList = __cols = _cols != null ? new ArrayList<String>(_cols) : null;
        if (__cols != null) {
            k = 1;
            for (String name : __cols) {
                this.positions.put(name, k++);
            }
        }
        k = 1;
        ArrayList<ColumnMetaData> tmpCols = new ArrayList<ColumnMetaData>();
        HashMap<String, ColumnMetaData> map = new HashMap<String, ColumnMetaData>();
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            int type = rs.getInt("DATA_TYPE");
            ColumnMetaData col = new ColumnMetaData(name, null, type);
            col.setTableName(tableName);
            col.setCatalogName(catalogName);
            col.setPosition(k++);
            tmpCols.add(col);
            map.put(name, col);
        }
        if (_cols == null) {
            this.cols.clear();
            this.cols.addAll(tmpCols);
        } else {
            if (aliases == null) {
                aliases = new HashMap<String, String>();
                for (String str : _cols) {
                    aliases.put(str, str);
                }
            }
            for (String alias : _cols) {
                __cols.remove(alias);
                String tbname = null;
                for (String string : aliases.keySet()) {
                    if (!caseSensitive && string.equalsIgnoreCase(alias)) {
                        tbname = aliases.get(string);
                        break;
                    }
                    if (!string.equals(alias)) continue;
                    tbname = aliases.get(string);
                    break;
                }
                ColumnMetaData _col = null;
                for (String str3 : map.keySet()) {
                    if (!caseSensitive && str3.equalsIgnoreCase(tbname)) {
                        _col = (ColumnMetaData)map.get(str3);
                        break;
                    }
                    if (!str3.equals(tbname)) continue;
                    _col = (ColumnMetaData)map.get(str3);
                    break;
                }
                if (_col == null) {
                    throw new SQLException(Messages.getString("ColumnMetaDataSet.0") + tbname);
                }
                ColumnMetaData columnMetaData = new ColumnMetaData(_col.getColumnName(), alias, _col.getColumnType());
                columnMetaData.setTableName(columnMetaData.getTableName());
                columnMetaData.setCatalogName(columnMetaData.getCatalogName());
                columnMetaData.setPosition(_col.getPosition());
                this.cols.add(columnMetaData);
            }
        }
        if (__cols != null && __cols.size() > 0) {
            throw new SQLException(Messages.getString("ColumnMetaDataSet.1") + this.cols);
        }
    }

    public ColumnMetaDataSet(ResultSet rs, Collection<String> _cols, Map<String, String> aliases, String catalogName, String tableName) throws SQLException {
        int k;
        ArrayList<String> __cols;
        ArrayList<String> arrayList = __cols = _cols != null ? new ArrayList<String>(_cols) : null;
        if (__cols != null) {
            k = 1;
            for (String name : __cols) {
                this.positions.put(name, k++);
            }
        }
        k = 1;
        ArrayList<ColumnMetaData> tmpCols = new ArrayList<ColumnMetaData>();
        HashMap<String, ColumnMetaData> map = new HashMap<String, ColumnMetaData>();
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            int type = rs.getInt("DATA_TYPE");
            ColumnMetaData col = new ColumnMetaData(name, null, type);
            col.setTableName(tableName);
            col.setCatalogName(catalogName);
            col.setPosition(k++);
            tmpCols.add(col);
            map.put(name, col);
        }
        if (_cols == null) {
            this.cols.clear();
            this.cols.addAll(tmpCols);
        } else {
            if (aliases == null) {
                aliases = new HashMap<String, String>();
                for (String str : _cols) {
                    aliases.put(str, str);
                }
            }
            for (String alias : _cols) {
                __cols.remove(alias);
                String tbname = aliases.get(alias);
                ColumnMetaData _col = (ColumnMetaData)map.get(tbname);
                if (_col == null) {
                    throw new SQLException(Messages.getString("ColumnMetaDataSet.2") + tbname);
                }
                ColumnMetaData col = new ColumnMetaData(_col.getColumnName(), alias, _col.getColumnType());
                col.setTableName(col.getTableName());
                col.setCatalogName(_col.getCatalogName());
                col.setPosition(_col.getPosition());
                this.cols.add(col);
            }
        }
        if (__cols != null && __cols.size() > 0) {
            throw new SQLException(Messages.getString("ColumnMetaDataSet.3") + this.cols);
        }
    }

    public ColumnMetaDataSet(ResultSet rs, List<String> _cols, Map<String, String> aliases, String catalogName, String tableName, HashMap<String, Integer> cellsIndex, boolean caseSensitive) throws SQLException {
        this(rs, _cols, aliases, catalogName, tableName, caseSensitive);
        for (ColumnMetaData c : this.cols) {
            if (cellsIndex.get(c.getColumnName()) == null) continue;
            c.setPosition(cellsIndex.get(c.getColumnName()));
        }
    }
}

