/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.parser.FunctionDataTypeVisitor;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.common.parser.MetadataStandardVisitor;
import com.stambia.jdbc.common.parser.WhereVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;

public class SelectMetaData
extends MetadataStandardVisitor {
    List<ColumnMetaData> lstColumns = new ArrayList<ColumnMetaData>();
    List<String> functionColumns = new ArrayList<String>();
    List<String> lstStringColumns = new ArrayList<String>();
    Map<String, String> aliasesColumn = new HashMap<String, String>();
    IWhereVisitor whereVisitor;
    List<TableMetaData> lstFromItems = new ArrayList<TableMetaData>();
    boolean allColumns = false;
    PlainSelect plainSelect;
    String whereString;

    public Map<String, String> getAliasesColumn() {
        return this.aliasesColumn;
    }

    public IWhereVisitor getWhereVisitor() {
        return this.whereVisitor;
    }

    public List<ColumnMetaData> getSelectedColumns() {
        return this.lstColumns;
    }

    @Override
    public void visit(Column tableColumn) {
    }

    public List<String> getLstStringColumns() {
        return this.lstStringColumns;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    private void addColumn(Column tableColumn, String _alias, int sqlType) {
        tableColumn.setColumnName(tableColumn.getColumnName().replace("\"", "").replace("[", "").replace("]", ""));
        String alias = _alias == null ? tableColumn.getColumnName() : _alias;
        ColumnMetaData cmd = new ColumnMetaData(tableColumn.getColumnName(), alias, sqlType, sqlType == 12 ? 255 : 0);
        cmd.setTableName(tableColumn.getTable().getName());
        cmd.setCatalogName(tableColumn.getTable().getSchemaName());
        this.lstColumns.add(cmd);
        this.lstStringColumns.add(alias);
        this.aliasesColumn.put(alias, tableColumn.getColumnName());
    }

    public SelectMetaData(PlainSelect plainSelect) {
        this.plainSelect = plainSelect;
        if (plainSelect.getSelectItems().size() == 1) {
            if (PlainSelect.getStringList((List)plainSelect.getSelectItems()).equals("*")) {
                this.allColumns = true;
            }
        }
        if (!this.allColumns) {
            Iterator it = plainSelect.getSelectItems().iterator();
            boolean i = false;
            while (it.hasNext()) {
                SelectExpressionItem sel = (SelectExpressionItem)it.next();
                String alias = null;
                if (sel.getAlias() != null) {
                    alias = sel.getAlias();
                } else {
                    Expression expression = sel.getExpression();
                    if (expression instanceof Column) {
                        alias = null;
                    } else if (expression instanceof Function) {
                        alias = "";
                    }
                }
                if (sel.getExpression() instanceof Column) {
                    this.addColumn((Column)sel.getExpression(), alias, 12);
                    continue;
                }
                if (!(sel.getExpression() instanceof Function)) continue;
                Function agg = (Function)sel.getExpression();
                agg.accept((ExpressionVisitor)new FunctionDataTypeVisitor(alias){

                    @Override
                    public void addColumn(Column column, String alias, int type) {
                        SelectMetaData.this.addColumn(column, alias, type);
                    }
                });
            }
        }
        plainSelect.accept((SelectVisitor)this);
        if (plainSelect.getWhere() != null) {
            this.whereString = "" + plainSelect.getWhere();
            WhereVisitor visitor = new WhereVisitor();
            plainSelect.getWhere().accept((ExpressionVisitor)visitor);
            this.whereString = visitor.replace(this.whereString);
            this.whereString = visitor.removeTableNamePrefix(this.whereString, this.getTableFrom());
        } else {
            this.whereString = "";
        }
    }

    public SelectMetaData(PlainSelect plainSelect, IWhereVisitor whereVisitor) {
        this(plainSelect);
        if (plainSelect.getWhere() != null) {
            this.whereString = "" + plainSelect.getWhere();
            this.whereVisitor = whereVisitor;
            whereVisitor.setSelectMetaData(this);
            plainSelect.getWhere().accept((ExpressionVisitor)this.whereVisitor);
            if (whereVisitor instanceof WhereVisitor) {
                this.whereString = ((WhereVisitor)((Object)whereVisitor)).replace(this.whereString);
            }
        } else {
            this.whereString = "";
        }
    }

    public List getOrderByElements() {
        return this.plainSelect.getOrderByElements() == null ? Collections.EMPTY_LIST : this.plainSelect.getOrderByElements();
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        super.visit(selectExpressionItem);
    }

    public String getWhereString() {
        return this.whereString;
    }

    public List<TableMetaData> getTableFrom() {
        return this.lstFromItems;
    }

    @Override
    public void visit(Table pTable) {
        TableMetaData fdrst = TableMetaData.toTableMetaData(pTable);
        this.lstFromItems.add(fdrst);
    }

    public List<String> getFunctions() {
        return this.functionColumns;
    }
}

