/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.stambia.udriver.googlesheets.GSheetsDatabaseMetaData;
import com.stambia.udriver.googlesheets.GSheetsDriver;
import com.stambia.udriver.googlesheets.GSheetsPreparedStatement;
import com.stambia.udriver.googlesheets.GSheetsStatement;
import com.stambia.udriver.googlesheets.Messages;
import com.stambia.udriver.googlesheets.oauth.OAuth2;
import com.stambia.udriver.googlesheets.oauth.OAuth2Metadata;
import com.stambia.udriver.jdbc.ConnectionImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class GSheetsConnection
extends ConnectionImpl {
    private Sheets service;
    private GSheetsDriver driver;

    public GSheetsConnection(GSheetsDriver driver, final OAuth2Metadata md) throws SQLException {
        this.driver = driver;
        HttpRequestInitializer httpRequestInitializer = new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                try {
                    String token = OAuth2.getToken(md);
                    request.getHeaders().setAuthorization("Bearer " + token);
                }
                catch (Exception e) {
                    throw new RuntimeException(Messages.getString("GSheetsConnection.0") + e);
                }
            }
        };
        try {
            this.service = new Sheets.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), httpRequestInitializer).setApplicationName("stambia-jdbcDriver").build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SQLException(Messages.getString("GSheetsConnection.1") + e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new GSheetsStatement(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new GSheetsDatabaseMetaData(this.driver, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new GSheetsPreparedStatement(this, sql);
    }

    public Sheets getService() {
        return this.service;
    }

    public String getSheetDataRange(String spreadsheetId, String sheetName) throws SQLException {
        int lastRow = this.getSheetProperties(spreadsheetId, sheetName).getGridProperties().getRowCount();
        if (lastRow < 3) {
            return null;
        }
        return "'" + sheetName + "'!2:" + lastRow;
    }

    public List<Sheet> getSheets(String spreadsheetId) throws IOException {
        return ((Spreadsheet)this.service.spreadsheets().get(spreadsheetId).execute()).getSheets();
    }

    public SheetProperties getSheetProperties(String spreadsheetId, String sheetName) throws SQLException {
        try {
            for (Sheet s : this.getSheets(spreadsheetId)) {
                if (!s.getProperties().getTitle().equals(sheetName)) continue;
                return s.getProperties();
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        throw new SQLException(Messages.getString("GSheetsConnection.2"));
    }
}

