/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.googlesheets.GSheetsDriver;
import com.stambia.udriver.jdbc.DatabaseMetadataImpl;
import com.stambia.udriver.jdbc.metadata.MetadataColumnResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableTypeResultSet;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GSheetsDatabaseMetaData
extends DatabaseMetadataImpl {
    GSheetsConnection conn;
    List<String> columns = null;

    public GSheetsDatabaseMetaData(GSheetsDriver driver, GSheetsConnection conn) {
        super(driver, conn);
        this.conn = conn;
    }

    private void addColumn(MetadataColumnResultSetImpl rs, String catalog, String sheetName, String columnName, int position) throws SQLException {
        rs.newRow();
        rs.addField(catalog, MetadataColumnResultSetImpl.MetadataColumnName.TABLE_CAT.name());
        rs.addField(sheetName, MetadataColumnResultSetImpl.MetadataColumnName.TABLE_NAME.name());
        rs.addField(columnName, MetadataColumnResultSetImpl.MetadataColumnName.COLUMN_NAME.name());
        rs.addField(12, MetadataColumnResultSetImpl.MetadataColumnName.DATA_TYPE.name());
        rs.addField("VARCHAR", MetadataColumnResultSetImpl.MetadataColumnName.TYPE_NAME.name());
        rs.addField(position, MetadataColumnResultSetImpl.MetadataColumnName.ORDINAL_POSITION.name());
        rs.addField("YES", MetadataColumnResultSetImpl.MetadataColumnName.NULLABLE.name());
        rs.addField("", MetadataColumnResultSetImpl.MetadataColumnName.REMARKS.name());
        rs.addField(12, MetadataColumnResultSetImpl.MetadataColumnName.SOURCE_DATA_TYPE.name());
        rs.addField("NO", MetadataColumnResultSetImpl.MetadataColumnName.IS_AUTOINCREMENT.name());
    }

    private void addTable(MetadataTableResultSetImpl rs, String spreadsheetId, String sheetName) throws SQLException {
        rs.newRow();
        rs.addField(sheetName, MetadataColumnResultSetImpl.MetadataColumnName.TABLE_NAME.name());
        rs.addField(sheetName, "TYPE_CAT");
        rs.addField(spreadsheetId, MetadataColumnResultSetImpl.MetadataColumnName.TABLE_CAT.name());
        rs.addField("TABLE", MetadataTableTypeResultSet.MetadataColumnName.TABLE_TYPE.name());
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaNamePattern, String sheetName, String columnNamePattern) throws SQLException {
        MetadataColumnResultSetImpl rs = new MetadataColumnResultSetImpl();
        try {
            List<String> cols = this.getListColumns(catalog, sheetName);
            for (int i = 0; i < cols.size(); ++i) {
                String s = cols.get(i);
                if (s == null || s.isEmpty()) continue;
                this.addColumn(rs, catalog, sheetName, s, i);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return rs;
    }

    public List<String> getListColumns(String spreadsheetId, String sheetName) throws IOException {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
            List<Object> firstRow = this.getFirstRow(spreadsheetId, sheetName);
            for (Object s : firstRow) {
                if (s != null && !((String)s).isEmpty()) {
                    this.columns.add((String)s);
                    continue;
                }
                return this.columns;
            }
        }
        return this.columns;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        MetadataTableTypeResultSet rs = new MetadataTableTypeResultSet();
        rs.newRow();
        rs.addField("TABLE", MetadataTableTypeResultSet.MetadataColumnName.TABLE_TYPE.name());
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            List<Sheet> sheets = this.conn.getSheets(catalog);
            MetadataTableResultSetImpl rs = new MetadataTableResultSetImpl();
            for (Sheet sheet : sheets) {
                this.addTable(rs, catalog, sheet.getProperties().getTitle());
            }
            return rs;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private List<Object> getFirstRow(String spreadsheetId, String sheetName) throws IOException {
        return (List)((ValueRange)this.conn.getService().spreadsheets().values().get(spreadsheetId, "'" + sheetName + "'!1:1").execute()).getValues().get(0);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "GoogleSheetsV4";
    }
}

