/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.googlesheets.Messages;
import com.stambia.udriver.googlesheets.oauth.OAuth2Metadata;
import com.stambia.udriver.googlesheets.security.EncryptDecrypt;
import com.stambia.udriver.jdbc.DriverImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class GSheetsDriver
extends DriverImpl {
    protected static final String urlFormat = "jdbc:semarchy:google:spreadsheet";
    protected static final String legacyUrlFormat = "jdbc:stambia:google:spreadsheet";

    public GSheetsDriver() {
        super("jdbc:semarchy:google:spreadsheet(.*)|jdbc:stambia:google:spreadsheet(.*)", 1, 0);
    }

    public GSheetsDriver(String urlRegexpMatcher, int majorVersion, int minorVersion) {
        super(urlRegexpMatcher, majorVersion, minorVersion);
    }

    @Override
    public boolean acceptsURL(String arg0) throws SQLException {
        if (arg0.startsWith(legacyUrlFormat)) {
            arg0 = arg0.replace(legacyUrlFormat, urlFormat);
        }
        return arg0.startsWith(urlFormat);
    }

    @Override
    public Connection connect(String arg0, Properties arg1) throws SQLException {
        String accessToken = null;
        String refreshToken = null;
        String clientId = null;
        String clientSecret = null;
        int connectionTimeout = -1;
        int readTimeout = -1;
        if ((arg0 = arg0.replace(legacyUrlFormat, urlFormat)).length() > urlFormat.length()) {
            String query = null;
            try {
                URI uri = new URI(arg0.replace(urlFormat, "jdbc://driver"));
                query = uri.getQuery();
            }
            catch (URISyntaxException e1) {
                throw new SQLException(e1);
            }
            if (query != null) {
                String[] split;
                for (String part : split = query.split("&")) {
                    int index = part.indexOf("=");
                    if (index <= -1) continue;
                    String value = part.substring(index + 1);
                    try {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException(e);
                    }
                    if (part.toLowerCase().startsWith("oauth2accesstoken")) {
                        accessToken = value;
                        continue;
                    }
                    if (part.toLowerCase().startsWith("oauth2refreshtoken")) {
                        refreshToken = value;
                        continue;
                    }
                    if (part.toLowerCase().startsWith("oauth2clientid")) {
                        clientId = value;
                        continue;
                    }
                    if (part.toLowerCase().startsWith("oauth2clientsecret")) {
                        clientSecret = value;
                        continue;
                    }
                    if (part.toLowerCase().startsWith("oauth2connectiontimeout")) {
                        connectionTimeout = Integer.valueOf(value);
                        continue;
                    }
                    if (part.toLowerCase().startsWith("oauth2readtimeout")) {
                        readTimeout = Integer.valueOf(value);
                        continue;
                    }
                    if (!part.toLowerCase().startsWith("oauth2encryptedclientsecret")) continue;
                    try {
                        clientSecret = EncryptDecrypt.decrypt(value);
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            }
        }
        OAuth2Metadata md = null;
        if (accessToken != null && !accessToken.isEmpty() || refreshToken != null && !refreshToken.isEmpty()) {
            if (accessToken == null || accessToken.isEmpty()) {
                if (clientId == null) {
                    throw new SQLException(Messages.getString("GSheetsDriver.0"));
                }
                if (clientSecret == null) {
                    throw new SQLException(Messages.getString("GSheetsDriver.1"));
                }
            }
        } else {
            throw new SQLException(Messages.getString("GSheetsDriver.2"));
        }
        md = new OAuth2Metadata();
        md.clientId = clientId;
        md.clientSecret = clientSecret;
        md.tokenEndpoint = "https://accounts.google.com/o/oauth2/token";
        md.scope = "https://spreadsheets.google.com/feeds";
        md.refreshToken = refreshToken;
        md.accessToken = accessToken;
        md.connectionTimeout = connectionTimeout;
        md.readTimeout = readTimeout;
        md.tokenEndpoint = "https://accounts.google.com/o/oauth2/token";
        return new GSheetsConnection(this, md);
    }

    static {
        try {
            DriverManager.registerDriver(new GSheetsDriver("jdbc:semarchy:google:spreadsheet(.*)", 1, 0));
        }
        catch (SQLException E) {
            throw new RuntimeException(Messages.getString("GSheetsDriver.3"));
        }
    }
}

